/*
 *      Win32-specific video driver code
 */

#include <stdio.h>
#include <string.h>

#include "SDL.h"
#include "itg.h"

#ifndef _WIN32
#error "This file is for Win32 only"
#endif

extern void gen_clut(int bpp);

// SDL 15 bpp, Direct (fullscreen)
extern "C" char *sdl15D_version();
extern "C" int sdl15D_on();
extern "C" void sdl15D_update(char *a);
extern "C" void sdl15D_retrieve(char *a);

// SDL 15bpp, Windowed version
extern "C" char *sdl15W_version();
extern "C" int sdl15W_on();
extern "C" void sdl15W_update(char *a);
extern "C" void sdl15W_retrieve(char *a);

// SDL 16 bpp, Direct (fullscreen)
extern "C" char *sdl16D_version();
extern "C" int sdl16D_on();
extern "C" void sdl16D_update(char *a);
extern "C" void sdl16D_retrieve(char *a);

// SDL 16 bpp, Windowed version
extern "C" char *sdl16W_version();
extern "C" int sdl16W_on();
extern "C" void sdl16W_update(char *a);
extern "C" void sdl16W_retrieve(char *a);

extern "C" char itg_caption[128];

void set_caption(char *m)
{
strcpy(itg_caption,m);
}

void sdl_off()
{
SDL_Quit();
}

int Init_SDL15D()
{
puts(ITGver);
puts("  Driver:  sdl15_d.cc");
printf("  %s\n",sdl15D_version());

on       = sdl15D_on;
update   = sdl15D_update;
retrieve = sdl15D_retrieve;

gen_clut(15);

return 1;
}

int Init_SDL15W()
{
puts(ITGver);
puts("  Driver:  sdl15_w.cc");
printf("  %s\n",sdl15W_version());

on       = sdl15W_on;
update   = sdl15W_update;
retrieve = sdl15W_retrieve;

gen_clut(15);

return 1;
}

int Init_SDL16D()
{
puts(ITGver);
puts("  Driver:  sdl16_d.cc");
printf("  %s\n",sdl16D_version());

on       = sdl16D_on;
update   = sdl16D_update;
retrieve = sdl16D_retrieve;

gen_clut(16);
return 1;
}

int Init_SDL16W()
{
puts(ITGver);
puts("  Driver:  sdl16_w.cc");
printf("  %s\n",sdl16W_version());

on       = sdl16W_on;
update   = sdl16W_update;
retrieve = sdl16W_retrieve;

gen_clut(16);
return 1;
}
