/*
 *	IRE	miscellaneous file loaders
 */

// MR: windows doesn't use
#ifndef _WIN32
#include <unistd.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "loaders.hpp"
#include "console.hpp"
#include "core.hpp"
#include "fs.hpp"
#include "memory.hpp"
#include "rgb_conv.hpp"

// Defines

// Variables

static char *buf=NULL;          // Buffers used for the PCX decoder
static char *pcxmem=NULL;

extern char *cfa;               // Current Function Access info

// Functions

void Loader_Init();                             // Init
void Loader_Term();                             // Term

int display_PCX(char *picture,short *screen);   // Display a PCX in buffer
void load_Cel(SPRITE *CEL,char *filename);  // Load a .CEL as a sprite
void pcx2sprite(SPRITE *PCX,char *filename);// Load a .PCX as a sprite
void UnPcx(char *in,char *out,int length);      // Decode PCX data

// Code


/*
 *  Display PCX -load a PCX by filename, and store in a screen-size buffer
 */

int display_PCX(char *picture,short *screen)
{
unsigned char pal[768];         // Space for the 8-bit palette
LOAD fp;                        // VFS filepointer
long fl;                        // file length
char str[128];                  // String space
int w,h,len;                    // Various data items
int ptr=0, ptr2 = 0;            // For PCX-24 debanding

cfa="display_PCX";              // We were here when we bombed

strcpy(str,picture);            // back up the filename so we can modify it

// Does it exist as it stands?  EG. 'mypcx.pcx'

if(!exist(str))
	strcat(str,".PCX");     // No, it was 'mypcx.' so add the '.pcx'

// Could not find it.  Let the loader load it anyway, so the user gets
// the absolute path when load::fp Panics.

// Now, open the PCX file

fp.open(str);

// Good, we're still around

fl=fp.filelength()-128;         // PCX file is HEADER:DATA:PAL
fp.read(pal,1,128);             // Read header, just DATA:PAL left
fp.close();                     // Finish.

// Get the width from the file.
// This is nonportable, modify to use ntohl() later

w = ((pal[9]<<8)&0xff00)+(pal[8]&0xff);
h = ((pal[11]<<8)&0xff00)+(pal[10]&0xff);

w++; // Adjust width to 1-based
h++; // Adjust height too


// Get the length of the raw bitmap

len = w*h;

// Now.  This applies a different decompressor method to each bitplane size

switch(pal[65])
    {

    // 8 bits per pixel

    case 1:
    fp.open(str);                       // Open picture.
    fp.fseek(-768L,SEEK_END);           // Seek to palette data (end-768)
    fp.read(pal,768,1);                 // Load the palette for indexing
    fp.fseek(128,SEEK_SET);             // Seek back to start of RLE data
    fp.read(pcxmem,1,fl-768);           // Read it all in
    fp.close();                         // Close the file

    UnPcx(pcxmem,buf,len);                 // Undo the RLE coding
    ConvertRGB(buf,pal,screen,len,8);      // Convert to native format
    break;                                 // Finished

    // 24 bits per pixel, true colour

    case 3:
    fp.open(str);                       // Open picture.
    fp.fseek(128,SEEK_SET);             // Skip the header
    fp.read(pcxmem,1,fl-768);           // Just get the RLE nothing else
    fp.close();                         // Close the file

    UnPcx(pcxmem,buf,len*3);            // Undo the RLE coding

    // Because PCX-24 is so strange, the RGB levels are banded.
    // First we have a complete mono image of the red component
    // Then a complete mono image of the Green component
    // Finally complete mono image of the Blue component

    // I do a horrid thing to recombine them.
    // I did it up one night while my brain was running in ring-0
    // The result is fed into makeRGB, to get the natively-packed word
    // for the current video mode

    unsigned short outword;

    // MR: defining ctr in the for below freaks VC, so i put it in its own scope

	{

	for(int ctr=0;ctr<h;ctr++)
        {
        for(int ctr2=0;ctr2<w;ctr2++)
            {
            outword = MakeRGB(buf[ptr],buf[ptr+w],buf[ptr+(w*2)]);
            if(!outword) outword=1;
            screen[ptr2++]=outword;
            ptr++;
            }
        ptr+=(w*2);
        }

	}
    break;

    default:
    sprintf((char *)pal,"%d planes in file %s",pal[65],str);
    panic("display_PCX","Funny number of bitplanes in PCX file!",str);
    }
              
return w;       // Return the width for later use.  We extrapolate H from W
}

/*
 * UnPCX - Decode the RLE data into RAW bitmap
 */

void UnPcx(char *in,char *out,int length)
{
unsigned char ob;                       // Output Byte

for(int ctr2,ctr=0;ctr<length;ctr++)    // Decode it all
    {
    ob=*in++;                           // Get the byte
    if(ob > 0xbf)                       // If it's a run of colour
        {
	ctr2=(ob & 0x3f);               // Get run length
	ob=*in++;                       // Get run colour
	memset(out,ob,ctr2);            // Do the run
	out+=ctr2;                      // Increment pointer
	ctr+=ctr2-1;                    // Adjust RLE pointer
	}
    else
	*out++=ob;                      // It was a single colour
    }
return;                                 // Finished
}


/*
 *  load_Cel - Given a name and a pointer to a .CEL file, load and convert it
 */

void load_CEL(SPRITE *CEL,char *filename)
{
LOAD fp;                                        // VFS file pointer
palette pal;                                    // Palette buffer
unsigned short ID;                              // ID marker and spare word
unsigned short w,h,wxh;                         // size of image

unsigned char *buf;                             // spare buffer
char str[128];                                  // string space

cfa="load_cel";                                 // I died in load_cel

strcpy(str,filename);                           // Work out proper filename

if(!exist(str))                                 // Not just 'myfile.cel'
	strcat(str,".CEL");                     // It is now

fp.open(str);                                   // If we can't open it, we die

// Still here?  That's good

ID=fp.getw();                                   // Get the ID byte

// re-validate ID number.  This should already be correct.

if(ID!=0x9119)
              panic(cfa,"This still isn't a cel file",str);

w=fp.getw();                                    // Get width
h=fp.getw();                                    // Get height
fp.fseek(32L,SEEK_SET);                         // Skip the header
fp.read(pal,768,1);                             // Get the palette

// Allocate the sprite we will put the .CEL into

if(!CEL->allocate(w,h))
	panic(cfa,"Out of memory loading .CEL file :",str);

// Still there

wxh=w*h;                                        // Calculate space
buf=(unsigned char *)M_get(1,wxh);              // Allocate room
fp.read(buf,wxh,1);                             // Read it in

// Convert colour space to native format
ConvertRGB((char *) buf,(unsigned char *)pal,CEL->spr,wxh,6);

M_free(buf);                                    // Free the temporary buffer

fp.close();                                     // Close file
return;
}



/*
 *  load_PCX - As load_CEL but for sprites
 *
 *             Optimisation.. can probably use PCX->spr instead of nastybig
 */

void load_PCX(SPRITE *PCX,char *filename)
{
LOAD fp;                                        // VFS file pointer
palette pal;                                    // Palette buffer
unsigned short w,h;                             // size of image

char str[128];                                  // string space
short *nastybig;                                // Nasty big buffer

cfa="load_pcx";                                 // I died in load_pcx

strcpy(str,filename);                           // Work out proper filename

if(!exist(str))                                 // Was it just 'myfile.pcx'
	strcat(str,".pcx");                     // Well it is now

fp.open(str);                                   // If this fails we blow

// Good, still here

fp.read(pal,1,128);                             // read palette for WxH
fp.close();                                     // Close the file

// Do the PCX width stuff again

w = ((pal[9]<<8)&0xff00)+(pal[8]&0xff);
h = ((pal[11]<<8)&0xff00)+(pal[10]&0xff);
w++,h++;

nastybig = (short *)M_get(BUFFERSIZE,1);        // So much memory
display_PCX(str,nastybig);                      // A screen for the decoder

if(!PCX->allocate(w,h))                         // Now allocate the sprite
	panic(cfa,"Out of memory loading .PCX file :",str);

memcpy(PCX->spr,nastybig,w*h*2);                // Copy to sprite from nasty
M_free(nastybig);                               // Free nasty big buffer

return;
}


/*
 *  BMPshot - given a screen buffer and the Width, save a screenshot
 *            Written without due care + attention
 *            Severe awfuless alert
 */

void BMPshot(short *screen,int width)
{
int height,length,x,y,ctr,pos,linelen;
short tbed;
char name[32];

// Haven't time to decode BMP format, here's two headers with the right data
// First, a specimen header for 320x200

char BMP320[0x36]=
	{
	0x42,0x4D,0x36,0xEE,0x02,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0x40,0x01,0x00,0x00,0xC8,0x00,0x00,0x00,0x01,0x00,0x18,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00	};

// Now a specimen header for 640x480

char BMP640[0x36]=
	{
	0x42,0x4D,0x36,0xB8,0x0B,0x00,0x00,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x28,0x00,
	0x00,0x00,0x80,0x02,0x00,0x00,0xe0,0x01,0x00,0x00,0x01,0x00,0x18,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00	};

// Pointer to a header

char *BMPdat,*BMPhead;
FILE *fp;               // File pointer to write to

// Assign the correct header

if(width==640)
	{
	BMPhead=BMP640;
	height=480;
	}
else
if(width==320)
	{
	BMPhead=BMP320;
	height=200;
	}
else
	return;         // Panic

// Find first unused BMP file

ctr=0;
do
	{
	sprintf(name,"ire%05d.bmp",ctr++);
	} while(Gexist(name));

// Create file or bail out

fp=fopen(name,"wb");
if(!fp) return;

// Opened, write appropriate(d) header

fwrite(BMPhead,0x36,1,fp);

// Set up for conversion

length=width*height;
BMPdat=(char *)M_get(length,3);
linelen=width*3;

// Start the conversion

ctr=length;
pos=0;

// Invert the whole image for Microsoff's vile BMP format stolen from OS/2

for(y=height;y>0;y--)
{
    pos+=linelen;
    for(x=0;x<width;x++)
	{
	tbed=screen[--ctr];
	BMPdat[--pos]=(tbed>>10)<<3;
	BMPdat[--pos]=((tbed>>5)&0x1f)<<3;
	BMPdat[--pos]=(tbed&0x1f)<<3;
	}
    pos+=linelen;
    }

// Done I hope, write it

fwrite(BMPdat,length,3,fp);

// Finish

fclose(fp);
M_free(BMPdat);
}

/*
 *  Loader_Init - Set up bigbuffers
 */

void Loader_Init()
{
// Now, have we already allocated a large buffer?
// No?  Then let's get one

// This strangeness is a workaround for DJGPP's malloc oddities

if(!buf)
        {
        boot2("CALLOCing buf\n");
        buf=(char *)M_get(BUFFERSIZE*2,1);
        }

// We need two, so let's go for it

if(!pcxmem)
        {
        boot2("CALLOCing pcxmem\n");
        pcxmem=(char *)M_get(BUFFERSIZE*2,1);
        }
}

/*
 *  Loader_Init - Close down bigbuffers
 */

void Loader_Term()
{
if(pcxmem)
       M_free(pcxmem);
if(buf)
       M_free(buf);
}




