//
//      saveload.cc - Map IO for starting the game, saving and loading
//

// #define LOG_RW       // If you want to debug object load/save
#include <stdio.h>

// MR: added
#ifdef _WIN32
#include <process.h>
#include <winsock2.h>		// for the endian funcs
#endif

#include <string.h>

// MR: windows doesn't use
#ifndef _WIN32
#include <netinet/in.h> // For the endian functions
#endif

#include "sys.hpp"
#include "console.hpp"
#include "cookies.h"
#include "core.hpp"
#include "fs.hpp"
#include "linklist.hpp"
#include "memory.hpp"
#include "script.hpp"
#include "object.hpp"
#include "nuspeech.hpp"
#include "keys.hpp"

// Defines

// Variables

extern char mapname[]; // belated anti-Vietnam message
extern WORLD curmap;   // Totality, All Things
extern int show_roof;  // State of the roof- on or off, int or SeeR will flip
extern char in_editor;    // Which program we are in
extern char fullrestore;  // Loading in the map, or a savegame
extern OBJECT *party[MAX_MEMBERS];
extern OBJECT **objectstore;
extern int    *storage;
extern OBJECT *player;
extern int map_W,map_H;        // Default map size

static char stemp[128];
static char key,change_all=0;
static LOAD fp;
static int temp_int,PStot;
static char sigtemp[40];       // Signature buffer
static FILE *ofp;

static long objctr;

// Functions

void load_map();
void load_z1(char *filename);
void save_z1(char *filename);
void wipe_z1();
void load_z2();

static void SumContainers(OBJECT *cont, long parent);
static void WriteContainers(OBJECT *cont);
static void WriteContainerSchedules(OBJECT *cont);
static void WriteContainerStats(OBJECT *cont);
static void WriteContainerFuncs(OBJECT *cont);
static void WriteContainerName(OBJECT *cont);

static OBJECT *find_id(long id);
static OBJECT *SearchContainer_id(OBJECT *cont, long id);
static void MoveToPocketEnd(OBJECT *object, OBJECT *container);
int SumObjects(OBJECT *cont, char *name, int total);
OBJECT *GetFirstObject(OBJECT *cont, char *name);
extern void Init_Areas(OBJECT *objsel);

// Code


/*
 *      LoadMap- Load the whole map from disk, for first-time startup
 */

void LoadMap()
{

load_map();

strcpy(stemp,mapname);
strcat(stemp,".mz1");
load_z1(stemp);

load_z2();

bootmsg("\n");
bootmsg("InitLand\n");
}

//
//      Functions for the tilemap IO
//

/*
 *      load_map - Load the tiles from disk for startup
 */

void load_map()
{
int x,y,b,do_delete=0;

curmap.w = map_W;
curmap.h = map_H;

bootmsg("Opening map:%s\n",mapname);
strcpy(stemp,mapname);
strcat(stemp,".map");

if(!exist(stemp))
	{
        bootmsg("Could not find file '%s'\n",stemp);
	bootmsg("Hit Y to create a new file, or any other key to exit.\n");
	key=SYS_KEY_WAIT();
	if(key!=KEY_Y && key!='y' && key!='Y')
		exit(1);

	curmap.sig=ntohl(MAPSIG);
        curmap.object = (struct OBJECT *)M_get(1,sizeof(OBJECT));
        curmap.object->next=NULL;
        curmap.physmap = (unsigned short *)M_get(curmap.w * curmap.h,sizeof(short));
        curmap.roof = (unsigned char *)M_get(curmap.w * curmap.h,sizeof(char));
	}
else
	{
	fp.open(stemp);

	fp.read(sigtemp,1,40);
	if(strcmp(sigtemp,COOKIE_MAP))
		{
		bootmsg("File '%s' is not a core map.. it does not contain the right cookie\n",stemp);
		exit(1);
		}

	fp.read(&curmap,1,sizeof(curmap));
	temp_int=htonl(curmap.sig);
	if((unsigned)temp_int != MAPSIG)
		{
		bootmsg("Current map version is 0x%x, but this is 0x%x\n",MAPSIG,temp_int);
		exit(1);
		}

        curmap.physmap = (unsigned short *)M_get(curmap.w * curmap.h,sizeof(short));
        fp.read(curmap.physmap,curmap.w*curmap.h,sizeof(short));
	fp.close();

        curmap.object = (struct OBJECT *)M_get(1,sizeof(OBJECT));
        curmap.object->name="Linkedlist entrypoint object";
        curmap.object->next=NULL;

        // Set up matrix of linked lists

        curmap.objmap = (OBJECT **)M_get(curmap.w * curmap.h, sizeof(OBJECT *));

        // Build quick-access table for the matrix

        boot2("Build qat using width %d\n",curmap.w);

        for(int yt=0;yt<curmap.h;yt++)
            ytab[yt]=curmap.w * yt;

        curmap.roof = (unsigned char *)M_get(curmap.w * curmap.h,sizeof(char));
        }

boot2("Check map integrity\n");

// Check map state and correct if necessary

for(y=0;y<curmap.h;y++)
    for(x=0;x<curmap.w;x++)
        {
        b=curmap.physmap[MAP_POS(x,y)];
        if(b>=TItot && b != 0xffff)     // 0xffff is random and allowed
            {
            if(in_editor)
                {
                if(!do_delete)
                    {
                    printf("Invalid tiles detected in the map.\n");
                    printf("Do you want to:\n");
                    printf("1. Set all unknown tiles to 0\n");
                    printf("2. Quit and add the tile (if you just deleted it)\n");
                    do
                        {
                        key=SYS_KEY_WAIT();
                        if(key == KEY_1 || key == '1')
                            do_delete=1;
                        if(key == KEY_2 || key == '2')
                            exit(1);
                        } while(key != KEY_1 && key != '1');
                    }
                }
            else
                {
                curmap.physmap[MAP_POS(x,y)] = 0xffff; // surprise!!
                do_delete = 2;
                }
            if(do_delete == 1)
                curmap.physmap[MAP_POS(x,y)]=0;
            }
        }
if(do_delete == 2)
    Bug("Invalid map tiles detected\n");
}

/*
 *      save_map - Save the tiles to disk
 */

void save_map()
{
FILE *ofp;
ofp=NULL;

strcpy(stemp,mapname);
strcat(stemp,".map");

ofp = fopen(stemp,"wb");

// Since error checking will have been done previously it is safe to explode
// if something has gone wrong.

fwrite(COOKIE_MAP,1,40,ofp);
fwrite(&curmap,1,sizeof(curmap),ofp);
fwrite(curmap.physmap,curmap.w*curmap.h,sizeof(short),ofp);
fclose(ofp);
}

//
//      Z1 functions for the object layer IO
//


/*
 *      load_z1 - Load the objects from disk, also used in savegame loading
 */

void load_z1(char *filename)
{
void *Ltemp[10];
OBJECT *temp,*parent,*next;
cfa="load_z1";
char dodelete=0,bad_object=0,is_open=0;
int id,len,ctr,ctr2,unknown=0;

if(!exist(filename))
	{
        bootmsg("Could not find file '%s'\n",stemp);
	bootmsg("Hit Y to create a new file, or any other key to exit.\n");
	key=SYS_KEY_WAIT();
	if(key!=KEY_Y && key!='y' && key!='Y')
		exit(1);
	}
else
	{
	fp.open(filename);
        is_open=1;
	fp.read(sigtemp,1,40);
	if(strcmp(sigtemp,COOKIE_MZ1))
		{
		bootmsg("File '%s' is not a z1 map.. it does not contain the right cookie\n",stemp);
		exit(1);
		}

        PStot = fp.getl();
        if(PStot)        // There are some items in the file
                {
                temp_int = fp.getl();
	        if(temp_int != sizeof(OBJECT))
                    {
		    bootmsg("File '%s' has incorrect data structure.\n",stemp);
		    bootmsg("Current sizeof is %d, but this is %d\n",sizeof(OBJECT),temp_int);
		    exit(1);
		    }

	        for(ctr=0;ctr<PStot;ctr++)
                    {
                    temp = OB_Alloc();

                    // Preserve the alloc'd values

                    Ltemp[0] = temp->funcs;
                    Ltemp[1] = temp->maxstats;
                    Ltemp[2] = temp->stats;
                    Ltemp[3] = temp->wield;
                    Ltemp[4] = temp->enemy;
                    Ltemp[5] = temp->schedule;
//                  Ltemp[6] = temp->pathptr;
                    Ltemp[7] = temp->personalname;

                    // the alloc'd values get trashed here

                    fp.read(temp,1,sizeof(OBJECT));
                    fp.read(stemp,1,32);                // Get name
                    stemp[32]=0;                        // Make sure

                    // restore preserved values

                    temp->funcs = (FUNCS *)Ltemp[0];
                    temp->maxstats = (STATS *)Ltemp[1];
                    temp->stats = (STATS *)Ltemp[2];
                    temp->wield = (OBJECT **)Ltemp[3];
                    temp->enemy = (OBJECT *)Ltemp[4];
                    temp->schedule = (char **)Ltemp[5];
//                  temp->pathptr = (PATH_NODE *)Ltemp[6];
                    temp->personalname= (char *)Ltemp[7];

                    // If we're not reloading, eradicate behaviour

                    if(!fullrestore)
                        {
                        ML_Del(&ActiveList,temp);
                        temp->behave = -1;
                        }

                    // Look up the name from the script

                    bad_object=0;
                    temp_int = getnum4char(stemp);      // Find character
                    if(temp_int == -1)
                        {
                        bad_object=1;
                        if(!in_editor)
                            panic("load_z1","Could not find this name in 'section: character'!",stemp);
                        if(change_all)
                            temp_int=0;
                        else
                            {
                            dodelete=0;
                            bootmsg("Could not find definition of object '%s' in the scriptfile.\n",stemp);
	                    bootmsg("Do you want to..\n");
                            bootmsg("1.  Change this object to a '%s'\n",CHlist[0].name);
                            bootmsg("2.  Change ALL unknown objects to '%s'\n",CHlist[0].name);
                            bootmsg("3.  Delete this object\n");
                            bootmsg("4.  Delete ALL unknown objects\n");
                            bootmsg("5.  Quit (so you can add the object to the scriptfile)\n");
                            do
                                {
	                        key=SYS_KEY_WAIT();
                                if(key == KEY_1 || key == '1')
                                    temp_int=0;
                                if(key == KEY_2 || key == '2')
                                    {
                                    temp_int=0;
                                    change_all=1;
                                    }
                                if(key == KEY_3 || key == '3')
                                    dodelete=1;
                                if(key == KEY_4 || key == '4')
                                    {
                                    dodelete=1;
                                    change_all=1;
                                    }
                                if(key == KEY_5 || key == '5')
                                    exit(1);
                                } while(key <KEY_1||key>KEY_5);
                            }
                        }

                    // Now set up this name using the index in the NPC dbase

                    if(dodelete && bad_object)
                        temp_int = 0;
                    temp->name = CHlist[temp_int].name; // Get name in script
                    if(!fullrestore)
                        temp->flags= CHlist[temp_int].flags;// Copy flags
                    temp->desc= CHlist[temp_int].desc;// Copy descriptions
                    temp->shortdesc= CHlist[temp_int].shortdesc;

                    temp->next=NULL;
                    temp->pocket=NULL;

#ifdef LOG_RW
                    boot2("load: %s id = %d  iid = %d map %d,%d\n",temp->name,temp->save_id,temp->inside_id,temp->x,temp->y);
#endif
                    OB_Init(temp,temp->name);           // reinitialise object
                    temp->stats->oldhp=temp->stats->hp; // JM: Moved here
// Store whether the object is fixed or not.
// Seekstate is a transient flag only used when non-fixed so store it there
                    temp->flags.seekstate = CHlist[temp_int].flags.fixed;
//                    temp->flags.seekstate=temp->flags.fixed;
                    if(temp->behave != -1)
                        AL_Add(&ActiveList,temp); // Make it active
                    if(!temp->inside_id)              // Not inside another
                        {
                        MoveToMap(temp->x,temp->y,temp);
                        Init_Areas(temp);
                        }
                    if(dodelete && bad_object)
                        DestroyObject(temp);
                    }
                }
        show_roof = !fp.getb();

//	fp.close();
        }

// Now sort out the nested objects business.
// Everything still left in the objlist needs to be inside something else
// This has to be done using a WHILE loop instead of a FOR loop, because
// temp->next gets changed!

temp = curmap.object->next;
while(temp)
    {
    next = temp->next;
    parent = find_id(temp->inside_id);
    if(parent)
        {
#ifdef LOG_RW
        boot2("Object ID %d (%s) is inside %d\n", temp->save_id,temp->name,temp->inside_id);
#endif
//        temp->flags.seekstate=temp->flags.fixed; // store it here for now
//        temp->flags.fixed=1;            // Send it to sleep until it leaves
        MoveToPocketEnd(temp,parent);
        }
    else
        {
        Bug("Oh shit!  %s is orphaned.  ID = %d Parent = %d\n",temp->name,temp->save_id,temp->inside_id);
        C_printf("%s [%d] has an identity crisis\n",temp->name,temp->save_id);
        DestroyObject(temp);
        }
    temp = next;
    };

// Abort if failed to open the map (and just used defaults)

if(!is_open)
    return;

// Auxiliary block 2: statistics

for(;;)
    {
    id = fp.getb();
    switch(id)
      {
        case '2':
        boot2("Loading block 2\n");
        len = fp.getl();//        len = sizeof(STATS);
        for(ctr=0;ctr<PStot;ctr++)
            {
            id = fp.getl();
            temp = find_id(id);
            if(!temp)
                {
                Bug("Bugger #2\n");
                fp.fseek(len,SEEK_CUR);
                }
            else
                {
                fp.read(temp->stats,1,len);

                // Find the owner of this object, if he/she exists

                if(temp->stats->owner != NULL)
                    {
                    // Here we convert the integer token back to OBJECT *
                    temp->stats->owner = find_id((int)temp->stats->owner);
                    if(!temp->stats->owner)
                        Bug("Bugger #2a\n");
                    }
                temp->stats->oldhp=temp->stats->hp; // JM: Do this always
                }
            }
        break;

// Auxiliary block 3: individual names

        case '3':
        boot2("Loading block 3\n");
        for(ctr=0;ctr<PStot;ctr++)
            {
            id = fp.getl();
            temp = find_id(id);
            if(!temp)
                {
                Bug("Bugger #3\n");
                fp.fseek(32,SEEK_CUR);
                }
            else
                fp.read(temp->personalname,1,32);
            }
        break;

// Auxiliary block 4: schedules

        case '4':
        boot2("Loading block 4\n");
        for(ctr=0;ctr<PStot;ctr++)
            {
            id = fp.getl();
            temp = find_id(id);
            if(!temp)
                {
                Bug("Bugger #4\n");
                fp.fseek(16*24,SEEK_CUR);
                }
            else
                for(ctr2=0;ctr2<24;ctr2++)
                    {
                    temp->schedule[ctr2] = (char *)M_get(1,16);
                    fp.read(temp->schedule[ctr2],1,16);
                    if(!strlen(temp->schedule[ctr2]))
                        {
                        M_free(temp->schedule[ctr2]);
                        temp->schedule[ctr2]=NULL;
                        }
                    }
            }
        break;

// Auxiliary block 5: functions

        case '5':
        boot2("Loading block 5\n");
        len = fp.getl();
        ctr2 = 1;
        for(;ctr2;)
            {
            id = fp.getl();
            if((unsigned)id == 0xffffffff)
                ctr2=0;
            else
                {
                temp = find_id(id);
                if(!temp)
                    {
                    Bug("Bugger #5\n");
                    fp.fseek(len,SEEK_CUR);
                    }
                else
                    fp.read(temp->funcs,1,len);
                }
            }
        break;

        case 'q':
        fp.close();
        return;
        break;

        default:
        unknown++;
        if(unknown>3)
            {
            fp.close();
            return;
            }
        break;
      }
    }
}

/*
 *      save_z1 - Write the object layer, or a savegame
 */

void save_z1(char *filename)
{
OBJECT *temp,*owner;
long objtot;
int vx,vy;

// Open the file.

ofp=fopen(filename,"wb");
if(!ofp)
    {
    if(!in_editor)
        {
        C_printf("Oh no!\n");
        C_printf("Could not create file '%s'\n",filename);
        }
    return;
    }

// First, set each object so it has an ID of its own and knows which object
// it is inside (if any)

objctr=1;
for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy); // RAWobjectbase ignores large objs
        for(;temp;temp=temp->next)
            {
            temp->save_id=objctr;
            temp->inside_id=0;
            if(temp->pocket)
                SumContainers(temp->pocket,objctr);
            objctr++;
            }
        }
objtot=objctr-1;

//      Write the header
fwrite(COOKIE_MZ1,1,40,ofp);        // Cookie
putl(objtot,ofp);                   // Number of objects
putl(sizeof(OBJECT),ofp);           // Size of data structure

//      Write each object

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy);
        for(;temp;temp=temp->next)
            {
            fwrite(temp,1,sizeof(OBJECT),ofp);
            fwrite(temp->name,1,32,ofp);
#ifdef LOG_RW
            boot2("Object ID %d (%s) is outside at %d,%d\n", temp->save_id,temp->name,temp->x,temp->y);
#endif
            if(temp->pocket)
                WriteContainers(temp->pocket);
            }
        }

putb(!show_roof,ofp);


//      Append object statistics

putb('2',ofp);

putl(sizeof(STATS),ofp);

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy);
        for(;temp;temp=temp->next)
            {
            // Put object's ID number
            putl(temp->save_id,ofp);

            // Translate stats->owner from pointer into ID number

            // Here we convert the pointer into an integer ID value
            // which we can decode when we have reloaded and any pointer
            // would no longer make sense and be invalid.
            // We use a cast to shoe-horn the integer into the pointer member.

            owner = temp->stats->owner;
            if(owner)
                temp->stats->owner=(OBJECT *)temp->stats->owner->save_id;

            // Write the data
            fwrite(temp->stats,1,sizeof(STATS),ofp);

            // Restore stats->owner
            temp->stats->owner = owner;
            if(temp->pocket)
                WriteContainerStats(temp->pocket);
            }
        }

//      Append personal names

putb('3',ofp);

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy);
        for(;temp;temp=temp->next)
            {
            putl(temp->save_id,ofp);
            fwrite(temp->personalname,32,sizeof(char),ofp);
            if(temp->pocket)
                WriteContainerName(temp->pocket);
            }
        }

/*
//      Append object schedules

putb('4',ofp);

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy);
        for(;temp;temp=temp->next)
            {
            putl(temp->save_id,ofp);
            for(ctr=0;ctr<24;ctr++)
                if(!temp->schedule[ctr])
                    {
                    putl(0,ofp);
                    putl(0,ofp);
                    putl(0,ofp);
                    putl(0,ofp);
                    }
                else
                    fwrite(temp->schedule[ctr],1,16,ofp);
            if(temp->pocket)
                WriteContainerSchedules(temp->pocket);
            }
        }
*/

//      Append custom functions

putb('5',ofp);

putl(sizeof(FUNCS),ofp);

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        temp = GetRawObjectBase(vx,vy);
        for(;temp;temp=temp->next)
            {
            if(temp->funcs->dirty)
                {
                putl(temp->save_id,ofp);
                fwrite(temp->funcs,1,sizeof(FUNCS),ofp);
                }
            if(temp->pocket)
                WriteContainerFuncs(temp->pocket);
            }
        }
putl(0xffffffff,ofp); // sentinel value for Custom Functions (blk5)

putb('q',ofp);
fclose(ofp);
}

/*
 *      wipe_z1 - deallocate the z1 layer entirely
 *                called prior to load_z1 in game, not in editor
 */

void wipe_z1()
{
OBJECT *temp,*anchor;
int vx,vy;

boot2("\nwiping objectstore\n");

for(vx=0;vx<OSTORE;vx++)
    if(objectstore[vx])
        objectstore[vx]->flags.on=0;

boot2("wiping object matrix\n");

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        {
        anchor = GetRawObjectBase(vx,vy); // RAWobjectbase ignores large objs
        if(anchor)
                for(temp = anchor;temp;temp=temp->next) temp->flags.on=0;
        }

boot2("Emptying Syspocket\n\n");
FreePockets(curmap.object);

pending_delete=1;       // Force garbage collection
DeletePending();
player=NULL;

boot2("\nwiping party members\n\n");

for(vx=0;vx<MAX_MEMBERS;vx++)
    party[vx]=NULL;
}

//
//      Z2 rooftops layer map IO
//

/*
 *      load_z2 - Load the rooftops from disk
 */

void load_z2()
{
LOAD fp;

//      Objects layer 2 - roof

strcpy(stemp,mapname);
strcat(stemp,".mz2");

if(!exist(stemp))
	{
	bootmsg("Could not find file '%s'\n",stemp);
	bootmsg("Hit Y to create a new file, or any other key to exit.");
	key=SYS_KEY_WAIT();
	if(key!=KEY_Y && key!='y' && key!='Y')
//	if(key!='Y'&&key!='y')
		exit(1);
	}
else
	{
	fp.open(stemp);
	fp.read(sigtemp,1,40);
	if(strcmp(sigtemp,COOKIE_MZ2))
		{
		bootmsg("File '%s' is not a z2 map.. it does not contain the right cookie\n",stemp);
		exit(1);
		}

        fp.read(curmap.roof,curmap.w*curmap.h,sizeof(unsigned char));
	fp.close();
        }
}

/*
 *      save_z2 - Save the rooftops to disk
 */

void save_z2()
{
FILE *ofp;

//      Objects layer 2 - roof

strcpy(stemp,mapname);
strcat(stemp,".mz2");

ofp = fopen(stemp,"wb");

if(!ofp)
    {
    if(!in_editor)
        {
        C_printf("Oh no!\n");
        C_printf("Could not create file '%s'\n",stemp);
        }
    return;
    }

fwrite(COOKIE_MZ2,1,40,ofp);
fwrite(curmap.roof,curmap.w*curmap.h,sizeof(unsigned char),ofp);
fclose(ofp);
return;
}

// Miscellaneous State

/*
 *      load_ms - Read miscellaneous savegame data
 */

void load_ms(char *filename)
{
FILE *ifp;
char buf[128];
int t,ctr;

// Open the file.

ifp=fopen(filename,"rb");
if(!ifp)
    return;

//      Write the header

fread(buf,1,40,ifp);                     // Cookie
if(strcmp(COOKIE_MS,buf))
    {
    fclose(ifp);
    return;
    }

player = find_id(getl(ifp));                    // Find the player
if(!player)
    panic("load_ms","Player AWOL in savegame",NULL);

for(ctr=0;ctr<MAX_MEMBERS;ctr++)
    {
    t = getl(ifp);
    if(t)
        {
        party[ctr] = find_id(t);              // ID numbers change to objptrs
        party[ctr]->flags.party = 1;
        }
    else
        party[ctr] = NULL;
    }

if(getl(ifp) != STORE)          // Oh no!
    {
    fclose(ifp);
    return;
    }
fread(storage,1,STORE,ifp);

Wipe_tFlags();
t=getl(ifp);
for(ctr=0;ctr<t;ctr++)
    {
    fread(buf,1,getb(ifp),ifp);
    Set_tFlag(buf,1);
    }

/*
if(getl(ifp) != OSTORE)
    {
    fclose(ifp);
    return;
    }

for(ctr=0;ctr<=OSTORE;ctr++)
    objectstore[ctr] = iuitab[getl(ifp)];
*/

fclose(ifp);
}

/*
 *      save_ms - Write miscellaneous savegame data
 */

void save_ms(char *filename)
{
long i;
int ctr;

ofp=fopen(filename,"wb");
if(!ofp)
    {
    if(!in_editor)
        {
        C_printf("Oh no!\n");
        C_printf("Could not create file '%s'\n",filename);
        }
    return;
    }

//      Write the header

fwrite(COOKIE_MS,1,40,ofp);                     // Cookie

putl(player->save_id,ofp);                      // The Player

for(ctr=0;ctr<MAX_MEMBERS;ctr++)
    {
    i=0;                        // Get the member's ID without blowing up
    if(party[ctr])              // if the member does not exist.
        i=party[ctr]->save_id;
    putl(i,ofp);                // Write the ID number, or 0 for N/A
    }

putl(STORE,ofp);
fwrite(storage,1,STORE,ofp);

// Flags: find all flags which are TRUE

i=0;
for(ctr=0;ctr<MAXFLAGS;ctr++)
    if(tFlag[ctr])
        {
        if(!tFlagIdentifier[ctr])
            {
            Bug("Flag is TRUE but has no identifier!\n");
            break;
            }
        i++;
        }
putl(i,ofp);

// Now write the names to disk

for(ctr=0;ctr<MAXFLAGS;ctr++)
    if(tFlag[ctr])
        {
        i = strlen(tFlagIdentifier[ctr]);
        putb((char)i,ofp);
        fwrite(tFlagIdentifier[ctr],1,i,ofp);
        }

/*
putl(OSTORE,ofp);
for(ctr=0;ctr<=OSTORE;ctr++)
    putl(getnum4object(objectstore[ctr]),ofp);   // Write the IUI numbers
*/

fclose(ofp);

}


//======================================================================
//===========  Auxiliary functions for map IO systems ==================
//======================================================================

/*
 *    MoveToPocketEnd()  -  Move an object into the end of someone's pocket
 *                          Only for objects in the main objlist
 */

void MoveToPocketEnd(OBJECT *object, OBJECT *container)
{
OBJECT *temp;
int num;

// Check for silliness.  This error has never happened to me, but if it
// does I thought that you should know.

if(!object || !container)
    {
    C_printf("MoveToPocketEnd(%x,%x) attempted\n",object,container);
    Bug("MoveToPocketEnd(%x,%x) attempted\n",object,container);
    return;
    }

// Look for the object in the list

for(temp=curmap.object;temp->next;temp=temp->next)
	if(temp->next==object)
		{
                LL_Remove(&curmap.object->next,object);
                LL_Add(&container->pocket,object);      // Add to end
                // Store the value of Fixed in seekstate which won't notice
                num = getnum4char(object->name);
                object->flags.seekstate=CHlist[num].flags.fixed;
                object->flags.fixed=1;
		return;
		}
panic("MoveToPocketEnd","This object was not in the list:",object->name);
}


/*
 *      SumContainers - Set up objects in pockets so they point to their
 *                      parent.  Recursive, called by save_z1
 */

void SumContainers(OBJECT *cont, long parent)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    temp->save_id = ++objctr;
    temp->inside_id = parent;
    if(temp->pocket)
        SumContainers(temp->pocket,temp->save_id);
    }
return;
}


/*
 *      WriteContainers - Write contents containers to disk.
 *                        Recursive, called by save_z1
 */

void WriteContainers(OBJECT *cont)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
#ifdef LOG_RW
    boot2("Object ID %d (%s) is inside %d\n", temp->save_id,temp->name,temp->inside_id);
#endif
    fwrite(temp,1,sizeof(OBJECT),ofp);
    fwrite(temp->name,1,32,ofp);
    if(temp->pocket)
        WriteContainers(temp->pocket);
    }

return;
}

/*
 *      WriteContainerSchedules - Write Schedules of container contents
 */

void WriteContainerSchedules(OBJECT *cont)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    putl(temp->save_id,ofp);
    for(int ctr=0;ctr<24;ctr++)
        if(!temp->schedule[ctr])
            {
            putl(0,ofp);
            putl(0,ofp);
            putl(0,ofp);
            putl(0,ofp);
            }
        else
            fwrite(temp->schedule[ctr],1,16,ofp);
    if(temp->pocket)
        WriteContainerSchedules(temp->pocket);
    }

return;
}

/*
 *      WriteContainerStats - Write Stats of container contents
 */

void WriteContainerStats(OBJECT *cont)
{
OBJECT *owner;

for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    putl(temp->save_id,ofp);
    // Change stats->owner from pointer to ID number
    owner = temp->stats->owner;
    // Again, stuff the integer into the pointer member with a cast
    if(owner)
        temp->stats->owner = (OBJECT *)owner->save_id;

    // Write the data
    fwrite(temp->stats,1,sizeof(STATS),ofp);
    // Restore stats->owner pointer
    temp->stats->owner = owner;
    if(temp->pocket)
        WriteContainerStats(temp->pocket);
    }

return;
}

/*
 *      WriteContainerFuncs - Write custom functions of container contents
 */

void WriteContainerFuncs(OBJECT *cont)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    if(temp->funcs->dirty)
        {
        putl(temp->save_id,ofp);
        fwrite(temp->funcs,1,sizeof(FUNCS),ofp);
        }
    if(temp->pocket)
        WriteContainerFuncs(temp->pocket);
    }

return;
}


/*
 *      WriteContainerNames - Write personalname of container contents
 */

void WriteContainerName(OBJECT *cont)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    putl(temp->save_id,ofp);
    fwrite(temp->personalname,32,sizeof(char),ofp);
    if(temp->pocket)
        WriteContainerName(temp->pocket);
    }

return;
}


/*
 *      find_id - Look for an ID number on the map and return the objptr
 */

OBJECT *find_id(long id)
{
int vx,vy;
OBJECT *temp,*search;

for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        for(temp = GetRawObjectBase(vx,vy);temp;temp=temp->next)
            {
            if(temp->save_id == id)
                return temp;
            if(temp->pocket)
                {
                search = SearchContainer_id(temp->pocket,id);
                if(search)
                    return search;
                }
            }
return NULL;
}

/*
 *      SearchContainer_id - Return the pocket which contains the object.
 *                           Recursive, called by find_id
 */

OBJECT *SearchContainer_id(OBJECT *cont, long id)
{
OBJECT *search;

for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    if(temp->save_id == id)
        return temp;
    if(temp->pocket)
        {
        search = SearchContainer_id(temp->pocket,id);
        if(search)
            return search;
        }
    }
return NULL;
}


