#
# Makefile for IRE, borrowed from MIKMOD 3.0
#

all: ire.beos #ed.exe

# Use the C or C++ compiler
CC                = gcc
CFLAGS            = -I. -Iitg -I/boot/beos/develop/headers -gdwarf-2 -Wunused -O6
LFLAGS		  = -L/boot/beos/system/add-ons

Lib_files         = itg/beos/itg70.a seer/beos/libseer.a # libgame.so libbe.so

ire_obj = at_exit.o bitmap_c.o console.o darkness.o fs.o doslib.o\
	init.o ire.o ire_game.o sys_beos.o\
	linklist.o loaders.o loadsave.o memory.o object.o\
	oscli.o project.o rgb_conv.o script.o nosound.o nuspeech.o\
	system.o textfile.o timer_b.o vidmodes.o

ed_obj = gui/about.o gui/backgrnd.o gui/bigmap.o gui/editor.o\
	 gui/gfx.o gui/igui.o gui/mouse.o gui/objects.o gui/roof.o\
	allegro/irq.o allegro/irqwrap.o\
	bitmap_c.o console.o dummy.o dummy_c.o fs.o init.o linklist.o\
	loaders.o loadsave.o memory.o object.o oscli.o rgb_conv.o script.o\
	spchlib.o sys_dos.o textfile.o vidmodes.o


####################
## Makefile rules ##
####################

ire.beos: $(ire_obj) $(Lib_files)
	gcc $(LFLAGS) $(ire_obj) $(Lib_files) -lgame -lbe -lSDL -o ire.be

ed.exe: $(ed_obj) $(Lib_files)
	gcc $(ed_obj) $(Lib_files) -o ed.exe

%.o: %.c
	$(CC) -c $(CFLAGS) $< -o $@

%.o: %.cc
	$(CC) -c $(CFLAGS) $< -o $@

%.o: %.cpp
	$(CC) -c $(CFLAGS) $< -o $@

%.o: %.S
	$(CC) -c $(CFLAGS) $< -o $@

clean:
	-rm -f *.o
	-rm -r ire.be
