/*
 *      Memory manager for IRE
 */

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

#include <sys/types.h>
// MR: modified
#if !defined(__BEOS__) && !defined(_WIN32)
#include <sys/mman.h>
#endif

#include "sys.hpp"
#include "memory.hpp"
#include "console.hpp"

// Variables

long M_core=0;
int log_mem_usage=0;

// Functions

extern void panic(char *a,char *b,char *c);

// Code

/*
 *      M_init - Get initial memory usage
 */

void M_init()
{
if(M_core)              // Is Memory already initialised?
          return;

M_core = coreleft();    // Get total free memory

printf("\rM_init() : 0x%lx bytes free\n",M_core);
}

/*
 *      M_term - Close up memory system
 */

void M_term()
{
M_core = NULL;
}

/*
 *      M_get - allocate a block of memory
 */
#ifndef FORTIFY
void *M_get(unsigned int quantity,long wanted)
{
void *temp;
long qty;

qty=quantity*wanted;

if(qty<1)
	M_error2("M_get() - Silly memory request: ",qty);

temp=calloc(quantity,wanted);
if(!temp)
	M_error2("M_get() - Out of memory requesting: ",qty);

if(log_mem_usage)
    boot2("Alloc %d [%x]\n",qty,temp);

return temp;
}
#endif

/*
 *      M_free - free a block of memory
 */

#ifndef FORTIFY
void M_free(void *M_bank)
{
if(log_mem_usage)
    boot2("Free [%x]\n",M_bank);

if(M_bank)
    free(M_bank);
else
    M_error2("Attempting to free a NULL pointer",NULL);
M_bank = NULL;
}
#endif

void M_error2(char *msg,unsigned long a)
{

printf("%s %ld\n",msg,a);
printf("%ld bytes left.",coreleft());
printf("The call was made from %s\n",cfa);

exit(1);
}

void M_error(char *msg)
{
printf("%s\n",msg);
printf("The call was made from %s\n",cfa);

exit(1);
}


/*
 *      Coreleft - Return amount of memory left to nearest 4k page
 */

long coreleft()
{
return SYS_CORELEFT();
}


