//
//      Sound/Timer engine wrappers for Midas-unsupported OS
//
#ifndef __BEOS__
#error This file is only for systems midas does not support yet!
#endif


#include <unistd.h>     // This is for sleep, in the timer check routine
#include <stdlib.h>     // atexit(), random
#include <string.h>     // String splicing routines

#include "doslib.hpp"
#include "sound.hpp"    // Us
#include "memory.hpp"   // Memory system
#include "console.hpp"  // Graphical console and logger
#include "fs.hpp"       // Filesystem routines
#include "vidmodes.h"

// defines

#define TIMER_INT 8     // Reprogram int 8
#define QUEUE_RATE 32   // Refresh sound queue every 32 clock cycles

// variables

extern char mus_chan;                      // Number of music channels
extern char sfx_chan;                      // Number of effects channels
extern int  driftlevel;                    // Amount of frequency variation

static int sf_volume = 63;
static int mu_volume = 0;

static char string[32];    // For string splicing
static char T_Running=0;   // Is the timer running?
static char S_Running=0;   // Is the sound running?
int Songs=0;
int Waves=0;
static int pausedata=0;   // Speed of song before pausing, 0 if not paused
static int cursong=-1;

struct SMTab *wavtab;       // Tables of data for each sound and song.
struct SMTab *modtab;       // Filled by script.cc

// functions

void S_Init();              // Set up sound device
void S_Load();              // Load the sound and music
void S_Start();             // Start the mixing kernel
void S_Term();              // Stop the mixing kernel and shut down
void S_SoundVolume();       // Set the Sound volume
void S_MusicVolume();       // Set the Music volume
void S_PlaySample(int s);   // Play a sound sample
void S_PlayModule(int s);   // Play a music module
void S_StopModule();        // Stop the music
char S_Sync();              // Make sure the timer is working

void T_Init();              // Animation timer
void T_Term();

//static void S_Tickhandler(void); // Mixer refresh
static void LoadMods();
static void LoadWavs();
static int  GetWavFreq(FILE *fp);               // Get frequency

extern "C" int T_Midas_Init();
extern "C" void T_Midas_Term();

// Public code

/*
 *      S_Init - Load in the soundcard settings and set up the device
 */

void S_Init()
{
if(S_Running)          // Safety valve
    return;

// Announce the sound library

bootmsg("S_Init()\n");
bootmsg("  Bugger-all sound system initialising...\n");

bootmsg("  Init successful\n");

S_Running=1;                    // Right! Let's go...
}


/*
 *      S_Start - Start the actual 'sound' output
 */

void S_Start()
{
cfa = "S_Start";
boot2("S_Start()\n");

T_Midas_Init();
//mp_volume = 100;
}


/*
 *      S_Term - Stop the sound process
 */

void S_Term()
{
cfa = "S_Term";
if(!S_Running)          // Safety valve
    return;

boot2("S_Term()\n");

S_Running=0;            // We could actually restart the system now
boot2("runstop\n");
}


/*
 *      S_Load - Load in the music and samples.
 */

void S_Load()
{
bootmsg("S_Load()\n");
}

/*
 *      T_Init - Start the timer
 */

void T_Init()
{
cfa = "T_Init";
boot2("T_Init()\n");
T_Running = 1;
T_Midas_Init();

}


/*
 *      T_Term - Stop the timer
 */

void T_Term()
{
cfa = "T_Term";
if(!T_Running)
    return;
boot2("T_Term()\n");

T_Midas_Term();
T_Running = 0;

}


/*
 *      S_MusicVolume - Set the music level
 */

void S_MusicVolume(int vol)
{
return;
}


/*
 *      S_SoundVolume - Set the effects level
 */

void S_SoundVolume(int vol)
{
return;
}


/*
 *   S_PlayModule - play a music module from the array song[]
 *                  may disrupt the sound effects slightly
 */

void S_PlayModule(char *name)
{
return;
}

/*
 *   S_PauseModule - Stop music, not SFX
 */

void S_PauseModule()
{
return;
}

/*
 *   S_UnPauseModule - Restart music
 */

void S_UnPauseModule()
{
return;
}

/*
 *   S_PlaySample - play a sound sample.
 */

void S_PlaySample(char *name)
{
return;
}


//
//   Private code hereon
//

void MIDASerror(void)
{
return;
}

