/*
 *      NuSpeech - A script-based conversation engine
 *                 Beware: the parser is a bit ugly
 *
 *      To Do:
 *                 Switch to print invalid lines to boot2?
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "script.hpp"
#include "core.hpp"
#include "fs.hpp"
#include "textfile.hpp"
#include "sys.hpp"
#include "console.hpp"
#include "keys.hpp"
#include "loaders.hpp"
#include "doslib.hpp"
#define MAXLINKS 10

#define MAXFLAGS 8192

char tFlag[MAXFLAGS];
char *tFlagIdentifier[MAXFLAGS];

void Wipe_tFlags();
int Get_tFlag(char *name);
void Set_tFlag(char *name,int a);

static int numFlags=0;
static TF_S conversation;       // TextFile class instance
static char img[256];
static char curpage[256];
static char autolink[256];
static char temp[256];
static char backing[256];
static char exitvrm[64];
static char link[MAXLINKS][2][256];
static int linkptr,y;
static char scan_only=0;
static char *curfile;

void NPC_Converse(char *file,char *startpage);
void setPflag(OBJECT *o,int n,int s);
int getPflag(OBJECT *o,int n);

static int  NPC_ParseCode(char *line);
static int  NPC_GetPage(char *line);
static int  NPC_GetEnd(int start);
static void deck(char *line,char c);   // to 'deck' means to headbutt
static void NPC_ResetLinks();
static void NPC_AddLink(char *msg,char *dest);
static void toke(char *string);

extern OBJECT *player,*current_object;
extern TakeQuantity(OBJECT *container,char *objectname,int qty);
extern void AddQuantity(OBJECT *container,char *objectname,int qty);
extern int getnum4VRM(char *name);      // Get index of VRM function
extern void Call_VRM(int num);


/*
 *      NPC_Converse(file,startpage) - User function to start a conversation.
 *                                     File is the path to the conversation
 *                                     file using standard IRE conventions.
 *                                     startpage is a page title, or NULL
 *                                     to use 'start' as the starting page,
 */

void NPC_Converse(char *file,char *startpage)
{
int k,s;
int start,end,ctr,lines;
char msg[5];
char buffer[256];

conversation.init(file);
curfile=file;
fset(bg_screen,0,QTRBUFFERSIZE);

strcpy(backing,"\0");
strcpy(exitvrm,"\0");

if(!startpage)
    start=NPC_GetPage("start");
else
    start=NPC_GetPage(startpage);

if(start==-1)
    return;

lines=50;
k=-1;
linkptr=-1;

if(lines>conversation.lines)
    lines=conversation.lines;

end=NPC_GetEnd(start);

SYS_KEY_FLUSH();
do  {
    fblit(swapscreen,bg_screen);
    y=128;
    strcpy(img,"\0");
    strcpy(temp,"\0");
    strcpy(curpage,"\0");
    strcpy(autolink,"\0");
    NPC_ResetLinks();

    for(ctr=start;ctr<end;ctr++)
        {
        if(conversation.line[ctr][0] != '[')
            {
            strcpy(buffer,conversation.line[ctr]);
            toke(buffer);
            C_printxy(0,y+=8,buffer);
            }
        else
            NPC_ParseCode(conversation.line[ctr]);
        }

    s = getnum4sprite(img);
    if(s>0)
        SPlist[s].image.cel_put_sprite((640-SPlist[s].w)/2,0,swapscreen);

    C_color(0,0,160);

    y+=32;
    for(ctr=0;ctr<linkptr;ctr++)
        {
        itoa(ctr+1,msg,10);
        C_printxy(0,y,msg);
        C_printxy(16,y,link[ctr][1]);
        y+=8;
        }

    C_color(255,255,255);


    // If no links, print an error and finish

    if(!autolink[0] && !linkptr)
        {
        C_color(255,0,0);
        C_printxy(16,y,"Error!  No links on this page.  Press any key to exit..");
        C_color(255,255,255);
        Bug("No links for page '%s' in file '%s'\n",curpage,file);
        update(swapscreen);
        strcpy(autolink,"exit"); // This will make it exit immediately
        }

    update(swapscreen);
    SYS_KEY_FLUSH();
    k=SYS_KEY_WAIT();
    if(k==KEY_F10)
        BMPshot((short *)swapscreen,640);

    if(autolink[0] != 0)        // If there's an automatic page change
        {
        ctr=NPC_GetPage(autolink);
        if(ctr>0)
            {
            start=ctr;
            end=NPC_GetEnd(start);
            }
        if(ctr==-2)             // -2 means end-of-conversation
            k=KEY_ESC;
        }
    else
        {
        ctr = k - KEY_1;
        if(ctr>=0 && ctr<linkptr)
            {
            start=NPC_GetPage(link[ctr][0]);
            if(start==-1)   // Error in code
                {
                Bug("Conversation: broken link.  Could not find page '%s'\n",link[ctr][0]);
                return;
                }
            if(start==-2)   // End of conversation
                k=KEY_ESC;
            end=NPC_GetEnd(start);
            }
        }

    } while(k!=KEY_ESC);
SYS_KEY_FLUSH();

conversation.term();
display_PCX("backings/panel",(short *)swapscreen);

k = getnum4VRM(exitvrm);
if(k)
    Call_VRM(k);
}

/*
 *      NPC_ParseCode(line) - Parse the given line and return an opcode.
 *                            This is the core of the conversation engine.
 */


int NPC_ParseCode(char *line)
{
char line1[1024];
char line2[1024];
char *pos;
OBJECT *obj;
int rgb,r,g,b;

if(!line)
    return 0;

strcpy(line1,line);

deck(line1,'[');
deck(line1,'\"');
deck(line1,']');
deck(line1,0xa);
deck(line1,0xd);
Strip(line1);

strcpy(line2,first(line1));

if(!stricmp(line2,"page") || !stricmp(line2,"page="))
    {
    strcpy(curpage,rest(line1));
    Strip(curpage);
    return 2;
    }

if(!stricmp(line2,"endpage"))
    return 3;

if(!stricmp(line2,"backing") || !stricmp(line2,"backing="))
    {
    strcpy(backing,rest(line1));
    deck(backing,'\"');
    deck(backing,']');
    display_PCX(backing,(short *)bg_screen);
    fblit(swapscreen,bg_screen);
    return 13;
    }

if(scan_only)
    return 0;

if(!stricmp(line2,"image") || !stricmp(line2,"image="))
    {
    strcpy(img,rest(line1));
    Strip(img);

    // IMG is now the name of the sprite to be used

    r = getnum4sprite(img);     // If it exists, find it
    if(r>0)
        r=SPlist[r].h;          // Extract the height..
    if(r>128)                   // If it's bigger than 128 pixels
        y=r+16;                 // then make room for it.
    return 1;
    }

if(!stricmp(line2,"nextpage") || !stricmp(line2,"nextpage="))
    {
    if(autolink[0]!=0)  // Already an automatic link.  Use by preference.
        return 4;
    strcpy(autolink,rest(line1));
    Strip(autolink);
    return 4;
    }

if(!stricmp(line2,"link") || !stricmp(line2,"link="))
    {
    strcpy(temp,rest(line1));
    Strip(temp);
    return 5;
    }

if(!stricmp(line2,"linkto") || !stricmp(line2,"linkto="))
    {
    NPC_AddLink(rest(line1),temp);
    strcpy(temp,"\0");
    return 6;
    }

if(!stricmp(line2,"if"))
    {
    if(!Get_tFlag(first(rest(line1))))
        return 8;
    pos=strchr(line,']');
    if(!pos)
        {
        Bug("Missing ] in line: %s\n",line);
        return 8;
        }
    pos++;

    if(pos[0]=='[')
        return(NPC_ParseCode(pos));
    else
        C_printxy(0,y+=8,pos);
    return 8;
    }

if(!stricmp(line2,"if_not"))
    {
    if(Get_tFlag(first(rest(line1))))
        return 8;
    pos=strchr(line,']');
    if(!pos)
        {
        Bug("Missing ] in line: %s\n",line);
        return 8;
        }
    pos++;

    if(pos[0]=='[')
        return(NPC_ParseCode(pos));
    else
        C_printxy(0,y+=8,pos);
    return 8;
    }

if(!stricmp(line2,"call") || !stricmp(line2,"call=")
|| !stricmp(line2,"callvrm") || !stricmp(line2,"callvrm=")
|| !stricmp(line2,"call_vrm") || !stricmp(line2,"call_vrm="))
    {
    strcpy(temp,rest(line1));
    Strip(temp);
    r = getnum4VRM(temp);
    if(r)
        Call_VRM(r);
    strcpy(temp,"\0");
    return 9;
    }

if(!stricmp(line2,"set"))
    {
    Set_tFlag(first(rest(line1)),1);
    return 10;
    }

if(!stricmp(line2,"clr") || !stricmp(line2,"clear"))
    {
    Set_tFlag(first(rest(line1)),0);
    return 10;
    }

if(!stricmp(line2,"colour=") || !stricmp(line2,"color="))
    {
    pos=strchr(line,'#');
    if(!pos)
        {
        Bug("Colour is not specified properly on line: %s\n",line);
        return 11;
        }
    pos++;
    strcpy(line2,pos);  // Isolate just the hex number
    line2[7]=0;
    sscanf(line2,"%x",&rgb);   // Got it in binary.
    r=(rgb>>16)&0xff;   // get Red
    g=(rgb>>8)&0xff;    // get green
    b=rgb&0xff;         // get blue

    pos=strchr(line,']');
    if(!pos)
        {
        Bug("Colour is not specified properly on line: %s\n",line);
        return 11;
        }
    pos++;

    C_color(r,g,b);
    strcpy(line2,pos);
    toke(line2);
    C_printxy(0,y+=8,line2);
    C_color(255,255,255);
    return 11;
    }

if(!stricmp(line2,"remove") || !stricmp(line2,"destroy"))
    {
    strcpy(temp,first(rest(line)));
    r = atoi(temp);
    strcpy(temp,first(rest(rest(line))));
    deck(temp,']');
    Strip(temp);
    Set_tFlag("true",0);
    Set_tFlag("false",1);
    if(TakeQuantity(player,temp,r))
        {
        Set_tFlag("true",1);
        Set_tFlag("false",0);
        }
    return 12;
    }

if(!stricmp(line2,"create"))
    {
    strcpy(temp,first(rest(line)));
    r = atoi(temp);
    strcpy(temp,first(rest(rest(line))));
    deck(temp,']');
    Strip(temp);
    AddQuantity(player,temp,r);
    return 12;
    }

if(!stricmp(line2,"set_personal_flag")|| !stricmp(line2,"set_pflag"))
    {
    setPflag(current_object,atoi(first(rest(line1))),1);
    return 14;
    }

if(!stricmp(line2,"clear_personal_flag") || !stricmp(line2,"clear_pflag")
|| !stricmp(line2,"clr_personal_flag")|| !stricmp(line2,"clr_pflag"))
    {
    setPflag(current_object,atoi(first(rest(line1))),0);
    return 14;
    }

if(!stricmp(line2,"if_pflag") || !stricmp(line2,"ifpflag")
|| !stricmp(line2,"if_personal_flag") || !stricmp(line2,"ifpersonalflag"))
    {
    if(!getPflag(current_object,atoi(first(rest(line1)))))
        return 15;                                      // If not true, abort
    pos=strchr(line,']');
    if(!pos)
        {
        Bug("Missing ] in line: %s\n",line);
        return 15;
        }
    pos++;

    if(pos[0]=='[')
        return(NPC_ParseCode(pos));
    else
        C_printxy(0,y+=8,pos);
    return 15;
    }

if(!stricmp(line2,"if_npflag") || !stricmp(line2,"ifnpflag")
|| !stricmp(line2,"if_not_pflag") || !stricmp(line2,"ifnotpflag")
|| !stricmp(line2,"if_not_personal_flag") || !stricmp(line2,"ifnotpersonalflag"))
    {
    if(getPflag(current_object,atoi(first(rest(line1)))))
        return 15;                                    // If true, abort
    pos=strchr(line,']');
    if(!pos)
        {
        Bug("Missing ] in line: %s\n",line);
        return 15;
        }
    pos++;

    if(pos[0]=='[')
        return(NPC_ParseCode(pos));
    else
        C_printxy(0,y+=8,pos);
    return 15;
    }

if(!stricmp(line2,"is_in_party") || !stricmp(line2,"in_in_party?")
|| !stricmp(line2,"in_party") || !stricmp(line2,"in_party?"))
    {
    Set_tFlag("true",0);
    Set_tFlag("false",1);
    for(r=0;r<MAX_MEMBERS;r++)
        if(party[r] == current_object)
            {
            Set_tFlag("true",1);
            Set_tFlag("false",0);
            }
    return 16;
    }

if(!stricmp(line2,"on_exit_call") || !stricmp(line2,"on_exit_call=")
|| !stricmp(line2,"at_exit_call") || !stricmp(line2,"at_exit_call=")
|| !stricmp(line2,"call_at_exit") || !stricmp(line2,"call_at_exit=")
|| !stricmp(line2,"call_on_exit") || !stricmp(line2,"call_on_exit=")
|| !stricmp(line2,"at_exit_callvrm") || !stricmp(line2,"at_exit_callvrm=")
|| !stricmp(line2,"at_exit_call_vrm") || !stricmp(line2,"at_exit_cal_lvrm=")
|| !stricmp(line2,"on_exit_callvrm") || !stricmp(line2,"on_exit_callvrm=")
|| !stricmp(line2,"on_exit_call_vrm") || !stricmp(line2,"on_exit_cal_lvrm="))
    {
    strcpy(exitvrm,rest(line1));
    Strip(exitvrm);
    return 17;
    }

if(!stricmp(line2,"am_carrying") || !stricmp(line2,"is_carrying")
|| !stricmp(line2,"is_in_pocket"))
    {
    Set_tFlag("true",0);
    Set_tFlag("false",1);
    strcpy(temp,first(rest(line)));
    deck(temp,']');
    Strip(temp);
    for(obj=player->pocket;obj;obj=obj->next)
        if(!stricmp(obj->name,temp))
            {
            Set_tFlag("true",1);
            Set_tFlag("false",0);
            return 18;
            }
    return 18;
    }

// Take from Player and give to the guy you're talking to

if(!stricmp(line2,"take"))
    {
    strcpy(temp,first(rest(line)));
    r = atoi(temp);
    strcpy(temp,first(rest(rest(line))));
    deck(temp,']');
    Strip(temp);
    Set_tFlag("true",0);
    Set_tFlag("false",1);
    if(TakeQuantity(player,temp,r))
        {
        Set_tFlag("true",1);
        Set_tFlag("false",0);
        AddQuantity(current_object,temp,r);
        }
    return 19;
    }

// Give to player, take from guy you're talking to

if(!stricmp(line2,"give"))
    {
    strcpy(temp,first(rest(line)));
    r = atoi(temp);
    strcpy(temp,first(rest(rest(line))));
    deck(temp,']');
    Strip(temp);
    Set_tFlag("true",0);
    Set_tFlag("false",1);
    if(TakeQuantity(current_object,temp,r))
        {
        Set_tFlag("true",1);
        Set_tFlag("false",0);
        AddQuantity(player,temp,r);
        }
    return 20;
    }

boot2("Parse error in file '%s':\n>>%s",curfile,line);
return 0;
}

/*
 *      NPC_GetPage(title) - Find the string '[page="title"]' and return
 *                           the line number where it's found
 */

int NPC_GetPage(char *name)
{
int ctr;
if(!stricmp(name,"exit"))
    return -2;
scan_only=1;
for(ctr=0;ctr<conversation.lines;ctr++)
    if(NPC_ParseCode(conversation.line[ctr]) == 2)
        {
        if(!stricmp(curpage,name))
            {
            scan_only=0;
            return ctr;
            }
        }
scan_only=0;
return -1;
}

/*
 *      NPC_GetEnd(starting link) - Find the end of the current page
 */

int NPC_GetEnd(int start)
{
int ctr,lines;
lines=conversation.lines;
if(start<0)
    return -1;
scan_only=1;
for(ctr=start;ctr<lines;ctr++)
    if(NPC_ParseCode(conversation.line[ctr]) == 3)
        {
        scan_only=0;
        return ctr;
        }
scan_only=0;
return lines;
}

/*
 *      NPC_ResetLinks() - Erase the links table
 */

void NPC_ResetLinks()
{
linkptr=0;
return;
}

/*
 *      NPC_AddLink(title,address) - Add a link to the table
 */

void NPC_AddLink(char *msg, char *dest)
{
if(linkptr>=MAXLINKS)
    return;
strcpy(link[linkptr][0],msg);
strcpy(link[linkptr][1],dest);
Strip(link[linkptr][0]);
Strip(link[linkptr][1]);
linkptr++;
}

/*
 *      deck(string,char) - Find all occurences of a character and "deck 'em"
 *                          i.e. turn them into spaces
 */

void deck(char *line,char c)
{
char *p;
do
    {
    p=strchr(line,c);
    if(p)
        *p=' ';
    } while(p);
}

/*
 *      toke(string) - search for and expand any system tokens in the string.
 *                     Modifies the given string so be sure it's not floating.
 */

void toke(char *string)
{
char *a;
char temp[1024];
char token[128];
char punctuation[]="  \0\0";
int k;
a=strchr(string,'$');
if(!a)
    return;      // No special tokens, don't need to change it

*a=0;
strcpy(temp,string);    // All up to the token
strcpy(token,(a+1));    // Copy the token to buffer

*rest(token)=0; // Make the token just one word
Strip(token);

punctuation[0]=' ';
k=strlen(token);

// Several cases where we deal with punctuation

// Case 1.  "name," the name, followed by a single punctuation character

if(token[k-1]<'a' && token[k-1]<'A')
    {
    punctuation[0]=token[k-1];
    token[k-1]=0;
    }
else // Case 2.  "name's" the name, followed by apostrophe and 's'
if(token[k-2]=='\'' && token[k-1]=='s')
    {
    punctuation[0]='\'';
    punctuation[1]='s';
    punctuation[2]=' ';
    token[k-2]=0;
    }
else // Case 3.  "name" No punctuation at all.
    punctuation[1]=0;

if(!strcmp(token,"PLAYER"))
    {
    strcat(temp,player->personalname);
    strcat(temp,punctuation);
    strcat(temp,rest((a+1)));
    strcpy(string,temp);
    return;
    }

if(!strcmp(token,"CHARNAME"))
    {
    strcat(temp,current_object->personalname);
    strcat(temp,punctuation);
    strcat(temp,rest((a+1)));
    strcpy(string,temp);
    return;
    }

}


/*
void NPC_DisplayFile(char *file)
{
int k,i,lines;
conversation.init(file);

i=0;
lines=50;
k=-1;

if(lines>conversation.lines)
    lines=conversation.lines;

SYS_KEY_FLUSH();
do  {
    fset(swapscreen,0,QTRBUFFERSIZE);
    for(int ctr=0;ctr<lines;ctr++)
        C_printxy(0,ctr<<3,conversation.line[ctr+i]);
    update(swapscreen);
    k=SYS_KEY_WAIT();
    if(k == KEY_UP)
         {
         i--;
         if(i<0)
             i=0;
         }
    if(k == KEY_DOWN)
         {
         i++;
         if(i>conversation.lines-lines)
             i=conversation.lines-lines;
         }
    } while(k!=KEY_ESC);
SYS_KEY_FLUSH();

conversation.term();
}
*/

void setPflag(OBJECT *o,int n,int s)
{
int bit,mask;
if(n<0 || n>31)
    {
    Bug("Attempt to set invalid p-flag %d for object %s.\n",n,o->name);
    return;
    }

bit = 1<<n;
mask = bit ^ 0xffffffff;
if(s)
    o->stats->pFlags |= bit;
else
    o->stats->pFlags &= mask;
}

int getPflag(OBJECT *o,int n)
{
int bit;
if(n<0 || n>31)
    {
    Bug("Attempt to query invalid p-flag %d for object %s.\n",n,o->name);
    return 0;
    }

bit = 1<<n;
return (o->stats->pFlags & bit);
}

void NPC_Init()
{
int ctr;
for(ctr=0;ctr<MAXFLAGS;ctr++)
    {
    tFlag[ctr]=0;
    tFlagIdentifier[ctr]=NULL;
    }
numFlags=0;
}

void Wipe_tFlags()
{
int ctr;
for(ctr=0;ctr<MAXFLAGS;ctr++)
    {
    tFlag[ctr]=0;
    if(tFlagIdentifier[ctr])
        {
        M_free(tFlagIdentifier[ctr]);
        tFlagIdentifier[ctr]=NULL;
        }
    }
numFlags=0;
}

int Get_tFlag(char *name)
{
int ctr;

if(!numFlags)
    return tFlag[0];

for(ctr=0;ctr<=numFlags;ctr++)
    if(!stricmp(tFlagIdentifier[ctr],name))
        return(tFlag[ctr]);
return 0;
}

void Set_tFlag(char *name,int a)
{
int ctr,len;

for(ctr=0;ctr<MAXFLAGS;ctr++)
    if(tFlagIdentifier[ctr])
        {
        if(!stricmp(tFlagIdentifier[ctr],name))
            {
            tFlag[ctr]=a;
            return;
            }
        }
    else
        {
        len = strlen(name);
        tFlagIdentifier[ctr]=(char *)M_get(1,len+1);
        strcpy(tFlagIdentifier[ctr],name);
        tFlag[ctr]=a;
        numFlags=ctr;
        return;
        }

panic("NuSpeech.cc","Too many flags defined: attempted to make flag called:",name);
}


