#include "core.hpp"
#include "linklist.hpp"
#include "doslib.hpp"
#include "console.hpp"
#include "memory.hpp"
#include "script.hpp"
#include "bitmap.h"

// defines

#define CHECK_FOR_MOVE_UP_ARSE(X,Y); if(X==Y)\
    {\
    C_printf("Object '%s' tried to vanish up it's own arse\n",Y->name);\
    Bug("Object '%s' tried to vanish up it's own arse\n",Y->name);\
    return;\
    }

#define CHECK_FOR_PLAYER_GETTING_LOST(X); if(X == player)\
    {\
    return;\
    }

// variables

static char str[90];
char pending_delete=0;
char AL_dirty=0;

extern OBJECT *current_object;
extern OBJECT *victim;
extern OBJECT **objectstore;
extern OBJECT *player;
extern OBJECT *largemap[24][24];
extern int solidmap[24][24];
extern int mapx,mapy;
extern int follower,playervrm;
extern char do_cd,in_editor;

// functions

extern void Call_VRM(int v);

int AddToParty(OBJECT *new_member);
TILE *GetTile(int x,int y);
int isSolid(int x,int y);
int ChooseLeader(int x);
void SubFromParty(int member);
void gen_largemap();
extern void Init_Areas(OBJECT *objsel);

void AddQuantity(OBJECT *container,char *type,int request);
int TakeQuantity(OBJECT *container,char *type,int request);


/* Linked-list world functions */

void MoveToPocket(OBJECT *object, OBJECT *container);
void TransferToPocket(OBJECT *object, OBJECT *container);
int MoveFromPocket(OBJECT *object, OBJECT *container,int x,int y);

/* Matrix world functions */

void MoveToMap(int x, int y, OBJECT *object);
int DropObject(int x,int y, OBJECT *object);
void TakeObject(int x,int y, OBJECT *container);
int MoveObject(OBJECT *object,int x,int y);
void TransferObject(OBJECT *object,int x,int y);
OBJECT *GetObject(int x,int y);
OBJECT *GetObjectBase(int x,int y);
OBJECT *GetRawObjectBase(int x,int y);
OBJECT *GetSolidObject(int x,int y);
void ForceDropObject(int x,int y, OBJECT *object);
void FindEmptySquare(int *x,int *y);
OBJECT *LookInAllPocketsForTag(int tag);
OBJECT *LookInAllPocketsFor(OBJECT *obj);
int InPocket(OBJECT *obj);
void CreateContents(OBJECT *obj);
void MoveToTop(OBJECT *object);

static OBJECT *SearchContainerTag(OBJECT *cont, int tag);
static OBJECT *SearchContainer(OBJECT *cont, OBJECT *obj);
static int WeighObjectR(OBJECT *list);
OBJECT *GetFirstObject(OBJECT *cont, char *name);
int SumObjects(OBJECT *cont, char *name, int total);

// code


/*
 *    MoveToPocket()  -  Move an object into someone's pocket
 */

void MoveToPocket(OBJECT *object, OBJECT *container)
{
OBJECT *temp;
int ox,oy;

// Check for silliness.  This error has never happened to me, but if it
// does I thought that you should know.

if(!object || !container)
    {
    C_printf("MoveToPocket(%x,%x) attempted\n",object,container);
    Bug("MoveToPocket(%x,%x) attempted\n",object,container);
    return;
    }

/*
if(!object->flags.on)      // It's going to be deleted.  Skip it.
    return;*/
if(!container->flags.on)   // NOOO!
    return;


CHECK_FOR_MOVE_UP_ARSE(container,object);
CHECK_FOR_PLAYER_GETTING_LOST(object);

TransferToPocket(object,container);
}

/*
 *    TransferToPocket()  -  Force an object into someone's pocket
 */

void TransferToPocket(OBJECT *object, OBJECT *container)
{
OBJECT *temp;
int ox,oy;

// Look for the object in nowhere land (the system pockets)

for(temp=curmap.object;temp->next;temp=temp->next)
        {
	if(temp->next==object)
		{
                // Good we found it.  We are looking at the entry before it.
                temp->next = object->next;         // object no longer in list
                object->next = container->pocket;  // Get of pocket->next
                container->pocket = object;        // Object now in pocket
                ML_Del(&ActiveList,object);        // Idle while in pocket
		return;                            // Done
		}
        }

// Is it lying on the ground?

if(!InPocket(object))
    {
    ox = object->x;
    oy = object->y;
    TransferObject(object,0,0);
    TakeObject(0,0,container);
    object->x = ox;
    object->y = oy;
    return;
    }

// It must be in someone's pocket then

temp = LookInAllPocketsFor(object);
if(temp)
    {
    LL_Remove(&temp->pocket,object);
    object->next = container->pocket;  // Get of pocket->next
    container->pocket = object;        // Object now in pocket
    return;
    }

panic("move_to_pocket","This object could not be found:",object->name);
}


/*
 *    MoveFromPocket()  -  Move an object out of someone's pocket
 */

int MoveFromPocket(OBJECT *object, OBJECT *container, int x,int y)
{
OBJECT *temp;
int ok;

// Check for silliness

if(!object || !container)
    return 0;
if(!container->pocket)
    return 0;

//if(!object->flags.on)      // It's going to be deleted.  Skip it.
//    return 0;
if(!container->flags.on)   // NOOO!
    return 0;

// If there is something solid there, abort, unless it's a container

if(isSolid(x,y))
    {
    temp=GetSolidObject(x,y);   // Find the obstruction
    if(!temp)                   // None? Must be a tile then
        return 0;
    ok=1;
    if(!temp->flags.tabletop)   // You can only drop on tabletops
        ok=0;                   // Disable
    if(temp->flags.container)   // Unless there is a bag there
        ok=1;                   // Re-enable
    if(!ok)                     // Quit if disabled
        return 0;
    }

// Go through to be sure it is there.

for(temp = container->pocket;temp;temp=temp->next)
    if(temp == object)
        {
        LL_Remove(&container->pocket,object);
        DropObject(x,y,object);                     // Drop into the map
        return 1;
        }

return 0;
}

/*
 *    ForceFromPocket()  -  MoveFromPocket without checking for obstructions
 */

int ForceFromPocket(OBJECT *object, OBJECT *container, int x,int y)
{
OBJECT *temp;

// These checks are to prevent a crash

if(!object || !container)
    return 0;
if(!container->pocket)
    return 0;

//if(!object->flags.on)      // It's going to be deleted.  Skip it.
//    return 0;
if(!container->flags.on)   // NOOO!
    return 0;

for(temp = container->pocket;temp;temp=temp->next)
    if(temp == object)
        {
        LL_Remove(&container->pocket,object);
        ForceDropObject(x,y,object);                     // Drop into the map
        return 1;
        }

return 0;
}

/*
 *    MoveToMap(int x,int y,OBJECT *object)  -  Move object to the world
 */

void MoveToMap(int x, int y, OBJECT *object)
{
OBJECT *temp;

// Check for silliness.

if(!object)
    return;

// Look for the object in the list

for(temp=curmap.object;temp->next;temp=temp->next)
	if(temp->next==object)
		{
                // Good we found it.  We are looking at the entry before it.
                temp->next = object->next;         // object no longer in list
                ForceDropObject(x,y,object);
		return;                            // Done
		}

panic("move_to_map","This object was not in the list:",object->name);
}

/*
 *    DropObject(int x,int y,OBJECT *object)  -  Drop object at x,y
 */

int DropObject(int x,int y, OBJECT *object)
{
OBJECT *temp;
OBJECT *anchor;
int sx,sy;

object->next=NULL; // It will be put onto the end of the list

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
   {
   // Terminate melodramatically
   sprintf(str,"DropObject(%d,%d,%s) Attempted to put outside map boundary",x,y,object->name);
   panic(cfa,str,"Ai! ai!  A Balrog!  A Balrog is come!  'Tis Durin's Bane!");
   return 0;
   }

// Find the list we want to modify

anchor=GetObjectBase(x,y);
//anchor=curmap.objmap[ytab[y]+x];

// If there's a bag, drop it inside
temp=anchor;
if(temp)
    for(;temp;temp=temp->next)
        if(temp->flags.container)
            {
            FindEmptySquare(&sx,&sy);           // Find scratch space
            curmap.objmap[MAP_POS(sx,sy)]=object;  // Dump the object there
            TakeObject(sx,sy,temp);             // Shift it into the bag
            return 1;
            }

// Modify the object's X,Y coords to sync with the matrix

object->x=x;
object->y=y;

object->flags.fixed=object->flags.seekstate;    // Object wakes up
object->flags.seekstate=0;            // Reset seekstate for tracking engine
LL_Add(&curmap.objmap[MAP_POS(x,y)],object);
gen_largemap();
return 1;
}


/*
 *    ForceDropObject(int x,int y,OBJECT *object)  -  Drop object at x,y
 */

void ForceDropObject(int x,int y, OBJECT *object)
{
if(!object)
    return;

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
   {
   // Terminate melodramatically
   sprintf(str,"ForceDropObject(%d,%d,%s) Attempted to put outside map boundary",x,y,object->name);
   panic(cfa,str,"Ai! ai!  A Balrog!  A Balrog is come!  'Tis Durin's Bane!");
   return;
   }

// Modify the object's X,Y coords to sync with the matrix

object->x=x;
object->y=y;

object->flags.fixed=object->flags.seekstate;    // Object wakes up
object->flags.seekstate=0;            // Reset seekstate for tracking engine
LL_Add(&curmap.objmap[MAP_POS(x,y)],object);
gen_largemap();
}


/*
 *    TakeObject(int x,int y,OBJECT *container)  -  take object from x,y into
 */

void TakeObject(int x,int y, OBJECT *container)
{
OBJECT *temp;

if(!container)
    return;

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
   {
   // Terminate melodramatically
   sprintf(str,"TakeObject(%d,%d) Attempted to get outside map boundary",x,y);
   panic(cfa,str,"Ai! ai!  A Balrog!  A Balrog is come!  'Tis Durin's Bane!");
   }

// Find the list we want to modify

temp=GetObject(x,y);
if(!temp)
    return;

//CHECK_FOR_MOVE_UP_ARSE(container,temp);
//CHECK_FOR_PLAYER_GETTING_LOST(temp);

LL_Remove(&curmap.objmap[MAP_POS(x,y)],temp);

temp->next=container->pocket;
container->pocket=temp;

// Store whether the object is fixed or not.
// Seekstate is a transient flag only used when non-fixed so store it there
temp->flags.seekstate=temp->flags.fixed;
temp->flags.fixed=1;            // Object sleeps while in pocket

gen_largemap();
}


/*
 *    MoveObject(OBJECT *object, int x,int y)  -  move object to x,y
 *    Performs error checking and some game functions, calls TransferObject
 */

int MoveObject(OBJECT *object,int x,int y)
{
OBJECT *temp;
int ox,oy,sx,sy;
char allow=1;

// Prevent the impossible

if(!object)
    return 0;

if(object->x == x)
    if(object->y == y)
        return 1;     // Oh yes, we've done it, honest ;-)

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
    return 0;

if(object->flags.fixed) // Can't move
    {
    if(!in_editor)
        return 0;
    }

// If it's a large object, check all of it, but allow if it's only
// hitting itself.

if(object->flags.large)
    {
    for(sy=0;sy<object->mh;sy++)
       for(sx=0;sx<object->mw;sx++)
           if(isSolid(sx+x,sy+y))
               if(GetSolidObject(sx+x,sy+y) != object)
                   return 0;
    }

// If there is something in the way, abort.
// If it turns out to be two party members, swap them over

if(isSolid(x,y))
    {
    temp=GetSolidObject(x,y);   // Find the obstruction
    allow=0;

    if(temp == object)                  // The object has hit itself..
        {
        TransferObject(object,x,y);     // Allow the move anyway
        return 1;
        }
// If it's the player, maybe a party member is in the way.
// If so, we swap them round.

    if(temp)                    // Before we touch the flags, sanity check
       {
       // If the obstruction is a party member, swap them with the player
       if(temp->flags.party)
       if(object==player)
          {
          // Store the player's old coordinates for the follower
          ox=player->x;
          oy=player->y;
          // Find a square we can move the player temporarily
          FindEmptySquare(&sx,&sy);
          // Got one.   Swap the two party members
          TransferObject(player,sx,sy);
          TransferObject(temp,ox,oy);
          TransferObject(player,x,y);
          // The two party members are reversed now
          return 1;
          }
      if(temp->flags.tabletop)            // Pushing something into a table
          if(!object->flags.person)       // Other people can't either
              allow=1;

      if(!in_editor)
        if(temp->flags.container && !object->flags.spikeproof)
          {
          MoveToPocket(object,temp);
          return 1;
          }
       }
    // Blocked
    }

// If we're about to move into a bag (the player must not)

if(!in_editor)
if(!object->flags.person && !object->flags.spikeproof)
    {
    temp=GetObject(x,y);
    if(temp)
        if(temp->flags.container)
            {
            MoveToPocket(object,temp);
            return 1;
            }
    }

if(allow)
    TransferObject(object,x,y);
return allow;
}


/*
 *    TransferObject(OBJECT *object, int x,int y)  -  move object to x,y
 *                                                    without solidity checks
 */

void TransferObject(OBJECT *object,int x,int y)
{
if(!object)
    return;

// Check to prevent object disappearing up it's own arse

if(object->x == x)
    if(object->y == y)
        return;

// silently ignore object request to leave the map

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
    return;

if(InPocket(object))    // Oh no it bloody isn't
   {
   sprintf(str,"move_object(%d,%d,%s) Object moved without using move_object",object->x,object->y,object->name);
   panic(cfa,str,"Fly!  This is a foe beyond any of you.  I must hold the narrow way.  Fly!");
   return;
   }

// Remove the object from the appropriate linked list in curmap.

LL_Remove(&curmap.objmap[MAP_POS(object->x,object->y)],object);

// Keep the object's internal data consistent
object->x=x;       // Very important!
object->y=y;       // Very important!

// Update the animation frame, if it's stepped
object->flags.stepupdated=1;

// Add to the target list
LL_Add(&curmap.objmap[MAP_POS(x,y)],object);

// Rebuild Large Objects table
gen_largemap();
}


/*
 *    GetObjectBase(int x,int y)  -  return pointer to list at x,y
 */

OBJECT *GetObjectBase(int x,int y)
{
OBJECT *anchor;

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
   {
   return NULL;
//   sprintf(str,"GetObjectBase(%d,%d,%s) Attempted outside map boundary",x,y);
//   panic(cfa,str,"Ai! ai!  A Balrog!  A Balrog is come!  'Tis Durin's Bane!");
   }

// Find the list

anchor=curmap.objmap[ytab[y]+x];

if(!anchor)
  if(x>=mapx && x<(mapx+8))
    if(y>=mapy && y<(mapy+8))
         anchor=largemap[4+x-mapx][4+y-mapy];

if(anchor)
  if(!anchor->flags.on)
    anchor=NULL;

return anchor;
}


/*
 *    GetRawObjectBase(int x,int y)  -  return pointer to list at x,y
 *                                      Excludes large objects.
 */

OBJECT *GetRawObjectBase(int x,int y)
{
OBJECT *anchor;

// Find the list we want to modify

if(x<0 || x>curmap.w || y<0 || y>curmap.h)
   {
   return NULL;
//   sprintf(str,"GetObjectBase(%d,%d,%s) Attempted outside map boundary",x,y);
//   panic(cfa,str,"Ai! ai!  A Balrog!  A Balrog is come!  'Tis Durin's Bane!");
   }

anchor=curmap.objmap[ytab[y]+x];
return anchor;
}


/*
 *    GetObject(int x,int y)  -  return pointer to object at x,y
 */

OBJECT *GetObject(int x,int y)
{
OBJECT *temp,*prev;
OBJECT *anchor_and_large;
OBJECT *anchor_small;

// Get two separate opinions of what is in that square.
// Find out where they differ and thereby make plain the truth.
// A little bit like the way RGB is coded into just two signals in a PAL tv

anchor_and_large=GetObjectBase(x,y);
anchor_small=GetRawObjectBase(x,y);

// If this square's list is empty, say so

if(!anchor_and_large)              // No large or small objects found
    return anchor_and_large;       // Might already be in EAX

if(!anchor_small)                  // No small objects here
    return anchor_and_large;       // Return any large object

// Find the last object
prev = NULL;
for(temp=anchor_and_large;temp->next;temp=temp->next)
    {
    if(temp->flags.on)                          // Store last real object
        prev=temp;
    };    // Just seek

// If the candidate is not real regress

if(!temp->flags.on)
    temp = prev;

// If we're in the game and the candidate is invisible, regress

/*
if(!in_editor)
    if(temp->flags.invisible)
        temp = prev;
*/
return temp;
}


/*
 *    GameGetObject(int x,int y)  -  return pointer to object at x,y
 *                                   if it is visible
 */

OBJECT *GameGetObject(int x,int y)
{
OBJECT *temp,*prev;
OBJECT *anchor_and_large;
OBJECT *anchor_small;

// Get two separate opinions of what is in that square.
// Find out where they differ and thereby make plain the truth.
// A little bit like the way RGB is coded into just two signals in a PAL tv

anchor_and_large=GetObjectBase(x,y);
anchor_small=GetRawObjectBase(x,y);

// If this square's list is empty, say so

if(!anchor_and_large)              // No large or small objects found
    return anchor_and_large;       // Might already be in EAX

if(!anchor_small)                  // No small objects here
    return anchor_and_large;       // Return any large object

// Find the last object
prev = NULL;
for(temp=anchor_and_large;temp->next;temp=temp->next)
    {
    if(temp->flags.on && temp->flags.invisible == 0)
        prev=temp;                         // Store last real object
    };    // Just seek

// If the candidate is not real regress

if(!temp->flags.on)
    temp = prev;

// If candidate is invisible, regress

if(temp->flags.invisible)
    temp = prev;
return temp;
}


/*
 *      GetTile - return a pointer to the kind of tile in this position
 */

TILE *GetTile(int x,int y)
{
return &TIlist[curmap.physmap[MAP_POS(x,y)]];
}


/*
 *      GetSolidObject - return a pointer to the first solid object
 */

OBJECT *GetSolidObject(int x,int y)
{
OBJECT *temp;

/*
if(GetBit(x,y,solid_map) == 0)          // Make sure there is something here
    return NULL;
*/

temp=GetObjectBase(x,y);
//temp = curmap.objmap[ytab[y]+x];

if(!temp)
    return temp;

for(;temp;temp=temp->next)
    if(temp->flags.solid)
      if(temp->flags.on)
        if(!temp->flags.invisible)
          return temp;
return NULL;
}

/*
 *      WeighObject - calculate how much weight is in the list
 *                    calls WeighObjectR
 */

int WeighObject(OBJECT *obj)
{
int w=0;
if(!obj)
     return 0;
if(!obj->flags.on)
    return 0;

w = obj->stats->weight;
if(obj->pocket)
    return w+WeighObjectR(obj->pocket);

return w;
}

/*
 *      WeighObjectR - recursive engine for WeightObject
 */

int WeighObjectR(OBJECT *list)
{
OBJECT *temp;
int w=0;

for(temp = list;temp;temp=temp->next)
    if(temp->flags.on)
        {
        w+=temp->stats->weight;
        if(temp->pocket)
            w+=WeighObjectR(temp->pocket);
        }
return w;
}


/*
 *      AddToParty - append a new member to the party array
 */

int AddToParty(OBJECT *new_member)
{
for(int ctr=0;ctr<MAX_MEMBERS;ctr++)
    if(!party[ctr])
        {
        party[ctr] = new_member;
        new_member->stats->oldbehave = new_member->behave;
        new_member->behave = follower;
        AL_Add(&ActiveList,new_member);
        new_member->flags.party = 1;
        return ctr;
        }
return -1;
}


/*
 *      SubFromParty - remove a party member
 */

void SubFromParty(int member)
{
if(member>MAX_MEMBERS)
    return;
if(!party[member])
    return;
if(party[member]->stats->hp>0)
    {
    party[member]->behave = party[member]->stats->oldbehave;
    party[member]->flags.party = 0;
    if(party[member]->behave == -1)
        ML_Del(&ActiveList,party[member]);
    }
else
    {
    // Prevent the dead guy from following you about
    party[member]->behave = -1;
    ML_Del(&ActiveList,party[member]);
    }

// If the leader is leaving, call an election

if(player == party[member])
     {
     player = NULL;
     for(int ctr2=0;ctr2<MAX_MEMBERS-1;ctr2++)
         if(party[ctr2])
             if(party[ctr2]->stats->hp>0)
                 ChooseLeader(ctr2);
     }

     party[member]=NULL;

   // sort the party to remove any holes

for(int ctr=0;ctr<MAX_MEMBERS-1;ctr++)
    if(!party[ctr])
        for(int ctr2=ctr;ctr2<MAX_MEMBERS-1;ctr2++)
            if(party[ctr2])
                {
                party[ctr] = party[ctr2];
                party[ctr2] = NULL;
                }

}


/*
 *      ChooseLeader- Set the party leader
 */

int ChooseLeader(int x)
{
if(!party[x])
    {
    Bug("Election: party member %d not present\n",x);
    return 0;
    }

for(int ctr=0;ctr<MAX_MEMBERS;ctr++)
    if(party[ctr])
        if(party[ctr]->stats->hp > 0)
            {
            ML_Del(&ActiveList,party[ctr]);
            party[ctr]->behave = follower;
            AL_Add(&ActiveList,party[ctr]);
            }
player = party[x];
player->behave = playervrm;
objectstore[0] = player;

return 1;
}


/*
 *      FindEmptySquare- Find some scratch space for certain map operations
 */

void FindEmptySquare(int *x,int *y)
{
int sx,sy;

for(sy=0;sy<curmap.h;sy++)
    for(sx=0;sx<curmap.w;sx++)
        if(!curmap.objmap[ytab[sy]+sx])
            {
            *x=sx;
            *y=sy;
            return;
            }
panic("FindEmptySquare","Umm... apparently there is at least one object on EVERY part of the map","I can only assume the map is corrupted...");
}


/*
 *      gen_largemap- Build the table of objects larger than 1 square
 */

void gen_largemap()
{
int x,y;
int sx,sy,ex,ey,bx,by,xo,yo;
int blockx,blocky,blockw,blockh;

OBJECT *temp;

sx=mapx-4;
sy=mapy-4;
ex=mapx+VSW+4;
ey=mapy+VSH+4;
xo=0;
yo=0;
if(sx<0)
    {
    xo=0-sx;
    sx=0;
    }
if(sy<0)
    {
    yo=0-sy;
    sy=0;
    }

// Clear the grids quickly
fset(&largemap[0][0],0,(sizeof(OBJECT *)*(24*24))/sizeof(OBJECT *));
fset(&solidmap[0][0],0,(sizeof(OBJECT *)*(24*24))/sizeof(int));

by=yo;
bx=xo;
for(y=sy;y<ey;y++)
    {
    for(x=sx;x<ex;x++)
        {
        temp = curmap.objmap[ytab[y]+x];
        for(;temp;temp=temp->next)
          if(temp->flags.on)
            {
            if(temp->flags.large)       // Found a large object?
                {
                if(temp->flags.solid)   // Is it solid? If so, find out where
                    {
                    if(temp->curdir>CHAR_D)
                        {
                        blockx=temp->hblockx;
                        blocky=temp->hblocky;
                        blockw=temp->hblockw;
                        blockh=temp->hblockh;
                        }
                    else
                        {
                        blockx=temp->vblockx;
                        blocky=temp->vblocky;
                        blockw=temp->vblockw;
                        blockh=temp->vblockh;
                        }

                    // Reset border size
                    temp->w = blockw<<5;
                    temp->h = blockh<<5;

                    // Colour in the squares where the solid parts are

                    for(int xctr=0;xctr<blockw;xctr++)
                        for(int yctr=0;yctr<blockh;yctr++)
                            solidmap[bx+xctr+blockx][by+yctr+blocky]=1;
                    }


                // Fill in the active area of the object

                if(temp->curdir>CHAR_D)
                    {
                    blockx=temp->HareaX;
                    blocky=temp->HareaY;
                    blockw=temp->HareaW;
                    blockh=temp->HareaH;
                    }
                else
                    {
                    blockx=temp->VareaX;
                    blocky=temp->VareaY;
                    blockw=temp->VareaW;
                    blockh=temp->VareaH;
                    }

                for(int xctr=0;xctr<blockw;xctr++)            // For the width,
                    for(int yctr=0;yctr<blockh;yctr++)        // For the height,
                        largemap[bx+blockx+xctr][by+blocky+yctr]=temp;
                largemap[bx+blockx][by+blocky]=NULL; // Delete core section
                }
            else
                if(temp->flags.solid)           // If it's small and solid
                        solidmap[bx][by]=1;       // Fill in the single square
            }
        bx++;
        }
    bx=xo;
    by++;
    }

}

/*
 *      DestroyObject - Perform the complex task of destroying an arbitraty
 *                      object without harming the fabric of the universe
 */

void DestroyObject(OBJECT *obj)
{
OBJECT *temp,*pocket;
char str[256];

if(!obj)                // No!
        {
        panic("DestroyObject","Attempted to destroy NULL",NULL);
        return;
        }

// First see if it is where it seems to be

if(!InPocket(obj))
    {
    LL_Remove(&curmap.objmap[MAP_POS(obj->x,obj->y)],obj);
    FreePockets(obj);
    LL_Kill(obj);
    return;
    }

// Next look in the pockets

pocket = LookInAllPocketsFor(obj);
if(pocket)
    {
    // Delete it from the wielding list if it's there
    if(player)
    for(int ctr=0;ctr<W_SIZE;ctr++)
        if(player->wield[ctr] == obj)
            player->wield[ctr] = NULL;

    // Remove it from the system
    LL_Remove(&pocket->pocket,obj);
    FreePockets(obj);
    LL_Kill(obj);
    return;
    }

// In case of non-fatal bug, look for it in the linked list buffer

temp = curmap.object;
for(;temp;temp=temp->next)
    if(temp == obj)
        {
        Bug("Removing loose object %s\n",obj->name);
        LL_Remove(&curmap.object,obj);
        FreePockets(obj);
        LL_Kill(obj);
        return;
        }

// Is it in the ObjectStore?

for(int ctr=0;ctr<OSTORE;ctr++)
    if(objectstore[ctr] == obj)
        {
        FreePockets(obj);
        LL_Kill(obj);
        return;
        }


// Oh dear

sprintf(str,"obj %s at %d,%d (id %d iid %d)",obj->name,obj->x,obj->y,obj->save_id,obj->inside_id);
panic("DestroyObject","Object has no physical existence",str);
}

/*
 *      CreateContents - Create the default contents of an item
 */

void CreateContents(OBJECT *objsel)
{
int num;
OBJECT *temp;
for(int ictr=0;ictr<objsel->funcs->contents;ictr++)
    if(objsel->funcs->contains[ictr])
        {
        temp = OB_Alloc();
        temp->curdir = temp->dir[0];
        OB_Init(temp,objsel->funcs->contains[ictr]);
        OB_SetDir(temp,1);
        num = getnum4char(objsel->funcs->contains[ictr]);
        temp->flags.seekstate=CHlist[num].flags.fixed;
        if(temp->behave != -1)
            AL_Add(&ActiveList,temp); // Make it active
        MoveToPocket(temp,objsel);
        }

// Call initial VRM if in the game

if(!in_editor)
    if(!objsel->flags.didinit)
        {
        Call_VRM(objsel->funcs->icache);
        objsel->flags.didinit=1;
        }
}

/*
 *      MoveToTop - Move specified object to the top of the pile
 */

void MoveToTop(OBJECT *object)
{
int ox,oy;
// Move object to the top of the heap by moving it to 0,0 and back

if(InPocket(object))   // See if on ground or in pocket
    return;            // Either in a pocket or world not consistent

ox = object->x;
oy = object->y;
TransferObject(object,0,0);
TransferObject(object,ox,oy);
}

/*
 *      TakeQuantity - Subtract an amount from a container with several
 *                     of these objects in, e.g. player pays 100 gold coins,
 *                     the coins may be scattered througout his pockets.
 */

int TakeQuantity(OBJECT *container,char *type,int request)
{
int total,found;
OBJECT *temp;
int o;

// First, see if the object can support quantity values.
o = getnum4char(type);
o = CHlist[o].flags.quantity;   // o is the boolean result

total = SumObjects(container->pocket, type, 0);

if(!request)
    request = 1;

if(total<request)
    return 0;

found=0;
do {
   temp = GetFirstObject(container->pocket,type);
   if(!temp)
       {
       Bug("take_quantity: financial irregularities detected in object %s\n",container->name);
       return 1;
       }

   // If the object doesn't support Quantities, we change it so it does
   // and set the quantity of the object to 1 temporarily, since it will
   // be destroyed later, anyway

   if(!o)
       temp->stats->quantity = 1;

   // If less than requested sum, take it all and destroy it.

   if(temp->stats->quantity <= request)
       {
       found += temp->stats->quantity;
       temp->flags.on = 0;     // Mark pending delete
       pending_delete = 1;     // Inform garbage colletion
       }
   else
       {
       temp->stats->quantity -=request; // Otherwise just take what we need
       found=request;
       }
   } while(found<request);

return 1;
}

/*
 *      AddQuantity - Add a number of objects to the container.
 *                    E.g. pay the player 100 gold coins, and group them
 *                    together by adding to the first pile we come across.
 *                    If we try to add 0, create a new object regardless
 */

void AddQuantity(OBJECT *container,char *type,int request)
{
OBJECT *temp;
int o;

// First, see if the object can support quantity values.
o = getnum4char(type);
o = CHlist[o].flags.quantity;   // o is the boolean result

temp = GetFirstObject(container->pocket,type);
if(request == 0)
    temp = NULL;

// If the object exists


if(temp)
  if(o)
     {
     temp->stats->quantity+=request;
     return;
     }

// If it supports multiply quantites, just create one and set the quantity

if(o)
    {
    temp = OB_Alloc();
    OB_Init(temp,type);
    temp->stats->quantity=request;
    MoveToPocket(temp,container);
    return;
    }

// If not, make several

for(o=0;o<request;o++)
    {
    temp = OB_Alloc();
    OB_Init(temp,type);
    CreateContents(temp);
    MoveToPocket(temp,container);
    }

return;
}


/*
 *      LookInAllPockets - Return the container which holds the object.
 *                         Calls SearchContainer.
 */

OBJECT *LookInAllPocketsFor(OBJECT *obj)
{
int vx,vy;
OBJECT *temp,*search;
for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        for(temp = GetRawObjectBase(vx,vy);temp;temp=temp->next)
            if(temp->pocket)
                {
                search = SearchContainer(temp,obj);
                if(search)
                    return search;
                }
return NULL;
}


/*
 *      SearchContainer - Return the pocket which contains the object.
 *                        Recursive, called by LookInAllPockets
 */

OBJECT *SearchContainer(OBJECT *cont, OBJECT *obj)
{
OBJECT *search;

for(OBJECT *temp = cont->pocket;temp;temp=temp->next)
    {
    if(temp == obj)
        return cont;
    if(temp->pocket)
        {
        search = SearchContainer(temp,obj);
        if(search)
            return search;
        }
    }
return NULL;
}

/*
 *      InPocket - Is the object in somebody's pocket?
 */

int InPocket(OBJECT *obj)
{
OBJECT *temp;

if(!obj)
    panic("InPocket","Given a NULL pointer",NULL);

temp = GetRawObjectBase(obj->x,obj->y);
for(;temp;temp=temp->next)
    if(temp == obj)
        return 0;

// It isn't where it thinks it is, so we assume (hope) it's in a pocket

return 1;
}

/*
 *      LookInAllPocketsForTag - Return the object which has that tag number.
 *                               Calls SearchContainerTag.
 */

OBJECT *LookInAllPocketsForTag(int tag)
{
int vx,vy;
OBJECT *temp,*search;
for(vy=0;vy<curmap.h;vy++)
    for(vx=0;vx<curmap.w;vx++)
        for(temp = GetRawObjectBase(vx,vy);temp;temp=temp->next)
            {
            if(temp->tag == tag)
                return temp;
            if(temp->pocket)
                {
                search = SearchContainerTag(temp,tag);
                if(search)
                    return search;
                }
            }
return NULL;
}


/*
 *      SearchContainerTag - Return the object with this tag.
 *                           Recursive, called by LookInAllPockets
 */

OBJECT *SearchContainerTag(OBJECT *cont, int tag)
{
OBJECT *search;

for(OBJECT *temp = cont->pocket;temp;temp=temp->next)
    {
    if(temp->tag == tag)
        return temp;
    if(temp->pocket)
        {
        search = SearchContainerTag(temp,tag);
        if(search)
            return search;
        }
    }
return NULL;
}

/*
 *     SumObjects - Return the total of a multiple object, e.g. money.
 *                  Recursive.
 */

int SumObjects(OBJECT *cont, char *name, int total)
{
for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    if(!stricmp(temp->name,name))
        {
        if(temp->flags.quantity)
            total+=temp->stats->quantity;
        else
            total++;
        }
    if(temp->pocket)
        total+=SumObjects(temp->pocket,name,total);
    }
return total;
}

/*
 *     GetFirstObject - Find the first instance of a specified object.
 *                      Recursive.
 */

OBJECT *GetFirstObject(OBJECT *cont, char *name)
{
OBJECT *search;

for(OBJECT *temp = cont;temp;temp=temp->next)
    {
    if(!stricmp(temp->name,name))
        return temp;
    if(temp->pocket)
        {
        search=GetFirstObject(temp->pocket,name);
        if(search)
            return search;
        }
    }
return NULL;
}

/*
 *      CheckDepend - Remove all references to a pointer
 */

void CheckDepend(OBJECT *ptr)
{
int ctr;
OBJLIST *t;

// All the objects in the entire universe

t = MasterList;
if(!t)
    return;

for(t=MasterList;t;t=t->next)
  {
  if(!t->ptr)
      {
      C_printf("Bug: null in masterlist\n");
      Bug("Bug: null in masterlist\n");
      ML_Del(&MasterList,NULL);
      t=MasterList;
      }
  if(t->ptr->enemy == ptr)
      t->ptr->enemy=NULL;
  if(t->ptr->stats)
      {
      if(t->ptr->stats->owner == ptr)
          t->ptr->stats->owner=NULL;
      }
  }

// All the objects in the user storage area

if(!in_editor)
for(ctr=0;ctr<OSTORE;ctr++)
    {
    // Remove references in the list itself
    if(objectstore[ctr] == ptr)
        objectstore[ctr] = NULL;

    // Remove references in objects in the list
    if(objectstore[ctr])
        {
        if(objectstore[ctr]->enemy == ptr)
            objectstore[ctr]->enemy = NULL;
        if(objectstore[ctr]->stats)
            {
            if(objectstore[ctr]->stats->owner == ptr)
                objectstore[ctr]->stats->owner = NULL;
            }
        }
    }

// If a party member was boiled to vapour kick 'em out of the party

if(!in_editor)
for(ctr=0;ctr<MAX_MEMBERS;ctr++)
    if(party[ctr])
       if(!party[ctr]->flags.on)
           party[ctr] = NULL;

return;
}

/*
 *      DeletePending() - Remove all Pending-Delete objects (Garbage collect)
 */

void DeletePending()
{
OBJLIST *t;
if(!pending_delete)
    return;

t = MasterList;
if(!t)
    return;

for(t=MasterList;t;t=t->next)
  {
  if(!t->ptr->flags.on)
      {
      DestroyObject(t->ptr);  // Free the object
      t=MasterList;           // Restart the check
      }
  }
pending_delete=0;             // None
}
