//
//      Interaction between the objects and the map
//

#include "core.hpp"


void trigger_objects(OBJECT *s);
int WeighObject(OBJECT *list);
int add_to_party(OBJECT *new_member);
void seek(OBJECT *hunter,OBJECT *target);
int ChooseLeader(int x);
void SubFromParty(int member);

// LinkedlistWorld functions

void MoveToPocket(OBJECT *object, OBJECT *container);
void TransferToPocket(OBJECT *object, OBJECT *container);
int MoveFromPocket(OBJECT *object, OBJECT *container,int x,int y);
int ForceFromPocket(OBJECT *object, OBJECT *container,int x,int y);
OBJECT *GetAverageObject();
OBJECT *GetSolidObject(int x,int y);
OBJECT *GetTopObject(int x,int y);
OBJECT *GetBestPlace(int x,int y);
OBJECT *GetUserSpec(int x,int y,int inc,int exc,int layer);

// MatrixWorld functions

extern void MoveToMap(int x, int y, OBJECT *object);
extern void DropObject(int x,int y, OBJECT *object);
extern void TakeObject(int x,int y, OBJECT *container);
extern int MoveObject(OBJECT *object,int x,int y);
extern OBJECT *GetObject(int x,int y);
extern OBJECT *GetObjectBase(int x,int y);
extern OBJECT *GetRawObjectBase(int x,int y);
extern void ForceDropObject(int x,int y, OBJECT *object);
extern void DestroyObject(OBJECT *obj);
extern int InPocket(OBJECT *obj);
extern void CreateContents(OBJECT *obj);
extern void MoveToTop(OBJECT *object);

extern OBJECT *LookInAllPocketsForTag(int tag);
extern OBJECT *LookInAllPocketsFor(OBJECT *obj);

extern void CheckDepend(OBJECT *ptr);
extern void DeletePending();
extern char pending_delete;

//extern char CheckDepend_on;
