/*
 *    OSCLI interpreter
 */

#include <stdio.h>
#include <stdlib.h>
// MR: added
#ifndef _WIN32
#include <strings.h>
#endif
#include <string.h>
#include "doslib.hpp"
#include "oscli.hpp"
#include "console.hpp"
#include "cookies.h"
#include "vidmodes.h"

// Defines

#define find(xxx) OSCLI_find(ArgC,ArgV,xxx)
#define found(xxx) OSCLI_found(ArgC,ArgV,xxx)

// Variables:  These are all commandline parameters

char gamespec =0;
char VideoMode=-1;
char no_panic=0;
char show_vrm_calls=0;
char graflog=-1;        // Graphical bootlog, true of false
char quickstart=0;      // Prevent logging to disk
int  logx,logy,loglen;  // Graphical boot log, X,Y and length in lines
char logpic[32];        // The backdrop
char mus_chan=16;       // Music channels
char sfx_chan=4;        // Sound channels
char use_light=1;       // Use lighting by default
char skip_unk=0;        // Don't skip unknown keywords in the scriptfile
char SuperPanic=0;      // Call CRASH() on panic so we can do a stack trace
int map_W=512,map_H=512;        // Map size
int driftlevel=20;      // Frequency change in Hz times -10 to +10

extern char in_editor; // Which program we are in

// Limits for the script editor

extern long spr_alloc;
extern long seq_alloc;
extern long vrm_alloc;
extern long chr_alloc;
extern long des_alloc;
extern long til_alloc;
extern long wav_alloc;
extern long mod_alloc;

// Functions

short OSCLI_find(short ArgC,char **ArgV,char *param);
char OSCLI_found(short ArgC,char **ArgV,char *param);
void OSCLI(int ArgC,char **ArgV);

// Code

// OSCLI, process a list of switches

void OSCLI(int ArgC,char **ArgV)
{
int cpt,len;

if(found("?") || found("h") || found("help"))
	{
	printf("\n");
	puts("-list [listfile]    Execute a list of commands (like @ in doom)");
	puts("-game [gamefile]    (same as -list)");
	puts("-file [RARfile(s)]  Use an external .RAR file");
	puts("-nopanic            no fancy error messages");
	puts("-superpanic         Create a debugging trace if a PANIC occurs");
	puts("-debugvrm           List all vrm calls in BOOTLOG.TXT");
	puts("-showmodes          List all available video modes");
	puts("-videomode          Use one of the above modes");
	puts("-nolight            Don't do any lighting (for slow systems)");
	puts("-skipunknowns       Ignore unknown keywords in the script, don't stop");
	puts("-?                  This screen");
	exit(1);
	}

cpt=find("mapfile");
if(cpt>=0&&(unsigned char)mapname[0]==0xff)
if(ArgV[cpt+1])
		{
		strcpy(mapname,ArgV[cpt+1]);
                len = strlen(mapname);
		for(cpt=0;cpt<len;cpt++)
			if(mapname[cpt]<32)
				mapname[cpt]=0;
		}

cpt=find("edit");
if(cpt>=0)
if(ArgV[cpt+1])
    strcpy(mapname,ArgV[cpt+1]);

if(found("nopanic"))
    no_panic = 1;

if(found("superpanic"))
    SuperPanic = 1;

if(found("skipunknowns"))
    skip_unk= 1;

if(found("debugvrm") || found("debugvrms"))
    show_vrm_calls= 1;

if(found("conlog"))
    conlog = 1;

if(found("nolight"))
    use_light = 0;

if(found("showmodes"))
    {
    printf("\n");
    V_query();
    exit(1);
    }

if(!gamespec)
    {
    cpt=find("game");
    if(cpt>=0)
    if(ArgV[cpt+1])
        {
	INI_file(ArgV[cpt+1]);
        gamespec=1;
        }
    }

cpt=find("resdir");
if(cpt>=0)
if(ArgV[cpt+1])
	strcpy(resdir,ArgV[cpt+1]);

cpt=find("mus_chan");
if(cpt>=0)
if(ArgV[cpt+1])
  	mus_chan = atoi(ArgV[cpt+1]);

cpt=find("sfx_chan");
if(cpt>=0)
if(ArgV[cpt+1])
        {
  	sfx_chan = atoi(ArgV[cpt+1]);
        if(sfx_chan < 4)
            sfx_chan = 4;
        }

if(VideoMode==-1)
  {
  cpt=find("VideoMode");
  if(cpt>=0)
  if(ArgV[cpt+1])
  	VideoMode=atoi(ArgV[cpt+1]);
  }

cpt=find("console_x");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	conx=atoi(ArgV[cpt+1]);
    }

cpt=find("console_y");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	cony=atoi(ArgV[cpt+1]);
    }

cpt=find("console_w");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	conwid=atoi(ArgV[cpt+1]);
    else
        conwid = 100;
    if(conwid > C_WID)
        panic("console_w","Usage: -console_w <width>","Width must be in characters, 2 to 80.  It is NOT in pixels.");
    }

cpt=find("console_h");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	conlen=atoi(ArgV[cpt+1])-1;
    else
        conlen = 100;   // Not valid, therefore print the message below.
    if(conlen > C_LEN)
        panic("console_h","Usage: -console_h <height>","Height must be in lines, 2 to 20.  It is NOT in pixels.");
    }

cpt=find("driftlevel");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	driftlevel=atoi(ArgV[cpt+1]);
    }

cpt=find("map_width");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	map_W=atoi(ArgV[cpt+1]);
    }

cpt=find("map_height");
if(cpt>=0)
    {
    if(ArgV[cpt+1])
  	map_H=atoi(ArgV[cpt+1]);
    }

cpt=find("log");
if(cpt>=0 && graflog ==-1)
	if(ArgV[cpt+1])
		{
		if(!stricmp(ArgV[cpt+1],"full"))
			graflog=0;
		if(!stricmp(ArgV[cpt+1],"partial"))
			graflog=1;
		if(!stricmp(ArgV[cpt+1],"none"))
			graflog=2;
		if(graflog)
			if(ArgV[cpt+2])
				strcpy(logpic,ArgV[cpt+2]);
			else
				{
				puts("\nIf Log is set to PARTIAL or NONE, you must also specify a picture to be shown");
				puts("while IRE is loading.  It must be a .PCX picture, 640x480.");
				puts("\nExample..  -log partial mypic.pcx\n");
				exit(1);
				}
		}
	else
		{
		puts("\nYou must specify the type of log.  There are three kinds:\n");
		puts("  -log full                  Runs in text mode, resembles DOOM.");
		puts("  -log partial FILE.PCX      Graphic mode, text on a PCX picture, FILE.");
		puts("  -log none FILE.PCX         Just the picture, no text at all.\n");
		puts("  -logxy X Y LENGTH          can be used to set the size of the text window.\n");
//		puts("The picture that is displayed can also be a .FLI file.\nThis allows a small animation to be played before the game loads.\nThe last frame will be the background for the log text."); // No it can't
		exit(1);
		}

cpt=find("logxy");
if(cpt>=0)
	{
	if(ArgV[cpt+1])
		logx=atoi(ArgV[cpt+1]);
	if(ArgV[cpt+2])
		logy=atoi(ArgV[cpt+2]);
	if(ArgV[cpt+3])
		loglen=atoi(ArgV[cpt+3]);
	if(logx>128)
		logx=4;
	if(logy+(loglen*8)>480)
		logy=4;
	if(loglen>59)
                loglen=8;
	}

if(found("quickstart"))
    quickstart=1;

// Set limits for the script editor

cpt = find("max_sprites");
if(cpt>=0)
    spr_alloc = atol(ArgV[cpt+1]);

cpt = find("max_sequences");
if(cpt>=0)
    seq_alloc = atol(ArgV[cpt+1]);

cpt = find("max_vrms");
if(cpt>=0)
    vrm_alloc = atol(ArgV[cpt+1]);

cpt = find("max_characters");
if(cpt>=0)
    chr_alloc = atol(ArgV[cpt+1]);

cpt = find("max_descriptions");
if(cpt>=0)
    des_alloc = atol(ArgV[cpt+1]);

cpt = find("max_tiles");
if(cpt>=0)
    til_alloc = atol(ArgV[cpt+1]);

cpt = find("max_wavs");
if(cpt>=0)
    wav_alloc = atol(ArgV[cpt+1]);

cpt = find("max_mods");
if(cpt>=0)
    mod_alloc = atol(ArgV[cpt+1]);

cpt=find("file");
if(cpt>=0)
	for(cpt++;cpt<=ArgC;cpt++)
		if(ArgV[cpt])
                        RFS_Add(ArgV[cpt]);

// It is of vital importance that -LIST comes last, or the INI parser will
// fall over, when the globals ArgV and ArgC are clobbered.

cpt=find("list");
if(cpt>=0)
if(ArgV[cpt+1])
    INI_file(ArgV[cpt+1]);

return;
}

short OSCLI_find(short ArgC,char **ArgV,char *param)
{
short ctr;
char tp[]=COOKIE_OscliTmp;

strcpy(tp,"-");
strcat(tp,param);
for(ctr=0;ctr<=ArgC;ctr++)
	if(ArgV[ctr])
		if(stricmp(tp,ArgV[ctr])==0)
			return(ctr);

strcpy(tp,"--");
strcat(tp,param);
for(ctr=0;ctr<=ArgC;ctr++)
	if(ArgV[ctr])
		if(stricmp(tp,ArgV[ctr])==0)
			return(ctr);

strcpy(tp,"/");
strcat(tp,param);
for(ctr=0;ctr<=ArgC;ctr++)
	if(ArgV[ctr])
		if(stricmp(tp,ArgV[ctr])==0)
			return(ctr);

return -1;
}

char OSCLI_found(short ArgC,char **ArgV,char *param)
{
if(OSCLI_find(ArgC,ArgV,param) > 0)
   return 1;
return 0;
}

void INI_file(char *ini)
{
short words,len;
char linebuf[4096];
char *word[64];
char *line;
FILE *fp;

//printf("Processing: %s\n",ini);


fp=fopen(ini,"r");
if(!fp)
	{
	printf("Could not open listfile '%s'\n",ini);
	exit(1);
	}
	do	{
	line=fgets(linebuf,4095,fp);
	if(line)
		if(line[0]!='#'&&line[0]!=';'&&line[0]!='%')
			{
//			puts(line);
			words=0;
			word[words++]=&line[0];
			len=strlen(line);                     
			for(short ctr=0;ctr<len&&words<15;ctr++)
				if(line[ctr]==' '||line[ctr]=='\t')
					{
					line[ctr]=0;
					word[words++]=&line[ctr+1];
					}
				else
					if(line[ctr]<' ')
               	line[ctr]=0;
			OSCLI(words-1,word);
			}
	} while(line);
fclose(fp);
}

