//
//      pathfind.cc - AI routine for the NPCs
//      based on pathfind.pas by Josef Drexler
//
//      I must confess I only have a sketchy idea of how this works.
//
//      It appears to do a floodfill between the start and end points,
//      until the two regions collide, and then it (somehow) works out
//      the optimum path within this domain by using the stored fill
//      droplets and the path they took during the fill.
//

#include "core.hpp"
#include "console.hpp"
#include "linklist.hpp"

#define MAXDROPS 1024
#define NUMWAYS 2

static int numdrops=0;
static int deaddrops=0;
static int kinddrops[3];
static int pathfound=0;
//static int steps=0;
static int maxx=0,maxy=0;
int pathstep[256][256];
static char vscreen[256][256];
int pathdrop[MAXDROPS];

extern int isSolid(int x,int y);
extern TILE *GetTile(int x,int y);


char dropcode[2][3] = {{0,1,2},
                       {0,3,4}};

//char dropcode[2][3] = {{0,1,2},
//                       {0,9,10}};

//maxx,maxy,pathstep[maxx][maxy],

/*
  dx : array[1..8] of integer         { change in x and y for 8 directions }
     = (0, 1, 1, 1, 0, -1, -1, -1);   { 1 is upwards, then clockwise }
  dy : array[1..8] of integer
     = (-1, -1, 0, 1, 1, 1, 0, -1);
*/
// It's better to weigh them such that straight movement is preferred
static int dx[] = {0, 1, 0, -1, 1, 1, -1, -1}; // change in x and y for 8 directions
static int dy[] = {-1, 0, 1, 0, -1, 1, 1, -1}; // 0 is upwards, then clockwise



void newdrop(int no, int x, int y, int anc);
void initdrops(int startx,int starty, int endx, int endy);
void checkdrop(int no);
void getpath();
void showdrops(int state);
void showdrop(int state,int no);
int waterflow(int sx,int sy,int ex,int ey);
void setpath(OBJECT *it);

struct DROP
    {
    int x,y;
    int ancestor;
    char type;
    int length;
    } drop[MAXDROPS];


void initdrops(int startx,int starty, int endx, int endy)
{
int x,y;
for(x=0;x<maxx;x++)
    for(y=0;y<maxy;y++)
        pathstep[x][y] = 255;     // 255 is worst possible length

  numdrops=2;   // One at start, one at end (and 0 is dummy)

  drop[1].type=1;       // drop from start
  drop[1].length=0;     // first point

  drop[2].type=2;       // drop from end
  drop[2].length=0;     // first point

  kinddrops[1] = 1;      // one of each type
  kinddrops[2] = 1;

  newdrop(1, startx, starty, 1);
  newdrop(2, endx, endy, 2);

//  steps = 1;

  pathfound = 0;
}


// Create a new droplet

void newdrop(int no, int x, int y, int anc)
{
int i;

//boot2("newdrop (%d) %d,%d anc=%d\n",no,x,y,anc);
//boot2("NDA: creat %d\n",no);


if(!no)
    for(i=1;i<numdrops;i++)
        if(!drop[i].type)
            {
//            boot2("DeadDrop %d\n",i);
            deaddrops--;
            no=i;
            kinddrops[drop[anc].type]++;
            break;
            }

//boot2("NDB: creat %d\n",no);

if(!no)
    {
    if(numdrops == MAXDROPS)
        panic("PathFinder","Too many droplets","Route too complex - increase buffer and recompile");
    numdrops++;
    no=numdrops;
    kinddrops[drop[anc].type]++;
    }

pathstep[x][y] = drop[anc].length;
drop[no].x=x;
drop[no].y=y;
drop[no].ancestor=anc;
drop[no].type=drop[anc].type;
drop[no].length=drop[anc].length+1;
showdrop(1,no);
}

// Check a droplet and move it if possible

void checkdrop(int no)
{
int i,old,x,y,xdx,ydy,numdirs;
int dirs[]={0,0,0,0,0,0,0,0};

x=drop[no].x;
y=drop[no].y;

numdirs=0;

//boot2("CHK: drop = %d (%d,%d) length = %d\n",no,drop[no].x,drop[no].y,drop[no].length);

for(i=0;i<8;i++)
    {
//    boot2("%d: start of loop\n",i);
    xdx=x+dx[i];
    ydy=y+dy[i];
//    boot2("%d: xdx,ydy = %d,%d, x,y is =%d,%d\n\n",i,xdx,ydy,x,y);
    if(xdx >=0 && xdx<maxx)
        if(ydy >=0 && ydy<maxy)
            {
//	      if screen[ydy, xdx, 1] in [dropchar[0, 3 - drops[drop, 4]], dropchar[1, 3 - drops[drop, 4]]] then
            if(vscreen[xdx][ydy] == dropcode[0][3-drop[no].type]
            || vscreen[xdx][ydy] == dropcode[1][3-drop[no].type])
                {
                pathdrop[0]=no;
                for(x=1;x<=numdrops;x++)
                    if(drop[x].x == xdx)
                        if(drop[x].y == ydy)
                            {
                            pathdrop[1]=x;
                            pathfound=1;
                            return;
                            }
                }
            else
                if(!vscreen[xdx][ydy])       // not a wall
                    {
                    dirs[numdirs]=i;
                    numdirs++;
                    }
            }
    }

showdrops(1);

// Now we know the possible movements, so do the motion

//boot2("NumDirs is zero\n");

if(!numdirs)    // No motion possible, let the drop die
    {
    kinddrops[drop[no].type]--;
    drop[no].type=0;
    deaddrops++;
    }

old = no;

for(i=0;i<numdirs;i++)
    {
    xdx=x+dx[dirs[i]];
    ydy=y+dy[dirs[i]];
    if(i==numdirs)
        no=old;   // just move this one
    else
        no=0;     // make a new one
    newdrop(no,xdx,ydy,old);
    }
}

// Move the drops of 'water'

int waterflow(int sx,int sy,int ex, int ey)
{
int curlen,type,no;

initdrops(sx,sy,ex,ey);
showdrops(1);
curlen=0;

do {
   for(type=1;type<=NUMWAYS;type++)      // 0 or 1?
       for(no=1;no<=numdrops;no++)
           {
           if(drop[no].length == curlen)
               if(drop[no].type == type)
                   {
                   checkdrop(no);
                   if(pathfound)
                       break;
                   }
           }
   curlen++;
   showdrops(0);

   } while (!pathfound && kinddrops[1] && kinddrops[2]);

if(!kinddrops[1] || !kinddrops[2])      // Can not route
    return 0;

return 1;       // Success
}

void getpath()
{
int dir,type;
int step,stept;
int length;
int x,y;
int xdx,ydy;

length=0;
for(type=0;type<=2;type++)
    {
    x=drop[pathdrop[type]].x;
    y=drop[pathdrop[type]].y;
//    vscreen[x][y]= 1;
    curmap.physmap[MAP_POS(x,y)]=9;    // was 0
    length+=drop[pathdrop[type]].length-1;

//    for(step=drop[pathdrop[type]].length-2;step>=0;step--)
    for(step=drop[pathdrop[type]].length-2;step>=0;step--)
        {
        stept=step;
        for(dir=0;dir<=8;dir++)
            {
            xdx=x+dx[dir];
            ydy=y+dy[dir];
            if(xdx >0 && xdx<maxx)
                if(ydy >0 && ydy<maxy)
                    if(pathstep[xdx][ydy] <= stept)
                        {
                        stept=0;
                        x=xdx;
                        y=ydy;
                        curmap.physmap[MAP_POS(x,y)]=9;
                        }
            }
        }
    }
C_printf("One of the shortest paths is %d steps\n",length);
}


void findpath(int sx,int sy,int ex,int ey)
{
int x,y;
for(x=0;x<256;x++)
   for(y=0;y<256;y++)
       {
       vscreen[x][y]=0;
       if(GetTile(x,y)->flags.solid)
       //if(isSolid(x,y))
           vscreen[x][y]=9;
       }

maxx=256;
maxy=256;

if(!waterflow(sx,sy,ex,ey))
    C_printf("CAN NOT ROUTE %d,%d-%d,%d\n",sx,sy,ex,ey);

getpath();
}


void makepath(OBJECT *it,int ex,int ey)
{
int x,y;
for(x=0;x<256;x++)
   for(y=0;y<256;y++)
       {
       vscreen[x][y]=0;
       if(GetTile(x,y)->flags.solid)
           vscreen[x][y]=9;
       }

maxx=256;
maxy=256;

if(!waterflow(it->x,it->y,ex,ey))
    {
    C_printf("CAN NOT ROUTE %s to %d,%d\n",it->name,ex,ey);
    it->pathptr=NULL;
    }

setpath(it);
}

void setpath(OBJECT *it)
{
int dir,type;
int step,stept;
int length;
int x,y;
int xdx,ydy;
PATH_NODE *pp;

length=0;
for(type=0;type<=2;type++)
    {
    x=drop[pathdrop[type]].x;
    y=drop[pathdrop[type]].y;
//    vscreen[x][y]= 1;

//    curmap.physmap[MAP_POS(x,y)]=9;    // was 0
    pp = PL_Add(&it->pathptr);
    pp->x=x;
    pp->y=y;
    length++;
//    length+=drop[pathdrop[type]].length-1;

//    for(step=drop[pathdrop[type]].length-2;step>=0;step--)
    for(step=drop[pathdrop[type]].length-2;step>=0;step--)
        {
        stept=step;
        for(dir=0;dir<=8;dir++)
            {
            xdx=x+dx[dir];
            ydy=y+dy[dir];
            if(xdx >0 && xdx<maxx)
                if(ydy >0 && ydy<maxy)
                    if(pathstep[xdx][ydy] <= stept)
                        {
                        stept=0;
                        x=xdx;
                        y=ydy;
//                        curmap.physmap[MAP_POS(x,y)]=9;
                        pp = PL_Add(&it->pathptr);
                        pp->x=x;
                        pp->y=y;
                        length++;
                        pathstep[xdx][ydy] =255;
                        }
            }
        }
    }
C_printf("%d nodes\n",length);
}


void showdrop(int state,int no)
{
int i;
if(!drop[no].type)
    return;
//boot2("Write %d,%d = %d [%d][%d]\n",drop[no].x,drop[no].y,dropcode[state][drop[no].type],state,drop[no].type);
vscreen[drop[no].x][drop[no].y]=dropcode[state][drop[no].type];
return;


        switch(dropcode[state][drop[no].type])
            {
            case 0:
            i=0;
            break;

            case 1:
            i=1;
            break;

            case 2:
            i=2;
            break;

            case 3:
            i=8;
            break;

            case 4:
            i=9;
            break;
            }

curmap.physmap[MAP_POS(drop[no].x,drop[no].y)]=i;
}

void showdrops(int state)
{
int i;
for(i=1;i<=numdrops;i++)
    showdrop(state,i);

return;
//redraw_map();

for(int x=0;x<256;x++)
    for(int y=0;y<256;y++)
        {
        i=vscreen[x][y];
        switch(i)
            {
            case 0:
            i=0;
            break;

            case 1:
            i=(15<<5);
            break;

            case 2:
            i=(15<<10);
            break;

            case 3:
            i=(15<<10)|15;
            break;

            case 4:
            i=(15<<5)|15;
            break;

            case 9:
            i=15;
            break;
            }
        dot(x,y,i,swapscreen);
        }
update(swapscreen);
//getch();
}

