/*
 *      Project - Sprite projection code
 */

#include "core.hpp"
#include "console.hpp"
#include "sound.hpp"    // For the timer code

// Defines
#define MAX_P_OVERLAY 255       // Maximum number of overlayed objects
                                // Per screen.  Somewhat unlikely..

// Variables

extern int mapx,mapy;
extern SPRITE lightmap;
extern OBJECT *player;

void (*animate[4])(OBJECT *temp);

// Functions

void Init_Projector();
void Eproject_sprites(char *screen);
void Eproject_roof(char *screen);

static void anim_00(OBJECT *temp);
static void anim_01(OBJECT *temp);
static void anim_10(OBJECT *temp);
static void anim_11(OBJECT *temp);

// Code

/*
 *      Init_Projector() - Set up the jump table for the animator
 */

void Init_Projector()
{
animate[0] = anim_00;
animate[1] = anim_01;
animate[2] = anim_10;
animate[3] = anim_11;
}

/*
 *      anim_00() - no ping-pong, no loop
 */

void anim_00(OBJECT *temp)
{
temp->sptr+=temp->sdir;         // Increment the animation frame
if(temp->sptr>=temp->slen)      // If the animation pointer > # of frames
	{
	temp->sptr=temp->slen-1;   // Set it to the last frame
	temp->sdir=0;              // Stop playing
	}
}

/*
 *      anim_01() - ping-pong, no loop
 */

void anim_01(OBJECT *temp)
{
temp->sptr+=temp->sdir;         // Increment the animation frame
if(temp->sptr>=temp->slen)	// if we reach upper limit
	{
	temp->sdir=-1;          // Play backwards
	temp->sptr-=2;		// This prevents 0123321001233210 etc
	}									// (should be 012321012321 etc)
else
	if(temp->sptr<0)	// if we reach -1, we've finished the backrun
	{
	temp->sdir=0;		// shut down
	temp->sptr=0;		// NEVER have a cyclic loop with 1 frame
	}                       // or this will blow up on you.
}

/*
 *      anim_10() - no ping-pong, loop
 */

void anim_10(OBJECT *temp)
{
temp->sptr+=temp->sdir;         // Increment the animation frame
if(temp->sptr>=temp->slen)      // If we reach the end,
	temp->sptr=0;           // Go back to the start
}

/*
 *      anim_11() - ping-pong, and loop
 */

void anim_11(OBJECT *temp)
{
temp->sptr+=temp->sdir;         // Increment the animation frame
if(temp->sptr>=temp->slen)	// if we reach upper limit
	{
	temp->sdir=-1;          // Play backwards
	temp->sptr-=2;		// prevent 0123321001233210 etc
	}									// (should be 012321012321 etc)
else
	if(temp->sptr<0)	// if we reach -1, finished the backward run
	{
	temp->sdir=1;           // Start playing forwards again
	temp->sptr=1;		// NEVER have a cyclic loop with 1 frame!
	}
}

/*
 *      Eproject_sprites- Display the sprites on the map
 */

void Eproject_sprites(char *screen)
{
int cx,cy,vx,vy,yoff;
int startx,starty;
OBJECT *temp;
SEQ_POOL *project;
int do_anim;
OBJECT *postoverlay[MAX_P_OVERLAY];
int post_ovl=0;

do_anim = T_IsDue();                    // Check the clock

startx = -4;
starty = -4;

if((mapx+startx)<0)
    startx=0;
if((mapy+starty)<0)
    starty=0;

for(vy=starty;vy<VSH;vy++)
    {
    yoff=ytab[mapy+vy];
    for(vx=startx;vx<VSW;vx++)
        {
        for(temp=curmap.objmap[yoff+mapx+vx];temp;temp=temp->next)
            {
            if(temp->flags.on)
            if(!temp->flags.invisible)
                {
                cx=vx+mapx;
                cy=vy+mapy;

                // Animate the object, continously (or once, if stepped)

                if(temp->form->flags&4)                      // if stepped
                    {
                    if(temp->flags.stepupdated)              // if updating
                        {
                        animate[temp->form->flags&3](temp);  // animate once
                        temp->flags.stepupdated=0;           // Clear flag
                        }
                    }
                else
                    {
                    if(do_anim)
                        {
                        temp->stats->tick++;
                        if(temp->stats->tick>=temp->form->speed)
                            {
                            animate[temp->form->flags&3](temp);  // animate it
                            temp->stats->tick=0;
                            }
                        }
                    }

                // Then we plot the object with the CLIP method
                // <<5 multiplies by 32, converting the map coordinates into pixels.

                // Project the sprite
                project = temp->form;
                if(temp->flags.translucent)
                    {
                    if((cx-mapx) >=0 && (cy-mapy) >=0)
                        project->seq[temp->sptr]->image.translucent_sprite(((cx-mapx)<<5)+STARTX,((cy-mapy)<<5)+STARTX,screen);
                    }
                else
                    project->seq[temp->sptr]->image.clip_sprite(((cx-mapx)<<5)+STARTX,((cy-mapy)<<5)+STARTX,screen);

                // If there is an overlay sprite, find out if it is for now
                // or for later.  If it's for now, display it, else queue it

                if(temp->form->overlay)
                    if(temp->flags.overlay)
                        {
                        if(post_ovl<MAX_P_OVERLAY)
                            postoverlay[post_ovl++]=temp;
                        }
                    else
                        project->overlay->image.clip_sprite(((cx-mapx)<<5)+STARTX,((cy-mapy)<<5)+STARTX,screen);
                }
            }

        }
    }

// Now, display any post-processed overlays

for(int ctr=0;ctr<post_ovl;ctr++)
    {
    temp = postoverlay[ctr];
    temp->form->overlay->image.clip_sprite(((temp->x-mapx)<<5)+STARTX,((temp->y-mapy)<<5)+STARTX,screen);
    }

}

/*
 *      Eproject_roof - Display the roof objects on the map
 */

void Eproject_roof(char *screen)
{
int xctr=0;
int xctr2=0,ptr,bit;

xctr=0;
xctr2=STARTX;

ptr=mapy*curmap.w;
ptr+=mapx;

bit=curmap.w - VSW;
xctr=STARTX;
for(int ctr=0;ctr<VSH;ctr++)
	{
	for(int ctr2=0;ctr2<VSW;ctr2++)
		{
                if(curmap.roof[ptr])
                    if(curmap.roof[ptr]<RTtot)
                        RTlist[curmap.roof[ptr]].image.cel_put_sprite(xctr,xctr2,bg_screen);
		xctr+=32;
		ptr++;
		}
	xctr=STARTX;
	xctr2+=32;
	ptr+=bit;
	}
}
