#ifndef __RVFS_included__
#define __RVFS_included__

struct RFS
	{
	char *name;	// file name
	char *rarname;	// archive name
	long offset;	// file pointer
	long length;	// length of file entry
	};

void RFS_Mount(int argc,char *argv[]);	// Construct RFS tables

//MR: VC doesn't seem to understand __attribute__
#ifdef _WIN32
#pragma pack( push, pack_1byte ,1 )

typedef unsigned char   rUBYTE ;       /*  unsigned 8 bits value type  */
typedef unsigned short  rUWORD ;       /*  unsigned 16 bits value type */
typedef unsigned long   rUDWORD ;      /*  unsigned 32 bits value type */

#pragma pack( pop, pack_1byte )

#else
typedef unsigned char   rUBYTE __attribute__ ((aligned (1))) ;       /*  unsigned 8 bits value type  */
typedef unsigned short  rUWORD __attribute__ ((aligned (1))) ;       /*  unsigned 16 bits value type */
typedef unsigned long   rUDWORD __attribute__ ((aligned (1))) ;      /*  unsigned 32 bits value type */
#endif

typedef long            rSDWORD;      /*  signed 32 bits value type   */
typedef char *    rHPBYTE;      /*  pointer type addressing     */
				     /*  up to 96 kilobytes          */

/* Archive internal block types */
enum { ALL_HEAD=0,MARK_HEAD=0x72,MAIN_HEAD=0x73,FILE_HEAD=0x74,
       COMM_HEAD=0x75 };

/* Headers definitions */

//MR: VC doesn't seem to understand __attribute__
#ifdef _WIN32
#pragma pack( push, pack_1byte ,1 )
#endif

struct MarkHeader
{
  rUBYTE Mark[5];
  rUWORD HeadSize;
};         //7

struct ArchiveHeader
{
  rUWORD  HeadCRC;
  rUBYTE  HeadType;
  rUWORD  Flags;
  rUWORD  HeadSize;
  rUBYTE  Reserved[6];
};// 13

struct FileHeader
{
  rUWORD  HeadCRC;
  rUBYTE  HeadType;
  rUWORD  Flags;
  rUWORD  HeadSize;
  rUDWORD PackSize;
  rUDWORD UnpSize;
  rUBYTE  HostOS;
  rUDWORD FileCRC;
//  struct dos_ftime FileTime;
  rUDWORD Ftime;
  rUBYTE  UnpVer;
  rUBYTE  Method;
  rUWORD  NameSize;
  rUDWORD FileAttr;
};      // 32

//MR: VC doesn't seem to understand __attribute__
#ifdef _WIN32
#pragma pack( pop, pack_1byte )
#endif

#endif

