#ifndef __IRE__SCRIPT__
#define __IRE__SCRIPT__

#include "core.hpp"

extern SEQ_POOL *SQlist; // Sequences in the SQlist
extern long SQtot;       // no. of sequences
extern VRM *COlist;      // Array of VRM modules
extern long COtot;       // no. of VRMs present
extern OBJECT *CHlist;   // Array of characters
extern long CHtot;       // no. of characters
extern S_POOL *SPlist;   // Array of sprites
extern long SPtot;       // number of sprites
extern TILE *TIlist;   // Array of sprites
extern long TItot;       // number of sprites
extern S_POOL *RTlist;   // Array of sprites
extern long RTtot;       // number of sprites
extern void Compile(char *file);
extern void Restring();

extern int getnum4char(char *name);     // Find index in array, of a character
extern int getnum4sequence(char *name); // Find index in array, of a sequence
extern int getnum4sprite(char *name);   // Find index in array, of a sprite
extern int getnum4VRM(char *name);      // Find index in array, of a VRM

extern char *rest(char *input);         // Get pointer to tail of string
extern char *last(char *input);         // Get pointer to end of tail
extern char *first(char *input);        // Get COPY of head of string
extern char *hardfirst(char *line);     // Mutilate original string
extern void Strip(char *tbuf);          // Eliminate trailing spaces

#endif
