/*
 *      grok.cc - grok the fullness of the datafiles
 */

#include <dir.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "../memory.hpp"
#include "grok.hpp"

// Defines

#define FNAME_LENGTH 262

// Variables

static char current_dir_name[FNAME_LENGTH];
static char splice_1[FNAME_LENGTH];
static char splice_2[FNAME_LENGTH];
extern char resdir[128];

// Functions

static void slash(char *str);
static int q_string(void *e1, void *e2);

// Code

/*
 * Find out how much memory we'll need
 */

void FILES::count(char *filespec)
{
	struct ffblk findblock;
	char prev_dir_name[FNAME_LENGTH];
	getcwd(current_dir_name,FNAME_LENGTH);

	if(findfirst(filespec,&findblock,0x2f) == 0)
		{
			do
			{
			total++;
			} while (findnext(&findblock)!= -1);
		}

	if(findfirst("*.*",&findblock,0x33) == 0)
		{
			do
			{
			if (findblock.ff_attrib & 0x10)
				{
				if (*findblock.ff_name != '.')
					{
					chdir(findblock.ff_name);
					count(filespec);
					chdir("..");
					}
				}
			} while (findnext (&findblock) != -1);
		}
}

/*
 * Log the files into memory
 */

void FILES::mount(char *filespec)
{
	struct ffblk findblock;
	char prev_dir_name[FNAME_LENGTH];
        char *head;
	getcwd(current_dir_name,FNAME_LENGTH);
        int len;

	if(findfirst(filespec,&findblock,0x2f) == 0)
		{
		do
			{
                        getcwd(splice_1,FNAME_LENGTH);
                        head = strstr(splice_1,resdir);
                        strcpy(splice_2,"");
                        if(head)
                            {
                            head +=(strlen(resdir)+1);
                            if(strlen(head)>1)
                                {
                                strcat(splice_2,head);
                                strcat(splice_2,"\\");
                                }
                            }
                        strcat(splice_2,findblock.ff_name);
                        len=strlen(splice_2)+1;

			list[file]=(char *)M_get(1,len);
			strcpy(list[file++],splice_2);
			} while (findnext(&findblock)!= -1);
		}

	if(findfirst("*.*",&findblock,0x33) == 0)
		{
		do
			{
			if (findblock.ff_attrib & 0x10)
				{
				if (*findblock.ff_name != '.')
					{
					chdir(findblock.ff_name);
					mount(filespec);
					chdir("..");
					}
				}
			} while (findnext (&findblock) != -1);
		}
}

/*
 * Set case and sort
 */

void FILES::sort()
{
for(long ctr=0;ctr<total;ctr++)
    {
    strupr(list[ctr]);
    slash(list[ctr]);
    }
qsort(list, total, sizeof(char *), q_string);
}

/*
 * Get the information
 */

int FILES::grok(char **a)
{
char curdir[FNAME_LENGTH];
int ctr;

getcwd(curdir,FNAME_LENGTH);
chdir(resdir);

total=0;
file=0;
for(ctr=0;a[ctr];ctr++)
    if(a[ctr])
        count(a[ctr]);

if(!total)
    {
    chdir(curdir);
    return 0;
    }

list=M_get(total+1,sizeof(char *));

for(ctr=0;a[ctr];ctr++)
    if(a[ctr])
        mount(a[ctr]);

sort();

chdir(curdir);
return 1;
}

/*
 * clean up afterwards
 */

void FILES::free()
{
for(long ctr=0;ctr<total;ctr++)
    M_free(list[ctr]);
M_free(list);
total=0;
file=0;
}

/*
 * helper function for Qsort
 */

int q_string(void *e1, void *e2)
{
return strcmp(*(char **)e1, *(char **)e2);
}

void slash(char *str)
{
#ifdef __DJGPP__
int len,ctr;
if(!str)
        return;
len=strlen(str);
for(ctr=0;ctr<len;ctr++)
    if(str[ctr]=='/')
        str[ctr]='\\';
#endif
}

