/*
 *  - MOD list menu tab
 */


#include <stdio.h>
#include "..\gui\igui.hpp"
#include "..\memory.hpp"
#include "..\console.hpp"
#include "..\core.hpp"
#include "..\gui\menusys.h"
#include "..\keys.hpp"
#include "..\sound.hpp"
#include "grok.hpp"     // Grok the data subdirectories

// defines

#define STR_LEN 32

// variables

extern int focus,MO_Id,Songs,mod_total;
extern char **modfiles;
extern long mod_alloc;
static int curmod=0;

static int ModNo_Id,ModName_Id,ModPath_Id;
static char ModNoStr[]="0     ";
static char str32[STR_LEN+1];
static char present=0;

// functions

extern void Toolbar();
static void Nothing();

void GetModName();
void GetModPath();
void ModUpdate();                       // Update the displays
void NewMod();
void PickMod();
void DelMod();
static int CMP(char *a, char *b);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void MO_GoFocal()
{
int temp;               // Used to get button handles

if(focus==6)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=6;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(MO_Id);     // And make the button stick inwards

// MOD list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

IG_TextButton(32,64," Add New Song      ",NewMod,NULL,NULL);
IG_TextButton(32,96," Pick a Song       ",PickMod,NULL,NULL);
IG_TextButton(32,128," Delete a Song     ",DelMod,NULL,NULL);

IG_AddKey(KEY_A,NewMod);
IG_AddKey(KEY_P,PickMod);
IG_AddKey(KEY_D,DelMod);

DrawSunkBox3D(300,56,620,460);

setcolor(WHITE);
DrawScreenText(320,64,"Music file name:");
ModName_Id = IG_InputButton(320,80,str32,GetModName,NULL,NULL);

DrawScreenText(320,112,"Music filename:");
ModPath_Id = IG_InputButton(320,128,str32,GetModPath,NULL,NULL);

IG_AddKey(KEY_N,GetModName);
IG_AddKey(KEY_F,GetModPath);

ModUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetModName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the music",32,modtab[curmod].name);
ModUpdate();
}

// Callback for Setting the sprite filename

void GetModPath()
{
char oldpath[128];

strcpy(oldpath,modtab[curmod].fname);
InputNameFromListWithFunc(-1,-1,"Choose a music file:",mod_total-1,modfiles,5,modtab[curmod].fname,0,0,NULL);
if(!modtab[curmod].fname[0])
    strcpy(modtab[curmod].fname,oldpath);
ModUpdate();
}

// Function for updating the display

void ModUpdate()
{
int num;
// Clear the name and path, set to proper value later, if valid no.
IG_UpdateText(ModPath_Id,"");
IG_UpdateText(ModName_Id,"");

if(!modtab[curmod].name || !modtab[curmod].fname)
    num = -1;
else
    {
    num = GetNumForFilename(modtab[curmod].fname);
    IG_UpdateText(ModPath_Id,modtab[curmod].fname);
    IG_UpdateText(ModName_Id,modtab[curmod].name);
    }
}

int GetNumForFilename(char *str)
{
if(!str)
    return -1;
for(int ctr=0;ctr<mod_total;ctr++)
    if(modtab[ctr].fname)
    if(!stricmp(modtab[ctr].fname,str))
        return ctr;
return -1;
}

void PickMod()
{
char name[512];
char **mlist;
long num=0;

mlist = M_get(mod_alloc,sizeof(char *));

for(long ctr=0;ctr<mod_alloc;ctr++)
    if(modtab[ctr].name && modtab[ctr].fname)
        mlist[num++]=modtab[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,modtab[curmod].name);
InputNameFromListWithFunc(-1,-1,"Choose a song:              ",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,modtab[curmod].name);

M_free(mlist);

for(long ctr=0;ctr<mod_alloc;ctr++)
    if(modtab[ctr].name != NULL)
    if(!stricmp(modtab[ctr].name,name))
        {
        curmod=ctr;
        ModUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewMod()
{
long num=0;

for(long ctr=0;ctr<mod_alloc;ctr++)
    if(!modtab[ctr].name)
        {
        curmod=ctr;
        modtab[curmod].fname = M_get(1,64);
        modtab[curmod].name = M_get(1,64);
        strcpy(modtab[curmod].fname,"NONE");
        strcpy(modtab[curmod].name,"NONE");
        ModUpdate();

        GetModPath();
        GetModName();

        return;
        }

Notify(-1,-1,"Cannot create a new music file.","Increase the value of MAX_MODS in SCRIPTER.INI");
}

void DelMod()
{
int res;
char msg[80];

if(curmod == 0)
    {
    Notify(-1,-1,"This entry is special and cannot be deleted.","You can still change it to something else though..");
    return;
    }

/*
res = VrmInUse(curspr);
if(res != -1)
    {
    sprintf(msg,"This sprite is used by sequence '%s'",SQlist[res].name);
    Notify(-1,-1,msg,"Please modify the sequence first");
    return;
    }
*/

if(Confirm(-1,-1,"Really delete this sound effect?",modtab[curmod].name))
    {
    M_free(modtab[curmod].fname);
    M_free(modtab[curmod].name);
    modtab[curmod].fname = NULL;
    modtab[curmod].name = NULL;
    curmod=0;
    ModUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}

/*
int VrmInUse(int spr)
{

OBJECT *CH;
int frame,ctr;

CH = &CHlist[spr];
for(ctr=0;ctr<chr_alloc;ctr++)
   {
   if(CHlist[ctr].name)
      {
      for(frame=0;frame<SQlist[ctr].frames;frame++)
          if(SQlist[ctr].seq[frame] == SPR)
              return ctr;
      if(SQlist[ctr].overlay == SPR)
          return ctr;
      }
   }

return -1;
}
*/

