 /*
 *      IRE script editor main module
 */


#include <malloc.h>
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <string.h>
#include <stdarg.h>

#include <netinet/in.h>    // For the endian functions

#include "..\core.hpp"     // Main data structures
#include "..\itg\itg.h"      // GFX lib
#include "..\init.hpp"     // Init module
#include "..\linklist.hpp" // Linked list alloc and free routines
#include "..\memory.hpp"   // Memory module
#include "..\loaders.hpp"  // Loader module
#include "..\keys.hpp"     // Keyboard routines
#include "..\fs.hpp"       // Filesystem
#include "..\oscli.hpp"    // Operating system command line interpreter
#include "..\console.hpp"  // Text output and logger routines
#include "..\cookies.h"    // Signatures for the Z1/Z2 map files
#include "..\script.hpp"   // The script file loader and search routines
#include "..\loadsave.hpp" // Map IO routines
#include "..\sound.hpp"    // Include the SMTab data structure
#include "..\vidmodes.h"   // Include the Video mode controller
#include "grok.hpp"        // Disk traversal

#include "..\gui\igui.hpp"

// Defines

// Variables

char InGFX=0;

FILES imagefiles;
FILES vrmfiles;
FILES Wavfiles;
FILES Modfiles;

int AB_Id,SP_Id,WA_Id,MO_Id,CO_Id,SQ_Id,CH_Id,TI_Id,RT_Id;
int  mapx=0,mapy=0;     // Initial map coordinates
char buggy=0;

char **sprites;
char **vrmfuncs;
char **wavfiles;
char **modfiles;
int spr_total,seq_total,vrm_total,wav_total,mod_total,til_total,rft_total=256;

char *screen;		        // the screen
char *bg_screen;		// the background screen
SPRITE transfer;

OBJECT *player;         // For the DLX engine
OBJECT *current_object; // parameters For the DLX engine
OBJECT *victim;         // parameters For the DLX engine
TILE   *current_tile;
char   *message;
int    *storage;

int Waves=0,Songs=0;    // Sound engine dummies
SMTab *modtab,*wavtab;  // More dummies

char mapname[]="1234567890";
// defaults for the DLX engine
int mainproc,vscheduler,look_none,use_none,status,follower,loadproc,playervrm,all_dead;
extern char in_editor;

extern long spr_alloc,seq_alloc,chr_alloc,til_alloc,vrm_alloc;

char __up[]={22,0};     // The arrow icons (in the font)
char __down[]={23,0};
char __left[]={20,0};
char __left2[]={20,20,0};
char __right[]={21,0};
char __right2[]={21,21,0};

// Functions

void banner();

void Toolbar();

void Quit();
void Snap();

void S_load();
void S_save();

extern void AB_GoFocal();       // About box handle
extern void SP_GoFocal();       // Sprites handle
extern void SQ_GoFocal();       // Animation Sequences handle
extern void CH_GoFocal();       // Characters handle
extern void WA_GoFocal();       // Wavfile handle
extern void MO_GoFocal();       // Modfile handle
extern void CO_GoFocal();       // VRM handle
extern void TI_GoFocal();       // Tiles
extern void RT_GoFocal();       // Roof Tiles

// Code

/*
 *      Main - start up all the things, run them, stop all the things, exit
 */

main(int argc,char *argv[])
{
/*
char *imgs[]={"*.cel","*.pcx",NULL};
char *vrms[]={"*.vrm",NULL};
char *wavs[]={"*.wav",NULL};
char *mods[]={"*.mod","*.xm","*.s3m","*.it",NULL};
*/
int ctr;
char path[256];

#ifdef __DJGPP__
printf("This product includes software developed by the University of California,\n");
printf("Berkeley and its contributors\n");
sleep(1);
#endif


strcpy(resdir,"res");   // Set default directory for resources
banner();

in_editor = 2;    // Some init functions are not necessary for the editor

V_init();         // Init video modes
M_init();         // Init memory systems

puts("Init_logger();");
Init_logger();

bootmsg("Allocating screens\n");
bg_screen = (char *)M_get(640000,1);
Loader_Init();

// Get commandline input

if(argc>=2)
    OSCLI(argc,argv);       // input from OSCLI

INI_file("scripter.ini");         // Read the main ini file and act upon it
V_format(VideoMode);            // Set correct RGB format

// For the editor, we must ensure that a file is loaded.

/*
if((unsigned char)mapname[0]==(unsigned char)0xff)
	{
	puts("\nPlease specify the name of the level you want to edit.");
	puts("  EG.  edit -edit mymap\n");
	exit(1);
	}
*/

Init_Filesystem();              // Start VFS

if(Gexist("!autoire.ini"))      // If the user ini file exists,
    INI_file("!autoire.ini");   // Read it in and act upon it

Init_Font();                    // Load font for console

bootmsg("Memory now available :%ld bytes decimal\n",coreleft());

// Init the VRM system

// Init_DLX();

// Now, parse/compile the scripts

bootmsg("Gather VRMs\n");
vrmfiles.grok((char *[]){"*.vrm",NULL});
vrmfuncs=vrmfiles.list;
vrm_total=vrmfiles.total;

bootmsg("Gather WAVs\n");
Wavfiles.grok((char *[]){"*.wav",NULL});
wavfiles=Wavfiles.list;
wav_total=Wavfiles.total;

bootmsg("Gather MODs\n");
Modfiles.grok((char *[]){"*.mod","*.s3m","*.xm","*.it",NULL});
modfiles=Modfiles.list;
mod_total=Modfiles.total;

bootmsg("Gather sprites\n");
imagefiles.grok((char *[]){"*.cel","*.pcx",NULL});
sprites=imagefiles.list;
spr_total=imagefiles.total;

bootmsg("Load them in\n");

strcpy(path,resdir);
strcat(path,"/main.txt");

Compile(path);          // This is less a compiler than it was once
Restring();             // Convert static strings to dynamic arrays for edits
S_load();
Init_Funcs();

// Set up the initial WxH levels

for(ctr=0;ctr<CHtot;ctr++)
    Init_Areas(&CHlist[ctr]);

// Make sure there are some tiles

//if(TItot<1)
//    panic("main","No tiles were defined","Check 'section: tiles' in the scriptfile");

transfer.allocate(256,256);     // Allocate transfer buffer for Map clipping

//LoadMap();                      // What it says

Loader_Term();                  // Initialisation completed, free some blocks

IG_Init(128);                   // Set up the iGUI for max 128 buttons

Toolbar();                      // Draw the menu bar at the top
                                // And then start the iGUI event loop

AB_GoFocal();                   // Start on the ABOUT screen

do IG_Dispatch(); while(running);       // Loop until quit

if(Confirm(-1,-1,"Do you want to save changes?",NULL))
    S_save();

IG_Term();                      // Free the iGUI resources

banner();                       // Show the banner

// Recompute all WxH levels before comitting to disk
for(ctr=0;ctr<CHtot;ctr++)
    Init_Areas(&CHlist[ctr]);

M_term();                       // Shut down memory alloc'er
}

/*
 *      Banner - Display the red banner at the top of the screen in startup
 */

void banner()
{
off();
textcolor(15);
textbackground(4);
cprintf("        IRE Script Editor - IT-HE RPG Engine (C) 1998 IT-HE Software          \r\n");
textcolor(7);
textbackground(0);
window(1,2,80,25);
}

/*
 *      Toolbar - set up the GUI components that are present in all cases
 */

void Toolbar()
{
IG_KillAll();
IG_AddKey(0x1b,Quit);           // Add key binding for ESC = Quit
IG_AddKey(0x5d,Snap);           // Add key binding for shift-F10
IG_Panel(0,0,640,32);

IG_Panel(0,32,640,480-32);
AB_Id = IG_Tab(540,4,"About",AB_GoFocal,NULL,NULL);
SP_Id = IG_Tab(4,4,"Sprites",SP_GoFocal,NULL,NULL);
SQ_Id = IG_Tab(72,4,"Sequences",SQ_GoFocal,NULL,NULL);
CH_Id = IG_Tab(156,4,"Characters",CH_GoFocal,NULL,NULL);
CO_Id = IG_Tab(248,4,"Code",CO_GoFocal,NULL,NULL);
WA_Id = IG_Tab(292,4,"Sound",WA_GoFocal,NULL,NULL);
MO_Id = IG_Tab(344,4,"Music",MO_GoFocal,NULL,NULL);
TI_Id = IG_Tab(396,4,"Tiles",TI_GoFocal,NULL,NULL);
RT_Id = IG_Tab(448,4,"Roof Tiles",RT_GoFocal,NULL,NULL);
/*
WA_Id = IG_Tab(72,4,"Sound",WA_GoFocal,NULL,NULL);
MO_Id = IG_Tab(124,4,"Music",MO_GoFocal,NULL,NULL);
*/
IG_TextButton(594,4,"Quit",Quit,NULL,NULL);

// Hotkeys for the sections

IG_AddKey(KEY_1,SP_GoFocal);
IG_AddKey(KEY_2,SQ_GoFocal);
IG_AddKey(KEY_3,CH_GoFocal);
IG_AddKey(KEY_4,CO_GoFocal);
IG_AddKey(KEY_5,WA_GoFocal);
IG_AddKey(KEY_6,MO_GoFocal);
IG_AddKey(KEY_7,TI_GoFocal);
IG_AddKey(KEY_8,RT_GoFocal);
IG_AddKey(KEY_0,AB_GoFocal);
}

/*
 *      Quit - The callback handler for Quitting
 */

void Quit()
{
if(Confirm(-1,-1,"Are you sure you want to quit?",NULL))
  running = 0;
}

/*
 *      Snap - The callback handler for taking a screen dump
 */

void Snap()
{
BMPshot((short *)swapscreen,640);
}


/* ================================ Map RW =============================== */


void S_load()
{
/*
int ctr;

// First, copy the compiled SPlist to SPedit, for editing.
// Keep SPlist around as we will need it to get to the sprites later

SPedit=M_get(spr_alloc,sizeof(S_POOL));
for(ctr=0;ctr<SPtot;ctr++)
        {
        SPedit[ctr].fname = M_get(1,64);
        SPedit[ctr].name = M_get(1,64);
        strcpy(SPedit[ctr].fname,SPlist[ctr].fname);
        strcpy(SPedit[ctr].name,SPlist[ctr].name);
//        M_free(SPlist[ctr].fname);
//        M_free(SPlist[ctr].name);
        }

//M_free(SPlist);
*/

/*
SPlist=M_get(spr_total,sizeof(S_POOL));
for(ctr=0;ctr<spr_total;ctr++)
        {
        // Set up the master sprite list, just a table of Name against Image
        SPlist[ctr].fname = sprites[ctr];
        SPlist[ctr].name="Oh bugger!";
        Init_Sprite(ctr);
        }
//SPtot=spr_total;
*/
}

void S_save()
{
FILE *fp;
char str[21];
char path1[256];
char path2[256];


strcpy(path1,resdir);
strcat(path1,"/main.bak");
strcpy(path2,resdir);
strcat(path2,"/main.txt");
remove(path1);
rename(path2,path1);

fp=fopen(path2,"w");
if(!fp)
    panic("DAMN!","Could not open output file:",path2);

SEQ_POOL *sp;

// Descriptions
// Code
// Sprites
// Sequences
// Characters
// Tiles
// Sound
// Music
// RoofTiles

fprintf(fp,"#\n");
fprintf(fp,"# IRE script file made by SCRIPTER using game kernel %s\n",IKV);
fprintf(fp,"#\n\n");

// Write Code

if(COtot>0)
    {
    fprintf(fp,"section: code\n\n");
    for(int ctr=0;ctr<vrm_alloc;ctr++)
    if(COlist[ctr].name && COlist[ctr].fname)
        {
        memset(str,' ',20);
        str[20-strlen(COlist[ctr].name)]=0;
        fprintf(fp,"\t%s%s%s\n",COlist[ctr].name,str,COlist[ctr].fname);
        }
    fprintf(fp,"\n\n");
    }

// Write Sprites

if(SPtot>0)
    {
    fprintf(fp,"section: sprites\n\n");
    for(int ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name && SPlist[ctr].fname)
        {
        memset(str,' ',20);
        str[20-strlen(SPlist[ctr].name)]=0;
        fprintf(fp,"\t%s%s%s\n",SPlist[ctr].name,str,SPlist[ctr].fname);
        }
    fprintf(fp,"\n\n");
    }

// Write Sequences

if(SQtot>0)
    {
    fprintf(fp,"section: sequences\n\n");
    for(int ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name)
        {
        fprintf(fp,"\tname %s\n",SQlist[ctr].name);

        if(SQlist[ctr].flags&1)
            fprintf(fp,"\tpingpong\n");
        if(SQlist[ctr].flags&2)
            fprintf(fp,"\tloop\n");
        if(SQlist[ctr].flags&4)
            fprintf(fp,"\tstepped\n");

        if(SQlist[ctr].x)
            fprintf(fp,"\tx %d\n",SQlist[ctr].x);
        if(SQlist[ctr].y)
            fprintf(fp,"\ty %d\n",SQlist[ctr].y);
        if(SQlist[ctr].speed)
            fprintf(fp,"\tspeed %d\n",SQlist[ctr].speed);
        if(SQlist[ctr].overlay)
            fprintf(fp,"\toverlay %s\n",SQlist[ctr].overlay->name);

        fprintf(fp,"\tframelist:\n");
        fprintf(fp,"\t#%d frames\n",SQlist[ctr].frames);
        for(int ctr2=0;ctr2<SQlist[ctr].frames;ctr2++)
           fprintf(fp,"\t\t%s\n",SQlist[ctr].seq[ctr2]->name);
        fprintf(fp,"\tend\n\n");
        }
    fprintf(fp,"\n");
    }

// Write Characters (complex)

if(SQtot>0)
    {
    fprintf(fp,"section: characters\n\n");
    for(int ctr=0;ctr<chr_alloc;ctr++)
    if(CHlist[ctr].name)
        {
        fprintf(fp,"\tname %s\n",CHlist[ctr].name);
        fprintf(fp,"\tleft\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_L]].name);
        fprintf(fp,"\tright\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_R]].name);
        fprintf(fp,"\tup\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_U]].name);
        fprintf(fp,"\tdown\t\t%s\n",SQlist[CHlist[ctr].dir[CHAR_D]].name);

        fprintf(fp,"\thp\t\t%d\n",CHlist[ctr].stats->hp);
        fprintf(fp,"\tdexterity\t%d\n",CHlist[ctr].stats->dex);
        fprintf(fp,"\tstrength\t%d\n",CHlist[ctr].stats->str);
        fprintf(fp,"\tintelligence\t%d\n",CHlist[ctr].stats->intel);
        fprintf(fp,"\tweight\t\t%d\n",CHlist[ctr].stats->weight);
        fprintf(fp,"\tdamage\t\t%d\n",CHlist[ctr].stats->damage);
        fprintf(fp,"\tlight\t\t%d\n",CHlist[ctr].light);


        fprintf(fp,"\tdescription\t\"%s\"\n",CHlist[ctr].desc);
        fprintf(fp,"\tshort\t\t\"%s\"\n",CHlist[ctr].shortdesc);

        if(CHlist[ctr].funcs->ucache != -1)
            fprintf(fp,"\tIfUsed\t\t%s\n",CHlist[ctr].funcs->use);
        if(CHlist[ctr].funcs->scache != -1)
            fprintf(fp,"\tIfTriggered\t%s\n",CHlist[ctr].funcs->stand);
        if(CHlist[ctr].funcs->kcache != -1)
            fprintf(fp,"\tIfKilled\t%s\n",CHlist[ctr].funcs->kill);
        if(CHlist[ctr].funcs->lcache != -1)
            fprintf(fp,"\tIfLookedAt\t%s\n",CHlist[ctr].funcs->look);
        if(CHlist[ctr].funcs->hcache != -1)
            fprintf(fp,"\tIfHurt\t\t%s\n",CHlist[ctr].funcs->hurt);
        if(CHlist[ctr].funcs->icache != -1)
            fprintf(fp,"\tOnInit\t\t%s\n",CHlist[ctr].funcs->init);
        if(CHlist[ctr].behave != -1)
            fprintf(fp,"\tbehaviour\t%s\n",COlist[CHlist[ctr].behave].name);

        if(CHlist[ctr].flags.solid)
            fprintf(fp,"\tsolid\n");
        if(CHlist[ctr].flags.blocklight)
            fprintf(fp,"\tblockslight\n");
        if(CHlist[ctr].flags.invisible)
            fprintf(fp,"\tinvisible\n");
        if(CHlist[ctr].flags.translucent)
            fprintf(fp,"\ttranslucent\n");
        if(CHlist[ctr].flags.overlay)
            fprintf(fp,"\tpost_overlay\n");
        if(CHlist[ctr].flags.fixed)
            fprintf(fp,"\tfixed\n");
        if(CHlist[ctr].flags.container)
            fprintf(fp,"\tcontainer\n");
        if(CHlist[ctr].flags.wield)
            fprintf(fp,"\twielded\n");
        if(CHlist[ctr].flags.tabletop)
            fprintf(fp,"\ttabletop\n");
        if(CHlist[ctr].flags.fragile)
            fprintf(fp,"\tfragile\n");
        if(CHlist[ctr].flags.spikeproof)
            fprintf(fp,"\tspikeproof\n");
        if(CHlist[ctr].flags.person)
            fprintf(fp,"\tperson\n");
        if(CHlist[ctr].flags.quantity)
            fprintf(fp,"\tquantity\n");

        if(strlen(CHlist[ctr].funcs->talk) > 1)
            fprintf(fp,"\tConversation\t%s\n",CHlist[ctr].funcs->talk);

        for(int ctr2=0;ctr2<CHlist[ctr].funcs->contents;ctr2++)
            fprintf(fp,"\tcontains\t%s\n",CHlist[ctr].funcs->contains[ctr2]);

        // Print resurrection state, if not same as name
        if(stricmp(CHlist[ctr].funcs->resurrect,CHlist[ctr].name))
            {
            // If resurrection state is just "-", use no_resurrect flag
            if(!stricmp(CHlist[ctr].funcs->resurrect,"-"))
                fprintf(fp,"\tno_resurrect\n");
            else
                fprintf(fp,"\tresurrect_as\t%s\n",CHlist[ctr].funcs->resurrect);
            }

        if(CHlist[ctr].vblockw && CHlist[ctr].vblockh)
            fprintf(fp,"\tsetsolid\tV %d %d %d %d\n",CHlist[ctr].vblockx,CHlist[ctr].vblocky,CHlist[ctr].vblockw,CHlist[ctr].vblockh);
        if(CHlist[ctr].hblockw && CHlist[ctr].hblockh)
            fprintf(fp,"\tsetsolid\tH %d %d %d %d\n",CHlist[ctr].hblockx,CHlist[ctr].hblocky,CHlist[ctr].hblockw,CHlist[ctr].hblockh);

        if(CHlist[ctr].VareaW && CHlist[ctr].VareaH)
            fprintf(fp,"\tsetActiveArea\tV %d %d %d %d\n",CHlist[ctr].VareaX,CHlist[ctr].VareaY,CHlist[ctr].VareaW,CHlist[ctr].VareaH);
        if(CHlist[ctr].HareaW&& CHlist[ctr].HareaH)
            fprintf(fp,"\tsetActiveArea\tH %d %d %d %d\n",CHlist[ctr].HareaX,CHlist[ctr].HareaY,CHlist[ctr].HareaW,CHlist[ctr].HareaH);
        fprintf(fp,"\n");
        }
    fprintf(fp,"\n");
    }

// Write Tiles

if(TItot>0)
    {
    fprintf(fp,"section: tiles\n\n");
    for(int ctr=0;ctr<=TItot;ctr++)
    if(TIlist[ctr].name)
        {
        fprintf(fp,"\tname %s\n",TIlist[ctr].name);
        fprintf(fp,"\tsequence\t%s\n",TIlist[ctr].seqname);
        fprintf(fp,"\tdescription\t\"%s\"\n",TIlist[ctr].desc);

        if(TIlist[ctr].flags.solid)
            fprintf(fp,"\tsolid\n");
        if(TIlist[ctr].flags.blocklight)
            fprintf(fp,"\tblockslight\n");
        fprintf(fp,"\n");
        }
    fprintf(fp,"\n");
    }

// Write Sounds

if(Waves>0)
    {
    fprintf(fp,"section: sounds\n\n");
    for(int ctr=0;ctr<Waves;ctr++)
    if(wavtab[ctr].name && wavtab[ctr].fname)
        {
        memset(str,' ',20);
        str[20-strlen(wavtab[ctr].name)]=0;
        if(wavtab[ctr].nodrift)
            fprintf(fp,"\t%s%s%s  nodrift\n",wavtab[ctr].name,str,wavtab[ctr].fname);
        else
            fprintf(fp,"\t%s%s%s\n",wavtab[ctr].name,str,wavtab[ctr].fname);
        }
    fprintf(fp,"\n\n");
    }

// Write Music

if(Songs>0)
    {
    fprintf(fp,"section: music\n\n");
    for(int ctr=0;ctr<Songs;ctr++)
    if(wavtab[ctr].name && wavtab[ctr].fname)
        {
        memset(str,' ',20);
        str[20-strlen(modtab[ctr].name)]=0;
        fprintf(fp,"\t%s%s%s\n",modtab[ctr].name,str,modtab[ctr].fname);
        }
    fprintf(fp,"\n\n");
    }

// Write Roof tiles

if(RTtot>0)
    {
    fprintf(fp,"section: rooftiles\n\n");
    for(int ctr=1;ctr<rft_total;ctr++)
    if(RTlist[ctr].fname)
        {
        memset(str,' ',20);
        str[20-strlen(RTlist[ctr].fname)]=0;
        if(RTlist[ctr].name)
            fprintf(fp,"\t%s\n",RTlist[ctr].fname);
        else
            fprintf(fp,"\t%s\tstand_under\n",RTlist[ctr].fname);
        }
    fprintf(fp,"\n\n");
    }

fclose(fp);
}

// Dummy functions

void AddQuantity(OBJECT *a, char *name, int num)
{
}

int TakeQuantity(OBJECT *a, char *name, int num)
{
return 0;
}
