/*
 *  - Sprite list menu tab
 */


#include <stdio.h>
#include "..\gui\igui.hpp"
#include "..\memory.hpp"
#include "..\console.hpp"
#include "..\core.hpp"
#include "..\gui\menusys.h"
#include "..\keys.hpp"
#include "grok.hpp"     // Grok the data subdirectories

// defines

#define VIEWX 320
#define VIEWY 176
#define STR_LEN 32

// variables

extern int focus,SP_Id,SPtot,spr_total,seq_alloc;
extern char **sprites;
extern SPRITE transfer;
extern long spr_alloc;
//extern S_POOL *SPedit;

static int curspr=0;

static int SprNo_Id,SprName_Id,SprPath_Id;
static char SprNoStr[]="0     ";
static char str32[STR_LEN+1];
static char present=0;

// functions

extern void Toolbar();
extern void Init_Sprite(int spr);
static void Nothing();

void GetSprName();
void GetSprPath();
void SprUpdate();                       // Update the displays
void NewSprite();
void PickSprite();
void DelSprite();
static int CMP(char *a, char *b);
static int SpriteInUse(int spr);

static int GetNumForFilename(char *str);

// GoFocal - The menu tab function.  This is called from the toolbar

void SP_GoFocal()
{
int temp;               // Used to get button handles

if(focus==1)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;  // Make a 255 character string

focus=1;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(SP_Id);     // And make the button stick inwards

// Sprite list editor.
// In the top-left corner is the sprite ID number and two movement buttons.

/*
IG_TextButton(32,64,__left,SP_Prev,NULL,NULL);
SprNo_Id = IG_InputButton(64,64,"0     ",GetSprNo,NULL,NULL);
IG_TextButton(128,64,__right,SP_Next,NULL,NULL);
*/

IG_TextButton(32,64," Add New Sprite    ",NewSprite,NULL,NULL);
IG_TextButton(32,96," Pick a sprite     ",PickSprite,NULL,NULL);
IG_TextButton(32,128," Delete a sprite   ",DelSprite,NULL,NULL);

IG_AddKey(KEY_A,NewSprite);
IG_AddKey(KEY_P,PickSprite);
IG_AddKey(KEY_D,DelSprite);

DrawSunkBox3D(300,56,620,460);

setcolor(WHITE);
DrawScreenText(320,64,"Sprite name:");
SprName_Id = IG_InputButton(320,80,str32,GetSprName,NULL,NULL);

DrawScreenText(320,112,"Sprite filename:");
SprPath_Id = IG_InputButton(320,128,str32,GetSprPath,NULL,NULL);

IG_BlackPanel(VIEWX-1,VIEWY-1,258,258);

IG_AddKey(KEY_N,GetSprName);
IG_AddKey(KEY_F,GetSprPath);

SprUpdate();
}

// Callback for a null event

void Nothing()
{
return;
}


// Callback for Setting the sprite description

void GetSprName()
{
//if(curspr<SPtot)
    InputString(-1,-1,"Enter the new description of the sprite",32,SPlist[curspr].name);
SprUpdate();
}

// Callback for Setting the sprite filename

void GetSprPath()
{
char oldpath[128];
strcpy(oldpath,SPlist[curspr].fname);
InputNameFromListWithFunc(-1,-1,"Choose an image file:",spr_total-1,sprites,5,SPlist[curspr].fname,0,0,NULL);
if(!SPlist[curspr].fname[0])
    strcpy(SPlist[curspr].fname,oldpath);
else
    {
    SPlist[curspr].image.free();
    Init_Sprite(curspr);
//    SPedit[curspr].image = SPlist[GetNumForFilename(SPedit[curspr].fname)].image;
    }

SprUpdate();
}

// Function for updating the display

void SprUpdate()
{
int num;
// Update the sprite number

//sprintf(SprNoStr,"%d",curspr);
//IG_UpdateText(SprNo_Id,SprNoStr);

// Clear the sprite's name and path, set to proper value later, if valid no.
IG_UpdateText(SprPath_Id,"");
IG_UpdateText(SprName_Id,"");

if(!SPlist[curspr].name || !SPlist[curspr].fname)
    num = -1;
else
    {
    num = GetNumForFilename(SPlist[curspr].fname);
    IG_UpdateText(SprPath_Id,SPlist[curspr].fname);
    IG_UpdateText(SprName_Id,SPlist[curspr].name);
    }

if(!SPlist[curspr].image.W)
    num=-1;


if(num==-1)
    {
    fbox2(VIEWX,VIEWY,256,256,21,swapscreen);
    DrawScreenText(VIEWX+8,VIEWY+8,"Does not exist");
    return;
    }

// Draw it

fbox2(0,0,256,256,21,bg_screen);
SPlist[num].image.cel_put_sprite(0,0,bg_screen);
transfer.get_sprite(0,0,bg_screen);
transfer.block_put_sprite(VIEWX,VIEWY,swapscreen);
}

int GetNumForFilename(char *str)
{
if(!str)
    return -1;
for(int ctr=0;ctr<spr_total;ctr++)
    if(SPlist[ctr].fname)
    if(!stricmp(SPlist[ctr].fname,str))
        return ctr;
return -1;
}

void PickSprite()
{
char name[128];
char **mlist;
long num=0;

mlist = M_get(spr_alloc,sizeof(char *));

for(long ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name && SPlist[ctr].fname)
        mlist[num++]=SPlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,SPlist[curspr].name);
InputNameFromListWithFunc(-1,-1,"Choose a sprite:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,SPlist[curspr].name);

M_free(mlist);

for(long ctr=0;ctr<spr_alloc;ctr++)
    if(SPlist[ctr].name != NULL)
    if(!stricmp(SPlist[ctr].name,name))
        {
        curspr=ctr;
        SprUpdate();
        return;
        }
Notify(-1,-1,"Oh Bugger!",NULL);
}

void NewSprite()
{
long num=0;

for(long ctr=0;ctr<spr_alloc;ctr++)
    if(!SPlist[ctr].name)
        {
        curspr=ctr;
        SPlist[curspr].fname = M_get(1,64);
        SPlist[curspr].name = M_get(1,64);
        strcpy(SPlist[curspr].fname,"NONE");
        strcpy(SPlist[curspr].name,"NONE");
        SprUpdate();

        GetSprPath();
        GetSprName();

        return;
        }

Notify(-1,-1,"Cannot create a new sprite.","Increase the value of MAX_SPRITES in SCRIPTER.INI");
}

void DelSprite()
{
int res;
char msg[80];

if(curspr == 0) // lame error message
    {
    Notify(-1,-1,"This sprite is special and cannot be deleted.","You may however change it to something else.");
    return;
    }

res = SpriteInUse(curspr);
if(res != -1)
    {
    sprintf(msg,"This sprite is used by sequence '%s'",SQlist[res].name);
    Notify(-1,-1,msg,"Please modify the sequence first");
    return;
    }

if(Confirm(-1,-1,"Really delete this sprite?",SPlist[curspr].name))
    {
    SPlist[curspr].image.free();
    M_free(SPlist[curspr].fname);
    M_free(SPlist[curspr].name);
    SPlist[curspr].fname = NULL;
    SPlist[curspr].name = NULL;
    curspr=0;
    SprUpdate();
    }

}

int CMP(char *a,char *b)
{
return strcmp(a,b);
}

int SpriteInUse(int spr)
{
S_POOL *SPR;
int frame,ctr;

SPR = &SPlist[spr];
for(ctr=0;ctr<seq_alloc;ctr++)
   {
   if(SQlist[ctr].name)
      {
      for(frame=0;frame<SQlist[ctr].frames;frame++)
          if(SQlist[ctr].seq[frame] == SPR)
              return ctr;
      if(SQlist[ctr].overlay == SPR)
          return ctr;
      }
   }

return -1;
}

