/*
 *  - Tile editor menu tab
 */


#include <stdio.h>
#include "..\gui\igui.hpp"
#include "..\memory.hpp"
#include "..\console.hpp"
#include "..\core.hpp"
#include "..\init.hpp"
#include "..\keys.hpp"
#include "..\gui\menusys.h"
#include "grok.hpp"     // Grok the data subdirectories

// defines

#define VIEWX 64
#define VIEWY 112
#define STR_LEN 32
#define OVL_LEN 24

// variables

extern int focus,TI_Id,til_alloc,seq_alloc;
extern SPRITE transfer;
//extern SEQ_POOL *SQedit;

static int curtil=0,offset=0,solid,blocklight;

static int TilName_Id,Desc_Id,Seq_Id,Sol_Id,Blocklight_Id;
static char TilName[33];
static char Desc32[128];
static char SeqName[33];
static char none[]="-";

static char str32[STR_LEN+1];

// functions

extern void Toolbar();
extern void Snap();
extern short exist(char *fname);


static void Nothing();
static void TilUpdate();                       // Update the displays
static void Name();
static void Description();
static short GetSequence(char *original);
static void AddTile();
static void DelTile();
static void PickTile();

static void Seq();
static void ToggleSolid();
static void ToggleBlockLight();
static void Toggle();

static void TLBl();
static void TLBr();
static void TLBll();
static void TLBrr();

// GoFocal - The menu tab function.  This is called from the toolbar

void TI_GoFocal()
{
int temp;               // Used to get button handles

if(focus==7)            // Make sure we don't redraw if the user clicks again
	return;

memset(str32,' ',STR_LEN); str32[STR_LEN]=0;
memset(TilName,' ',STR_LEN); TilName[STR_LEN]=0;
//memset(behave_str,' ',STR_LEN); behave_str[STR_LEN]=0;

focus=7;                // This is now the focus
Toolbar();              // Build up the menu system again from scratch
IG_SetFocus(TI_Id);     // And make the button stick inwards

IG_TextButton(32,80, " Add tile to end ",AddTile,NULL,NULL);
IG_AddKey(KEY_A,AddTile);

IG_TextButton(32,112," Delete from end ",DelTile,NULL,NULL);
IG_AddKey(KEY_D,DelTile);

DrawScreenText(224,104,"Tile:");
TilName_Id = IG_InputButton(320,96,str32,Name,NULL,NULL);

DrawScreenText(32,192,"Long description:");
Desc_Id = IG_InputButton(192,184,str32,Description,NULL,NULL);

DrawScreenText(32,256,"Animation sequence:");
Seq_Id = IG_InputButton(192,248,str32,Seq,NULL,NULL);

DrawScreenText(32,288,"Is it solid:");
Sol_Id = IG_ToggleButton(144,280,"   ",ToggleSolid,NULL,NULL,&solid);
IG_SetInText(Sol_Id," X ");

DrawScreenText(32,320,"Does it block light:");
Blocklight_Id = IG_ToggleButton(208,312,"   ",ToggleBlockLight,NULL,NULL,&blocklight);
IG_SetInText(Blocklight_Id," X ");

IG_Region(32,400,576,32,PickTile,NULL,NULL);        // Tile selector

// Draw the VCR buttons on the Tile selector

IG_TextButton(8,410,__left,TLBl,NULL,NULL);     // Normal speed
IG_TextButton(616,410,__right,TLBr,NULL,NULL);

IG_TextButton(8,440,__left2,TLBll,NULL,NULL);   // Fast Forward
IG_TextButton(608,440,__right2,TLBrr,NULL,NULL);

TilUpdate();
}

void AddTile()
{
long num=0;

if(TItot == til_alloc)
    {
    Notify(-1,-1,"No more space for tiles allocated.","Edit the entry for MAX_TILES in 'scripter.ini'");
    return;
    }

TIlist[TItot].name = M_get(1,33);
TIlist[TItot].desc = M_get(1,4096);
strcpy(TIlist[TItot].name,TIlist[TItot-1].name);
strcpy(TIlist[TItot].desc,TIlist[TItot-1].desc);
strcpy(TIlist[TItot].seqname,TIlist[TItot-1].seqname);
TIlist[TItot].form = TIlist[TItot-1].form;
TItot++;

TilUpdate();
IG_WaitForRelease();
}

void DelTile()
{
if(TItot == 1)
    {
    Notify(-1,-1,"You must have at least one tile.",NULL);
    return;
    }

TItot--;
M_free(TIlist[TItot].name);
M_free(TIlist[TItot].desc);
TIlist[TItot].form = NULL;
TIlist[TItot].name = NULL;

// If it's onscreen, make it go away

curtil=TItot-1;
if(offset>(TItot-17))
    offset=(TItot-17);

TilUpdate();
IG_WaitForRelease();
}

short GetSequence(char *original)
{
char name[128];
char **mlist;
long num=0;

mlist = M_get(seq_alloc,sizeof(char *));
mlist[num++]="-";

for(long ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name)
         mlist[num++]=SQlist[ctr].name;

qsort(mlist,num,sizeof(char *),CMP);

strcpy(name,original);
InputNameFromListWithFunc(-1,-1,"Choose an animation:",num-1,mlist,5,name,0,0,NULL);
if(!name[0])
    strcpy(name,original);

M_free(mlist);

for(long ctr=0;ctr<seq_alloc;ctr++)
    if(SQlist[ctr].name != NULL)
    if(!stricmp(SQlist[ctr].name,name))
        return ctr;
//Notify(-1,-1,"Oh Bugger!",NULL);
return -1;         // This is NONE
}


// Callback for a null event

void Nothing()
{
return;
}


// Function for updating the display

void TilUpdate()
{
int num=-1,len,co;

solid = TIlist[curtil].flags.solid;
blocklight = TIlist[curtil].flags.blocklight;

draw_button(Sol_Id);
draw_button(Blocklight_Id);


strcpy(TilName,TIlist[curtil].name);
for(int ctr=strlen(TilName);ctr<32;ctr++)
    TilName[ctr]=' ';
TilName[32]=0;
IG_UpdateText(TilName_Id,TilName);

strncpy(Desc32,TIlist[curtil].desc,32);
for(int ctr=strlen(Desc32);ctr<32;ctr++)
    Desc32[ctr]=' ';
Desc32[32]=0;
IG_UpdateText(Desc_Id,Desc32);

strncpy(SeqName,TIlist[curtil].seqname,32);
for(int ctr=strlen(SeqName);ctr<32;ctr++)
    SeqName[ctr]=' ';
SeqName[32]=0;
IG_UpdateText(Seq_Id,SeqName);

co=17;
if(TItot<17)
    co=TItot;
IG_BlackPanel(31,399,578,34);
for(int ctr=0;ctr<co;ctr++)
    {
    TIlist[ctr+offset].form->seq[0]->image.block_put_sprite(33+(34*ctr),401,swapscreen);
    if(curtil == ctr+offset)
        ITG_box(33+(34*ctr),401,65+(34*ctr),432,WHITE,swapscreen);
    }
}

void Name()
{
InputString(-1,-1,"Enter the new name of the tile:",32,TIlist[curtil].name);
TilUpdate();
}

void Description()
{
InputIString(-1,-1,"Enter the full description of the tile:",1024,TIlist[curtil].desc);
TilUpdate();
}

void Seq()
{
int i;
strupr(TIlist[curtil].seqname);
i = GetSequence(TIlist[curtil].seqname);
if(i != -1)
    {
    if(SQlist[i].seq[0]->w != 32 || SQlist[i].seq[0]->h != 32)
        if(!Confirm(-1,-1,"This object is not 32x32 and may crash the program.","Are you sure you want to use it?"))
            return;
    strcpy(TIlist[curtil].seqname,SQlist[i].name);
    TIlist[curtil].form=&SQlist[i];
    }
TilUpdate();
}

void ToggleSolid()
{
TIlist[curtil].flags.solid = ! TIlist[curtil].flags.solid;
solid = TIlist[curtil].flags.solid;
TilUpdate();
IG_WaitForRelease();
}

void ToggleBlockLight()
{
TIlist[curtil].flags.blocklight = ! TIlist[curtil].flags.blocklight;
blocklight = TIlist[curtil].flags.blocklight;
TilUpdate();
IG_WaitForRelease();
}

void TLBr()
{
offset++;
if(offset>(TItot-17))
    offset=(TItot-17);
TilUpdate();
}

void TLBl()
{
offset--;
if(offset<0) offset=0;
TilUpdate();
}

void TLBrr()
{
offset+=10;
if(offset>(TItot-17))
    offset=(TItot-17);
TilUpdate();
}

void TLBll()
{
offset-=10;
if(offset<0) offset=0;
TilUpdate();
}

void PickTile()
{
int co;
co=17;
if(TItot<17) co=TItot;
for(int ctr=0;ctr<co;ctr++)
	if(x>33+(34*ctr) && x<65+(34*ctr))
		{
		curtil=ctr+offset;
                TilUpdate();
		return;
		}
}

