/*      DEMO.C
 *
 * MIDAS megademo
 *
 * Copyright 1996 Petteri Kangaslampi
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <conio.h>
#include "soundsys/midasdll.h"

#ifdef __DJGPP__
#include <dpmi.h>
#endif



/* To start the program right away, without a configuration screen,
   uncomment the following line. However, this is generally NOT a good
   idea, as the user might want to use a different sound card than the
   one detected, or might want better sound quality than the default. Also
   some sound cards can NOT be detected at all.

   If you uncomment the following line, at least provide a way for the
   user to get to the setup by giving a command line argument - this
   program does also this. */

/*#define ATTEMPT_DETECT*/


/* Music playing position information - updated by UpdateInfo: */
unsigned        position;               /* Current position */
unsigned        pattern;                /* Current pattern number */
unsigned        row;                    /* Current row number */
int             syncInfo;               /* Music synchronization info */

/* Music file name ;) */
char            *moduleName = "setup.mod";


/* Frame counter variable - note VOLATILE! */
volatile unsigned   frameCount;

MIDASmodule module;                     /* Der Module */
MIDASmodulePlayHandle playHandle;       /* Das Playing Handle */



#ifdef __DJGPP__
/* DJGPP mode set routine: */
void SetMode(unsigned mode)
{
    __dpmi_regs regs;

    regs.x.ss = regs.x.sp = 0;
    regs.d.eax = (mode & 0xFF);
    __dpmi_simulate_real_mode_interrupt(0x10, &regs);
}
#define vgaSetMode SetMode
#endif


/****************************************************************************\
*
* Function:     void MIDASerror(void)
*
* Description:  Displays most recent MIDAS error and exits to DOS
*
\****************************************************************************/

void MIDASerror(void)
{
    vgaSetMode(3);
    printf("MIDAS error: %s\n", MIDASgetErrorMessage(MIDASgetLastError()));
#ifndef NOMUSIC
    MIDASclose(); /*!!!!!*/
#endif
    exit(EXIT_FAILURE);
}



/****************************************************************************\
*
* Function:     void UpdateInfo(void)
*
* Description:  Updates song playing information (defined at the beginning of
*               this file)
*
* Note:         To use the position information from Assembler, do the
*               following (almost - get the idea?)
*
*               INCLUDE "midas.inc"
*               ...
*               GLOBAL  UpdateInfo : LANG
*               ...
*               EXTRN   position : dword
*               EXTRN   pattern : dword
*               EXTRN   row : dword
*               EXTRN   syncInfo : dword
*               ...
*               CODESEG
*               ...
*               PROC    SuperRoutine    NEAR
*               ...
*               call    UpdateInfo C
*               cmp     [position],17
*               je      @@design
*               ...
*
\****************************************************************************/

void MIDAS_CALL UpdateInfo(void)
{
    /* MIDAS_CALL is cdecl for Watcom, empty for DJGPP. Helps calling this
       from assembler, otherwise unnecessary */
    
    static MIDASplayStatus status;

    /* Get playback status: */
    if ( !MIDASgetPlayStatus(playHandle, &status) )
        MIDASerror();

    /* Store interesting information in easy-to-access variables: */
    position = status.position;
    pattern = status.pattern;
    row = status.row;
    syncInfo = status.syncInfo;
}


int main(int argc, char *argv[])
{
    /* Unbuffer stdout: */
    setbuf(stdout, NULL);

    /* Prevent warnings: */
    argc = argc;
    argv = argv;

#ifndef NOMUSIC
    /* Call this first: */
    MIDASstartup();

    /* Try to detect the sound card if we should, otherwise run config
       right away. Also, if something was on the commend line, run config. */
#ifdef ATTEMPT_DETECT
    if ( (argc > 1) || (!MIDASdetectSoundCard()) )
#endif
    {
        if ( !MIDASconfig() )
        {
            /* Configuration failed. Check if it is an error - if yes, report,
               otherwise exit normally: */
            if ( MIDASgetLastError() )
            {
                MIDASerror();
            }
            else
            {
                printf("User exit!\n");
                return 1;
            }
        }
    }
#endif /* #ifndef NOMUSIC */    

    /* Here we could set up a cool display mode */
    vgaSetMode(0x03);
    /* But we don't */

    /* Now initialize MIDAS Digital Audio System: */

    puts("Initializing MIDAS Digital Audio System");

    if ( !MIDASinit() )
        MIDASerror();

    puts("Loading music");

    if ( (module = MIDASloadModule(moduleName)) == NULL )
        MIDASerror();

    /* Now we could do all our initialization, set up a fancy display mode
       etc. */

#ifndef NOMUSIC
    /* Start playing the module: */
    if ( (playHandle = MIDASplayModule(module, TRUE)) == 0 )
        MIDASerror();

#endif

    while ( !kbhit() )
    {
        UpdateInfo();
        printf("Pos %02X, Patt %02X, Row %02X", position,
            pattern, row);
        printf("\r");
    }

    getch();

    /* Uninitialization */

#ifndef NOMUSIC
    /* Stop playing module: */
    if ( !MIDASstopModule(playHandle) )
        MIDASerror();

    MIDASsaveConfig("audio.cfg");

    /* Deallocate the module: */
    if ( !MIDASfreeModule(module) )
        MIDASerror();

    /* And close MIDAS: */
    if ( !MIDASclose() )
        MIDASerror();
#endif

    /* End of DEMO - DOS! */

    return 0;
}

