/*      DEMO.C
 *
 * MIDAS megademo
 *
 * Copyright 1996 Petteri Kangaslampi
*/

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include <conio.h>
#include "itg/itg.h"
extern "C"{
#include "soundsys/midasdll.h"
}

extern "C" int i110_on();
extern "C" int i111_on();
extern "C" int i110CL_on();
extern "C" int i111CL_on();
extern "C" int i4110_on();
extern "C" int i4111_on();
extern "C" char *i110_version();
extern "C" char *i111_version();
extern "C" char *i110CL_version();
extern "C" char *i111CL_version();
extern "C" char *i4110_version();
extern "C" char *i4111_version();

extern "C" void *I32_clut;
extern "C" void *I32_dlut;
extern "C" void *I32_llut;

void insertmode(char *file,int mode);

char *(*ModeName[])(void) = {i110_version,i111_version,
                             i4110_version,i4111_version,
                             i110CL_version,i111CL_version};

struct Modes
    {
    int (*test)(void);
    int (*check)(void);
    int good,mode;
    } v[4][2];

#ifdef __DJGPP__
#include <dpmi.h>
#endif



/* To start the program right away, without a configuration screen,
   uncomment the following line. However, this is generally NOT a good
   idea, as the user might want to use a different sound card than the
   one detected, or might want better sound quality than the default. Also
   some sound cards can NOT be detected at all.

   If you uncomment the following line, at least provide a way for the
   user to get to the setup by giving a command line argument - this
   program does also this. */

/*#define ATTEMPT_DETECT*/


/* Music playing position information - updated by UpdateInfo: */
unsigned        position;               /* Current position */
unsigned        pattern;                /* Current pattern number */
unsigned        row;                    /* Current row number */
int             syncInfo;               /* Music synchronization info */

/* Music file name ;) */
char            *moduleName = "setup.mod";


/* Frame counter variable - note VOLATILE! */
volatile unsigned   frameCount;

MIDASmodule module;                     /* Der Module */
MIDASmodulePlayHandle playHandle;       /* Das Playing Handle */



#ifdef __DJGPP__
/* DJGPP mode set routine: */
void SetMode(unsigned mode)
{
    __dpmi_regs regs;

    regs.x.ss = regs.x.sp = 0;
    regs.d.eax = (mode & 0xFF);
    __dpmi_simulate_real_mode_interrupt(0x10, &regs);
}
#define vgaSetMode SetMode
#endif


/****************************************************************************\
*
* Function:     void MIDASerror(void)
*
* Description:  Displays most recent MIDAS error and exits to DOS
*
\****************************************************************************/

void MIDASerror(void)
{
    vgaSetMode(3);
    printf("MIDAS error: %s\n", MIDASgetErrorMessage(MIDASgetLastError()));
#ifndef NOMUSIC
    MIDASclose(); /*!!!!!*/
#endif
    exit(EXIT_FAILURE);
}



/****************************************************************************\
*
* Function:     void UpdateInfo(void)
*
* Description:  Updates song playing information (defined at the beginning of
*               this file)
*
* Note:         To use the position information from Assembler, do the
*               following (almost - get the idea?)
*
*               INCLUDE "midas.inc"
*               ...
*               GLOBAL  UpdateInfo : LANG
*               ...
*               EXTRN   position : dword
*               EXTRN   pattern : dword
*               EXTRN   row : dword
*               EXTRN   syncInfo : dword
*               ...
*               CODESEG
*               ...
*               PROC    SuperRoutine    NEAR
*               ...
*               call    UpdateInfo C
*               cmp     [position],17
*               je      @@design
*               ...
*
\****************************************************************************/

void MIDAS_CALL UpdateInfo(void)
{
    /* MIDAS_CALL is cdecl for Watcom, empty for DJGPP. Helps calling this
       from assembler, otherwise unnecessary */
    
    static MIDASplayStatus status;

    /* Get playback status: */
    if ( !MIDASgetPlayStatus(playHandle, &status) )
        MIDASerror();

    /* Store interesting information in easy-to-access variables: */
    position = status.position;
    pattern = status.pattern;
    row = status.row;
    syncInfo = status.syncInfo;
}


int main(int argc, char *argv[])
{

    int gc,mode,ctr,ctr2;

    short *vbuf,*tbuf;

    /* Unbuffer stdout: */
    setbuf(stdout, NULL);

    /* Prevent warnings: */
    argc = argc;
    argv = argv;

#ifndef NOMUSIC
    /* Call this first: */
    MIDASstartup();

    /* Try to detect the sound card if we should, otherwise run config
       right away. Also, if something was on the commend line, run config. */
#ifdef ATTEMPT_DETECT
    if ( (argc > 1) || (!MIDASdetectSoundCard()) )
#endif
    {
        if ( !MIDASconfig() )
        {
            /* Configuration failed. Check if it is an error - if yes, report,
               otherwise exit normally: */
            if ( MIDASgetLastError() )
            {
                MIDASerror();
            }
            else
            {
                printf("User exit!\n");
                return 1;
            }
        }
    }
#endif /* #ifndef NOMUSIC */    

    /* Here we could set up a cool display mode */
    vgaSetMode(0x03);
    /* But we don't */

    /* Now initialize MIDAS Digital Audio System: */

    puts("Initializing MIDAS Digital Audio System");

    if ( !MIDASinit() )
        MIDASerror();

    puts("Loading music");

    if ( (module = MIDASloadModule(moduleName)) == NULL )
        MIDASerror();

    /* Now we could do all our initialization, set up a fancy display mode
       etc. */

#ifndef NOMUSIC
    /* Start playing the module: */
    if ( (playHandle = MIDASplayModule(module, TRUE)) == 0 )
        MIDASerror();

#endif

    while ( !kbhit() )
    {
        UpdateInfo();
        printf("Pos %02X, Patt %02X, Row %02X", position,
            pattern, row);
        printf("\r");
    }

    getch();

    /* Uninitialization */

#ifndef NOMUSIC
    /* Stop playing module: */
    if ( !MIDASstopModule(playHandle) )
        MIDASerror();

    MIDASsaveConfig("audio.cfg");

    /* Deallocate the module: */
    if ( !MIDASfreeModule(module) )
        MIDASerror();

    /* And close MIDAS: */
    if ( !MIDASclose() )
        MIDASerror();
#endif

    printf("\n\nDo you want to autodetect the video card?\n");
    printf("You will see strange things, or a 17\" monitor may go blank for a while.\n");
    printf("However it should find the best mode to run the game in.\n\n");
    printf("(press 'y' or 'n')\n\n");

    do {
       gc = getch();
       if(gc == 'Y')
	    gc = 'y';
       if(gc == 'N' || gc == 0x1a)
	    gc = 'n';
       } while(gc != 'y' && gc != 'n');

    if(gc == 'n')
        return 0;

    printf("\n\nWould you prefer a 15bpp or 16bpp video mode?\n");
    printf("16bpp mode needs an extra 2MB of memory.\n\n");
    printf("(press '1' for 15bpp, or '2' for 16bpp)\n\n");

    do {
       gc = getch();
       } while(gc != '1' && gc != '2');

    if(gc == '1')
        gc = 15;
    else
 	gc = 16;

    v[0][0].test = i110_on;
    v[0][0].check = Init_110;
    v[0][0].mode = 0;

    v[0][1].test = i111_on;
    v[0][1].check = Init_111;
    v[0][1].mode = 1;

    v[1][0].test = i110CL_on;
    v[1][0].check = Init_110CL;
    v[1][0].mode = 4;

    v[1][1].test = i111CL_on;
    v[1][1].check = Init_111CL;
    v[1][1].mode = 5;

    v[2][0].test = i4110_on;
    v[2][0].check = Init_4110;
    v[2][0].mode = 2;

    v[2][1].test = i4111_on;
    v[2][1].check = Init_4111;
    v[2][1].mode = 3;

    v[3][0].test = NULL;

    // Do initial test

    for(ctr=0;v[ctr][0].test;ctr++)
       {
       v[ctr][0].good = v[ctr][0].test();
       v[ctr][1].good = v[ctr][1].test();
       }

    off();
    vbuf = (short *)calloc(1,BUFFERSIZE);
    tbuf = (short *)calloc(1,BUFFERSIZE);
    if(!vbuf || !tbuf)
        {
	printf("Out of memory\n");
	exit(1);
	}

    for(ctr=0;ctr<HALFBUFFERSIZE;ctr++)
        vbuf[ctr] = random()&0xffff;

// Now check for compatability

    for(ctr=0;v[ctr][0].test;ctr++)
      for(ctr2=0;ctr2<2;ctr2++)
        {
        if(v[ctr][ctr2].good)
            {
            if(v[ctr][ctr2].check())
                {
                on();
                update((char *)vbuf);
	        retrieve((char *)tbuf);
                free(I32_clut);
                free(I32_dlut);
                free(I32_llut);
	        if(memcmp(vbuf,tbuf,BUFFERSIZE))
                    v[ctr][ctr2].good = 0;
                }
            }
        else
            v[ctr][ctr2].good = 0;
        off();
        }

// Now decide which is best, Banked or Linear

mode = -1;

for(ctr=0;v[ctr][0].test;ctr++)
    if(v[ctr][0].good || v[ctr][1].good)
        mode = ctr;

if(mode == -1)
    {
    printf("Nothing worked!\n");
    printf("Please email DOUG-15@bigfoot.com and say what kind of video card you have.\n");
    exit(1);
    }

// Pick the best mode, taking into account availability and user preference.

ctr=0;
if(gc == 15 && v[mode][0].good)
    ctr = v[mode][0].mode;
if(gc == 15 && !v[mode][0].good)
    ctr = v[mode][1].mode;
if(gc == 16 && v[mode][1].good)
    ctr = v[mode][1].mode;
if(gc == 16 && !v[mode][1].good)
    ctr = v[mode][0].mode;

mode = ctr;

printf("Done!  Updating config files..\n");

insertmode("game.ini",mode);
insertmode("editor.ini",mode);

printf("Finished.\n  IRE will use %s\n", ModeName[mode]());

    /* End of DEMO - DOS! */
    return 0;
}

void insertmode(char *file,int mode)
{
FILE *fpi,*fpo;
char buffer[1024];

remove("$SCRATCH.UH!");
fpi=fopen(file,"r");
fpo=fopen("$SCRATCH.UH!","w");

if(!fpi)
    {
    printf("Could not open '%s'\n",file);
    return;
    }
if(!fpo)
    {
    printf("Could not create '$SCRATCH.UH!'\n");
    return;
    }

while(fgets(buffer,1024,fpi))
   {
   if(strstr(buffer,"-videomode "))
       fprintf(fpo,"-videomode %d\n",mode);
   else
       fputs(buffer,fpo);
   };
fclose(fpi);
fclose(fpo);

remove(file);
rename("$SCRATCH.UH!",file);
}

