struct SMTab
{
    char *name;
    char *fname;
    int freq;
    long handle;
    char nodrift;
};

extern SMTab *wavtab;
extern SMTab *modtab;

// functions

extern void S_Init();              // Set up sound device
extern void S_Load();              // Load the sound and music
extern void S_Start();             // Start the mixing kernel
extern void S_Term();              // Stop the mixing kernel and shut down
extern void S_SoundVolume(int v);  // Set the Sound volume
extern void S_MusicVolume(int v);  // Set the Music volume
extern void S_PlaySample(char *s); // Play a sound sample
extern void S_PlayModule(char *s); // Play a music module
extern void S_PlayModule(char *s); // Play a music module
extern void S_PauseModule();       // Pause a music module
extern void S_UnPauseModule();       // Pause a music module
extern void S_StopModule();        // Stop the music
extern char S_Sync();              // Make sure the timer is working

extern void T_Init();              // Animation timer
extern void T_Term();
extern "C" int T_IsDue();              // Is it time yet?

