//
//      System-dependent functions (BeOS)
//

#ifndef __BEOS__
#error "sys_beos contains portions specific to BeOS R4 or greater"
#endif

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <InterfaceKit.h>
#include <OS.h>

#include "keys.hpp"
#include "sys.hpp"
#include "loaders.hpp"
#include "console.hpp"

extern "C" int T_IsDue();  // Return true every 1/35 second
extern void set_caption(char *m);  // Set window caption
extern int itg_lastkey;		// Key returned from ITG BeOS driver

static char keyboard_is_installed=0;
static unsigned char lastkey;
static unsigned char test_key();
static unsigned char take_key();

int xkey[255];  // key translation table

/*
 *      SYS_BANNER - Draw banner (do bugger-all)
 */

void SYS_BANNER(char *msg)
{
set_caption(msg);
}


/*
 *      SYS_CREDITS - Translate end screen to Sinclair ZX81 font for BeOS
 */

void SYS_CREDITS(char *screen)
{
unsigned char a;
printf("\n");

for(int ctr=0;ctr<1920;ctr++)
    {
    a=screen[ctr<<1];
    if(a>31 && a<127)
        printf("%c",a);
    else
        switch(a)
           {
	   case 179: // | lines
	   case 186:
	   printf("|");
	   break;

	   case 196: // - lines
	   case 205:
	   case 193: // T junctions
	   case 194:
	   case 202:
	   case 203:
	   case 207:
	   case 208:
	   case 209:
	   case 210:
	   printf("-");
	   break;

	   case 197:	// crossovers
	   case 206:
	   case 215:
	   case 216:
	   printf("+");
	   break;

	   case 180:	// -|
	   case 181:
	   case 182:
	   case 185:
	   printf("{");
	   break;

	   case 195:	// |-
	   case 198:
	   case 199:
	   case 204:
	   printf("}");
	   break;

	   case 170:	// TR corner
	   case 183:
	   case 184:
	   case 187:
	   case 191:
	   case 192:	// Also BL corner
	   case 200:
	   case 211:
	   case 212:
	   printf("\\");
	   break;

	   case 169:	// TL corner
	   case 201:
	   case 213:
	   case 214:
           case 218:
	   case 188:	// Also BR corner
	   case 189:
	   case 190:
	   case 217:
	   printf("/");
	   break;

	   default:
	   printf("#");
	   }
    }
printf("\n");
}


/*
 *      SYS_DELAY - delay for n milliseconds, 1/35 second granularity
 */

void SYS_DELAY(int ms)
{
int ctr=(ms*35)/1000;

if(ctr<=0)
    ctr=1;
for(;ctr>0;ctr--)
    {
    while(!T_IsDue());
    while(T_IsDue());
    }
}


/*
 *      SYS_CPRINT - Print in textmode with scrolling in a window
 *                   Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_CPRINT(char *a)
{
printf("%s",a);
}


/*
 *      SYS_TEXTCOLOR - Set textmode colour
 *                      Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_TEXTCOLOR(int c)
{
//textcolor(c);
}

/*
 *      SYS_GET_KEY - Non-blocking keyboard function, returns in HW format
 */

int SYS_GET_KEY()
{
int a;
if(!keyboard_is_installed)
    return 0;//getchar();
a=test_key();
if(a)
    lastkey=0;
return a;
}

/*
 *      SYS_KEY_WAIT - Blocking keyboard function, returns in HW format
 */

char SYS_KEY_WAIT()
{
if(!keyboard_is_installed)
    return getchar();
return take_key();
}

/*
 *	SYS_KEY_FLUSH - Flush the keyboard 'buffer'
 */

void SYS_KEY_FLUSH()
{
while(test_key());
lastkey=0;
}




/*
 *      K_Init - keyboard handler startup
 */

void K_Init()
{
int ctr;
if(keyboard_is_installed)
    return;
bootmsg("K_Init()\n");
lastkey=0;
keyboard_is_installed=1;

memset(xkey,0,255*sizeof(int));

xkey[1] = KEY_ESC;
xkey[B_F1_KEY] = KEY_F1;
xkey[B_F2_KEY] = KEY_F2;
xkey[B_F3_KEY] = KEY_F3;
xkey[B_F4_KEY] = KEY_F4;
xkey[B_F5_KEY] = KEY_F5;
xkey[B_F6_KEY] = KEY_F6;
xkey[B_F7_KEY] = KEY_F7;
xkey[B_F8_KEY] = KEY_F8;
xkey[B_F9_KEY] = KEY_F9;
xkey[B_F10_KEY] = KEY_F10;
xkey[B_F11_KEY] = KEY_F11;
xkey[B_F12_KEY] = KEY_F12;
// xkey[B_PRINT_KEY] = ;
// xkey[B_SCROLL_KEY] = ;
// xkey[B_PAUSE_KEY] = ;
// xkey[0x11] = KEY_`
xkey[0x12] = KEY_1;
xkey[0x13] = KEY_2;
xkey[0x14] = KEY_3;
xkey[0x15] = KEY_4;
xkey[0x16] = KEY_5;
xkey[0x17] = KEY_6;
xkey[0x18] = KEY_7;
xkey[0x19] = KEY_8;
xkey[0x1a] = KEY_9;
xkey[0x1b] = KEY_0;
//xkey[0x1c] = KEY_MINUS;
//xkey[0x1d] = KEY_EQUALS;
//xkey[0x1e] = KEY_BACKSPACE;
//xkey[0x1f] = KEY_INSERT;
xkey[0x20] = KEY_HOME;
xkey[0x21] = KEY_PGUP;
//xkey[0x22] = Numlock;
//xkey[0x23] = Divide;
//xkey[0x24] = Multiply;
//xkey[0x25] = Minus;
xkey[0x26] = KEY_TAB;
xkey[0x27] = KEY_Q;
xkey[0x28] = KEY_W;
xkey[0x29] = KEY_E;
xkey[0x2a] = KEY_R;
xkey[0x2b] = KEY_T;
xkey[0x2c] = KEY_Y;
xkey[0x2d] = KEY_U;
xkey[0x2e] = KEY_I;
xkey[0x2f] = KEY_O;
xkey[0x30] = KEY_P;
//xkey[0x31] = [
//xkey[0x32] = ]
//xkey[0x33] = \
//xkey[0x34] = KEY_DELETE;
xkey[0x35] = KEY_END;
xkey[0x36] = KEY_PGDN;
xkey[0x37] = KEY_HOME;
xkey[0x38] = KEY_UP;
xkey[0x39] = KEY_PGUP;
//xkey[0x3a] = KEY_PLUS;
//xkey[0x3b] = Capslock;
xkey[0x3c] = KEY_A;
xkey[0x3d] = KEY_S;
xkey[0x3e] = KEY_D;
xkey[0x3f] = KEY_F;
xkey[0x40] = KEY_G;
xkey[0x41] = KEY_H;
xkey[0x42] = KEY_J;
xkey[0x43] = KEY_K;
xkey[0x44] = KEY_L;
//xkey[0x45] = KEY_COLON;
//xkey[0x46] = KEY_QUOTE;
xkey[0x47] = KEY_ENTER;
xkey[0x48] = KEY_LEFT;
xkey[0x49] = KEY_5;
xkey[0x4a] = KEY_RIGHT;
//xkey[0x4b] = KEY_LSHIFT;
xkey[0x4c] = KEY_Z;
xkey[0x4d] = KEY_X;
xkey[0x4e] = KEY_C;
xkey[0x4f] = KEY_V;
xkey[0x50] = KEY_B;
xkey[0x51] = KEY_N;
xkey[0x52] = KEY_M;
xkey[0x53] = KEY_COMMA;
xkey[0x54] = KEY_DOT;
//xkey[0x55] = KEY_/
//xkey[0x56] = KEY_Rshift;
xkey[0x57] = KEY_UP;
xkey[0x58] = KEY_END;
xkey[0x59] = KEY_DOWN;
xkey[0x5a] = KEY_PGDN;
xkey[0x5b] = KEY_ENTER;
//xkey[0x5c] = KEY_CTRL;
//xkey[0x5d] = KEY_ALT;
xkey[0x5e] = KEY_SPACE;
//xkey[0x5f] = KEY_ALT;
//xkey[0x60] = KEY_CTRL;
xkey[0x61] = KEY_LEFT;
xkey[0x62] = KEY_DOWN;
xkey[0x63] = KEY_RIGHT;
//xkey[0x64] = KEY_INSERT;
xkey[0x65] = KEY_DOT;
}

/*
 *      K_Term - keyboard handler shutdown
 */

void K_Term()
{
if(!keyboard_is_installed)
    return;
keyboard_is_installed=0;
boot2("K_Term()\n");
lastkey=0;
}

/*
 *      take_key - wait for a key to be pressed
 *                 calls test_key
 */

unsigned char take_key()
{
unsigned char a=0;
while(!a) a=test_key();
return a;
}

/*
 *      test_key - return a key in PC hardware format if pending or else 0
 *                 Algorithm derived from SDL by Sam Lantinga
 */

unsigned char test_key()
{
struct key_info k8;
int ctr,pos;
unsigned char key;

if(get_key_info(&k8) == B_ERROR)
    return 0;

for(ctr=0;ctr<16;ctr++)
    if(k8.key_states[ctr])
        {
        key = k8.key_states[ctr];
	pos = ctr*8;
	for(ctr=0;ctr<8;ctr++)
	    {
            if(key&0x80)
                {
		lastkey = xkey[pos+ctr];
	        return lastkey;//xkey[pos+ctr];
		}
            key<<=1;
            }
        }
return 0;
}


/*
 *	SYS_CORELEFT - return free memory in bytes
 */

long SYS_CORELEFT()
{
system_info si;
get_system_info(&si);
return (si.max_pages - si.used_pages)*4096;
}

