//
//      System-dependent functions (DOS)
//

#ifndef __DJGPP__
#error "sys_dos contains portions specific to DJGPP"
#endif

#include <dos.h>
#include <bios.h>
#include <go32.h>
#include <mem.h>
#include <dpmi.h>
#include <sys/movedata.h>
#include <sys/farptr.h>
#include <conio.h>
#include <string.h>

#include "sys.hpp"
#include "loaders.hpp"
#include "console.hpp"

#define FIFO_SIZE 4

extern "C" int _install_irq(int num, int (*handler)());
extern "C" void _remove_irq(int num);

extern "C" int T_IsDue();  // Return true every 1/35 second

static char keyboard_is_installed=0;
static volatile int KB_Handler(void);
static volatile unsigned char key_fifo[FIFO_SIZE+1];
static volatile unsigned char key_ptr=0;
static volatile unsigned char key_empty=1;

static char BiosKeyWait();
static int GetBiosKey();
static char take_key();

/*
 *      SYS_BANNER - Draw banner (using ANSI colours)
 */

void SYS_BANNER(char *msg)
{
int len;
char buf[100];  // Just in case of overflow

// Make a line of spaces

memset(buf,' ',80);
buf[80]=0;

// Centre the message and put it into the line of spaces

len = strlen(msg)/2;
strcpy(&buf[40-len],msg);

// Blow away the ASCIIZ terminator to bring it to full length

buf[strlen(buf)] = ' ';

// Hit colour textmode and print the centred text onscreen

off();
textcolor(15);
textbackground(RED);
cprintf("%s\r\n",buf);
textcolor(LIGHTGRAY);
textbackground(BLACK);
window(1,2,80,25);
}


/*
 *      SYS_CREDITS - Draw credits screen (using ANSI colours)
 */

void SYS_CREDITS(char *screen)
{
off();
_movedatal(_go32_my_ds(), (int) screen,_dos_ds, 0xb8000 , 1000);
gotoxy(1,23);
}


/*
 *      SYS_DELAY - delay for n milliseconds, 1/35 second granularity
 */

void SYS_DELAY(int ms)
{
int ctr=(ms*35)/1000;
if(ctr<=0)
    ctr=1;
for(;ctr>0;ctr--)
    {
    while(!T_IsDue());
    while(T_IsDue());
    }
}


/*
 *      SYS_CPRINT - Print in textmode with scrolling in a window
 */

void SYS_CPRINT(char *a)
{
cprintf("%s",a);
}


/*
 *      SYS_TEXTCOLOR - Set textmode colour
 */

void SYS_TEXTCOLOR(int c)
{
textcolor(c);
}

/*
 *      SYS_GET_KEY - Non-blocking keyboard function, returns ascii value
 */

int GetBiosKey()
{
if(bioskey(1))
    return( bioskey(0)>>8 );
return NULL;
}

/*
 *      SYS_KEY_WAIT - Wait for a key, return ASCII value
 */

char BiosKeyWait()
{
int key;
while(!bioskey(1));
key=bioskey(0)>>8;
while(bioskey(1));
return key;
}

int SYS_GET_KEY()
{
if(!keyboard_is_installed)
    return GetBiosKey();
if(!key_empty)
    return take_key();
return 0;
}

/*
char SYS_KEY_POLL()
{
if(!keyboard_is_installed)
    return bioskey(1);
return key_empty;
}
*/

char SYS_KEY_WAIT()
{
if(!keyboard_is_installed)
    return BiosKeyWait();
while(key_empty);
return take_key();
}

void SYS_KEY_FLUSH()
{
_farpokew(_dos_ds, 0x41a, _farpeekw(_dos_ds,0x41c));
key_empty=1;
key_ptr=0;
}

/*
 *      K_Init_dos - DOS-specific keyboard handler startup
 */

void K_Init()
{
if(keyboard_is_installed)
    return;
bootmsg("K_Init()\n");
_install_irq(9,KB_Handler);
keyboard_is_installed = 1;
}

/*
 *      K_Term_dos - DOS-specific keyboard handler shutdown
 */

void K_Term()
{
if(!keyboard_is_installed)
    return;
boot2("K_Term()\n");
_remove_irq(9);
_farpokew(_dos_ds, 0x41a, _farpeekw(_dos_ds,0x41c));    // Flush buffer
keyboard_is_installed = 0;
}

/*
 *      KB_handler - DOS-specific keyboard handler code
 */

static volatile int KB_Handler(void)
{
unsigned char a;
a = inportb(0x60);
if(!(a & 0x80))
     {
     key_ptr++;
     if(key_ptr == FIFO_SIZE)
         key_ptr = 0;
     key_fifo[key_ptr]=a;
     key_empty=0;
     }
_farpokew(_dos_ds, 0x41a, _farpeekw(_dos_ds,0x41c));
return 1;
}

char take_key()
{
unsigned char a;
a = key_fifo[key_ptr];
if(key_ptr > 0)
    key_ptr--;
else
    {
    key_empty=1;
    a=0;
    }
return a;
}

long SYS_CORELEFT()
{
struct _go32_dpmi_meminfo block;
_go32_dpmi_get_free_memory_information(&block);

if(block.available_physical_pages > 0)
    return block.available_physical_pages*4096;
return block.available_memory;
}


