//
//      System-dependent functions (LINUX-GGI)
//

#ifndef __linux__
#error "sys_ggi contains portions specific to LINUX"
#endif

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <ggi/ggi.h>
#include <ggi/gii.h>

#include "keys.hpp"
#include "sys.hpp"
#include "loaders.hpp"
#include "console.hpp"

extern "C" int T_IsDue();  // Return true every 1/35 second
extern void set_caption(char *m);  // Set window caption

extern ggi_visual_t itg_ggi_surface;

static char keyboard_is_installed=0;
static unsigned char lastkey;
static unsigned char test_key();
static unsigned char take_key();
//static gii_input_t keyb;
static ggi_event event;

int xkey[255];  // key translation table

/*
 *      SYS_BANNER - Draw banner (set X11 window caption)
 */

void SYS_BANNER(char *msg)
{
set_caption(msg);
}


/*
 *      SYS_CREDITS - Translate end screen to Sinclair ZX81 font for linux
 */

void SYS_CREDITS(char *screen)
{
unsigned char a;
printf("\n");

for(int ctr=0;ctr<1920;ctr++)
    {
    a=screen[ctr<<1];
    printf("%c",(a>31 && a<127)?a:'#');
    }
printf("\n");
}


/*
 *      SYS_DELAY - delay for n milliseconds, 1/35 second granularity
 */

void SYS_DELAY(int ms)
{
int ctr=(ms*35)/1000;
if(ctr<=0)
    ctr=1;
for(;ctr>0;ctr--)
    {
    while(!T_IsDue());
    while(T_IsDue());
    }

//usleep(ms*1000);
}


/*
 *      SYS_CPRINT - Print in textmode with scrolling in a window
 *                   Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_CPRINT(char *a)
{
printf("%s",a);
}


/*
 *      SYS_TEXTCOLOR - Set textmode colour
 *                      Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_TEXTCOLOR(int c)
{
//textcolor(c);
}

/*
 *      SYS_GET_KEY - Non-blocking keyboard function, returns in HW format
 */

int SYS_GET_KEY()
{
int a;
if(!keyboard_is_installed)
    return 0;//getchar();
a=test_key();
if(a)
    lastkey=0;
return a;
}

/*
 *      SYS_KEY_WAIT - Blocking keyboard function, returns in HW format
 */

char SYS_KEY_WAIT()
{
if(!keyboard_is_installed)
    return getchar();
return take_key();
}

void SYS_KEY_FLUSH()
{
lastkey=0;
}

/*
 *      K_Init - keyboard handler startup
 */

void K_Init()
{
if(keyboard_is_installed)
    return;
bootmsg("K_Init()\n");
/*
if(giiInit())
    panic("K_Init","Cannot start gii-init!","Oh no!");

keyb = giiOpen("input-stdin",NULL);
if(!keyb)
    panic("K_Init","Cannot open stdin!","Oh no!");
*/

lastkey=0;
keyboard_is_installed=1;

memset(xkey,0,255*sizeof(int));

xkey[GIIUC_Tab]=KEY_TAB;
xkey[GIIUC_Return]=KEY_ENTER;
xkey[GIIUC_Escape]=KEY_ESC;
xkey[GIIUC_Space]=KEY_SPACE;
xkey[GIIUC_Comma]=KEY_COMMA;
xkey[GIIUC_Period]=KEY_DOT;

xkey[GIIUC_0]=KEY_0;
xkey[GIIUC_1]=KEY_1;
xkey[GIIUC_2]=KEY_2;
xkey[GIIUC_3]=KEY_3;
xkey[GIIUC_4]=KEY_4;
xkey[GIIUC_5]=KEY_5;
xkey[GIIUC_6]=KEY_6;
xkey[GIIUC_7]=KEY_7;
xkey[GIIUC_8]=KEY_8;
xkey[GIIUC_9]=KEY_9;

xkey[GIIUC_a]=KEY_A;
xkey[GIIUC_b]=KEY_B;
xkey[GIIUC_c]=KEY_C;
xkey[GIIUC_d]=KEY_D;
xkey[GIIUC_e]=KEY_E;
xkey[GIIUC_f]=KEY_F;
xkey[GIIUC_g]=KEY_G;
xkey[GIIUC_h]=KEY_H;
xkey[GIIUC_i]=KEY_I;
xkey[GIIUC_j]=KEY_J;
xkey[GIIUC_k]=KEY_K;
xkey[GIIUC_l]=KEY_L;
xkey[GIIUC_m]=KEY_M;
xkey[GIIUC_n]=KEY_N;
xkey[GIIUC_o]=KEY_O;
xkey[GIIUC_p]=KEY_P;
xkey[GIIUC_q]=KEY_Q;
xkey[GIIUC_r]=KEY_R;
xkey[GIIUC_s]=KEY_S;
xkey[GIIUC_t]=KEY_T;
xkey[GIIUC_u]=KEY_U;
xkey[GIIUC_v]=KEY_V;
xkey[GIIUC_w]=KEY_W;
xkey[GIIUC_x]=KEY_X;
xkey[GIIUC_y]=KEY_Y;
xkey[GIIUC_z]=KEY_Z;

xkey[GIIK_F1]=KEY_F1;
xkey[GIIK_F2]=KEY_F2;
xkey[GIIK_F3]=KEY_F3;
xkey[GIIK_F4]=KEY_F4;
xkey[GIIK_F5]=KEY_F5;
xkey[GIIK_F6]=KEY_F6;
xkey[GIIK_F7]=KEY_F7;
xkey[GIIK_F8]=KEY_F8;
xkey[GIIK_F9]=KEY_F9;
xkey[GIIK_F10]=KEY_F10;
xkey[GIIK_F11]=KEY_F11;
xkey[GIIK_F12]=KEY_F12;

xkey[GIIK_Up]=KEY_UP;
xkey[GIIK_Down]=KEY_DOWN;
xkey[GIIK_Left]=KEY_LEFT;
xkey[GIIK_Right]=KEY_RIGHT;

xkey[GIIK_Home]=KEY_HOME;
xkey[GIIK_End]=KEY_END;
xkey[GIIK_PageUp]=KEY_PGUP;
xkey[GIIK_PageDown]=KEY_PGDN;

xkey[GIIK_P1]=KEY_END;
xkey[GIIK_P2]=KEY_DOWN;
xkey[GIIK_P3]=KEY_PGDN;
xkey[GIIK_P4]=KEY_LEFT;
xkey[GIIK_P6]=KEY_RIGHT;
xkey[GIIK_P7]=KEY_HOME;
xkey[GIIK_P8]=KEY_UP;
xkey[GIIK_P9]=KEY_PGUP;

}

/*
 *      K_Term - keyboard handler shutdown
 */

void K_Term()
{
if(!keyboard_is_installed)
    return;
boot2("K_Term()\n");

/*
giiClose(keyb);
giiExit();
*/

lastkey=0;
keyboard_is_installed=0;
}

/*
 *      take_key - wait for a key to be pressed
 *                 calls test_key
 */

unsigned char take_key()
{
unsigned char a=0;
while(!a) a=test_key();
return a;
}

/*
 *      test_key - return a key in PC hardware format if pending or else 0
 */

unsigned char test_key()
{
struct timeval t;
ggi_event_mask m;
ggi_event e;
unsigned char a=0;

if(lastkey)
    {
    a=lastkey;
    lastkey=0;
    return a;
    }

t.tv_sec=0;
t.tv_usec=100000;

m = ggiEventPoll(itg_ggi_surface,emKeyPress,&t);
if( m )
    {
    ggiEventRead(itg_ggi_surface,&e,emKeyPress);
    lastkey = xkey[e.key.sym & 0x7f];
    return lastkey;
    }

return 0;
}

