//
//      System-dependent functions (LINUX-SDL)
//

#ifndef __linux__
#error "sys_lin contains portions specific to LINUX"
#endif

#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "/usr/local/include/SDL/SDL.h"

#include "keys.hpp"
#include "sys.hpp"
#include "loaders.hpp"
#include "console.hpp"

extern "C" int T_IsDue();  // Return true every 1/35 second
extern void set_caption(char *m);  // Set window caption

static char keyboard_is_installed=0;
static unsigned char lastkey;
static unsigned char test_key();
static unsigned char take_key();

int xkey[SDLK_LAST];  // key translation table

/*
 *      SYS_BANNER - Draw banner (set X11 window caption)
 */

void SYS_BANNER(char *msg)
{
set_caption(msg);
}


/*
 *      SYS_CREDITS - Translate end screen to Sinclair ZX81 font for linux
 */

void SYS_CREDITS(char *screen)
{
unsigned char a;
printf("\n");

for(int ctr=0;ctr<1920;ctr++)
    {
    a=screen[ctr<<1];
    if(a>31 && a<127)
        printf("%c",a);
    else
        switch(a)
           {
	   case 179: // | lines
	   case 186:
	   printf("|");
	   break;

	   case 196: // - lines
	   case 205:
	   case 193: // T junctions
	   case 194:
	   case 202:
	   case 203:
	   case 207:
	   case 208:
	   case 209:
	   case 210:
	   printf("-");
	   break;

	   case 197:	// crossovers
	   case 206:
	   case 215:
	   case 216:
	   printf("+");
	   break;

	   case 180:	// -|
	   case 181:
	   case 182:
	   case 185:
	   printf("{");
	   break;

	   case 195:	// |-
	   case 198:
	   case 199:
	   case 204:
	   printf("}");
	   break;

	   case 170:	// TR corner
	   case 183:
	   case 184:
	   case 187:
	   case 191:
	   case 192:	// Also BL corner
	   case 200:
	   case 211:
	   case 212:
	   printf("\\");
	   break;

	   case 169:	// TL corner
	   case 201:
	   case 213:
	   case 214:
           case 218:
	   case 188:	// Also BR corner
	   case 189:
	   case 190:
	   case 217:
	   printf("/");
	   break;

	   default:
	   printf("#");
	   }
    }
printf("\n");
}


/*
 *      SYS_DELAY - delay for n milliseconds, 1/35 second granularity
 */

void SYS_DELAY(int ms)
{
int ctr=(ms*35)/1000;
if(ctr<=0)
    ctr=1;
for(;ctr>0;ctr--)
    {
    while(!T_IsDue());
    while(T_IsDue());
    }
}


/*
 *      SYS_CPRINT - Print in textmode with scrolling in a window
 *                   Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_CPRINT(char *a)
{
printf("%s",a);
}


/*
 *      SYS_TEXTCOLOR - Set textmode colour
 *                      Be lame and screw all the pretty stuff like linuxdoom
 */

void SYS_TEXTCOLOR(int c)
{
//textcolor(c);
}

/*
 *      SYS_GET_KEY - Non-blocking keyboard function, returns in HW format
 */

int SYS_GET_KEY()
{
int a;
if(!keyboard_is_installed)
    return 0;//getchar();
a=test_key();
if(a)
    lastkey=0;
return a;
}

/*
 *      SYS_KEY_WAIT - Blocking keyboard function, returns in HW format
 */

char SYS_KEY_WAIT()
{
if(!keyboard_is_installed)
    return getchar();
return take_key();
}

void SYS_KEY_FLUSH()
{
lastkey=0;
}

/*
 *      K_Init - keyboard handler startup
 */

void K_Init()
{
if(keyboard_is_installed)
    return;
bootmsg("K_Init()\n");
lastkey=0;
keyboard_is_installed=1;

memset(xkey,0,SDLK_LAST*sizeof(int));

/*
        SDLK_BACKSPACE =;
	SDLK_CLEAR = 12,
	SDLK_QUOTE = 39,
        SDLK_MINUS= ;
	SDLK_SLASH = 47,
	SDLK_SEMICOLON = 59,
	SDLK_EQUALS = 61,
	SDLK_LEFTBRACKET = 91,
	SDLK_BACKSLASH = 92,
	SDLK_RIGHTBRACKET = 93,
	SDLK_BACKQUOTE = 96,

	SDLK_KP0 = 70,
	SDLK_KP1 = 71,
	SDLK_KP2 = 72,
	SDLK_KP3 = 73,
	SDLK_KP4 = 74,
	SDLK_KP5 = 75,
	SDLK_KP6 = 76,
	SDLK_KP7 = 77,
	SDLK_KP8 = 78,
	SDLK_KP9 = 79,
	SDLK_KP_PERIOD = 80,
	SDLK_KP_DIVIDE = 81,
	SDLK_KP_MULTIPLY = 82,
	SDLK_KP_MINUS = 83,
	SDLK_KP_PLUS = 84,
	SDLK_KP_ENTER = 85,
	SDLK_KP_EQUALS = 86,
	SDLK_DELETE = 127,
	SDLK_PAUSE = 143,
	SDLK_NUMLOCK = 144,
	SDLK_INSERT = 149,
*/

xkey[SDLK_DELETE] = KEY_DELETE;
xkey[SDLK_BACKSPACE] = KEY_BACKSPACE;

xkey[SDLK_TAB]=KEY_TAB;
xkey[SDLK_RETURN]=KEY_ENTER;
xkey[SDLK_ESCAPE]=KEY_ESC;
xkey[SDLK_SPACE]=KEY_SPACE;
xkey[SDLK_COMMA]=KEY_COMMA;
xkey[SDLK_PERIOD]=KEY_DOT;

xkey[SDLK_0]=KEY_0;
xkey[SDLK_1]=KEY_1;
xkey[SDLK_2]=KEY_2;
xkey[SDLK_3]=KEY_3;
xkey[SDLK_4]=KEY_4;
xkey[SDLK_5]=KEY_5;
xkey[SDLK_6]=KEY_6;
xkey[SDLK_7]=KEY_7;
xkey[SDLK_8]=KEY_8;
xkey[SDLK_9]=KEY_9;

xkey[SDLK_a]=KEY_A;
xkey[SDLK_b]=KEY_B;
xkey[SDLK_c]=KEY_C;
xkey[SDLK_d]=KEY_D;
xkey[SDLK_e]=KEY_E;
xkey[SDLK_f]=KEY_F;
xkey[SDLK_g]=KEY_G;
xkey[SDLK_h]=KEY_H;
xkey[SDLK_i]=KEY_I;
xkey[SDLK_j]=KEY_J;
xkey[SDLK_k]=KEY_K;
xkey[SDLK_l]=KEY_L;
xkey[SDLK_m]=KEY_M;
xkey[SDLK_n]=KEY_N;
xkey[SDLK_o]=KEY_O;
xkey[SDLK_p]=KEY_P;
xkey[SDLK_q]=KEY_Q;
xkey[SDLK_r]=KEY_R;
xkey[SDLK_s]=KEY_S;
xkey[SDLK_t]=KEY_T;
xkey[SDLK_u]=KEY_U;
xkey[SDLK_v]=KEY_V;
xkey[SDLK_w]=KEY_W;
xkey[SDLK_x]=KEY_X;
xkey[SDLK_y]=KEY_Y;
xkey[SDLK_z]=KEY_Z;

xkey[SDLK_F1]=KEY_F1;
xkey[SDLK_F2]=KEY_F2;
xkey[SDLK_F3]=KEY_F3;
xkey[SDLK_F4]=KEY_F4;
xkey[SDLK_F5]=KEY_F5;
xkey[SDLK_F6]=KEY_F6;
xkey[SDLK_F7]=KEY_F7;
xkey[SDLK_F8]=KEY_F8;
xkey[SDLK_F9]=KEY_F9;
xkey[SDLK_F10]=KEY_F10;
xkey[SDLK_F11]=KEY_F11;
xkey[SDLK_F12]=KEY_F12;

xkey[SDLK_UP]=KEY_UP;
xkey[SDLK_DOWN]=KEY_DOWN;
xkey[SDLK_LEFT]=KEY_LEFT;
xkey[SDLK_RIGHT]=KEY_RIGHT;

xkey[SDLK_HOME]=KEY_HOME;
xkey[SDLK_END]=KEY_END;
xkey[SDLK_PAGEUP]=KEY_PGUP;
xkey[SDLK_PAGEDOWN]=KEY_PGDN;

xkey[SDLK_KP1]=KEY_END;
xkey[SDLK_KP2]=KEY_DOWN;
xkey[SDLK_KP3]=KEY_PGDN;
xkey[SDLK_KP4]=KEY_LEFT;
xkey[SDLK_KP6]=KEY_RIGHT;
xkey[SDLK_KP7]=KEY_HOME;
xkey[SDLK_KP8]=KEY_UP;
xkey[SDLK_KP9]=KEY_PGUP;

/*
	SDLK_RSHIFT = 156,
	SDLK_LSHIFT = 157,
	SDLK_RCTRL = 158,
	SDLK_LCTRL = 159,
	SDLK_RALT = 160,
	SDLK_LALT = 161,
*/
}

/*
 *      K_Term - keyboard handler shutdown
 */

void K_Term()
{
if(!keyboard_is_installed)
    return;
boot2("K_Term()\n");
lastkey=0;
}

/*
 *      take_key - wait for a key to be pressed
 *                 calls test_key
 */

unsigned char take_key()
{
unsigned char a=0;
while(!a) a=test_key();
return a;
}

/*
 *      test_key - return a key in PC hardware format if pending or else 0
 */

unsigned char test_key()
{
SDL_Event sdlEvent;
unsigned char a=0;

if(lastkey)
    {
    a=lastkey;
    lastkey=0;
    return a;
    }

if( SDL_PollEvent( &sdlEvent ) )
    {
    if(sdlEvent.type == SDL_KEYDOWN)
        lastkey = xkey[sdlEvent.key.keysym.sym];
    else
        lastkey=0;
    return lastkey;
    }
return 0;
}

/*
 *      SYS_CORELEFT - return free physical memory
 *                     Based on source from RHIDE by Robert Hohne
 */

long SYS_CORELEFT()
{
unsigned long p,c;
char buf[1024];
FILE *m;

m = fopen("/proc/meminfo","r");
fgets(buf,1024,m);
fscanf(m,"Mem: %*d %*d %ld %*d %*ld %ld\n",&p,&c);
fclose(m);

return (p+c);

/*
    FILE *mem = fopen("/proc/meminfo","r");
    unsigned long buffers,sw_free,cached;
    char buf[1024];
    fgets(buf,1024,mem);
    fscanf(mem,"Mem: %*d %*d %ld %*d %ld %ld\nSwap: %*d %*d %ld",&phys_mem,&buffers,&cached,&sw_free);
    fclose(mem);
*/
}
