//
//      Game-To-Vrm interface.
//      Contains all the system calls that VRMs can use.
//

#define IRE_SYSTEM_MODULE

#include <stdlib.h>
#include <string.h>
#include <stdarg.h>

#include "console.hpp"
#include "sound.hpp"
#include "sys.hpp"
#include "nuspeech.hpp"

#include "doslib.hpp"
#include "seer/seer.h"
#include "vrm_in.hpp"

#define LIBEXPORT(x) scAdd_External_Symbol(#x,(void*)x);
#define LIBEXVAR(x)  scAdd_External_Symbol(#x,(void*)&x);

void DT();

// Variables

extern char show_vrm_calls;     // From OSCLI
extern long COtot;
extern int do_lightning;
extern char pending_delete;

// Master function

void register_exporttable();

// These functions and variables are exported

extern int mapx;
extern int mapy;
extern int playervrm;
extern int follower;
extern char *swapscreen;
extern OBJECT *player;
extern OBJECT *victim;
extern OBJECT *party[MAX_MEMBERS];
extern int    show_roof;
extern int    new_x;
extern int    new_y;

extern unsigned int game_minute;
extern unsigned int game_hour;
extern unsigned int game_day;
extern unsigned int game_month;
extern unsigned int game_year;

extern OBJECT *current_object;
extern TILE   *current_tile;
extern int    *storage;
extern OBJECT **objectstore;
extern OBJECT *syspocket;

extern OBJECT *OB_Alloc();
extern void OB_Free(OBJECT *a);
extern void DestroyObject(OBJECT *a);
extern void OB_Init(OBJECT *a,char *name);
extern void OB_SetDir(OBJECT *objsel,int dir);
extern void OB_SetSeq(OBJECT *objsel,char *name);
extern int  getnum4VRM(char *name);
void Call_VRM(int num);
void call_vrm(char *name);
extern TILE *GetTile(int x,int y);
extern int WeighObject(OBJECT *obj);
extern int AddToParty(OBJECT *new_member);
extern void SubFromParty(int member);
extern int isSolid(int x,int y);
extern int InPocket(OBJECT *obj);
extern int get_key();
extern int get_key_debounced();
extern void Restart(void);
extern void SetDarkness(int l);
extern void spillcontents(OBJECT *bag,int x,int y);
extern void NPC_Converse(char *file, char *start);
extern void CheckHurt(OBJECT *list);
extern void RedrawMap();
extern void panic(char *a,char *b,char *c);
extern void boot2(char *a,...);
extern char *GetVrmName(int num);

extern OBJECT *GetBestPlace(int x,int y);
extern OBJECT *GetTopObject(int x,int y);
extern void MoveToPocket(OBJECT *src,OBJECT *dest);
extern void TransferToPocket(OBJECT *src,OBJECT *dest);
extern int MoveFromPocket(OBJECT *obj,OBJECT *container,int x,int y);
extern int ForceFromPocket(OBJECT *obj,OBJECT *container,int x,int y);
extern void MoveToTop(OBJECT *obj);

// MR: this should be defined at void
//extern int MoveToMap(int x, int y, OBJECT *object);
extern void MoveToMap(int x, int y, OBJECT *object);
extern void TakeObject(int x,int y, OBJECT *container);
extern int MoveObject(OBJECT *object,int x,int y);
extern void TransferObject(OBJECT *object,int x,int y);
extern OBJECT *GetObject(int x,int y);
extern OBJECT *GetSolidObject(int x,int y);
extern OBJECT *GameGetObject(int x,int y);
extern OBJECT *GetObjectBase(int x,int y);
extern void CreateContents(OBJECT *o);
extern int TakeQuantity(OBJECT *c,char *o,int q);
extern void AddQuantity(OBJECT *c,char *o,int q);
extern OBJECT *LookInAllPocketsForTag(int tag);
extern OBJECT *LookInAllPocketsFor(OBJECT *obj);
extern int getYN(char *q);
extern void ML_Add(OBJLIST **m,OBJECT *o);
extern void ML_Del(OBJLIST **m,OBJECT *o);
extern void AL_Add(OBJLIST **a,OBJECT *o);
extern void gen_largemap();
extern void setPflag(OBJECT *o,int n,int s);
extern int getPflag(OBJECT *o,int n);
extern int get_num(int no);
extern int get_str();
extern char user_input[128];

/*
 *    register_exporttable() - register functions that the script can use
 */

void register_exporttable()
{
// Here is the export table itself

LIBEXPORT(strcmp)
LIBEXPORT(stricmp)
LIBEXPORT(strcpy)
LIBEXPORT(malloc)
LIBEXPORT(free)
LIBEXPORT(realloc)
LIBEXPORT(waitfor)

// My console IO functions

LIBEXPORT(print)
LIBEXPORT(clear)
LIBEXPORT(printxy)
LIBEXPORT(get_number)

scAdd_External_Symbol("printf",print);  // Symbol name != identifier

// Object control functions

LIBEXPORT(create_object)
LIBEXPORT(change_object)
LIBEXPORT(replace_object)
LIBEXPORT(remove_object)
LIBEXPORT(set_object_direction)
LIBEXPORT(set_object_sequence)
LIBEXPORT(set_object_behaviour)
LIBEXPORT(show_object)
LIBEXPORT(get_tile)
LIBEXPORT(get_object)
LIBEXPORT(get_top_object)
LIBEXPORT(get_best_object)
LIBEXPORT(get_first_object)
LIBEXPORT(move_to_pocket)
LIBEXPORT(transfer_to_pocket)
LIBEXPORT(move_from_pocket)
LIBEXPORT(force_from_pocket)
LIBEXPORT(move_to_top)
LIBEXPORT(weigh_object)
LIBEXPORT(is_solid)
LIBEXPORT(spill_contents)
LIBEXPORT(spill_contents_at)
LIBEXPORT(move_object)
LIBEXPORT(transfer_object)
LIBEXPORT(in_pocket)
LIBEXPORT(set_flag)
LIBEXPORT(get_flag)
LIBEXPORT(take_quantity)
LIBEXPORT(add_quantity)
LIBEXPORT(find_object_with_tag)
LIBEXPORT(find_container)
LIBEXPORT(set_pflag)
LIBEXPORT(get_pflag)
LIBEXPORT(set_user_flag)
LIBEXPORT(get_user_flag)
LIBEXPORT(move_forward)
LIBEXPORT(move_backward)
LIBEXPORT(turn_l)
LIBEXPORT(turn_r)
LIBEXPORT(wait_for_animation)

//Miscellaneous functions

LIBEXPORT(call_vrm)
LIBEXPORT(call_vrm_number)
LIBEXPORT(get_vrm_name)
LIBEXPORT(play_song)
LIBEXPORT(play_sound)
LIBEXPORT(stop_song)
LIBEXPORT(start_song)
LIBEXPORT(object_is_called)
LIBEXPORT(redraw)
LIBEXPORT(get_input)
LIBEXPORT(rnd)
LIBEXPORT(restart)
LIBEXPORT(set_darkness)
LIBEXPORT(line_of_sight)
LIBEXPORT(talk_to)
LIBEXPORT(check_hurt)
LIBEXPORT(redraw_map)
LIBEXPORT(get_yn)
LIBEXPORT(lightning)

// Member control

LIBEXPORT(add_to_party)
LIBEXPORT(remove_from_party)
LIBEXPORT(choose_member)
LIBEXPORT(choose_leader)

// System variables

LIBEXVAR(syspocket)
LIBEXVAR(show_roof)
LIBEXVAR(player)
LIBEXVAR(victim)
LIBEXVAR(current_tile)
LIBEXVAR(current_object)
LIBEXVAR(storage)
LIBEXVAR(objectstore)
LIBEXVAR(message)
LIBEXVAR(new_x)
LIBEXVAR(new_y)
LIBEXVAR(key)
LIBEXVAR(game_minute)
LIBEXVAR(game_hour)
LIBEXVAR(game_day)
LIBEXVAR(game_month)
LIBEXVAR(game_year)

#ifdef DEBUGSEER
scOpen_Debug("sire.deb");
atexit(DT);
#endif
}

/*
void Call_VRM(int v)
{
scInstance *vrm;
if(show_vrm_calls)
   {
   boot2("system_vrm: vrm ID %d was called\n",v);
   if(v<=COtot && v>=0)
       boot2("system_vrm: vrm is named %s\n",COlist[v].name);
   else
       boot2("system_vrm: vrm ID out of range!!!\n",v);
   }
if(v<=COtot && v>=0)
    {
    vrm = scCreate_Instance(COlist[v].VRM,"");
    if(!vrm)
        {
        if(scErrorNo != scOK)
            {
            boot2("SeeR instancing error #%d\n",scErrorNo);
            boot2("Error: %s\n",scErrorMsg);
            boot2("Line: %s\n\n",scErrorLine);
            }
        boot2("Fault with VRM %d: %s\n",v,COlist[v].name);
        panic("Call_VRM","Could not create instance of function",COlist[v].name);
        }
    scCall_Instance(vrm,scGet_Symbol(vrm,"vrm_entrypoint"),0,0);
    if(scErrorNo != scOK)
        {
        C_printf("SeeR processing error!!!!\n");
        Bug("SeeR processing error #%d\n",scErrorNo);
        Bug("Error: %s\n",scErrorMsg);
        Bug("Line: %s\n\n",scErrorLine);
        }
    scFree_Instance(vrm);
    }
}
*/

/*
 *    Call_VRM(int n) - call a VRM function by number
 */

void Call_VRM(int v)
{
if(show_vrm_calls)
   {
   boot2("system_vrm: vrm ID %d was called\n",v);
   if(v<=COtot && v>=0)
       boot2("system_vrm: vrm is named %s\n",COlist[v].name);
   else
       boot2("system_vrm: vrm ID out of range!!!\n",v);
   }
if(v<=COtot && v>=0)
    {
    if(!COlist[v].instance)
        {
        COlist[v].instance = scCreate_Instance(COlist[v].vrm,"");
        if(!COlist[v].instance)
            {
            if(scErrorNo != scOK)
                {
                boot2("SeeR instancing error #%d\n",scErrorNo);
                boot2("Error: %s\n",scErrorMsg);
                boot2("Line: %s\n\n",scErrorLine);
                }
            boot2("Fault with VRM %d: %s\n",v,COlist[v].name);
            panic("Call_VRM","Could not create instance of function",COlist[v].name);
            }
        }
    scCall_Instance((scInstance *)COlist[v].instance,scGet_Symbol((scInstance *)COlist[v].instance,"vrm_entrypoint"),0,0);
    if(scErrorNo != scOK)
       {
       C_printf("SeeR processing error!!!!\n");
       Bug("SeeR processing error #%d\n",scErrorNo);
       Bug("Error: %s\n",scErrorMsg);
       Bug("Line: %s\n\n",scErrorLine);
       }
//        scFree_Instance(vrm);
    }
}


///////////////////////////////////

OBJECT *create_object(STRING name, int x, int y)
{
OBJECT *temp;
temp = OB_Alloc();
temp->curdir = temp->dir[0];
OB_Init(temp,name);
OB_SetDir(temp,1);
MoveToMap(x,y,temp);
CreateContents(temp);
return(temp);
}

void remove_object(OBJECT *object)
{
object->flags.on = 0;   // Mark Pending-delete
pending_delete=1;       // Tell the garbage collector it will be needed
}

void change_object(OBJECT *obj,char *name)
{
STATS ostats;
char resname[32];
char pname[32];
char speech[128];
int tcache;

if(obj && name)
   {
   memcpy(&ostats,obj->stats,sizeof(STATS));
   strcpy(resname,obj->funcs->resurrect);
   strcpy(speech,obj->funcs->talk);
   tcache = obj->funcs->tcache;
   strcpy(pname,obj->personalname);
   OB_Init(obj,name);
   memcpy(obj->stats,&ostats,sizeof(STATS));
   strcpy(obj->funcs->resurrect,resname);
   strcpy(obj->personalname,pname);
   strcpy(obj->funcs->talk,speech);
   obj->funcs->tcache = tcache;
   }
}

void replace_object(OBJECT *obj,STRING name)
{
if(obj && name)
   OB_Init(obj,name);
}

void set_object_direction(OBJECT *obj,int dir)
{
if(obj)
   OB_SetDir(obj,dir);
}

void set_object_sequence(OBJECT *obj,char *seq)
{
if(obj && seq)
   OB_SetSeq(obj,seq);
}

void print(char *msg, ...)
{
char temp[4096];
va_list ap;

if(!msg)
    {
    C_printf("Attemped to print NULL message\n");
    Bug("Attemped to print NULL message\n");
    va_end(ap);
    return;
    }

va_start(ap, msg);
vsprintf(temp,msg,ap);          // Temp is now the message
va_end(ap);

C_printf(temp);
}

void printxy(int x,int y,char *msg, ...)
{
char temp[128];
va_list ap;

va_start(ap, msg);
vsprintf(temp,msg,ap);          // Temp now is the message
C_printxy(x,y,temp);
va_end(ap);
}


void clear()
{
C_cls();
}

void show_object(OBJECT *z,int x,int y)
{
if(!z)
   return;
z->form->seq[0]->image.clip_sprite(x,y,swapscreen);
}

void call_vrm(char *name)
{
int v;

v = getnum4VRM(name);

if(show_vrm_calls)
   boot2("chain_vrm: vrm '%s' was called, ID returned was %d\n",name,v);

if(v<0)
       panic("call_vrm","This VRM was not found in Section: CODE...",name);
Call_VRM(v);
}

void call_vrm_number(int name)
{
if(show_vrm_calls)
   boot2("chain_vrm: vrm %d was called\n",name);
Call_VRM(name);
}

char *get_vrm_name(int num)
{
return GetVrmName(num);
}

OBJECT *get_best_object(int x,int y)
{
Bug("Call to obsolete function get_best_object, replace with get_object()\n");
return GetObject(x,y);
//return GetBestPlace(x,y);
}

OBJECT *get_top_object(int x,int y)
{
Bug("Call to obsolete function get_top_object, replace with get_object()\n");
return GetObject(x,y);//GetTopObject(x,y);
}

OBJECT *get_first_object(int x,int y)
{
return GetObjectBase(x,y);//GetTopObject(x,y);
}

OBJECT *get_object(int x,int y)
{
return GameGetObject(x,y);
}

TILE *get_tile(int x,int y)
{
return GetTile(x,y);
}

void move_to_pocket(OBJECT *src,OBJECT *dest)
{
if(src->flags.quantity)
    {
    AddQuantity(dest,src->name,src->stats->quantity);
    src->flags.on = 0;      // Mark Pending-delete
    pending_delete=1;       // Tell the garbage collector it will be needed
    }
else
    MoveToPocket(src,dest);
}

void transfer_to_pocket(OBJECT *src,OBJECT *dest)
{
if(src->flags.quantity)
    {
    AddQuantity(dest,src->name,src->stats->quantity);
    src->flags.on = 0;      // Mark Pending-delete
    pending_delete=1;       // Tell the garbage collector it will be needed
    }
else
    TransferToPocket(src,dest);
}

int move_from_pocket(OBJECT *obj,OBJECT *container,int x,int y)
{
if(!MoveFromPocket(obj,container,x,y))
    return 0;
return 1;
}


int force_from_pocket(OBJECT *obj,OBJECT *container,int x,int y)
{
if(!ForceFromPocket(obj,container,x,y))
    return 0;
return 1;
}


int move_object(OBJECT *obj,int x, int y)
{
if(!MoveObject(obj,x,y))
    return 0;
return 1;
}


void transfer_object(OBJECT *obj,int x, int y)
{
TransferObject(obj,x,y);
}


void spill_contents(OBJECT *bag)
{
spillcontents(bag,bag->x,bag->y);
}

void spill_contents_at(OBJECT *bag,int x, int y)
{
spillcontents(bag,x,y);
}

int weigh_object(OBJECT *obj)
{
return(WeighObject(obj));
}


void play_song(char *a)
{
S_PlayModule(a);
}


void play_sound(char *a)
{
S_PlaySample(a);
}


void stop_song()
{
S_PauseModule();
}


void start_song()
{
S_UnPauseModule();
}


int object_is_called(OBJECT *obj,char *str)
{
if(!obj) return 0;
if(!stricmp(obj->name,str))
    return 1;
return 0;
}

void redraw()
{
C_updatelist();         // Redraw all text output
update(swapscreen);     // And blit the screen again
}


void get_input()
{
key=get_key_debounced();
}

int get_number(int no)
{
if(!get_num(no))
    return 0;
return atoi(user_input);
}

int is_solid (int x,int y)
{
return isSolid(x,y);
}


int rnd(int max)
{
if(max==0) return 0;    // Prevent division by 0
// MR: random is rand in win32
#ifdef _WIN32
return(rand() % max);
#else
return(random() % max);
#endif
}


int choose_member(int x)
{
if(party[x])
    {
    for(int ctr=0;ctr<MAX_MEMBERS;ctr++)
    if(party[ctr])
        {
        party[ctr]->behave = -1;
        ML_Del(&ActiveList,party[ctr]);
        }
    player = party[x];
    player->behave = playervrm;
    AL_Add(&ActiveList,player);
    objectstore[0] = player;
    return 1;
    }
return 0;
}


int choose_leader(int x)
{
if(!party[x])
    return 0;
for(int ctr=0;ctr<MAX_MEMBERS;ctr++)
    {
    if(party[ctr])
        {
        ML_Del(&ActiveList,party[ctr]);
        party[ctr]->behave = follower;
        AL_Add(&ActiveList,party[ctr]);
        }
    }
    player = party[x];
    player->behave = playervrm;
    objectstore[0] = player;
return 1;
}


int add_to_party(OBJECT *new_member)
{
return(AddToParty(new_member));
}


void remove_from_party(int member)
{
SubFromParty(member);
}


OBJECT *get_user_object(int x,int y,int include,int exclude,int lastlayer)
{
Bug("Call to obsolete function get_user_object, replace with get_object()\n");
return NULL;
}

void set_object_behaviour(OBJECT *obj,char *vrm)
{
if(obj)
       if(vrm)
              {
              obj->behave = getnum4VRM(vrm);
              AL_Add(&ActiveList,obj);        // Need to add new entry
              }
       else
              {
              obj->behave = -1;
              ML_Del(&ActiveList,obj);            // Delete entry
              }
}


void restart()
{
Restart();
}

void set_darkness(int l)
{
if(l<0)
   l=0;
if(l>255)
   l=255;
SetDarkness(l);
}

void talk_to(char *speechfile, char *start)
{
NPC_Converse(speechfile,start);
}

void check_hurt(OBJECT *obj)
{
CheckHurt(obj);
}

void redraw_map()
{
RedrawMap();
}

void waitfor(unsigned ms)
{
SYS_DELAY(ms);
}

// Line of sight routine, using J. Grant's interpretation of Bresenham
// From the ITG32 graphics library (1995)

int line_of_sight(int xa, int ya, int xb, int yb)
{
int t, distance;
int xerr=0, yerr=0, delta_x, delta_y;
int incx, incy;
int xo,yo;
OBJECT *obj;

// Don't count the origin as a solid object
xo = xa;
yo = ya;

// Find the distance to go in each plane.
        delta_x = xb - xa;
        delta_y = yb - ya;

// Find out the direction
	if(delta_x > 0) incx = 1;
	else if(delta_x == 0) incx = 0;
	else incx = -1;

	if(delta_y > 0) incy = 1;
	else if(delta_y == 0) incy = 0;
	else incy = -1;

	// Find which way is were mostly going
	delta_x = abs(delta_x);
	delta_y = abs(delta_y);
	if(delta_x > delta_y) distance=delta_x;
	else distance=delta_y;

	// Draw the god dam line.
	for(t = 0; t <= distance + 1; t++) {
                if(isSolid(xa,ya))
                    if(!(xa == xo && ya == yo))
                        if(!(xa == xb && ya == yb))
			   {
			   obj = GetSolidObject(xa,ya);
			   if(!obj)
			      return 0;
			   if(!obj->flags.tabletop)
                              return 0;
			   }
		xerr += delta_x;
		yerr += delta_y;
		if(xerr > distance) {
			xerr -= distance;
			xa += incx;
		}
		if(yerr > distance) {
			yerr -= distance;
			ya += incy;
		}
	}
return 1;
}

void move_to_top(OBJECT *object)
{
MoveToTop(object);
}

int in_pocket(OBJECT *obj)
{
return(InPocket(obj));
}

void DT()
{
#ifdef DEBUGSEER
scClose_Debug();
#endif
}

void set_flag(OBJECT *target, int flag, int value)
{
if(!target)
    return;

switch(flag)
    {
    case IS_ON:
    target->flags.on=value;
    if(value == 0)
        pending_delete = 1;
    break;

    case IS_ONSCREEN:
    Bug("Flag ONSCREEN is not supported\n");
    C_printf("Flag ONSECREEN is not supported\n");
    break;

    case IS_OVERLAY:
    Bug("Flag OVERLAY is read-only\n");
    C_printf("Flag OVERLAY is read-only\n");
    break;

    case IS_SOLID:
    target->flags.solid=value;
    break;

    case IS_FRAGILE:
    target->flags.fragile=value;
    break;

    case IS_TRIGGER:
    Bug("Flag TRIGGER is read-only\n");
    C_printf("Flag TRIGGER is read-only\n");
    break;

    case IS_INVISIBLE:
    target->flags.invisible=value;
    break;

    case IS_PARTY:
    target->flags.party=value;
    break;

    case IS_FIXED:
    target->flags.fixed=value;
    break;

    case IS_CONTAINER:
    target->flags.container=value;
    break;

    case IS_TRANSLUCENT:
    target->flags.translucent=value;
    break;

    case IS_LARGE:
    Bug("Flag LARGE is read-only\n");
    C_printf("Flag LARGE is read-only\n");
    break;

    case IS_SPIKEPROOF:
    target->flags.spikeproof=value;
    break;

    case CAN_WIELD:
    target->flags.wield=value;
    break;

    case DID_STEPUPDATE:
    target->flags.stepupdated=value;
    break;

    case IS_YOURS:
    target->flags.yours=value;
    break;

    case DOES_BLOCKLIGHT:
    target->flags.blocklight=value;
    break;

    case IS_TABLETOP:
    target->flags.tabletop=value;
    break;

    case DID_INIT:
    target->flags.didinit=value;
    break;

    case DID_UPDATE:
    target->flags.didupdate=value;
    break;

    case IS_PERSON:
    target->flags.person=value;
    break;

    case IS_QUANTITY:
    target->flags.quantity=value;
    break;

    default:
    Bug("Attempt to set unknown flag %08d\n",flag);
    C_printf("Attempt to set unknown flag %08x\n",flag);
    break;
    }
}

int get_flag(OBJECT *target, int flag)
{
if(!target)
    return 0;

switch(flag)
    {
    case IS_ON:
    return (target->flags.on);
    break;

    case IS_ONSCREEN:
    return (target->flags.onscreen);
    break;

    case IS_OVERLAY:
    return (target->flags.overlay);
    break;

    case IS_SOLID:
    return (target->flags.solid);
    break;

    case IS_FRAGILE:
    return (target->flags.fragile);
    break;

    case IS_TRIGGER:
    return (target->flags.trigger);
    break;

    case IS_INVISIBLE:
    return (target->flags.invisible);
    break;

    case IS_PARTY:
    return (target->flags.party);
    break;

    case IS_FIXED:
    return (target->flags.fixed);
    break;

    case IS_CONTAINER:
    return (target->flags.container);
    break;

    case IS_TRANSLUCENT:
    return (target->flags.translucent);
    break;

    case IS_LARGE:
    return (target->flags.large);
    break;

    case IS_SPIKEPROOF:
    return (target->flags.spikeproof);
    break;

    case CAN_WIELD:
    return (target->flags.wield);
    break;

    case DID_STEPUPDATE:
    return (target->flags.stepupdated);
    break;

    case IS_YOURS:
    return (target->flags.yours);
    break;

    case DOES_BLOCKLIGHT:
    return (target->flags.blocklight);
    break;

    case IS_TABLETOP:
    return (target->flags.tabletop);
    break;

    case DID_INIT:
    return (target->flags.didinit);
    break;

    case DID_UPDATE:
    return (target->flags.didupdate);
    break;

    case IS_PERSON:
    return (target->flags.person);
    break;

    case IS_QUANTITY:
    return (target->flags.quantity);
    break;
    }

Bug("Attempt to read unknown flag %08x\n",flag);
C_printf("Attempt to read unknown flag %08x\n",flag);
return 0;
}

int take_quantity(OBJECT *container, char *objecttype, int quantity)
{
return (TakeQuantity(container,objecttype,quantity));
}

void add_quantity(OBJECT *container, char *objecttype, int quantity)
{
AddQuantity(container,objecttype,quantity);
}

OBJECT *find_object_with_tag(int tag,char *name)
{
OBJLIST *t;

for(t=MasterList;t;t=t->next)
    if(t->ptr->tag == tag)
        if(name)
            {
            if(!stricmp(name,t->ptr->name))
                return t->ptr;
            }
        else
            return t->ptr;

return NULL;
}

int get_yn(char *question)
{
return(getYN(question));
}

void set_pflag(OBJECT *a,int flag, int state)
{
if(flag<0 || flag>31)
    {
    Bug("Attempt to set invalid p-flag %d for object %s, in a VRM\n",flag,a->name);
    return;
    }
setPflag(a,flag,state);
}

int get_pflag(OBJECT *a,int flag)
{
if(!a)
    return 0;
if(flag<0 || flag>31)
    {
    Bug("Attempt to read invalid p-flag %d for object %s, in a VRM\n",flag,a->name);
    return 0;
    }
return(getPflag(a,flag));
}

void set_user_flag(char *a, int s)
{
Set_tFlag(a,s);
}

int get_user_flag(char *a)
{
return(Get_tFlag(a));
}

int move_forward(OBJECT *a)
{
if(!a)
    return 0;

a->flags.stepupdated=1; // Force animation

if(a->curdir == CHAR_U)
    return MoveObject(a,a->x,a->y-1);
if(a->curdir == CHAR_D)
    return MoveObject(a,a->x,a->y+1);
if(a->curdir == CHAR_L)
    return MoveObject(a,a->x-1,a->y);
if(a->curdir == CHAR_R)
    return MoveObject(a,a->x+1,a->y);
return 0;
}

int move_backward(OBJECT *a)
{
if(!a)
    return 0;

a->flags.stepupdated=1; // Force animation

if(a->curdir == CHAR_U)
    return MoveObject(a,a->x,a->y+1);
if(a->curdir == CHAR_D)
    return MoveObject(a,a->x,a->y-1);
if(a->curdir == CHAR_L)
    return MoveObject(a,a->x+1,a->y);
if(a->curdir == CHAR_R)
    return MoveObject(a,a->x-1,a->y);
return 0;
}

int turn_l(OBJECT *a)
{
if(!a)
    return 0;

switch(a->curdir)
    {
    case CHAR_U:
    OB_SetDir(a,CHAR_L);
    break;

    case CHAR_L:
    OB_SetDir(a,CHAR_D);
    break;

    case CHAR_D:
    OB_SetDir(a,CHAR_R);
    break;

    case CHAR_R:
    OB_SetDir(a,CHAR_U);
    break;
    }
return a->curdir;
}

int turn_r(OBJECT *a)
{
if(!a)
    return 0;

switch(a->curdir)
    {
    case CHAR_U:
    OB_SetDir(a,CHAR_R);
    break;

    case CHAR_R:
    OB_SetDir(a,CHAR_D);
    break;

    case CHAR_D:
    OB_SetDir(a,CHAR_L);
    break;

    case CHAR_L:
    OB_SetDir(a,CHAR_U);
    break;
    }
return a->curdir;
}

void wait_for_animation(OBJECT *obj)
{
if(!obj)
    return;

if(obj->form->flags&6)  // Ignore if looped or stepped
    return;             // (Otherwise it will never come back)

for(;obj->sdir;RedrawMap());
}

void lightning(int ticks)
{
do_lightning=ticks;
}

OBJECT *find_container(OBJECT *obj)
{
return LookInAllPocketsFor(obj);
}

