/*
 *      IRE - text file routines, loading and indexing thru' VFS layer
 */

#include <stdio.h>
#include "textfile.hpp"

// TextFile_Struct constructor, set values to reasonable defaults

TF_S::TF_S()
    {
    size = 0;
    lines = 0;
    block = NULL;
    line = NULL;
    }

// TextFile_Struct destructor, free memory if necessary

TF_S::~TF_S()
    {
    term();
    return;
    }

// TextFile_Struct terminator, free memory if necessary and set to defaults

void TF_S::term()
    {
    if(size)
        {
        if(block)
            {
//            memset(block,0,size);
            M_free(block);
            }
        size=0;
        }
    if(lines)
        {
        if(line)
            M_free(line);
        lines=0;
        }
    }

// TextFile_Struct initializer, open file, alloc memory and index by line

void TF_S::init(char *filename)
    {
    LOAD fp;
    int ctr,current;

    fp.open(filename);          // Open file
    size = fp.filelength();     // Get length

    block = (char *)M_get(1,size+1);    // Alloc memory for block, and a NULL
    fp.read(block,1,size);              // Read the file into block
    fp.close();                         // Finished

    lines = 1;                     // Count Carriage Returns

    for(ctr = 0;ctr < size;ctr++)
       if(block[ctr] == '\n')   // Found one
           lines++;

    // We now know how many lines there are, so allocate the line index

    line = (char **)M_get(lines,sizeof(char *));

    // Now we go through the lines indexing them.

    current = 0;                                // First line
    line[0] = block;                            // This is the first line

    for(ctr = 0;ctr < size;ctr++)
       if(block[ctr] == '\n')                   // Found a line break
           {
           block[ctr] = 0;                   // End the string
           line[++current] = &block[ctr+1];  // This is the next line
           }
    }
