//
//      BeOS-specific stub for the timer.
//	Based on timer_l.c
//

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

#define TIMER_SIGNAL SIGUSR2

static volatile unsigned char Tick=0;
static volatile unsigned char ready_for_tick=0;
static char T_Running=0;
static int TimerChild_Id=0;

int T_Midas_Init();
void T_Midas_Term();
int T_IsDue();
static void TimerChild(int sig);

/*
 * T_Midas_Init() - Start it up.
 *                  In Linux we fork a separate process which does nothing
 *                  but count at 140Hz and reset the timer latch at 35Hz
 */

int T_Midas_Init()
{
int id;
if(T_Running)     // Safety valve
    return 0;

id=fork();
switch(id)
    {
    case -1:
    fprintf(stderr,"Could not fork timing code!\n");
    exit(1);
    break;

    case 0:
    // Child
    id = getppid();          // Get parent's ID
    sleep(2);		     // Sleep 2 seconds while the parent gets ready
    for(;;)
        {
        //usleep(7143);        // 1000000/140 = ~7143 useconds
	snooze(7143);
        Tick++;              // 140Hz/4 = 35Hz
        Tick&=3;
        if(Tick == 0)
            kill(id,TIMER_SIGNAL);      // Prod the parent
        };

    // Oh no!
        
    fprintf(stderr,"\n\n");
    fprintf(stderr,"What shall we do with the drunken sailor?\n");
    fprintf(stderr,"What shall we do with the drunken sailor?\n");
    fprintf(stderr,"What shall we do with the drunken sailor, earl-eye in the mor-ning\n");
    fprintf(stderr,"Hit him with the lash until he's sober\n");
    fprintf(stderr,"Hit him with the lash until he's sober\n");
    fprintf(stderr,"Hit him with the lash until he's sober, earl-eye in the mor-ning\n");
    fprintf(stderr,"Hoo-ray and up she rises\n");
    fprintf(stderr,"Hoo-ray and up she rises\n");
    fprintf(stderr,"Hoo-ray and up she rises, earl-eye in the mor-ning\n");
    fprintf(stderr,"\n\n");
    exit(1);
    break;

    default:
    TimerChild_Id=id;
    fprintf(stderr,"Installing USR2 Signal Handler\n");
    if(signal(TIMER_SIGNAL,TimerChild) == SIG_ERR)
        {
        perror("FAILED:");
        exit(1);
        }

    T_Running=1;
    break;
    }

return(1);
}

/*
 * T_Midas_Term() - Shut it down, kill the child
 */

void T_Midas_Term()
{
if(!T_Running)    // Safety valve
    return;
kill(TimerChild_Id,SIGKILL);    // Knife the baby
signal(TIMER_SIGNAL,SIG_DFL);
T_Running = 0;    // Never again shall T_Term run
}


/*
 * T_IsDue() - returns true if it's time to update the animations
 */

int T_IsDue()
{
if(ready_for_tick)
   {
   ready_for_tick = 0;
   return 1;
   }
return 0;
}


void TimerChild(int sig)
{
// Update the animation timer

ready_for_tick = 1;

// Something has gone catastrophically wrong.  Sing a sea shanty.

if(sig != TIMER_SIGNAL)
    {
    fprintf(stderr,"\n\n");
    fprintf(stderr,"What shall we do with the drunken sailor?\n");
    fprintf(stderr,"What shall we do with the drunken sailor?\n");
    fprintf(stderr,"What shall we do with the drunken sailor, earl-eye in the mor-ning\n");
    fprintf(stderr,"Throw him in the oil 'till he grows a flipper\n");
    fprintf(stderr,"Throw him in the oil 'till he grows a flipper\n");
    fprintf(stderr,"Throw him in the oil 'till he grows a flipper, earl-eye in the mor-ning\n");
    fprintf(stderr,"Hoo-ray and up she rises\n");
    fprintf(stderr,"Hoo-ray and up she rises\n");
    fprintf(stderr,"Hoo-ray and up she rises, earl-eye in the mor-ning\n");
    fprintf(stderr,"\n\n");
    exit(1);
    }

// Ok, it worked fine
}
