//
//      DJGPP/MIDAS-specific stub for the timer.
//

#include <stdio.h>
#include <stdlib.h>
#include <go32.h>
#include "soundsys\midasdll.h"

static volatile unsigned char Tick=0;
static volatile unsigned char ready_for_tick=0;
static char T_Running=0;
void MIDAS_CALL T_i8handler(void);

void (MIDAS_CALL *MFhandler)(void);

int T_Midas_Init();
void T_Midas_Term();
int T_IsDue();

/*
 * turn_system_to_ash() - har har har
 */

void turn_system_to_ash()
{
char *v;
v=NULL;
strcpy(v,"In the antique cities of dead Relyah, Cthulu dreams and waits...");
}

/*
 * T_Midas_Init() - Start it up
 */

int T_Midas_Init()
{
int rv;
if(T_Running)     // Safety valve
    return 0;
rv=MIDASsetTimerCallbacks(140000L, FALSE, NULL, T_i8handler, NULL);

if(rv)
   {
   T_Running = 1;                          // Prevent any reentry
   atexit(T_Midas_Term);
   }
return(rv);
}

/*
 * T_Midas_Term() - Shut it down
 */

void T_Midas_Term()
{
if(!T_Running)    // Safety valve
    return;
MIDASremoveTimerCallbacks();
T_Running = 0;    // Never again shall T_Term run
}

/*
 * T_i8_handler() - HandlerSys
 */

void MIDAS_CALL T_i8handler(void)
{

  Tick++;                      // 140Hz/4 = 35Hz
  Tick&=3;                     // But it must be >70 for the mixing kernel

  if(!Tick)
      ready_for_tick = 1;      // Do it
}

/*
 * T_IsDue() - returns true if it's time to update the animations
 */

int T_IsDue()
{
if(ready_for_tick)
   {
   ready_for_tick = 0;
   return 1;
   }
return 0;
}


