//
//      WIN32-specific stub for the timer.
//

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <stdio.h>
#include <process.h>

#include "sdl.h"

#define TICK_RATE 30

static volatile unsigned char ready_for_tick=0;
static char T_Running=0;
static DWORD dwLastTickCount = 0;

int T_Midas_Init();
void T_Midas_Term();
int T_IsDue();


/*
 * T_Midas_Init() - Start it up.
 *                  In Linux we fork a separate process which does nothing
 *                  but count at 140Hz and reset the timer latch at 35Hz
 */

int T_Midas_Init()
{
if(T_Running)     // Safety valve
    return 0;

// get the initial tick count
dwLastTickCount = SDL_GetTicks();

T_Running=1;

return(1);
}

/*
 * T_Midas_Term() - Shut it down, kill the child
 */

void T_Midas_Term()
{
if(!T_Running)    // Safety valve
    return;
T_Running = 0;    // Never again shall T_Term run
}


/*
 * T_IsDue() - returns true if it's time to update the animations
 */

int T_IsDue()
{
if ((SDL_GetTicks()-dwLastTickCount) > TICK_RATE)
{
	dwLastTickCount = SDL_GetTicks();
	ready_for_tick = 1;
	return 1;
}
	
ready_for_tick = 0;
return 0;
}