//
//      VRM_IN.HPP - Internal version of vrm.hpp
//

#ifndef IRE_NATIVE_EXECUTION_MODULE_HEADER_FILE
#define IRE_NATIVE_EXECUTION_MODULE_HEADER_FILE

#include "core.hpp"

typedef char *STRING;

#include "seer/seer.h"

#define TYPE "C"
#ifndef NULL
  #define NULL 0L
#endif


/////// Virtual Runnable Module subroutines ////////

#define AND &&
#define OR ||
#define NOT !

extern TYPE void print(char *msg, ...);
extern TYPE void printF(char *msg, ...);
extern TYPE void clear();
extern TYPE void printxy(int x,int y,char *msg, ...);

extern TYPE OBJECT *create_object(STRING name, int x, int y);
extern TYPE void remove_object(OBJECT *obj);
extern TYPE void change_object(OBJECT *obj, STRING name);
extern TYPE void replace_object(OBJECT *obj, STRING name);
extern TYPE void set_object_direction(OBJECT *obj, int dir);
extern TYPE void set_object_sequence(OBJECT *obj, STRING name);
extern TYPE void set_object_behaviour(OBJECT *obj, STRING name);
#define set_object_behavior set_object_behaviour
extern TYPE void spill_contents(OBJECT *bag);
extern TYPE void spill_contents_at(OBJECT *bag,int x,int y);
extern TYPE int get_flag(OBJECT *target, int flag);
extern TYPE void set_flag(OBJECT *target, int flag, int value);
extern TYPE void add_quantity(OBJECT *container, char *objecttype, int quantity);
extern TYPE int take_quantity(OBJECT *container, char *objecttype, int quantity);
extern TYPE OBJECT *find_object_with_tag(int a, char *name);
extern TYPE OBJECT *find_container(OBJECT *ex);
extern TYPE int get_pflag(OBJECT *target, int flag);
extern TYPE void set_pflag(OBJECT *target, int flag, int state);
extern TYPE int get_user_flag(char *flag);
extern TYPE void set_user_flag(char *flag, int state);
extern TYPE void show_object(OBJECT *z,int x,int y);
extern TYPE void call_vrm(char *name);
extern TYPE void call_vrm_number(int name);
extern TYPE char *get_vrm_name(int num);
extern TYPE void play_song(char *song);
extern TYPE void play_sound(char *sound);
extern TYPE void start_song();
extern TYPE void stop_song();
extern TYPE int object_is_called(OBJECT *obj,char *str);
extern TYPE int rnd(int max);
extern TYPE void waitfor(unsigned millisec);
extern TYPE int get_number(int no);

extern TYPE TILE *get_tile(int x,int y);
extern TYPE OBJECT *get_object(int x,int y);

extern TYPE OBJECT *get_top_object(int x,int y);
extern TYPE OBJECT *get_best_object(int x,int y);
extern TYPE OBJECT *get_first_object(int x,int y);

extern TYPE void move_to_pocket(OBJECT *src,OBJECT *dest);
extern TYPE void transfer_to_pocket(OBJECT *src,OBJECT *dest);
extern TYPE int force_from_pocket(OBJECT *obj,OBJECT *container,int x,int y);
extern TYPE int move_from_pocket(OBJECT *obj,OBJECT *container,int x,int y);
extern TYPE void move_to_top(OBJECT *obj);
extern TYPE int weigh_object(OBJECT *obj);
extern TYPE int is_solid(int x,int y);
extern TYPE int in_pocket(OBJECT *o);
extern TYPE int move_object(OBJECT *src,int x,int y);
extern TYPE void transfer_object(OBJECT *src,int x,int y);
extern TYPE int line_of_sight(int xa, int ya, int xb, int yb);
extern TYPE int move_forward(OBJECT *a);
extern TYPE int move_backward(OBJECT *a);
extern TYPE int turn_l(OBJECT *a);
extern TYPE int turn_r(OBJECT *a);
extern TYPE void wait_for_animation(OBJECT *a);

extern TYPE int add_to_party(OBJECT *new_member);
extern TYPE void remove_from_party(int member);
extern TYPE int choose_member(int member);
extern TYPE int choose_leader(int leader);

extern TYPE void set_darkness(int level);
extern TYPE void redraw();
extern TYPE void restart();
extern TYPE void get_input();
extern TYPE void talk_to(char *speechfile,char *startpage);
extern TYPE void check_hurt(OBJECT *list);
extern TYPE void redraw_map();
extern TYPE int get_yn(char *question);
extern TYPE void lightning(int ticks);


extern OBJECT *syspocket;
extern OBJECT *player;
extern OBJECT *victim;
extern OBJECT *current_object;
extern TILE   *current_tile;
extern STRING message;
extern int    *storage;
extern OBJECT **objectstore;
extern int    show_roof;
extern int    key;
extern int    new_x,new_y;

#define hurt_object(x,y) {x->stats->hp-=y; check_hurt(x);}

#define UP 0
#define DOWN 1
#define LEFT 2
#define RIGHT 3

#define CHAR_U 0
#define CHAR_D 1
#define CHAR_L 2
#define CHAR_R 3

#define IS_ON           0x00000001
#define IS_ONSCREEN     0x00000002
#define IS_OVERLAY      0x00000004
#define IS_SOLID        0x00000008
#define IS_FRAGILE      0x00000010
#define IS_TRIGGER      0x00000020
#define IS_INVISIBLE    0x00000040
#define IS_PARTY        0x00000080
#define IS_FIXED        0x00000100
#define IS_CONTAINER    0x00000200
#define IS_TRANSLUCENT  0x00000400
#define IS_LARGE        0x00000800
#define IS_SPIKEPROOF   0x00001000
#define CAN_WIELD       0x00002000
#define DID_STEPUPDATE  0x00004000
#define IS_YOURS        0x00008000
#define DOES_BLOCKLIGHT 0x00010000
#define IS_TABLETOP     0x00020000
#define DID_INIT        0x00040000
#define DID_UPDATE      0x00080000
#define IS_PERSON       0x00100000
#define SEEK_STATE      0x00200000
#define IS_QUANTITY     0x00400000

#define KEY_ESC  1
#define KEY_1    2
#define KEY_2    3
#define KEY_3    4
#define KEY_4    5
#define KEY_5    6
#define KEY_6    7
#define KEY_7    8
#define KEY_8    9
#define KEY_9    10
#define KEY_0    11

#define KEY_TAB  15
#define KEY_Q    16
#define KEY_W    17
#define KEY_E    18
#define KEY_R    19
#define KEY_T    20
#define KEY_Y    21
#define KEY_U    22
#define KEY_I    23
#define KEY_O    24
#define KEY_P    25

#define KEY_ENTER  28

#define KEY_A    30
#define KEY_S    31
#define KEY_D    32
#define KEY_F    33
#define KEY_G    34
#define KEY_H    35
#define KEY_J    36
#define KEY_K    37
#define KEY_L    38

#define KEY_Z    44
#define KEY_X    45
#define KEY_C    46
#define KEY_V    47
#define KEY_B    48
#define KEY_N    49
#define KEY_M    50
#define KEY_COMMA    51
#define KEY_DOT      52

#define KEY_SPACE    57

#define KEY_UP     72
#define KEY_DOWN   80
#define KEY_LEFT   75
#define KEY_RIGHT  77

#define KEY_HOME   0x47
#define KEY_END    0x4f
#define KEY_PGUP   0x49
#define KEY_PGDN   0x51

#define KEY_F1	59
#define KEY_F2	60
#define KEY_F3	61
#define KEY_F4	62
#define KEY_F5	63
#define KEY_F6	64
#define KEY_F7	65
#define KEY_F8	66
#define KEY_F9	67
#define KEY_F10	60
#define KEY_F11	87
#define KEY_F12	88

#define MAX_MEMBERS 128

#endif

