#ifndef bauisdkh
#define bauisdkh
#define false -1
typedef unsigned short word;
typedef unsigned char byte;
typedef unsigned long dword;

#include <stdio.h>
#include <stdlib.h>
#include <windows.h>
#include <ddraw.h>
#include <string.h>

#define RESX 640
#define RESY 480
#define MAXX 608
#define MAXY 448
#define RESXM 639
#define RESYM 479
#define TILXNUM 20
#define TILYNUM 12
#define TILXSIZ 32
#define TILYSIZ 32
#define TILXSIZM 31
#define TILYSIZM 31
#define TILXNUMP 21
#define TILYNUMP 13
#define TILXNUMM 19
#define TILYNUMM 11
#define BUFXSIZ 640
#define BUFYSIZ 480


#define BLT_TILE 	0
#define BLT_SPRITE 	1

#define BACKBUF  	0
#define FRAMEBUF	1
#define TILEBUF1 	2
#define MANBUF  	3
#define ATKBUF		4
#define SURFACENUM 	100

#define VM_RDOWN 	0
#define VM_LDOWN 	1
#define VM_LDCLK 	2
#define VM_RDCLK 	3
#define VM_RUP		4
#define VM_LUP 		5
#define MAXMBUTTON 	6

#define VK_LSTART 	91
#define VK_RSTART 	92
#define VK_MENUKEY 	93
#define VK_HANJA 	25
#define VK_HANENG 	21
#define VK_ANYKEY 	254
#define VK_VALUE 	255

#define LISTMAN 0
#define LISTTXT 1
#define LISTBUT 2
#define LISTPRV 3
#define LISTBOX 4
#define LISTIBOX 5
#define LISTATK	6
#define LISTNUM 7

typedef struct{
  unsigned char maker,version,code,bpp;
  unsigned short x1,y1,x2,y2,hres,vres;
  unsigned char palette[48];
  unsigned char vmode,nplanes;
  unsigned short bpl,palinfo,svres,shres;
  unsigned char unused[54];
}HPCX;

struct Gle{unsigned num:15,flag:1;};

typedef union{
	struct Gle gle;
	unsigned glestr;
}HAN;

typedef struct{
	int max,size;
	int **unit;
}LIST;

typedef struct{
    char *Data;
    int Pos;
    int Size;
}DECORD;

extern HWND hwnd;
extern byte *Screen;
extern HPCX header;
extern byte TempPal[768];

extern byte *keyvaluebuf,oldkeynum;
extern unsigned oldglestr;
extern char keybufadd,htableadd,capslock,chojungjong,shifton,numlock;
extern int *strdest,*numdest;

extern HWND hwnd;
extern MSG msg;
extern HINSTANCE hInstance;
extern int nCmdShow;

extern int accessable;
extern char charkey,haneng;
extern byte downkey[];
extern byte upkey[];
extern int mousex,mousey,mdx,mdy;
extern byte mbutton[];
extern byte keycode[];
extern short keycodeadd;

void fputi(int,FILE *);
int fgeti(FILE *);

void WinMsgProcess();
RECT Makerect(int,int,int,int);

void StartFps();
void Samedelay(DWORD);
void ShowFps();
int FpsCheck();
void Box(int,int,int,int,int,int);
void Getstrbox(int,int,char*,char,byte,byte);


void Regitolist(LIST *,int);
void Clearlist(LIST *);
void Addunit(LIST *);
void Delunit(LIST *,int);

void Loadcurser(char *);
BOOL InitDevice();
void Showcursor();
void Waitkey(byte);
void Waitfps(int);
void (*Returnfunc)();
void keynone();

DECORD *Initdecord(char *);
void Closedecord(DECORD *);
char Getbyte(DECORD *);
short Getword(DECORD *);
long Getdword(DECORD *);
char *Getstring(DECORD *);

void Unpresspcx(byte *,word,word,FILE *);
void Compresspcx(byte *,word,word,FILE *);

void Textwrite(int,int,byte,byte *);
void Textwritef(int,int,byte,byte *,...);
void Sethanwidth(int,int,int);
BOOL Loadefont(char *);
BOOL Loadhfont(char *);
void Allhangle();
void Getnum(int *);
void Getstr(int *,byte);

BOOL LoadPalette(char*);
void Fadeout(int);
void Fadein(int);
void GetPalette();
void Setcolorkey(byte);
void ClosePainter();
BOOL InitPainter(byte colorkey);
void FillScreen(char,int,int,int,int,byte);
BOOL movedata(int,int,char,RECT,DWORD);
BOOL FlipAll();

void PutPict(int,int,byte);
byte GetPict(int,int);

char *Lock(char);
void Unlock(char);
BOOL LoadPcx(int,int,char,char*);
RECT Getrect(int);

#endif
