#include "Bitmap.h"
#include <iostream>
#include <fstream>
#include <math.h>

using namespace std;

// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// The bulk of this code is dictated by the 
// Windows bitmap standard...

Bitmap::Bitmap ()
{
  Init ();
}

Bitmap::Bitmap (char *filename)
{
  Init ();
  Load (filename);
}

Bitmap::~Bitmap ()
{
  delete[]Data;
  delete[]Palette;
}

void Bitmap::
Init ()
{
  Width = 0;
  Height = 0;
  Size = 0;
  HResolution = 0;
  VResolution = 0;
  Colors = 0;
  Palette = NULL;
  Data = NULL;
}

long Bitmap::
ReadDWord (fstream & f)
{
  char t;
  unsigned char a, b, c, d;
//      fstream debug2("debug2.txt",ios::app);
  //      f>>a>>b>>c>>d;
  f.get (t);
  a = (unsigned char) t;
  f.get (t);
  b = (unsigned char) t;
  f.get (t);
  c = (unsigned char) t;
  f.get (t);
  d = (unsigned char) t;
//      debug2<<"a="<<(int)a<<" b="<<(int)b<<" c="<<(int)c<<" d="<<(int)d<<endl;
  // debug2.close();
  return (long) (a + (b * 256) + (c * 65536) + (d * 16777216));
}

void Bitmap::
Load (char *filename)
{
  fstream f (filename, ios::in | ios::binary);
  int j = 0;
  if (!f.good ())
    {
      cerr << "Big problems loading a bitmap\n";
      cerr << "Filename=" << filename << endl;
    }
//      if (strcmp(filename,"home0.bmp")==0)
  //       fstream debug("debug.txt",ios::out);
  //      f.setmode(filebuf::binary);
  //              debug<<"Big problems setting to binary!\n";
  //      if (!f.is_open())
  //  debug<<"Big problems\n";
  unsigned char x;
  long tempdword;
  f >> x;
  f >> x;
  Size = ReadDWord (f);
//      debug<<"Size="<<Size<<endl;
  tempdword = ReadDWord (f);	//Reserved

  tempdword = ReadDWord (f);	//Data Offset

  tempdword = ReadDWord (f);	//Header Size

  Width = ReadDWord (f);
  Height = ReadDWord (f);
//      debug<<"Width="<<Width<<".  Height="<<Height<<endl;
  tempdword = ReadDWord (f);	//Planes and bits per pixel

  tempdword = ReadDWord (f);	//Compression.  Should be 0.
  //      debug<<"Compression="<<tempdword<<endl;

  tempdword = ReadDWord (f);	//Data size.
  //      debug<<"Data Size="<<tempdword<<endl;

  HResolution = ReadDWord (f);
  VResolution = ReadDWord (f);
// debug<<"HResolution:  "<<HResolution<<".  VResolution:  "<<VResolution<<endl;
  tempdword = ReadDWord (f);	//colors
  //      debug<<"Real Colors:  "<<tempdword<<endl; //Should be 256

  Colors = ReadDWord (f);
// debug<<"Important colors:  "<<Colors<<endl;

  Palette = new unsigned char[ /*Colors */ 256 * 4];
  for (j = 0; j < 256 * 4 /*(int)Colors */ ; j += 4)
    {
	  char t;
      f.get (t);	//Blue 
      Palette[j] = (unsigned char) t;
      f.get (t);	//Green
      Palette[j + 1] = (unsigned char) t;
      f.get (t);	//Red
      Palette[j + 2] = (unsigned char) t;
      f.get (t);	//Reserved
      Palette[j + 3] = (unsigned char) t;

      //                      if (strcmp(filename,"home0.bmp")==0)
      //                      {
      //        fstream debug("debug.txt",ios::app);
      //               debug<<"Palette entry:  "<<(int)Palette[j]<<" "<<(int)Palette[j+1]<<" "<<(int)Palette[j+2]<<" "<<(int)Palette[j+3]<<endl;
      //                 debug.close();
      //                      }

    }
//      debug<<"Read the palette... :)\n";
  /*              if (strcmp(filename,"home0.bmp")==0)
     {
     fstream debug("debug.txt",ios::app);
     debug<<"Size="<<Size<<endl;
     }
   */

  Data = new unsigned char[Size];
  for (j = 0; j < /*Size */ Height * Width; j++)
    {	
	  char t;
      f.get (t);
	  Data[j] = (unsigned char) t;

/*      if (strcmp(filename,"home1.bmp")==0)
   {
   fstream debug("debug.txt",ios::app);
   debug<<Data[j]<<" ";
   if (j%Width==0)
   debug<<endl;
   } */
    }
// debug<<"Read the data... :)\n\n";

/*      if (strcmp(filename,"home1.bmp")==0)
   {
   fstream debug("debug.txt",ios::out);
   debug<<"Width="<<Width<<", Height="<<Height<<endl;
   debug<<"Bitmap Data"<<endl;
   for (int m=0;m<Height;m++)
   {
   for (int n=0;n<Width;n++)
   debug<<Data[(m*Width)+n]<<" ";
   debug<<endl;
   }
   debug.close();
   }
 */
  f.close ();

}

GLubyte *Bitmap::
GetGLTexture ()
{
  int width = Width;
  int height = Height;

  if ((double) (log (Width) / log (2)) != (int) (log (Width) / log (2)))
    {
      width = 1;
      for (int w = 0; w < (int) (log (Width) / log (2)) + 1; w++)
	width *= 2;
    }

  if ((double) (log (Height) / log (2)) != (int) (log (Height) / log (2)))
    {
      height = 1;
      for (int h = 0; h < (int) (log (Height) / log (2)) + 1; h++)
	height *= 2;
    }

  GLubyte *texture = new GLubyte[width * height * 3];

//      fstream debug2("debug2.txt",ios::out);
  //      debug2<<"---------------\n";
  //      debug2<<(int)Palette[8]<<" "<<(int)Palette[9]<<" "<<
  //                     (int)Palette[10]<<" "<<(int)Palette[11]<<endl;
  //      debug2<<"---------------\n";
  for (int y = 0; y < Height; y++)
    {
      for (int x = 0; x < Width; x++)
	{
//                                      debug2<<"Index="<<(int)Data[(y*Width)+x]<<endl;
	  //                                      debug2<<"Entries should be:  "<<(int)Palette[(int)Data[(y*Width)+x]]<<" "
	  //                                                                                                                                                                                                                                                                              <<(int)Palette[(int)Data[(y*Width)+x]+1]<<" "
	  //                                                                                                                                                                                                                                                                              <<(int)Palette[(int)Data[(y*Width)+x]+2]<<endl;
	  for (int z = 0; z < 3; z++)
	    {
	      texture[(y * 3 * Width) + (3 * x) + z] = Palette[((int) Data[(y * Width) + x] * 4) + (2 - z)];
/*                              if (y<50)
   {
   if (z==0)
   debug2<<"Blue="<<(int)texture[(y*3*Width)+(3*x)+z]<<endl;
   else if (z==1)
   debug2<<"Green="<<(int)texture[(y*3*Width)+(3*x)+z]<<endl;
   else if (z==2)
   debug2<<"Red="<<(int)texture[(y*3*Width)+(3*x)+z]<<endl;
   } */
//                              debug2<<(int)texture[(y*(3*Width))+(3*x)+z]<<" ";
	    }
	}
//              debug2<<endl;
    }
// debug2.close();
  return texture;
}

void Bitmap::
CopyBits (Bitmap & b, int tops, int lefts, int topd, int leftd, int length, int width, int reverse)
{
  int factor = 1;
  if (reverse)
    factor = -1;
  int ld = leftd;		//0;

  if (reverse)
    ld = leftd + width;
  int td = Height - topd;
  int ls = lefts;
  int ts = b.Height - tops;

// fstream debug("debug.txt",ios::app);
  //      debug<<"b.Width="<<b.Width<<".  b.Height="<<b.Height<<endl;
  /*      debug<<"B's bits:"<<endl;
     for (int y=0;y<b.Height;y++)
     {
     for (int x=0;x<b.Width;x++)
     debug<<(int)b.Data[x+(b.Width*y)]<<" ";
     debug<<endl;
     } */
//      debug<<"Colors="<<b.Colors<<endl;
  // debug<<endl;
  // debug.close();
  for (int y = 0; y < width; y++)
    for (int x = 0; x < length; x++)
      Data[(ld + (factor * x)) + (Width * (td - y))] = b.Data[(ls + x) + (b.Width * (ts - y))];

}
