#include "Body.h"

// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


Body::Body():Head(),Hip(),LeftFoot(),LeftHand(),LeftLowerArm(),
             LeftShin(),LeftThigh(),LeftUpperArm(),Neck(),
													RightFoot(),RightHand(),RightLowerArm(),
													RightShin(),RightThigh(),RightUpperArm(),
													Stick(),Torso()
{
		ConnectParts();
}

Body::Body(Body &b)
{
	Head=b.Head;
	Neck=b.Neck;
	Torso=b.Torso;
	LeftUpperArm=b.LeftUpperArm;
	LeftLowerArm=b.LeftLowerArm;
	LeftHand=b.LeftHand;
	RightUpperArm=b.RightUpperArm;
	RightLowerArm=b.RightLowerArm;
	RightHand=b.RightHand;
 Hip=b.Hip;
	LeftThigh=b.LeftThigh;
	LeftShin=b.LeftShin;
	LeftFoot=b.LeftFoot;
	RightThigh=b.RightThigh;
	RightShin=b.RightShin;
	RightFoot=b.RightFoot;
	Stick=b.Stick;
	ConnectParts();
}

const Body& Body::operator=(const Body &b)
{
	Head=b.Head;
	Neck=b.Neck;
	Torso=b.Torso;
	LeftUpperArm=b.LeftUpperArm;
	LeftLowerArm=b.LeftLowerArm;
	LeftHand=b.LeftHand;
	RightUpperArm=b.RightUpperArm;
	RightLowerArm=b.RightLowerArm;
	RightHand=b.RightHand;
 Hip=b.Hip;
	LeftThigh=b.LeftThigh;
	LeftShin=b.LeftShin;
	LeftFoot=b.LeftFoot;
	RightThigh=b.RightThigh;
	RightShin=b.RightShin;
	RightFoot=b.RightFoot;
	Stick=b.Stick;
	ConnectParts();
	return *this;
}


void Body::SetExtremeZs(/*double **Vertices/*[500][3],*/ double Scale)
{
  Head.SetExtremeZs(/*Vertices,*/ Scale);
  Neck.SetExtremeZs(/*Vertices,*/ Scale);
  Torso.SetExtremeZs(/*Vertices,*/ Scale);
  LeftUpperArm.SetExtremeZs(/*Vertices,*/ Scale);
  LeftLowerArm.SetExtremeZs(/*Vertices,*/ Scale);
  LeftHand.SetExtremeZs(/*Vertices,*/ Scale);
  RightUpperArm.SetExtremeZs(/*Vertices,*/ Scale);
  RightLowerArm.SetExtremeZs(/*Vertices,*/ Scale);
  RightHand.SetExtremeZs(/*Vertices,*/ Scale);
  Hip.SetExtremeZs(/*Vertices,*/ Scale);
  LeftThigh.SetExtremeZs(/*Vertices,*/ Scale);
  LeftShin.SetExtremeZs(/*Vertices,*/ Scale);
  LeftFoot.SetExtremeZs(/*Vertices,*/ Scale);
  RightThigh.SetExtremeZs(/*Vertices,*/ Scale);
  RightShin.SetExtremeZs(/*Vertices,*/ Scale);
  RightFoot.SetExtremeZs(/*Vertices,*/ Scale);
  Stick.SetExtremeZs(/*Vertices,*/ Scale);
}

void Body::ConnectParts()
// Builds the tree by explictly stating connections
{
	Hip.SetChild(&LeftThigh);
	LeftThigh.SetSibling(&RightThigh);
	RightThigh.SetSibling(&Torso);
	Torso.SetChild(&RightUpperArm);
	RightUpperArm.SetSibling(&LeftUpperArm);
	LeftUpperArm.SetSibling(&Neck);
	Neck.SetChild(&Head);
	RightUpperArm.SetChild(&RightLowerArm);
	RightLowerArm.SetChild(&RightHand);
	LeftUpperArm.SetChild(&LeftLowerArm);
	LeftLowerArm.SetChild(&LeftHand);
	LeftThigh.SetChild(&LeftShin);
	RightThigh.SetChild(&RightShin);
 LeftShin.SetChild(&LeftFoot);
	RightShin.SetChild(&RightFoot);
	LeftHand.SetChild(&Stick);

	Hip.SetHighLow(0);
	LeftThigh.SetHighLow(0);
	RightThigh.SetHighLow(0);
	Torso.SetHighLow(1);
	RightUpperArm.SetHighLow(0);
	LeftUpperArm.SetHighLow(0);
	Neck.SetHighLow(0);
	RightUpperArm.SetHighLow(0);
	RightLowerArm.SetHighLow(0);
	LeftUpperArm.SetHighLow(0);
	LeftLowerArm.SetHighLow(0);
	LeftThigh.SetHighLow(0);
	RightThigh.SetHighLow(0);
 LeftShin.SetHighLow(0);
	RightShin.SetHighLow(0);
	RightHand.SetHighLow(0);

}

