// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "BodyPart.h"
#ifdef USEMFC
#include <GL/gl.h>
#endif
#ifndef USEMFC
#include <GL/glut.h>
#endif
#include <fstream>
#include <string>
#include "Vector.h"
#include <math.h>

using namespace std;

BodyPart::BodyPart ():Angles ()
{
  Child = NULL;
  Sibling = NULL;
  MaxZ = 0;
  MinZ = 0;
  MaxX = 0;
  MinX = 0;
  MaxY = 0;
  MinY = 0;
  StartIndex = 0;
  EndIndex = 0;
  DisplayListIdentifier = 0;
  Vertices = new int *[20];
  for (int x = 0; x < 20; x++)
    Vertices[x] = new int[6];
}

BodyPart::~BodyPart ()
{
 for (int x = 0; x < TotalNumberOfPoints; x++)
  delete[] Points[x];
 for (int i = 0; i < NumFaces; i++)
    delete[]Vertices[i];
 delete[]NumVertices;
}

BodyPart::BodyPart (BodyPart & b)
{
  //  cout<<"Copying a body part.."<<endl;
  int i, j, x;
  Points = b.Points;//new double*[b.TotalNumberOfPoints];
  //  for (i = 0; i < b.TotalNumberOfPoints; i++)
  //   Points[i] = new double[3];
  TotalNumberOfPoints = b.TotalNumberOfPoints;
  Location = b.Location;

  Vertices = b.Vertices;//new int *[b.NumFaces];
  //  for (x = 0; x < b.NumFaces; x++)
  //    Vertices[x] = new int[b.NumVertices[x]];
  //  for (i = 0; i < b.NumFaces; i++)
  //    for (j = 0; j < b.NumVertices[i]; j++)
  //      Vertices[i][j] = b.Vertices[i][j];
  NumFaces = b.NumFaces;
  NumVertices = b.NumVertices;//new int[b.NumFaces];
  //  for (i = 0; i < b.NumFaces; i++)
  //    NumVertices[i] = b.NumVertices[i];

  Child = b.Child;
  Sibling = b.Sibling;
  MaxZ = b.MaxZ;
  MinZ = b.MinZ;
  MaxX = b.MaxX;
  MinX = b.MinX;
  MaxY = b.MaxY;
  MinY = b.MinY;
  StartIndex = b.StartIndex;
  EndIndex = b.EndIndex;
  DisplayListIdentifier = b.DisplayListIdentifier;
  Angles = b.Angles;
  HighLow = b.HighLow;  
}


const BodyPart & BodyPart::operator = (const BodyPart & b)
{
  //   cout<<"Copying a body part.."<<endl;
  int i, j, x;
  Points = b.Points;//new double*[b.TotalNumberOfPoints];
  //  for (i = 0; i < b.TotalNumberOfPoints; i++)
  //   Points[i] = new double[3];
  TotalNumberOfPoints = b.TotalNumberOfPoints;
  Location = b.Location;

  Vertices = b.Vertices;//new int *[b.NumFaces];
  //  for (x = 0; x < b.NumFaces; x++)
  //    Vertices[x] = new int[b.NumVertices[x]];
  //  for (i = 0; i < b.NumFaces; i++)
  //    for (j = 0; j < b.NumVertices[i]; j++)
  //      Vertices[i][j] = b.Vertices[i][j];
  NumFaces = b.NumFaces;
  NumVertices = b.NumVertices;//new int[b.NumFaces];
  //  for (i = 0; i < b.NumFaces; i++)
  //    NumVertices[i] = b.NumVertices[i];

  Child = b.Child;
  Sibling = b.Sibling;
  MaxZ = b.MaxZ;
  MinZ = b.MinZ;
  MaxX = b.MaxX;
  MinX = b.MinX;
  MaxY = b.MaxY;
  MinY = b.MinY;
  StartIndex = b.StartIndex;
  EndIndex = b.EndIndex;
  DisplayListIdentifier = b.DisplayListIdentifier;
  Angles = b.Angles;
  HighLow = b.HighLow;  
  return *this;
 }

void BodyPart::Load(fstream &acfile)
{
 string token;
 acfile>>token;  // loc
 acfile>>Location.X>>Location.Y>>Location.Z;
 acfile>>token; // numvert
 acfile>>TotalNumberOfPoints;
 // cout<<"Total Number of Distinct Points is "<<TotalNumberOfPoints<<". ";
 Points = new double*[TotalNumberOfPoints];
 for (int k = 0; k < TotalNumberOfPoints; k++)
  Points[k] = new double[3];
 for (int x = 0; x < TotalNumberOfPoints; x++)
 {
  acfile>>Points[x][0]>>Points[x][1]>>Points[x][2];
  Points[x][0] += Location.X;
  Points[x][1] += Location.Y;
  Points[x][2] += Location.Z;
 }
 acfile>>token; //numsurf
 acfile>>NumFaces;
 // cout<<"NumFaces is "<<NumFaces<<endl;
 Vertices = new int*[NumFaces];
 NumVertices = new int[NumFaces];
 for (int i = 0; i < NumFaces; i++)
 {
  acfile>>token>>token>>token>>token; // SURF 0xXX mat X
  acfile>>token>>NumVertices[i]; //refs X
  //  cout<<"Face "<<i<<", number of vertices is "<<NumVertices[i]<<endl;
  Vertices[i] = new int[NumVertices[i]];
  //  cout<<"Vertices are ";
  for (int j = 0; j < NumVertices[i]; j++)
  {
   acfile>>Vertices[i][j]>>token>>token; //ignore tex coords for now
   //   cout<<Vertices[i][j]<<" "<<flush;
  }
  //  cout<<endl;
 }
 acfile >> token>>token; // kids X
}

#ifdef USEMFC
void BodyPart::Save (CArchive & out)
				//fstream &out)
  {
//      out<<endl;
  for (int y = 0; y < 6; y++)
  {
  out << NumVertices[y];	//<<endl;
   for (int x = 0; x < NumVertices[y]; x++)
  out << Vertices[x][y];	//<<" ";
    //out<<endl;
  }
  }
#endif

#ifndef USEMFC
void BodyPart::Save (fstream & out)
				//fstream &out)
  {
//      out<<endl;
  for (int y = 0; y < 6; y++)
  {
  out << NumVertices[y];	//<<endl;
   for (int x = 0; x < NumVertices[y]; x++)
  out << Vertices[x][y];	//<<" ";
    //out<<endl;
  }
  }
#endif

/*void BodyPart::SetVertices (int **vertices, int numvertices[6])
  {
  int x, y, j;
  for (x = 0; x < 6; x++)
  NumVertices[x] = numvertices[x];
  for (y = 0; y < 6; y++)
  for (j = 0; j < NumVertices[y]; j++)
  Vertices[j][y] = vertices[j][y];
  }
*/

void BodyPart::AddVertex (int Vertex1, int Vertex2, int NewVertex)
  {
  for (int y = 0; y < 6; y++)
  for (int x = 0; x < NumVertices[y] - 1; x++)
  if ((Vertices[x][y] == Vertex1 && Vertices[x + 1][y] == Vertex2) ||
      (Vertices[x][y] == Vertex2 && Vertices[x + 1][y] == Vertex1))
  {
  for (int z = NumVertices[y]; z > x + 1; z--)
  Vertices[z][y] = Vertices[z - 1][y];
  Vertices[x + 1][y] = NewVertex;
  NumVertices[y]++;
  }
  }

void BodyPart::CreateDisplayList (int identifier,/* double **vertices /*[300][3] ,*/ double Scale)
// Declares a display list for this body part from the provided
// vertex list, starting at StartIndex and ending at EndIndex, as found in the
// loading process by the delimiters in the file
  {
  DisplayListIdentifier = identifier;
  glNewList ((GLuint) DisplayListIdentifier, GL_COMPILE);
  for (int y = 0; y < NumFaces; y++)
  {
    // glBegin (GL_POLYGON);
    glBegin (GL_TRIANGLE_FAN);
    //    glBegin(GL_LINE_LOOP);
    //              cout<<"Begin. Max="<<NumVertices[y]<<endl;
  double maxx = MaxX / Scale;
  double maxy = MaxY / Scale;
  double minx = MinX / Scale;
  double miny = MinY / Scale;

  double texx=0, texy=0;
  for (int x = 0; x < NumVertices[y]; x++)
  { 
   texy = Points[Vertices[y][x]][2] / 13;

   double xoffset = Points[Vertices[y][x]][0] - minx;
   double centerx = 0;//minx + ((maxx - minx) / 2);
   double centery = 0;//miny + ((maxy - miny) / 2);
   //double centerz = 0;
	Vector m(Points[Vertices[y][x]][0],
	         Points[Vertices[y][x]][1],
			 Points[Vertices[y][x]][2]);
	Vector c(centerx, centery, m.GetZ());
	Vector n = m - c;
	double xoff = 0;
	n.Reduce();
//			texx = (n.GetX() + 1)/2;
//			texx = (n.GetX()/4)+.25;
//			if (n.GetY() < 0)
//			 texx += .5;
	texx = n.GetX()/4;
    if (n.GetX() >= 0 && n.GetY() >= 0)
	 texx = (.25-fabs(texx)) + 0;
    else if (n.GetX() < 0 && n.GetY() >= 0)
     texx = (fabs(texx)) + .25;
	else if (n.GetX() < 0 && n.GetY() < 0)
     texx = (.25-fabs(texx)) + .5;
	else if (n.GetX() >= 0 && n.GetY() < 0)
	 texx = (fabs(texx)) + .75;

	if (texx > 1 || texx < 0)
		 cout<<"Ack!"<<endl;


    glTexCoord2f (texx, texy);
  //  else
    //  if (y < 4)
    //  glTexCoord2f ((Points[Vertices[y][x]][0] + 15 + (90 * y - 2)) / 20, Points[Vertices[y][x]][2] / 15);
  //  else
  //  if (y < 6)
  //  glTexCoord2f ((Points[Vertices[y][x]][1]) / 30 + .25, Points[Vertices[y][x]][2] / 15);
//                      cout<<"Drawing "<<vertices[Vertices[x][y]][0]<<" "<<vertices[Vertices[x][y]][1]<<" "<<vertices[Vertices[x][y]][2]<<"  ("<<Vertices[x][y]<<")"<<endl;
  glVertex3f (Points[Vertices[y][x]][0] * Scale, Points[Vertices[y][x]][1] * Scale, Points[Vertices[y][x]][2] * Scale);
  }
  glEnd ();
  }

//      if (glGetError())
  //              MessageBox(NULL,"Bad Bad Bad","!!!",MB_OK);
  /*      int currentpart=0;
     int x=StartIndex;
     while (x<EndIndex)
     {
     //#ifdef GLUT
     //  glBegin(GL_LINE_LOOP);
     //#else
     //           glBegin(GL_POLYGON);
     glBegin(GL_TRIANGLE_FAN); // Triangle fans are rumored to render faster than polygons
     //#endif
     // The end of a polygon is shown by 999's as all three coordinates.
     while (Vertices[x][0]!=999&&Vertices[x][1]!=999&&Vertices[x][2]!=999)
     {
     if (currentpart<2)
     glTexCoord2f((Vertices[x][0]+15+(90*currentpart))/120,Vertices[x][2]/75);
     else if (currentpart<4)
     glTexCoord2f((Vertices[x][0]+15+(90*currentpart-2))/120,Vertices[x][2]/75);
     else if (currentpart<6)
     glTexCoord2f((Vertices[x][1])/30+.25,Vertices[x][2]/75);
     glVertex3f(Vertices[x][0]*Scale,Vertices[x][1]*Scale,Vertices[x][2]*Scale);
     x++;
     }
     glEnd();
     currentpart++;
     x++;
     } */


  glEndList ();
/*      if (glGetError()==GL_INVALID_VALUE)
   MessageBox(NULL,"Invalid Value","!!!",MB_OK);
   if (glGetError()==GL_INVALID_ENUM)
   MessageBox(NULL,"Invalid Enum","!!!",MB_OK);
   if (glGetError()==GL_INVALID_OPERATION)
   MessageBox(NULL,"Invalid Value","!!!",MB_OK);
 */
  }

#ifdef USEMFC
void BodyPart::Draw2d (CDC & pDC, int ZoomFactor, int XOffset, int YOffset, int Dimension1, int Dimension2, double **RealVertices)
  {
  for (int y = 0; y < 6; y++)
  {
  if (NumVertices[y] > 0)
  pDC.MoveTo (ZoomFactor * RealVertices[Vertices[0][y]][Dimension1] + XOffset, YOffset - (ZoomFactor * RealVertices[Vertices[0][y]][Dimension2]));
  for (int x = 1; x < NumVertices[y]; x++)
  {
//      CBrush br(RGB(10*(Vertices[x][0]+50), 10*(Vertices[x][1]+20), 3*Vertices[x][2]));
      //              CBrush *old=MemoryDC.SelectObject(&br);
  pDC.LineTo (ZoomFactor * RealVertices[Vertices[x][y]][Dimension1] + XOffset, YOffset - (ZoomFactor * RealVertices[Vertices[x][y]][Dimension2]));
//              MemoryDC.SelectObject(old);
  }
  if (NumVertices[y] > 0)
  pDC.LineTo (ZoomFactor * RealVertices[Vertices[0][y]][Dimension1] + XOffset, YOffset - (ZoomFactor * RealVertices[Vertices[0][y]][Dimension2]));
  }
  }
#endif

void BodyPart::Draw (/*double **vertices,*/ int DrawMode)
// Render the body part.  This is typically called from the 
// root of the tree and allowed to recurse.
  {
  glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
  glPushMatrix ();		// preserve the current matrix state
   if (Sibling != NULL)		// display any others on this level of the hierarchy
     Sibling->Draw (/*vertices,*/ DrawMode);
  glPopMatrix ();
  if (HighLow == 0)		// If this is not the torso, translate to its top point for rotation
   glTranslatef (MinX + ((MaxX - MinX) / 2), MinY + ((MaxY - MinY) / 2), MaxZ);
  else				// if this is the torso, translate to its bottom point

  glTranslatef (MinX + ((MaxX - MinX) / 2), MinY + ((MaxY - MinY) / 2), MinZ);
  glRotatef (Angles.X, 1, 0, 0);	// rotate appropriately around all three axes
   glRotatef (Angles.Y, 0, 1, 0);
  glRotatef (Angles.Z, 0, 0, 1);
  //if (Angles.X!=0)
  //     cout<<"Rotation:  "<<Angles.X<<" "<<Angles.Y<<" "<<Angles.Z<<endl;
  if (HighLow == 0)		// translate back, since the body parts are not centered at the origin
   glTranslatef (-(MinX + ((MaxX - MinX) / 2)), -(MinY + ((MaxY - MinY) / 2)), -MaxZ);
  else
  glTranslatef (-(MinX + ((MaxX - MinX) / 2)), -(MinY + ((MaxY - MinY) / 2)), -MinZ);
//      fstream debug("debug.txt",ios::app);
  //      debug<<"calling list "<<DisplayListIdentifier<<endl;
  //debug<<" startindex="<<StartIndex<<".  endindex="<<EndIndex<<endl;
  //      debug.close();
  for (int y = 0; y < 6; y++)
  {
  if (DrawMode == 0)
  glBegin (GL_LINE_LOOP);
  else
  if (DrawMode == 1)
  glBegin (GL_TRIANGLE_FAN);
//                              glBegin(GL_LINE_LOOP);
    //              cout<<"Begin. Max="<<NumVertices[y]<<endl;
  for (int x = 0; x < NumVertices[y]; x++)
  {
  if (y < 2)
  glTexCoord2f ((Points[Vertices[x][y]][0] + 15 + (90 * y)) / 120, Points[Vertices[x][y]][2] / 75);
  else
  if (y < 4)
  glTexCoord2f ((Points[Vertices[x][y]][0] + 15 + (90 * y - 2)) / 120, Points[Vertices[x][y]][2] / 75);
  else
  if (y < 6)
  glTexCoord2f ((Points[Vertices[x][y]][1]) / 30 + .25, Points[Vertices[x][y]][2] / 75);
//                      cout<<"Drawing "<<vertices[Vertices[x][y]][0]<<" "<<vertices[Vertices[x][y]][1]<<" "<<vertices[Vertices[x][y]][2]<<"  ("<<Vertices[x][y]<<")"<<endl;
  glVertex3f (Points[Vertices[x][y]][0], Points[Vertices[x][y]][1], Points[Vertices[x][y]][2]);
  }
  glEnd ();
  }
  if (Child != NULL)		// draw any parts further down the hierarchy using this matrix
    Child->Draw (/*vertices,*/ DrawMode);
  }



void BodyPart::Display ()
// Render the body part.  This is typically called from the 
// root of the tree and allowed to recurse.
  {
  glTexEnvf (GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
  glPushMatrix ();		// preserve the current matrix state
   if (Sibling != NULL)		// display any others on this level of the hierarchy
   Sibling->Display ();
  glPopMatrix ();
  if (HighLow == 0)		// If this is not the torso, translate to its top point for rotation
    glTranslatef (MinX + ((MaxX - MinX) / 2), MinY + ((MaxY - MinY) / 2), MaxZ);
  else				// if this is the torso, translate to its bottom point

    glTranslatef (MinX + ((MaxX - MinX) / 2), MinY + ((MaxY - MinY) / 2), MinZ);
  glRotatef (Angles.X, 1, 0, 0);	// rotate appropriately around all three axes
   glRotatef (Angles.Y, 0, 1, 0);
  glRotatef (Angles.Z, 0, 0, 1);
  //if (Angles.X!=0)
  //     cout<<"Rotation:  "<<Angles.X<<" "<<Angles.Y<<" "<<Angles.Z<<endl;
  if (HighLow == 0)		// translate back, since the body parts are not centered at the origin
    glTranslatef (-(MinX + ((MaxX - MinX) / 2)), -(MinY + ((MaxY - MinY) / 2)), -MaxZ);
  else
    glTranslatef (-(MinX + ((MaxX - MinX) / 2)), -(MinY + ((MaxY - MinY) / 2)), -MinZ);
//      fstream debug("debug.txt",ios::app);
  //      debug<<"calling list "<<DisplayListIdentifier<<endl;
  //debug<<" startindex="<<StartIndex<<".  endindex="<<EndIndex<<endl;
  //      debug.close();
  glCallList (DisplayListIdentifier);	// draw the part
   if (Child != NULL)		// draw any parts further down the hierarchy using this matrix
   Child->Display ();
  }



void BodyPart::SetChild (BodyPart * child)
  {
  Child = child;
  }

void BodyPart::SetSibling (BodyPart * sibling)
  {
  Sibling = sibling;
  }

void BodyPart::SetExtremeZs (/*double **vertices /*[300][3]  ,*/ double Scale)
// Records the most exreme points of a body part
// This is used to determine where to translate to when
// rendering, and for determining the lengths and widths
// of individual body parts
  {
/*      double currenthigh=Vertices[StartIndex][2]*Scale;
   double currentlow=Vertices[StartIndex][2]*Scale;
   double currenthighx=Vertices[StartIndex][0]*Scale;
   double currentlowx=Vertices[StartIndex][0]*Scale;
   double currenthighy=Vertices[StartIndex][1]*Scale;
   double currentlowy=Vertices[StartIndex][1]*Scale;
   int index=StartIndex+1;
   while (index<=EndIndex)
   {
   if (Vertices[index][2]*Scale>currenthigh&&Vertices[index][2]!=999)
   currenthigh=Vertices[index][2]*Scale;
   if (Vertices[index][2]*Scale<currentlow)
   currentlow=Vertices[index][2]*Scale;
   if (Vertices[index][1]*Scale>currenthighy&&Vertices[index][1]!=999)
   currenthighy=Vertices[index][1]*Scale;
   if (Vertices[index][1]*Scale<currentlowy)
   currentlowy=Vertices[index][1]*Scale;
   if (Vertices[index][0]*Scale>currenthighx&&Vertices[index][0]!=999)
   currenthighx=Vertices[index][0]*Scale;
   if (Vertices[index][0]*Scale<currentlowx)
   currentlowx=Vertices[index][0]*Scale;
   index++;
   }
   MaxZ=currenthigh;
   MinZ=currentlow;
   MaxX=currenthighx;
   MinX=currentlowx;
   MaxY=currenthighy;
   MinY=currentlowy;
 */
//      for (int x=0;x<6;x++)
  //              cout<<NumVertices[x]<<" ";
  // cout<<endl;
    //  cout<<"Setting extreme z's for a part.."<<endl;
  double currenthigh = Points[Vertices[0][0]][2] * Scale;
  double currentlow = Points[Vertices[0][0]][2] * Scale;
  double currenthighx = Points[Vertices[0][0]][0] * Scale;
  double currentlowx = Points[Vertices[0][0]][0] * Scale;
  double currenthighy = Points[Vertices[0][0]][1] * Scale;
  double currentlowy = Points[Vertices[0][0]][1] * Scale;
  //  cout<<"At least part of this is valid...NumFaces is "<<NumFaces<<endl;

  for (int y = 0; y < NumFaces; y++)
  for (int x = 0; x < NumVertices[y]; x++)
  {
    //    cout<<"Y = "<<y<<", X = "<<x<<".  Points = "<<Vertices[y][x]<<". "<<flush;
  if (Points[Vertices[y][x]][2] * Scale > currenthigh)
  currenthigh = Points[Vertices[y][x]][2] * Scale;
  if (Points[Vertices[y][x]][2] * Scale < currentlow)
  currentlow = Points[Vertices[y][x]][2] * Scale;
  if (Points[Vertices[y][x]][1] * Scale > currenthighy)
  currenthighy = Points[Vertices[y][x]][1] * Scale;
  if (Points[Vertices[y][x]][1] * Scale < currentlowy)
  currentlowy = Points[Vertices[y][x]][1] * Scale;
  if (Points[Vertices[y][x]][0] * Scale > currenthighx)
  currenthighx = Points[Vertices[y][x]][0] * Scale;
  if (Points[Vertices[y][x]][0] * Scale < currentlowx)
  currentlowx = Points[Vertices[y][x]][0] * Scale;
  }
  //  cout<<endl;
  MaxZ = currenthigh;
  MinZ = currentlow;
  MaxX = currenthighx;
  MinX = currentlowx;
  MaxY = currenthighy;
  MinY = currentlowy;
  //  cout<<"Done with this part."<<endl;
  }

void BodyPart::SetStartIndex (int startindex)
  {
  StartIndex = startindex;
  }

void BodyPart::SetEndIndex (int endindex)
  {
  EndIndex = endindex;
  }

BodyPart * BodyPart::GetChild ()
  {
  return Child;
  }

BodyPart * BodyPart::GetSibling ()
  {
  return Sibling;
  }

double BodyPart::GetMaxZ ()
  {
  return MaxZ;
  }

double BodyPart::GetMinZ ()
  {
  return MinZ;
  }

double BodyPart::GetLength ()
  {
  return MaxZ - MinZ;
  }

int BodyPart::GetStartIndex ()
  {
  return StartIndex;
  }

int BodyPart::GetEndIndex ()
  {
  return EndIndex;
  }

void BodyPart::SetHighLow (int highlow)
  {
  HighLow = highlow;
  }
