// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#include "Point.h"
#include <fstream>
using namespace std;

#ifdef USEMFC
#include "stdafx.h"
#endif

#ifndef BODYPART
#define BODYPART

class BodyPart
{
  public:
  BodyPart ();
  ~BodyPart ();
  BodyPart (BodyPart & b);
  const BodyPart & operator = (const BodyPart & b);
  void Display ();
  void Draw (/*double **vertices,*/ int DrawMode);
#ifdef USEMFC
  void Draw2d (CDC & pDC, int ZoomFactor, int XOffset, int YOffset, int Dimension1, int Dimension2, double **RealVertices);
  void Save (CArchive & out);	//fstream &out);
#endif
#ifndef USEMFC
  void Save (fstream & out);	//fstream &out);
#endif
  //  void SetVertices (int **vertices, int numvertices[6]);
  void AddVertex (int Vertex1, int Vertex2, int NewVertex);
  void CreateDisplayList (int identifier, /*double ** /*vertices[300][3] ,*/ double Scale);
  void SetChild (BodyPart * child);
  void SetSibling (BodyPart * sibling);
  void SetExtremeZs (/*double **Vertices /*[300][3]  ,*/ double Scale);
  void SetHighLow (int highlow);
  void SetStartIndex (int startindex);
  void SetEndIndex (int endindex);
  void SetAngles (Point angle);
  void Load(fstream &acfile);
  BodyPart *GetChild ();
  BodyPart *GetSibling ();
  double GetMaxZ ();
  double GetMinZ ();
  double GetLength ();
  int GetStartIndex ();
  int GetEndIndex ();
  Point Angles;
 private:
  BodyPart * Child;
  BodyPart *Sibling;
  double MaxZ;
  double MinZ;
  double MaxY;
  double MinY;
  double MaxX;
  double MinX;
  int NumFaces;
  int TotalNumberOfPoints;
  Point Location;
  double **Points;
  int *NumVertices;
  int **Vertices;
  int HighLow;
  int StartIndex;
  int EndIndex;
  int DisplayListIdentifier;
};

#endif
