// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


// CoachDialog.cpp : implementation file
//

#include "stdafx.h"
//#include "simulator.h"
#include "CoachDialog.h"
#include "HomePositionDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCoachDialog dialog


CCoachDialog::CCoachDialog(CoachSettings* coach, PositionData *Home, CWnd* pParent /*=NULL*/)
	: CDialog(CCoachDialog::IDD, pParent)
{
	Coach=coach;
	Positions=Home;
	//{{AFX_DATA_INIT(CCoachDialog)
	//}}AFX_DATA_INIT
}


void CCoachDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCoachDialog)
	DDX_Control(pDX, IDC_STAYHOMEATTACK, m_StayHomeAttack);
	DDX_Control(pDX, IDC_STAYHOME, m_StayHomeLabel);
	DDX_Control(pDX, IDC_SLOWBREAKOUT, m_SlowBreakoutLabel);
	DDX_Control(pDX, IDC_SHOTAGGRESSION, m_ShotAggression);
	DDX_Control(pDX, IDC_SHOOTRARELY, m_ShootRarelyLabel);
	DDX_Control(pDX, IDC_SHOOTOFTEN, m_ShootOftenLabel);
	DDX_Control(pDX, IDC_PLAYPUCK, m_PlayPuckLabel);
	DDX_Control(pDX, IDC_PASSMORE, m_PassMoreLabel);
	DDX_Control(pDX, IDC_PLAYMAN, m_PlayManLabel);
	DDX_Control(pDX, IDC_PASSDUMP, m_PassDump);
	DDX_Control(pDX, IDC_NUMBER, m_NumberOfForecheckers);
	DDX_Control(pDX, IDC_MANPUCK, m_ManPuck);
	DDX_Control(pDX, IDC_FORECHECKINGAGGRESSION, m_ForecheckingAggression);
	DDX_Control(pDX, IDC_FASTBREAKOUT, m_FastBreakoutLabel);
	DDX_Control(pDX, IDC_DUMPMORE, m_DumpMoreLabel);
	DDX_Control(pDX, IDC_COVERAGE, m_CoverageBox);
	DDX_Control(pDX, IDC_CONSERVATIVE, m_ConservativeLabel);
	DDX_Control(pDX, IDC_COACHTAB, m_CoachTab);
	DDX_Control(pDX, IDC_BREAKOUT, m_Breakout);
	DDX_Control(pDX, IDC_ATTACK, m_AttackLabel);
	DDX_Control(pDX, IDC_AGGRESSIVE, m_AggressiveLabel);
	DDX_Control(pDX, IDC_ONE, m_OneForechecker);
	DDX_Control(pDX, IDC_TWO, m_TwoForecheckers);
	DDX_Control(pDX, IDC_THREE, m_ThreeForecheckers);
	DDX_Control(pDX, IDC_MANTOMAN, m_ManToMan);
	DDX_Control(pDX, IDC_ZONE, m_Zone);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCoachDialog, CDialog)
	//{{AFX_MSG_MAP(CCoachDialog)
	ON_NOTIFY(TCN_SELCHANGE, IDC_COACHTAB, OnSelchangeCoachtab)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	ON_BN_CLICKED(IDC_EDITPOSITIONS, OnEditpositions)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCoachDialog message handlers

void CCoachDialog::ShowPage(int page)
{
 m_AggressiveLabel.ShowWindow(SW_HIDE);
 m_AttackLabel.ShowWindow(SW_HIDE);
 m_Breakout.ShowWindow(SW_HIDE);
 m_ConservativeLabel.ShowWindow(SW_HIDE);
 m_CoverageBox.ShowWindow(SW_HIDE);
 m_DumpMoreLabel.ShowWindow(SW_HIDE);
 m_FastBreakoutLabel.ShowWindow(SW_HIDE);
 m_ForecheckingAggression.ShowWindow(SW_HIDE);
 m_ManPuck.ShowWindow(SW_HIDE);
 m_NumberOfForecheckers.ShowWindow(SW_HIDE);
 m_PassDump.ShowWindow(SW_HIDE);
 m_PassMoreLabel.ShowWindow(SW_HIDE);
 m_PlayManLabel.ShowWindow(SW_HIDE);
 m_PlayPuckLabel.ShowWindow(SW_HIDE);
 m_ShootOftenLabel.ShowWindow(SW_HIDE);
 m_ShootRarelyLabel.ShowWindow(SW_HIDE);
 m_ShotAggression.ShowWindow(SW_HIDE);
 m_SlowBreakoutLabel.ShowWindow(SW_HIDE);
 m_StayHomeAttack.ShowWindow(SW_HIDE);
 m_StayHomeLabel.ShowWindow(SW_HIDE);
 m_OneForechecker.ShowWindow(SW_HIDE);
 m_TwoForecheckers.ShowWindow(SW_HIDE);
 m_ThreeForecheckers.ShowWindow(SW_HIDE);
 m_ManToMan.ShowWindow(SW_HIDE);
 m_Zone.ShowWindow(SW_HIDE);

	switch(page)
	{
	case 0:
		m_Breakout.ShowWindow(SW_SHOW);
		m_DumpMoreLabel.ShowWindow(SW_SHOW);
		m_FastBreakoutLabel.ShowWindow(SW_SHOW);
		m_PassDump.ShowWindow(SW_SHOW);
  m_PassMoreLabel.ShowWindow(SW_SHOW);
		m_ShootOftenLabel.ShowWindow(SW_SHOW);
		m_ShootRarelyLabel.ShowWindow(SW_SHOW);
		m_ShotAggression.ShowWindow(SW_SHOW);
		m_SlowBreakoutLabel.ShowWindow(SW_SHOW);
		break;
	case 1:
		m_AttackLabel.ShowWindow(SW_SHOW);
		m_CoverageBox.ShowWindow(SW_SHOW);
		m_ManPuck.ShowWindow(SW_SHOW);
		m_PlayManLabel.ShowWindow(SW_SHOW);
		m_PlayPuckLabel.ShowWindow(SW_SHOW);
		m_StayHomeAttack.ShowWindow(SW_SHOW);
		m_StayHomeLabel.ShowWindow(SW_SHOW);
  m_ManToMan.ShowWindow(SW_SHOW);
  m_Zone.ShowWindow(SW_SHOW);
		break;
	case 2:
		m_AggressiveLabel.ShowWindow(SW_SHOW);
		m_ConservativeLabel.ShowWindow(SW_SHOW);
		m_ForecheckingAggression.ShowWindow(SW_SHOW);
		m_NumberOfForecheckers.ShowWindow(SW_SHOW); 
  m_OneForechecker.ShowWindow(SW_SHOW);
  m_TwoForecheckers.ShowWindow(SW_SHOW);
  m_ThreeForecheckers.ShowWindow(SW_SHOW);
		break;
 }
}

void CCoachDialog::OnSelchangeCoachtab(NMHDR* pNMHDR, LRESULT* pResult) 
{
	ShowPage(m_CoachTab.GetCurSel());
	*pResult = 0;
}

void CCoachDialog::OnOK() 
{
	OnApply();
	CDialog::OnOK();
}

void CCoachDialog::OnApply() 
{
	Coach->Breakout=m_Breakout.GetPos();
	if (m_ManToMan.GetCheck()==1)
		Coach->Coverage=1;
	else
		Coach->Coverage=0;
	Coach->ForecheckingAggression=m_ForecheckingAggression.GetPos();
	Coach->ManPuck=m_ManPuck.GetPos();
	if (m_OneForechecker.GetCheck()==1)
		Coach->NumForeCheckers=1;
	else if (m_TwoForecheckers.GetCheck()==1)
		Coach->NumForeCheckers=2;
	else
		Coach->NumForeCheckers=3;
	Coach->PassDump=m_PassDump.GetPos();
	Coach->ShotAggression=m_ShotAggression.GetPos();
	Coach->StayHomeAttack=m_StayHomeAttack.GetPos();
}

void CCoachDialog::SetupControls()
{
	m_Breakout.SetRange(0,100);
	m_Breakout.SetPos(Coach->Breakout);
	if (Coach->Coverage==0)
	{
		m_ManToMan.SetCheck(0);
		m_Zone.SetCheck(1);
	}
	else
	{
		m_ManToMan.SetCheck(1);
		m_Zone.SetCheck(0);
	}
	m_ForecheckingAggression.SetRange(0,100);
 m_ForecheckingAggression.SetPos(Coach->ForecheckingAggression);
	m_ManPuck.SetRange(0,100);
	m_ManPuck.SetPos(Coach->ManPuck);
	m_OneForechecker.SetCheck(0);
	m_TwoForecheckers.SetCheck(0);
	m_ThreeForecheckers.SetCheck(0);
	switch (Coach->NumForeCheckers)
 {
	 case 1:m_OneForechecker.SetCheck(1); break;
	 case 2:m_TwoForecheckers.SetCheck(1); break;
	 case 3:m_ThreeForecheckers.SetCheck(1); break;
	}
 m_PassDump.SetRange(0,100);
	m_PassDump.SetPos(Coach->PassDump);
	m_ShotAggression.SetRange(0,100);
	m_ShotAggression.SetPos(Coach->ShotAggression);
	m_StayHomeAttack.SetPos(Coach->StayHomeAttack);
}

BOOL CCoachDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	TC_ITEM x;
	x.mask=TCIF_TEXT;
	x.pszText="Offense";
	m_CoachTab.InsertItem(0,&x);
	x.pszText="Defense";
	m_CoachTab.InsertItem(1,&x);
	x.pszText="Forechecking";
	m_CoachTab.InsertItem(2,&x);
	ShowPage(0);
	SetupControls();
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CCoachDialog::OnEditpositions() 
{
 CHomePositionDialog *x=new CHomePositionDialog(Positions);
	x->DoModal();
}
