// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.

#if !defined(AFX_COACHDIALOG_H__08297272_4635_11D1_B9ED_C7C8D53DE527__INCLUDED_)
#define AFX_COACHDIALOG_H__08297272_4635_11D1_B9ED_C7C8D53DE527__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000
#include "constants.h"
#include "resource.h"
// CoachDialog.h : header file
//

/////////////////////////////////////////////////////////////////////////////
// CCoachDialog dialog

class CCoachDialog : public CDialog
{
// Construction
public:
	CCoachDialog(CoachSettings *coach, PositionData *Home, CWnd* pParent = NULL);   // standard constructor
// Dialog Data
	//{{AFX_DATA(CCoachDialog)
	enum { IDD = IDD_COACHDIALOG };
	CSliderCtrl	m_StayHomeAttack;
	CStatic	m_StayHomeLabel;
	CStatic	m_SlowBreakoutLabel;
	CSliderCtrl	m_ShotAggression;
	CStatic	m_ShootRarelyLabel;
	CStatic	m_ShootOftenLabel;
	CStatic	m_PlayPuckLabel;
	CStatic	m_PassMoreLabel;
	CStatic	m_PlayManLabel;
	CSliderCtrl	m_PassDump;
	CButton	m_NumberOfForecheckers;
	CSliderCtrl	m_ManPuck;
	CSliderCtrl	m_ForecheckingAggression;
	CStatic	m_FastBreakoutLabel;
	CStatic	m_DumpMoreLabel;
	CButton	m_CoverageBox;
	CStatic	m_ConservativeLabel;
	CTabCtrl	m_CoachTab;
	CSliderCtrl	m_Breakout;
	CStatic	m_AttackLabel;
	CStatic	m_AggressiveLabel;
	CButton m_OneForechecker;
	CButton m_TwoForecheckers;
	CButton m_ThreeForecheckers;
	CButton m_ManToMan;
	CButton m_Zone;
	//}}AFX_DATA


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CCoachDialog)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	void SetupControls();
 void ShowPage(int page);
	CoachSettings *Coach;
	PositionData *Positions;
	// Generated message map functions
	//{{AFX_MSG(CCoachDialog)
	afx_msg void OnSelchangeCoachtab(NMHDR* pNMHDR, LRESULT* pResult);
	virtual void OnOK();
	afx_msg void OnApply();
	virtual BOOL OnInitDialog();
	afx_msg void OnEditpositions();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_COACHDIALOG_H__08297272_4635_11D1_B9ED_C7C8D53DE527__INCLUDED_)
