// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


#ifndef CONSTANTS
#define CONSTANTS
#include "Point.h"


const double pi = 3.1415926;

struct CoachSettings
  {
    int Breakout, PassDump, ShotAggression, ForecheckingAggression, NumForeCheckers,
      Coverage, ManPuck, StayHomeAttack;
  };

struct PlayerView
  {
    double X, Y, XVelocity, YVelocity, WantsPuck, Crashing, OnIce, InControl;
    int ID, Position;
  };

struct KeyData
  {
    int left, right, up, down, shoot, pass, dump, linechange, nextplayer;
  };

struct ControlData
  {
    int Coaching, LineChanges, PuckHog, Position, Player;
  };

struct BodyPartStarts
  {
    int Head;
    int Neck;
    int Torso;
    int LeftUpperArm;
    int RightUpperArm;
    int LeftLowerArm;
    int RightLowerArm;
    int LeftHand;
    int RightHand;
    int Hip;
    int LeftThigh;
    int RightThigh;
    int LeftShin;
    int RightShin;
    int LeftFoot;
    int RightFoot;
  };



const int PlayersPerTeam = 20;
const double length = 640;	//the rink length

const double width = 272;	//the rink width

const int TicksPerMinute = 960;
const double TicksPerSecond = (double) TicksPerMinute / 60;

const double BlueLine[2] =
{.71 * (length / 2), length - (.71 * (length / 2))};
const int goallength = 20;	//length of a goal

const int goalwidth = 10;	//width of a goal

const double homegoalx = (.065 * length) - 5;
const double visitorgoalx = (.935 * length) + 5;
const double FrameRate = 3.8;	//somewhat determines the speed of the
//const double FrameRate = 3.8;	//somewhat determines the speed of the
//const double FrameRate = 6;	//somewhat determines the speed of the game
//const int bluelinerel=0;
//const int BlueLine=5;  // :P
//const float FrameRate=5;

const int playerdiameter = 10;	//the size of a player
//const int cornerrel=90;

const int savethreshold = 3;	//< = more saves

const int TrackingTimeFactor = 7;	//Relative importance of Tracking Time and

const double QuicknessFactor = .5;	//goalie quickness in making a save

const int PConChanceFactor = 20;	//Amount of randomness in possession conflict resolution 

const double cornerdecel = 1.10;	//compensate for weird graph things

const double cornerexitaccel = 1.4;	//recompensate

const double minshotquality = 40.0;
const double maxshotquality = 85.0;

class PositionData
//a single player's home positions
{
  public:
  double OffenseX, OffenseY, NeutralX, NeutralY, DefenseX, DefenseY;
};

const int CENTER=0;
const int LEFTWING=1;
const int RIGHTWING=2;
const int LEFTDEFENSE=3;
const int RIGHTDEFENSE=4;

const int NUMLINESPERSITUATION=4;
const int NUMSITUATIONS=12;
const int NUMLINES=NUMLINESPERSITUATION*NUMSITUATIONS;


//database structure for reading in players
typedef struct player {
	//GENERAL ATTRIBUTES 
	int ID;
	int TeamID;	
        int UniformNumber;
	int CaptainStatus;
	int HallOfFamePoints;
	int Age;
	int YearsExperience;
	int Height;
	int Weight;
	int YearsInContract;
	int JuniorLeagueID;
	int DraftPickNumber;
	//PLAYER ATTRIBUTES
	int Intelligence;
	int Attitude;
	int Ego;
	int Discipline;
	int Aggressiveness;
	int SkatingSpeed;
	int Quickness;
	int StickHandling;
	int Passing;
	int PuckControl;
	int Stamina;
	int Durability;
	int FightingAbility;
	int InjuryType;
	int InjuryLength;
	int InjuryVulnerability;
	int ShotPower;
	int ShotAccuracy;
	int Position;
	//SKATER ATTRIBUTES
	int Strength;
	int Checking;
	int Line;
	// GOALIE ATTRIBUTES
	int Blocker;
	int Glove;
	int Stick;
	int Pads;
	int Concentration;
} PLAYER_TYPE;

const int FORWARD = 0;
const int DEFENSE  = 1;
const int GOALIE = 6;
const int LINE1RW = 3;
const int LINE1C = 4;
const int LINE1LW = 5;
const int LINE2RW = 6;
const int LINE2C = 7;
const int LINE2LW = 8;
const int LINE3RW = 9;
const int LINE3C = 10;
const int LINE3LW = 11;
const int LINE4RW = 12;
const int LINE4C = 13;
const int LINE4LW = 14;
const int LINE1RD = 15;
const int LINE1LD = 16;
const int LINE2RD = 17;
const int LINE2LD = 18;
const int LINE3RD = 19;
const int LINE3LD = 20;
const int LINE4RD = 21;
const int LINE4LD = 22;
const int SCRATCH = 23;

const int SND_CROWDLOOP = 1;
const int SND_CROWDEXCITEMAJOR = 2;
const int SND_CROWDEXCITEMINOR = 3;
const int SND_CROWDEXCITEEXTRAMINOR = 4;
const int SND_CROWDUPSET = 5;
const int SND_WHISTLE = 6;
const int SND_PUCKBOARDS = 7;
const int SND_CRUNCH = 8;
const int SND_DUMP = 9;
const int SND_POWERPLAYEND = 10;
const int SND_MISS = 11;
const int SND_DEMANDPASS = 12;
const int SND_PUCKPOST = 13;
const int SND_SHOT = 14;

const int PUCK_HIT_NOTHING = -1;
const int PUCK_HIT_SIDEBOARD = 0;
const int PUCK_HIT_CORNER = 1;
const int PUCK_HIT_POST = 2;
const int PUCK_HIT_BACKBOARD = 3;
#endif
