// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.

// ControlDialog.cpp : implementation file
//

#include "stdafx.h"
//#include "simulator.h"
#include "ControlDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CControlDialog dialog


CControlDialog::CControlDialog(ControlData *d,CWnd* pParent /*=NULL*/)
	: CDialog(CControlDialog::IDD, pParent)
{
	controldata=d;
	//{{AFX_DATA_INIT(CControlDialog)
	//}}AFX_DATA_INIT
}


void CControlDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CControlDialog)
	DDX_Control(pDX, IDC_CONTROLLINECHANGES, m_ControlLineChanges);
	DDX_Control(pDX, IDC_CONTROLCOACHING, m_ControlCoaching);
	DDX_Control(pDX, IDC_POSITIONLIST, m_PositionList);
	DDX_Control(pDX, IDC_PLAYERLIST, m_PlayerList);
	DDX_Control(pDX, IDC_CONTROLPLAYERS, m_ControlPlayers);
	DDX_Control(pDX, IDC_PUCKHOG, m_PuckHog);
	DDX_Control(pDX, IDC_SINGLEPLAYER, m_SinglePlayer);
	DDX_Control(pDX, IDC_SINGLEPOSITION, m_SinglePosition);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CControlDialog, CDialog)
	//{{AFX_MSG_MAP(CControlDialog)
	ON_BN_CLICKED(IDC_CONTROLPLAYERS, OnControlplayers)
	ON_BN_CLICKED(IDC_PUCKHOG, OnPuckhog)
	ON_BN_CLICKED(IDC_SINGLEPLAYER, OnSingleplayer)
	ON_BN_CLICKED(IDC_SINGLEPOSITION, OnSingleposition)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CControlDialog message handlers

void CControlDialog::OnControlplayers() 
{
	if (m_ControlPlayers.GetCheck()==1)
	{
//		m_SinglePlayer.EnableWindow(true);
  m_SinglePosition.EnableWindow(true);
	 m_PuckHog.EnableWindow(true);
	}
	else
	{
		m_SinglePlayer.EnableWindow(false);
  m_SinglePosition.EnableWindow(false);
	 m_PuckHog.EnableWindow(false);
	}
}

void CControlDialog::OnPuckhog() 
{
	m_PositionList.EnableWindow(false);
 m_PlayerList.EnableWindow(false);
	
}

void CControlDialog::OnSingleplayer() 
{
	m_PositionList.EnableWindow(false);
 m_PlayerList.EnableWindow(true);
	
}

void CControlDialog::OnSingleposition() 
{
	m_PositionList.EnableWindow(true);
 m_PlayerList.EnableWindow(false);
	
}

void CControlDialog::OnOK() 
{
	if (m_ControlCoaching.GetCheck()) 
	 controldata->Coaching=1;
	else 
		controldata->Coaching=-1;
	if (m_ControlLineChanges.GetCheck())
	 controldata->LineChanges=1;
	else
		controldata->LineChanges=-1;
	controldata->Player=-1;
	controldata->Position=-1;
	controldata->PuckHog=-1;
	if (m_ControlPlayers.GetCheck())
 {
	 if (m_PositionList.IsWindowEnabled())
	 	controldata->Position=m_PositionList.GetCurSel();
	 else if (m_PlayerList.IsWindowEnabled())
	 	controldata->Player=m_PlayerList.GetCurSel();
	 else if (m_ControlPlayers.GetCheck())
	 	controldata->PuckHog=1;
	}

	CDialog::OnOK();
}

BOOL CControlDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	if (controldata->Coaching==1)
  m_ControlCoaching.SetCheck(1);
	if (controldata->LineChanges==1)
	 m_ControlLineChanges.SetCheck(1);
 if (controldata->Player>-1||
		   controldata->Position>-1||
					controldata->PuckHog>-1)
					m_ControlPlayers.SetCheck(1);
	else
	{
		m_PositionList.EnableWindow(false);
	 m_PlayerList.EnableWindow(false);
	 m_SinglePlayer.EnableWindow(false);
  m_SinglePosition.EnableWindow(false);
  m_PuckHog.EnableWindow(false);
 }
	m_PositionList.ResetContent();
	m_PositionList.AddString("C");
	m_PositionList.AddString("LW");
	m_PositionList.AddString("RW");
	m_PositionList.AddString("LD");
	m_PositionList.AddString("RD");
	m_PositionList.Invalidate();

	/*if (controldata->Player!=-1)
	{
		m_SinglePlayer.SetCheck(1);
		m_PlayerList.EnableWindow(true);
		m_PlayerList.SetCurSel(controldata->Player);
 }
	else*/ if (controldata->Position!=-1)
	{
		m_SinglePosition.SetCheck(1);
		m_PositionList.EnableWindow(true);
		m_PositionList.SetCurSel(controldata->Position);
	}
	else if (controldata->PuckHog==1)
		m_PuckHog.SetCheck(1);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}
