#include <iostream>
#include <fstream>
#include <stdlib.h>
#include "Constants.h"
#include <string.h>
#include "Database.h"

using namespace std;

void ReadPlayer(char *filename, PLAYER_TYPE &myplayer)
{
	fstream inf(filename, ios::in | ios::binary); 
	inf.read((char*) &myplayer, sizeof myplayer);	
}

void WritePlayer(char *filename, PLAYER_TYPE &myplayer)
{
	fstream outf(filename, ios::out | ios::binary | ios::app);
	outf.write((char*)&myplayer, sizeof(myplayer));
	outf.close();
}

int CountPlayersOnTeam(int teamID)
{
	PLAYER_TYPE myplayer; 
	int count = 0 ;
	int team = 0;
	fstream inf("players.dat" , ios::in | ios::binary);
	if (!inf.good())
	  cout<<"Can't open players.dat!"<<endl;
	else
	do {	
		inf.seekg(sizeof(PLAYER_TYPE)*count,ios::beg);
		inf.read((char*) &myplayer, sizeof myplayer);	
		if (myplayer.TeamID == teamID )
			team++;
		count++;
	   	//bzero((void *)&myplayer, sizeof(PLAYER_TYPE) );
	}
	while (!inf.eof());
	inf.close();
	return team;
}

void GetAllSkaters(int teamID ,PLAYERLIST &mylist)
{
	PLAYER_TYPE myplayer;
	int count=0;
	fstream inf("players.dat", ios::in | ios::binary);
	if (!inf.good())
	  cout<<"Can't open players.dat!"<<endl;
	else
	do {
		inf.seekg(sizeof(PLAYER_TYPE)*count, ios::beg);
		inf.read((char*)&myplayer, sizeof myplayer);
		if (myplayer.TeamID == teamID && myplayer.Position != GOALIE)
		{
		  //		  cout<<"Grabbed player "<<myplayer.ID;
			mylist.push_back(myplayer);
		}
		count++;
    	//bzero((void *)&myplayer,sizeof(PLAYER_TYPE));
	} while (!inf.eof());
	inf.close();
}

void GetAllGoalies(int teamID , PLAYERLIST &mylist)
{
 
	PLAYER_TYPE myplayer;
	int count=0;
	fstream inf("players.dat", ios::in | ios::binary);
	if (!inf.good())
	  cout<<"Can't open players.dat!"<<endl;
	else
	do {
		inf.seekg(sizeof(PLAYER_TYPE)*count, ios::beg);
		inf.read((char*)&myplayer, sizeof myplayer);
		if (myplayer.TeamID == teamID && myplayer.Position == GOALIE)
		{
			mylist.push_back(myplayer);
		}
		count++;
      		//bzero((void *)&myplayer,sizeof(PLAYER_TYPE));
	} while (!inf.eof());
	inf.close();
}

