// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//ggoalie.cpp

//goalie specific functions


#include "GGoalie.h"
#include "Constants.h"
#include "Utils.h"
#include <fstream>
#include <math.h>
#include <stdlib.h>
using namespace std;

GGoalie:: GGoalie ():GPlayer ()
{
// Attributes.Generate(5);
}

GGoalie::GGoalie(PLAYER_TYPE attr):GPlayer(attr)
{
    Attributes.Load(attr);
    GAttributes.Load(attr);
}

GGoalie::GGoalie(const GGoalie &g)
{
 Attributes = g.Attributes;
 GAttributes.Blocker = g.GAttributes.Blocker;
 GAttributes.Concentration = g.GAttributes.Concentration;
 GAttributes.Glove = g.GAttributes.Glove;
 GAttributes.Pads = g.GAttributes.Pads;
 GAttributes.Stick = g.GAttributes.Stick;
 //Attributes.ID = g.Attributes.ID;
 OnIce = 0;
 Energy = 100;
}

int GGoalie::
AtDestination ()
//goalies have to be precise, so it's unlikely that they're ever satisfied
//with where they are
{
  if (abs (Location.X - DestX) < 2 && abs (Location.Y - DestY) < 2)
    return 1;
  return 0;
}

void GGoalie::
SetComponents (double totalspeed)
//sets the component vectors.  Goalies accelerate roughly twice as fast as
//skaters, since most of their movement is lateral and short in distance
{
  if (AtDestination ())
    {
      Location.XVelocity /= 4;
      Location.YVelocity /= 4;
      return;
    }
  double c = 0;

  double numerator = abs (DestX - Location.X);
  double denominator = numerator + abs (DestY - Location.Y);

  if (denominator > 0)
    c = sqrt (sqr (totalspeed) * (numerator / denominator));

  double desXVelocity = c;
  if ((DestX - Location.X) < 0)
    desXVelocity = -desXVelocity;
  if (InControl >= 0)
    Location.XVelocity += (desXVelocity - Location.XVelocity) / 3;
  else
    Location.XVelocity /= 1.1;
  double y;


  if (abs (sqr (totalspeed) - sqr (c)) < .5)
    y = 0;
  else
    y = sqr (totalspeed) - sqr (c);

  double desYVelocity = sqrt (y);
  if (DestY - Location.Y < 0)
    desYVelocity = -desYVelocity;

  if (InControl >= 0)
    Location.YVelocity += (desYVelocity - Location.YVelocity) / 3;
  else
    Location.YVelocity /= 1.1;
}



int GGoalie::
CanReachPuck (Puck p)
// 0 = no
// 1 = glove
// 2 = stick/blocker/chest
// 3 = pad (standing)
// 4 = pad (on knees)
// 5 = pad (stacked)
{
  if (gamestatus[p.PlayerInControl].ID!=id && 
      Distance (Location.X, Location.Y, p.GetX (), p.GetY ()) < 15 && p.PlayerInControl != (2*PlayersPerTeam)+(HomeOrVisitor*2))
    {
//                fstream debug;
      //                              debug.open("saves.txt",ios::app);
      //return 3;
      if (PassX>=0&&(/*Location.Y - p.GetY () > 0 && */abs (Location.Y - p.GetY ()) < 15 && InControl > -10 /*&& p.GetZ () >= 4*/ && p.GetZ () < 15 &&	//5...
	   rand () % GAttributes.Glove > savethreshold &&
	  rand () % 100 < TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor) ||
	  sqrt (sqr (p.GetXVelocity ()) + sqr (p.GetYVelocity ())) < 10))
	{
	  //          cout<<"PassX="<<PassX<<".  Glove save made.  Tracking Time="<<p.GetTrackingTime()<<".  "<<"magic number="<<TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)<<endl;
	  //PassX=0;
	  return 1;
	}
      else if (PassX>=0&&p.GetZ () < 13 && p.GetZ () > 4 && rand () % GAttributes.Stick > savethreshold &&
	       rand () % 100 < TrackingTimeFactor * p.GetTrackingTime () + AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)
	{
	  //          cout<<"Stick save made.  Tracking Time="<<p.GetTrackingTime()<<".  "<<"magic number="<<TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)<<endl;
          //cout<<"Stick save made.\n";
	  PassX = -5;
	  return 2;
	}
      else if (PassX>=0&&abs (Location.Y - p.GetY ()) > 10 && abs (Location.Y - p.GetY ()) < 13 &&
	       p.GetZ () < 6 && rand () % GAttributes.Pads > savethreshold &&
	       rand () % 100 < TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor))		//if outside

	{
	  //          cout<<"Pad save made.  Tracking Time="<<p.GetTrackingTime()<<".  "<<"magic number="<<TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)<<endl;
	  //cout<<"Pad save made (kick)\n";
	  PassX = -5;
	  InControl = -5;
	  return 3;
	}
      else if (PassX>=0&&abs (Location.Y - p.GetY ()) < 11 && p.GetZ () < 5 &&
	       rand () % GAttributes.Pads > savethreshold &&
	       rand () % 100 < TrackingTimeFactor * p.GetTrackingTime () + AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)
	{
	  //          cout<<"Pad save made (5 hole).  Tracking Time="<<p.GetTrackingTime()<<".  "<<"magic number="<<TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)<<endl;
          //cout<<"Pad save made (5 hole)  Tracking Time="<<p.GetTrackingTime()<<"\n";
	  PassX = -3;
	  InControl = -10;
	  return 1;		//if inside

	}
      //      else if (PassX>=0)
	//         cout<<"Got by...  Tracking Time="<<p.GetTrackingTime()<<".  "<<"magic number="<<TrackingTimeFactor * p.GetTrackingTime () + (AdjustForFatigue (Attributes.Quickness) * QuicknessFactor)<<endl;
//      debug.close();
    }
 
  return 0;
}


int GGoalie::
Surrounded ()
//determines enemy players are in the area
{
  int homeorvisitor = HomeOrVisitor;
  for (int i = PlayersPerTeam * homeorvisitor; i < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); i++)
// for (int i=0;i<10;i++)
    if (abs (gamestatus[i].X - Location.X) < 40 &&
	abs (gamestatus[i].Y - Location.Y) < 40 &&
	gamestatus[i].ID != id)
      return 1;
  return 0;
}



void GGoalie::
SetAction (PlayerView gamestatus[(PlayersPerTeam * 2) + 4], Puck p,
	   PositionData Home)
//determines a goalie's course of action for a frame
{
  SetView (gamestatus);
  int homeorvisitor=HomeOrVisitor;		//quick reference variables

  int otherteam = !homeorvisitor;
// DestX=Home.NeutralX;
  // DestY=Home.NeutralY;

  double distancefromgoal;
  if (homeorvisitor == 0)
    distancefromgoal = Distance (homegoalx, width / 2, Location.X, Location.Y);
  else
    distancefromgoal = Distance (visitorgoalx, width / 2, Location.X, Location.Y);

  if (distancefromgoal < 40)	//don't move too far out

    {
      if (homeorvisitor == 0)	//move out to cut off angles

	DestX = (Home.NeutralX + 3) + ((length / 2) - ((length / 2) - (p.GetX () / 5)));
      else
	DestX = (Home.NeutralX + 3) - (length - p.GetX ()) / 5;
      DestY = (width / 2) + ((p.GetY () - Home.NeutralY) / 2);	//stay in line with the
      //puck
      //   DestX=X+50*((double)p.GetX()/(p.GetY()+1))*(-1*homeorvisitor);
      //   DestY=Y+50*((double)p.GetY()/(p.GetX()+1));

    }
  else
    {
      DestX = Home.NeutralX;	//move backwards if too far out

      DestY = Home.NeutralY;
    }

  if (DestY > (width / 2) + goallength / 2 + 5)		//don't move too far down or up

    DestY = (width / 2) + goallength / 2 + 5;
  else if (DestY < (width / 2) - goallength / 2 - 5)
    DestY = (width / 2) - goallength / 2 - 5;

  if (p.PlayerInControl == (2*PlayersPerTeam)+(2*HomeOrVisitor))	//if you have the puck

    {
      DestX = Location.X;	//don't move

      DestY = Location.Y;
    }


  if (PassX > 0 && p.PlayerInControl != (2*PlayersPerTeam)+(2*HomeOrVisitor))
    {
      PassX = 0;
      PassY = 0;
    }

  //determine where to pass the puck
  if (p.PlayerInControl == (2*PlayersPerTeam)+(HomeOrVisitor*2))
//  for (int i=(PlayersPerTeam*homeorvisitor);PlayersPerTeam+(PlayersPerTeam*homeorvisitor); i++)
    for (int i = PlayersPerTeam * homeorvisitor; i < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); i++)
      if ((!Surrounded ()) &&	//if surrounded, freeze the puck
	   p.ClearPath (gamestatus[i].X, gamestatus[i].Y,
			gamestatus, homeorvisitor) &&	//but have an open teammate
	   (PassX >= 0) &&
	  (Distance (Location.X, Location.Y, gamestatus[i].X, gamestatus[i].Y) < 200) &&
	  gamestatus[i].ID != id && gamestatus[i].Y != width + 10)
	{
	  PassX = gamestatus[i].X + (gamestatus[i].XVelocity);	//pass to the open teammate

	  PassY = gamestatus[i].Y + (gamestatus[i].YVelocity);
	  Shooting = 0;		//cancel any thoughts of shooting

	}
  if (PassX > 0 && ((homeorvisitor==0&&PassX < Location.X) ||(homeorvisitor==1&&PassX > length - Location.X)))
    {
      PassX = 0;
      PassY = 0;
    }
}
