// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//ggoalie.h

//goalie specific functions

#include "GoalieAttributes.h"
#include "Puck.h"
#include "GPlayer.h"
#include "Constants.h"
#ifdef USEMFC
#include "stdafx.h"
#endif
#include <vector>

#ifndef GGOALIE
#define GGOALIE

class GGoalie:public GPlayer
{
  friend class Game;
    public:
    GGoalie ();
    GGoalie (PLAYER_TYPE attr);
	GGoalie(const GGoalie &g);
  void SetComponents (double totalspeed);
  void SetAction (PlayerView gamestatus[(PlayersPerTeam * 2) + 4], Puck p,
		  PositionData Home);
  virtual int CanReachPuck (Puck p);
  virtual int AtDestination ();
  virtual int Surrounded ();
    protected:
    GoalieAttributes GAttributes;
};

typedef vector<GGoalie> GOALIELIST;

#endif
