// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//gplayer.cpp

//common functions used by all players
#include "GPlayer.h"
#include <math.h>
#include "Constants.h"
#include "Utils.h"
#include <fstream>
#include <stdlib.h>
#include <stdio.h>

using namespace std;

GPlayer::GPlayer():Body()//,TextureBitmap()
//initializes a player
{
   BaseModel=NULL;
   
   Attributes.Generate();
   HomeOrVisitor = -1;
   Energy=100;
   Direction=0;
   InControl=0;
   DestX=0;
   DestY=0;
   Shooting=0;

   PassX=-10;
   PassY=0;
   PassDelay=10;
   PlayerToCheck=0;
   PenaltyTime=0;
   OnIce=0;
}

GPlayer::GPlayer(PLAYER_TYPE attr):Body()
{
    Attributes.Load(attr);
	HomeOrVisitor = -1;
    id=attr.ID;
    BaseModel=NULL;
    Energy = 100;
    Direction=0;
    InControl=0;
    DestX=0;
    DestY=0;
    Shooting=0;
    PassX=-10;
    PassY=0;
    PassDelay=10;
    PlayerToCheck=0;
    PenaltyTime=0;
    OnIce=0;
}

GPlayer::GPlayer(const GPlayer &p)
{
 BaseModel = NULL;
 Energy=100;
 Direction=0;
 InControl=0;
 DestX=0;
 DestY=0;
 Shooting=0;
 PassX=-10;
 PassY=0;
 PassDelay=10;
 PlayerToCheck=0;
 PenaltyTime=0;
 OnIce=0;

 id = p.id;
 HomeOrVisitor = p.HomeOrVisitor;
 Attributes = p.Attributes;
}

GPlayer::~GPlayer()
{
	if (BaseModel)
	 delete BaseModel;
}

void GPlayer::SetModel(Model *model)
{
// BaseModel=model;
	 BaseModel=new Model(model);
	 BaseModel->SetScale(5*Attributes.Height/70.0);
}

#ifndef TWODVERSION
void GPlayer::GenerateTexture(char *filename)
{
  //  cout<<"Generating a texture from "<<filename<<endl;
	uint32 *Texture;
	Tiff TextureTiff;
	TextureTiff.Load(filename);
	/*	if (Attributes.UniformNumber<10)
	{
		char filename0[15];
		if (HomeOrVisitor==0)
		 sprintf(filename0,"home%d.bmp",Attributes.UniformNumber);
		else
		 sprintf(filename0,"visitor%d.bmp",Attributes.UniformNumber);

	Bitmap digit1(filename0);
//		Bitmap digit1("home1.bmp");
	 TextureBitmap.CopyBits(digit1,0,0,32,14,18,28,1);
	 TextureBitmap.CopyBits(digit1,0,0,32,219,18,28,0);
//	 TextureBitmap.CopyBits(digit1,32,212,32,22,16,28);
	}
	else
	{
		char filename1[15];
		if (HomeOrVisitor==0)
		 sprintf(filename1,"home%d.bmp",Attributes.UniformNumber%10);
		else
		 sprintf(filename1,"visitor%d.bmp",Attributes.UniformNumber%10);
		char filename2[15];
		if (HomeOrVisitor==0)
		 sprintf(filename2,"home%d.bmp",Attributes.UniformNumber/10);
		else
		 sprintf(filename2,"visitor%d.bmp",Attributes.UniformNumber/10);
	 Bitmap digit1(filename1);
	 Bitmap digit2(filename2);
	 TextureBitmap.CopyBits(digit1,0,0,32,2,18,28,1);
	 TextureBitmap.CopyBits(digit2,0,0,32,20,18,28,1);
	 TextureBitmap.CopyBits(digit1,0,0,32,222,18,28,0);
	 TextureBitmap.CopyBits(digit2,0,0,32,208,18,28,0);
	}
	*/
	Texture=TextureTiff.GetGLTexture();
	glPixelStorei(GL_UNPACK_ALIGNMENT,1);
        glGenTextures(1,&TextureName);
        glBindTexture(GL_TEXTURE_2D,TextureName);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T,GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER,GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER,GL_LINEAR);
        glTexImage2D(GL_TEXTURE_2D,0,GL_RGBA,128,128/*width,length*/,0,GL_RGBA,GL_UNSIGNED_BYTE,Texture);
	//       	delete[] Texture;
	//	cout<<"Deleted the junk"<<endl;
// glTexImage2D(GL_TEXTURE_2D,0,GL_RGB,32,32/*width,length*/,0,GL_RGB,GL_UNSIGNED_BYTE,Texture);
}

void GPlayer::Paint(Puck &p, int CurrentPlayer, int Textures)
//draws the player
{
	if (Attributes.Position==6&&HomeOrVisitor==0)
		Direction=0;
	else if (Attributes.Position==6&&HomeOrVisitor==1)
		Direction=pi;
	else
	if (sqr(Location.XVelocity)+sqr(Location.YVelocity)>5)
	{
		if (Location.XVelocity==0)
			if (Location.YVelocity>0)
				Direction=3*pi/2;
			else
				Direction=pi/2;
			else
		Direction=angle(Location.XVelocity,Location.YVelocity);
	}
/*	if (id<=PlayersPerTeam&&Distance(p.GetX(),p.GetY(),homegoalx,width/2)>
		   Distance(Location.X,Location.Y,homegoalx,width/2))
					Direction=2*pi-Direction;
	else
		if (id>PlayersPerTeam&&Distance(p.GetX(),p.GetY(),visitorgoalx,width/2)>
		   Distance(Location.X,Location.Y,visitorgoalx,width/2))
					Direction=2*pi-Direction;
*/
	//Attributes.Position=id%5;
int red=0, green=0, blue=0;
 if (CurrentPlayer != -1 && gamestatus[CurrentPlayer].ID==Attributes.ID)
	{
		red=0;
		green=255;
		blue=0;
	}
	else
 if (InControl<0)
 {
  red=0;
  green=0;
  blue=0;
 }
 else
 if (HomeOrVisitor==1)    //pick a color
  if (Attributes.Position>2)
   red=100;
  else
   red=150;
 else
 {
  red=50;
  green=50;
  if (Attributes.Position>2)
  	blue=150;
  else
   blue=250;
 }
	if (CurrentPlayer == -1 || gamestatus[CurrentPlayer].ID!=Attributes.ID)
 if (HomeOrVisitor==1&&gamestatus[p.PlayerInControl].ID==Attributes.ID)
    red=200;
 else
  if (gamestatus[p.PlayerInControl].ID==Attributes.ID)
  {
   red=100;
   green=100;
   blue=255;
  }

	glColor3f(red/255.0,green/255.0,blue/255.0);

	glPushMatrix();
 double maxdistance=Body.GetMaxDistance(&BaseModel->BodyParts);

	glTranslatef(Location.X,Location.Y,0);
	glScalef(.35,.35,.35);
	if (CurrentPlayer != -1 && gamestatus[CurrentPlayer].ID==Attributes.ID)
	{
	glBegin(GL_POLYGON);
	for (double x=0;x<2*pi;x+=.3)
		glVertex3f(30*cos(x),30*sin(x),3);
	glEnd();
	}

	glTranslatef(0,0,-maxdistance/4);

	if (Textures)
  glEnable(GL_TEXTURE_2D);
 glBindTexture(GL_TEXTURE_2D,TextureName);
	glRotatef((Direction*180/pi)-90,0,0,1);
	BaseModel->Display(Body, red/255.0, green/255.0, blue/255.0);
	glPopMatrix();
 glDisable(GL_TEXTURE_2D);


/*	Point realleftknee;
	realleftknee.X=Location.X+(LeftKnee.X*cos(Direction));
	realleftknee.Y=Location.Y+(LeftKnee.X*sin(Direction));
	realleftknee.Z=3;
	Point realrightknee;
	realrightknee.X=Location.X+(RightKnee.X*cos(Direction));
	realrightknee.Y=Location.Y+(RightKnee.X*sin(Direction));
	realrightknee.Z=3;
	Point realleftfoot;
	realleftfoot.X=Location.X+(LeftFoot.X*cos(Direction));
	realleftfoot.Y=Location.Y+(LeftFoot.X*sin(Direction));
	realleftfoot.Z=0;
	Point realrightfoot;
	realrightfoot.X=Location.X+(RightFoot.X*cos(Direction));
	realrightfoot.Y=Location.Y+(RightFoot.X*sin(Direction));
	realrightfoot.Z=0;

	Point Neck(Location.X+Location.XVelocity/3, Location.Y+Location.YVelocity/3,9);
 Point LeftElbow(Location.X+RightKnee.X/1.5+Location.XVelocity/6,Location.Y+RightKnee.Y/1.5+Location.YVelocity/6,7);
	Point RightElbow(Location.X+LeftKnee.X/1.5+Location.XVelocity/6,Location.Y+LeftKnee.Y/1.5+Location.YVelocity/6,7);
	Point RightHand(Location.X+LeftFoot.X/1.5+Location.XVelocity/6,Location.Y+LeftFoot.Y/1.5+Location.YVelocity/6,5);
 Point LeftHand(Location.X+RightFoot.X/1.5+Location.XVelocity/6,Location.Y+RightFoot.Y/1.5+Location.YVelocity/6,5);

 Point LeftShoulder(Location.X+LeftKnee.X/2+Location.XVelocity/2.5,Location.Y+LeftKnee.Y/2+Location.YVelocity/2.5,8);
	Point RightShoulder(Location.X+RightKnee.X/2+Location.XVelocity/2.5,Location.Y+RightKnee.Y/2+Location.YVelocity/2.5,8);
 Point LeftHip(Location.X+LeftKnee.X/2,Location.Y+LeftKnee.Y/2,6);
	Point RightHip(Location.X+RightKnee.X/2,Location.Y+RightKnee.Y/2,6);
*/
/* glBegin(GL_LINE_STRIP);
	 glVertex3f(realrightfoot.X,realrightfoot.Y,realrightfoot.Z);
		glVertex3f(realrightknee.X,realrightknee.Y,realrightknee.Z);
		glVertex3f(Location.X,Location.Y,Location.Z);
		glVertex3f(realleftknee.X,realleftknee.Y,realleftknee.Z);
		glVertex3f(realleftfoot.X,realleftfoot.Y,realleftfoot.Z);
	glEnd();

 glBegin(GL_POLYGON);
	 glVertex3f(Neck.X,Neck.Y,Neck.Z);
		glVertex3f(RightShoulder.X,RightShoulder.Y,RightShoulder.Z);
		glVertex3f(RightLocation.X,RightLocation.Y,RightLocation.Z);
	 glVertex3f(LeftLocation.X,LeftLocation.Y,LeftLocation.Z);
		glVertex3f(LeftShoulder.X,LeftShoulder.Y,LeftShoulder.Z);
	glEnd();
*/
/* Point BLeftShoulder(Location.X+LeftKnee.X/2+Location.XVelocity/3.5,Location.Y+LeftKnee.Y/2+Location.YVelocity/3.5,8);
	Point BRightShoulder(Location.X+RightKnee.X/2+Location.XVelocity/3.5,Location.Y+RightKnee.Y/2+Location.YVelocity/3.5,8);
 Point BLeftHip(Location.X+LeftKnee.X/2,Location.Y+LeftKnee.Y/2,6);
	Point BRightHip(Location.X+RightKnee.X/2,Location.Y+RightKnee.Y/2,6);
*/
/*
 glBegin(GL_POLYGON);
	 glVertex3f(Neck.X,Neck.Y,Neck.Z);
		glVertex3f(BRightShoulder.X,BRightShoulder.Y,BRightShoulder.Z);
		glVertex3f(BRightLocation.X,BRightLocation.Y,BRightLocation.Z);
	 glVertex3f(BLeftLocation.X,BLeftLocation.Y,BLeftLocation.Z);
		glVertex3f(BLeftShoulder.X,BLeftShoulder.Y,BLeftShoulder.Z);
	glEnd();
*/
 
/* int sign=(2*(Location.XVelocity>0)-1);

 Point StickTop(LeftHand.X+(-4*sign), LeftHand.Y,6);

	Point StickBottom(LeftHand.X+(9*sign), LeftHand.Y, 3);
	if (p.PlayerInControl==id)
	{
		StickBottom.X=p.GetX();
		StickBottom.Y=p.GetY();
		StickBottom.Z=0;
	}

 Point Head(Neck.X-2, Neck.Y-2,9);

	Head.X=Neck.X+2;
	Head.Y=Neck.Y+2;
	Head.Z=12;
*/
}
#endif

#ifdef TWODVERSION
void GPlayer::Paint(CDC &dc, Puck &p, int CurrentPlayer)
{
  //Attributes.Position=id%5;
int red=0, green=0, blue=0;
 if (gamestatus[CurrentPlayer].ID==Attributes.ID)
	{
		red=0;
		green=255;
		blue=0;
	}
	else
 if (InControl<0)
 {
  red=0;
  green=0;
  blue=0;
 }
 else
 if (HomeOrVisitor==1)    //pick a color
  if (Attributes.Position>2)
   red=100;
  else
   red=150;
 else
 {
  red=50;
  green=50;
  if (Attributes.Position>2)
  	blue=150;
  else
   blue=250;
 }
	if (gamestatus[CurrentPlayer].ID!=Attributes.ID)
 if (HomeOrVisitor==1&&gamestatus[p.PlayerInControl].ID==Attributes.ID)
    red=200;
 else
  if (gamestatus[p.PlayerInControl].ID==Attributes.ID)
  {
   red=100;
   green=100;
   blue=255;
		}
	CBrush mrbrush(RGB(red, green, blue));
 CBrush *pBrush=dc.SelectObject(&mrbrush);
	CRect CB;
 CB.top=Location.Y-5;
	CB.bottom=Location.Y+5;
 CB.right=Location.X+5;
	CB.left=Location.X-5;
 dc.Ellipse(CB);
	dc.SelectObject(pBrush);
}
#endif

int GPlayer::GoodAngle()
{
 int homeorvisitor=HomeOrVisitor;
	double goalx=homegoalx;
	double goaly=width/2;
 if (homeorvisitor==0)
		goalx=visitorgoalx;
	double a=angle(goalx-Location.X,width/2-Location.Y);
	if /*abs((Y-goaly)/(X-goalx))>.75&&
			   abs((Location.Y-goaly)/(Location.X-goalx))>1.25)*/
						((a>7*pi/4&&a<2*pi)||
						(a<pi/4&&a<0)||
						(a>3*pi/4&&a<5*pi/4)||
						((goalx==homegoalx&&Location.X>75)||
						 (goalx==visitorgoalx&&Location.X<length-75)))
//						Distance(goalx,width/2,Location.X,Location.Y)<50)
						return 1;
//  if (X+50>visitorgoalx)
//   return 0;
  else return 0;
 /*else if (X-50<homegoalx)
  return 0;
*/
// else return 1;
}


void GPlayer::SetComponents(double totalspeed)
//sets the component vectors given the total speed to be allocated
{
 if (AtDestination())		//don't circle around destination...just stop
 {
  Location.XVelocity/=1.3;
  Location.YVelocity/=1.3;
/*		if (abs(RightFoot.X)<4&&abs(RightKnee.X)<4)
		{
			RightKnee.XVelocity=0;
		 RightFoot.XVelocity=0;
		}
		*/
  return;
 }
 double c=0;

 double numerator=sqr(DestX-Location.X);		//proportion of xvelocity to total speed
 double denominator=numerator+sqr(DestY-Location.Y);

 if (denominator>0)
  c=sqrt(sqr(totalspeed)*(numerator/denominator));

 double desXVelocity=c;
 if ((DestX-Location.X)<0)
  desXVelocity=-desXVelocity;			//if moving in a negative direction,
                                //negate the speed

 if (InControl>=0&&
		   ((Location.XVelocity<-1&&desXVelocity>=0)||
					 (Location.XVelocity>1&&desXVelocity<=0)))
	 Location.XVelocity+=-Location.XVelocity/(4*((double)Attributes.Weight/225));
 else
 if (InControl>=0)
		Location.XVelocity+=(desXVelocity-Location.XVelocity)/(3*((double)Attributes.Weight/225));  //accelerate
 else
  Location.XVelocity/=1.1;		//friction on people who are knocked over

	

 double y;


  if (abs(sqr(totalspeed)-sqr(c))<.5) //stop eventually
   y=0;
  else
   y=sqr(totalspeed)-sqr(c); //remaining speed belongs to yvelocity

 double desYVelocity=sqrt(y);
 if (DestY-Location.Y<0)
  desYVelocity=-desYVelocity;

 if (InControl>=0&&
		   ((Location.YVelocity<-1&&desYVelocity>=0)||
					 (Location.YVelocity>1&&desYVelocity<=0)))
	 Location.YVelocity+=-Location.YVelocity/(4*((double)Attributes.Weight/225));
 else
 if (InControl>=0)
  Location.YVelocity+=(desYVelocity-Location.YVelocity)/(3*((double)Attributes.Weight/225)); //accelerate
 else
  Location.YVelocity/=1.1;	//friction on the fallen

/*	if (XVelocity>1&&RightKnee.XVelocity==0&&RightFoot.XVelocity==0)
	{
		RightKnee.XVelocity=3;
		RightFoot.XVelocity=4;
		LeftKnee.XVelocity=-3;
		LeftFoot.XVelocity=-4;
 }
	else if (XVelocity<-1&&RightKnee.XVelocity==0&&RightFoot.XVelocity==0)
	{
		LeftKnee.XVelocity=3;
		LeftFoot.XVelocity=4;
		RightKnee.XVelocity=-3;
		RightFoot.XVelocity=-4;
 }
*/
}

int GPlayer::CanReachPuck(Puck p)
//determines if the puck is within a certain radius of the player and
//if so, whether he can control it
{
 double puckspeed=sqrt(sqr(p.GetXVelocity())+sqr(p.GetYVelocity()));
 if (InControl>=0&&OnIce)
  if (Distance(Location.X,Location.Y,p.GetX(),p.GetY())<playerdiameter*2)
   if (puckspeed<60&&p.GetZ()<3)
    return 1;
   else
   {
    int mod=(int)((puckspeed*1/100)*((AdjustForFatigue(Attributes.StickHandling)+
                                      AdjustForFatigue(Attributes.PuckControl))));
    if (mod==0)
     mod=1;
    if (p.GetZ()<10&&rand()%mod<=50+20*((HomeOrVisitor==0&&p.GetXVelocity()>0)||
                                         (HomeOrVisitor==1&&p.GetXVelocity()<0)))
    return 2;
   }
 return 0;
}


int GPlayer::AtDestination()
//determines if a player is close enough to his destination to be considered
//at it
{
 if (abs(Location.X-DestX)<10&&abs(Location.Y-DestY)<10)
  return 1;
 return 0;
}

double GPlayer::AdjustXForDot(double x, int dot)
{
 switch(dot)
 {
  case 0: return x;
  case 1: case 3: return x/4;
  case 2: case 4: x=length-x; return length-x/4;
  case 5: case 7: return x/3;
  case 6: case 8: x=length-x; return length-x/3;
 }
 return 0;
}

double GPlayer::AdjustYForDot(double y, int dot)
{
 switch(dot)
 {
  case 0: return y;
  case 1: case 2: case 5: case 6: return y/3;
  case 3: case 4: case 7: case 8: y=width-y; return width-y/3;
 }
 return 0;
}


void GPlayer::SetPosition(PositionData Home,int dot)
//sets a player up for a midice faceoff
{
 if (OnIce)
 {
  Location.X=AdjustXForDot(Home.NeutralX,dot);
  Location.Y=AdjustYForDot(Home.NeutralY,dot);
  InControl=0;
 }
 else if (Location.Y!=-5)
 {
  Location.X=Home.NeutralX;
  Location.Y=width+10;
  InControl=0;
 }
 OldLocation=Location;
}

double GPlayer::SetShotX(double GoalX, double GoalY)
{
 int mod=(int)(Distance(Location.X,Location.Y,GoalX,GoalY)/3);
	if (mod==0)
		mod=1;
 double SpeedFactor=(sqrt(sqr(Location.XVelocity)+sqr(Location.YVelocity))/40)*175;
 return GoalX+((rand()%mod-rand()%mod)*(((SpeedFactor+rand()%100)-Attributes.ShotAccuracy)/100.0));
}

double GPlayer::SetShotY(double GoalX, double GoalY)
{
 int mod=(int)(Distance(Location.X,Location.Y,GoalX,GoalY)/3);
	if (mod==0)
		mod=1;
 double SpeedFactor=(sqrt(sqr(Location.XVelocity)+sqr(Location.YVelocity))/40)*175;
 return GoalY+((rand()%mod-rand()%mod)*(((SpeedFactor+rand()%100)-Attributes.ShotAccuracy)/100.0));
}

double GPlayer::SetShotZ(double GoalX, double GoalY)
{
 int mod=(int)(Distance(Location.X,Location.Y,GoalX,GoalY)/10);
	if (mod==0)
  mod=1;
 return rand()%20+((rand()%mod-rand()%mod)*(((100+rand()%100)-Attributes.ShotAccuracy)/100.0));
}




double GPlayer::SetShotSpeed(Puck p, double GoalX, double GoalY)
{
 double s=(Distance(p.GetX(),p.GetY(),GoalX,GoalY)/1.3)*(AdjustForFatigue(Attributes.ShotPower)/100);
 if (s>100)
  s=100;
 if (s<50)
  s=50;
 return s;
}

double GPlayer::SetDumpSpeed(Puck p)
{
 double s=(Distance(p.GetX(),p.GetY(),PassX,PassY)/1.8)*(AdjustForFatigue(Attributes.ShotPower)/100);
 if (s>80)
  s=80;
 if (s<60)
  s=60;
 return s;
}


void GPlayer::Shoot(Puck &p, double GoalX, double GoalY)
//shoots the puck towards the given goal
{
 if (Shooting>1&&(!Surrounded()||rand()%5==0))  //handle the windup
 { 
  Shooting--;
 }
 else
 {
  p.SetComponents(SetShotSpeed(p,GoalX,GoalY), SetShotX(GoalX, GoalY), SetShotY(GoalX,GoalY), SetShotZ(GoalX,GoalY));  //if delay is over, shoot it
  p.PlayerInControl=-1;
  Shooting=-(int)(SetShotSpeed(p,GoalX,GoalY)/11); //create new delay
  p.ResetTrackingTime();
 }
}

double GPlayer::SetPassX()
{
 int mod=(int)(Distance(Location.X,Location.Y,PassX,PassY)/10);
	if (mod==0)
		mod=1;
 return PassX+((rand()%mod-rand()%mod)*(((100+rand()%100)-Attributes.Passing)/100.0));
}

double GPlayer::SetPassY()
{
 int mod=(int)(Distance(Location.X,Location.Y,PassX,PassY)/10);
	if (mod==0)
		mod=1;
 return PassY+((rand()%mod-rand()%mod)*(((100+rand()%100)-Attributes.Passing)/100.0));
}



double GPlayer::FindPassSpeed(Puck p)
{
 double s=Distance(p.GetX(),p.GetY(),PassX,PassY);
 s/=3;
 if (s>55)
   s=55;
 if (s<20)
   s=20;
 return s;
}


void GPlayer::Pass(Puck &p)
//passes the puck to the determined spot on the ice
{
	int homeorvisitor=HomeOrVisitor;
	if (homeorvisitor!=0)
		homeorvisitor=1;
 if (PassDelay>0) //handle the delay --outdated? don't think so...
  PassDelay--;
 else
 {
  if (PassY==1||PassY==width)
   p.SetComponents(SetDumpSpeed(p),PassX,PassY,SetDumpSpeed(p)*.7);
  else if (PassY==BlueLine[!homeorvisitor])
  {
   p.SetComponents(FindPassSpeed(p),SetPassX(),SetPassY(),SetDumpSpeed(p)*.7); //make the pass
  }
  else
   p.SetComponents(FindPassSpeed(p),SetPassX(),SetPassY()); //make the pass
  p.PlayerInControl=-1;
  PassX=-15;
  PassY=0;
  PassDelay=10;
  p.ResetTrackingTime();
 }
}

void GPlayer::Check(GPlayer* Victim)
//throw a player's body at another player
{
   if (PlayerToCheck>-1) //check delay
   {
    DestX=Victim->Location.X+Victim->Location.XVelocity; //run into him
    DestY=Victim->Location.Y+Victim->Location.YVelocity;
    SetComponents(40); //speed burst
    PlayerToCheck=-10; //delay
   }
}

int GPlayer::TeamPossesses(int homeorvisitor, Puck p)
//determines if the puck is possessed by a player of the same team
{
  if (!homeorvisitor&&p.PlayerInControl!=-1&&(p.PlayerInControl<PlayersPerTeam||
                                              p.PlayerInControl==PlayersPerTeam*2))
   return 1;
  if (homeorvisitor&&p.PlayerInControl>PlayersPerTeam+1/*&&p.PlayerInControl!=10*/)
   return 1;
 return 0;
}

int GPlayer::ForwardOnTeamPossesses(int homeorvisitor, Puck p)
//determines if a forward on the same team possesses the puck
{
  if (TeamPossesses(homeorvisitor,p)&&gamestatus[p.PlayerInControl].Position<3)
   return 1;
//  if (homeorvisitor&&p.PlayerInControl>PlayersPerTeam&&p.PlayerInControl<8)
//   return 1;
 return 0;
}

int GPlayer::ClearPath(double destx, double desty)
//determines if there is a clear path for a skater to a given spot on the ice
{
/*	
	double d=Distance(Location.X,Location.Y,destx,desty)/4;
 for (int i=0;i<PlayersPerTeam*2+4;i++) //if any enemy player is
 {
 	if (i!=id&&gamestatus[i].OnIce&&
 	   (abs(angle((gamestatus[i].X-Location.X),(gamestatus[i].Y-Location.Y))-
 		       angle((destx-Location.X),(desty-Location.Y)))<3.1415926/4&&
										((((destx>Location.X&&gamestatus[i].X<destx&&gamestatus[i].X>Location.X)||
										 (destx<Location.X&&gamestatus[i].X>destx&&gamestatus[i].X<Location.X))&&
											((desty>Location.Y&&gamestatus[i].Y<desty&&gamestatus[i].Y>Location.Y)||
										 (desty<Location.Y&&gamestatus[i].Y>desty&&gamestatus[i].Y<Location.Y)))//||
										/*Distance(destx,desty,gamestatus[i].X,gamestatus[i].Y)<
										Distance(destx,desty,Location.X,Location.Y)/3*///)))

		/*			   abs(atan((gamestatus[i].Y-Location.Y)/(gamestatus[i].X-Location.X))-
 		       atan((desty-Location.Y)/(destx-Location.X)))<3.1415926/4&&
										((destx>Location.X&&gamestatus[i].X<destx+d&&gamestatus[i].X>Location.X-d)||
										 (destx<=Location.X&&gamestatus[i].X>destx-d&&gamestatus[i].X<Location.X+d))&&
										((desty>Location.Y&&gamestatus[i].Y<desty+d&&gamestatus[i].Y>Location.Y-d)||
										 (desty<=Location.Y&&gamestatus[i].Y>desty-d&&gamestatus[i].Y<Location.Y+d)))
*//* 									return 0;
 }
*/

 double y=Location.Y;
 double x=Location.X;
 if ((y-desty)<40&&(y-desty)>=0)		//widen zone if narrow
 {
  y+=20;
  desty-=20;
 }
 if ((y-desty)>-40&&(y-desty)<=0)
 {
  y-=20;
  desty+=20;
 }
 if ((x-destx)<40&&(x-destx)>=0)
 {
  x+=20;
  destx-=20;
 }
 if ((x-destx)>-40&&(x-destx)<=0)
 {
  x-=20;
  destx+=20;
 }

// for (int i=0+(5*!homeorvisitor);i<5+(5*!homeorvisitor);i++)
 for (int i=0;i<PlayersPerTeam*2+4;i++)
  if (((x>=gamestatus[i].X&&gamestatus[i].X>=destx)||  //if in the lane
      (destx>=gamestatus[i].X&&gamestatus[i].X>=x))&&
     ((y>=gamestatus[i].Y&&gamestatus[i].Y>=desty)||
      (desty>=gamestatus[i].Y&&gamestatus[i].Y>=y))&&
      abs(gamestatus[i].X-x)<50&&  //or extremely close
      abs(gamestatus[i].Y-y)<50&&
      gamestatus[i].ID!=Attributes.ID&&gamestatus[i].Y!=width+10) //not the same person
      return 0;
						
 return 1;


}

int GPlayer::OnMyHalf(Puck p)
{
	if (Attributes.Position==0&&(p.GetY()>width/4&&p.GetY()<width-width/4))
		return 1;
	if (p.GetY()>width/2&&Attributes.Position%2==0)
		return 1;
	else if (p.GetY()<width/2&&Attributes.Position%2==1)
		return 1;
	else return 0;
}

int GPlayer::InMyZone(Puck p)
{
 int homeorvisitor=HomeOrVisitor;
 if ((homeorvisitor==0&&p.GetX()<BlueLine[0])||
		   (homeorvisitor==1&&p.GetX()>BlueLine[1]))
		return 1;
	return 0;
}


int GPlayer::Surrounded()
//determines if a player is in danger of being hit
{
 int homeorvisitor=HomeOrVisitor;
	if (homeorvisitor!=0) 
		homeorvisitor=1;
// for (int i=5*homeorvisitor;i<5+5*homeorvisitor;i++)
 for (int i=0;i<PlayersPerTeam*2+4;i++)
  if (Distance(Location.X,Location.Y,gamestatus[i].X,gamestatus[i].Y)<30&&
      gamestatus[i].ID!=Attributes.ID)
       return 1;
 return 0;
}



int GPlayer::SurroundedByBadGuys()
//determines if a player is in danger of being hit
{
 int homeorvisitor=HomeOrVisitor;
// for (int i=5*homeorvisitor;i<5+5*homeorvisitor;i++)
 for (int i=PlayersPerTeam*(!homeorvisitor);i<PlayersPerTeam*(!homeorvisitor+1);i++)  
		if (Distance(Location.X,Location.Y,gamestatus[i].X,gamestatus[i].Y)<30&&
      gamestatus[i].ID!=Attributes.ID)
       return 1;
 return 0;
}

int GPlayer::SurroundedInFront()
//determines if a player is in danger of being hit
{
 int homeorvisitor=HomeOrVisitor;
	if (homeorvisitor!=0) 
		homeorvisitor=1;
// for (int i=5*homeorvisitor;i<5+5*homeorvisitor;i++)
 for (int i=0;i<PlayersPerTeam*2+4;i++)
  if (Distance(Location.X,Location.Y,gamestatus[i].X,gamestatus[i].Y)<30&&
			   ((Location.XVelocity>0&&gamestatus[i].X>Location.X)||
						 (Location.XVelocity<0&&gamestatus[i].X<Location.X))&&
      gamestatus[i].ID!=Attributes.ID)
       return 1;
 return 0;
}


double GPlayer::SituationQuality(int i)
{
 int homeorvisitor=HomeOrVisitor;
 double badguysnear=1;
	double goalx=visitorgoalx;
	if (homeorvisitor==1)
 	goalx=homegoalx;
 for (int x=PlayersPerTeam*(!homeorvisitor);x<PlayersPerTeam*(!homeorvisitor+1);x++)
  if (gamestatus[x].OnIce==1&&Distance(gamestatus[i].X,gamestatus[i].Y,
			            gamestatus[x].X,gamestatus[x].Y)<100)
															badguysnear+=(100-Distance(gamestatus[i].X,
															                      gamestatus[i].Y,
																																					gamestatus[x].X,
																																					gamestatus[x].Y));
	return (-badguysnear)*
                (Distance(gamestatus[i].X,gamestatus[i].Y,
			                       goalx, width/2));
}

double GPlayer::PassValue(int i)
{
 int index=0;
 // cout<<"finding pass value for "<<i<<endl;
 while (gamestatus[index].ID != i && index<PlayersPerTeam*2)
  index++;
 if (index==PlayersPerTeam*2)
  return -1e40;
	//if (gamestatus[i].OnIce!=1)
		//return -1e60;
	return SituationQuality(index);
/* Puck *p=new Puck();
	p->SetPosition(gamestatus[i].X, gamestatus[i].Y);
 int homeorvisitor=0;
	if (i>PlayersPerTeam)
		homeorvisitor=1;
 double sitqual=SituationQuality(id);
 	for (int x=PlayersPerTeam*(!homeorvisitor);x<PlayersPerTeam*(!homeorvisitor+1);x++)	
   if (gamestatus[x].OnIce==1&&gamestatus[x].InControl&&p->ClearPath(gamestatus[x].X, gamestatus[x].Y,gamestatus,homeorvisitor))
															sitqual-=SituationQuality(x)/2;
	return sitqual;*/
}

int GPlayer::SomebodyIsCrashing()
//determines if any attackers are in front of an offensive
//player's goal
{
 int homeorvisitor=HomeOrVisitor;
	double goalx=homegoalx;
	double goaly=width/2;
 if (homeorvisitor==0)
		goalx=visitorgoalx;

// for (int i=5*homeorvisitor;i<5+5*homeorvisitor;i++)
 for (int i=PlayersPerTeam*homeorvisitor;i<PlayersPerTeam*(homeorvisitor+1);i++)
  if ((gamestatus[i].Crashing==1&&gamestatus[i].OnIce==1)||
			   (Distance(gamestatus[i].X,gamestatus[i].Y,goalx,width/2)<50))
       return 1;
 return 0;
}

int GPlayer::NumBadGuysBlockingMyShot(double goalx)
{
	double myangle=angle((Location.X-goalx),(Location.Y-width/2));
	int otherteam=0;
	if (HomeOrVisitor==0)
		otherteam=1;
	int num=0;
	for (int x=PlayersPerTeam*otherteam;x<PlayersPerTeam*(otherteam+1);x++)
		if ((gamestatus[x].OnIce==1&&abs(myangle-angle((Location.X-gamestatus[x].X),(Location.Y-gamestatus[x].Y)))<3.1415926/8&&
			   Distance(gamestatus[x].X,gamestatus[x].Y,goalx,width/2)<
						Distance(Location.X,Location.Y,goalx,width/2))||
						Distance(Location.X,Location.Y,gamestatus[x].X,gamestatus[x].Y)<30)
		 num++;
 return num;
}


int GPlayer::AttackerInFrontOfGoal()
//determines if any attackers are in front of an offensive
//player's goal
{
 int homeorvisitor=HomeOrVisitor;
	double goalx=homegoalx;
	double goaly=width/2;
 if (homeorvisitor==0)
		goalx=visitorgoalx;

// for (int i=5*homeorvisitor;i<5+5*homeorvisitor;i++)
 for (int i=PlayersPerTeam*homeorvisitor;i<PlayersPerTeam*(homeorvisitor+1);i++)
  if (Distance(gamestatus[i].X, gamestatus[i].Y, goalx, goaly)<75
			&&
			  ((homeorvisitor==0&&gamestatus[i].X<goalx)||
					 (homeorvisitor==1&&gamestatus[i].X>goalx))&&
			  gamestatus[i].OnIce==1)
       return 1;
 return 0;
}


void GPlayer::UpdateDelays(Puck p)
//updates the delays for the player
{
	if (PassDelay>0&&gamestatus[p.PlayerInControl].ID==Attributes.ID)
		PassDelay--;
 if (PlayerToCheck<-1)
  PlayerToCheck++;
// if (InControl<0)
//  InControl++;
	if (Body.Joints.Hip.X>30||Body.Joints.Hip.X<-30||
	   	Body.Joints.Hip.Y>30||Body.Joints.Hip.Y<-30)
				 InControl=-1;
	else
		InControl=0;
 if (PassX<0)
  PassX++;
 if (Shooting<0)
  Shooting++;
}

void GPlayer::HandleCollision(GPlayer *b)
//determines the outcome of a collision between two players
{
 double tempx,tempy;
 tempx=Location.XVelocity;
 tempy=Location.YVelocity;
 if ((!(b->Location.XVelocity*Location.XVelocity>0))&&abs(b->Location.XVelocity*b->Attributes.Weight)>abs(Location.XVelocity*Attributes.Weight)) //move
   DestX=b->DestX;									//backwards if on the wrong end
   													//of the collision
 if ((!(b->Location.YVelocity*Location.YVelocity>0))&&abs(b->Location.YVelocity*b->Attributes.Weight)>abs(Location.YVelocity*Attributes.Weight))
   DestY=b->DestY;


 //determines the new component vectors after the collisions
/* double axSpeed=abs(((abs(Location.XVelocity)*Attributes.Weight)-(abs(b->Location.XVelocity)*
                                  b->Attributes.Weight))/Attributes.Weight)/1.5;
 double bxSpeed=abs(((abs(b->Location.XVelocity)*b->Attributes.Weight)-(abs(Location.XVelocity)*
                                   Attributes.Weight))/b->Attributes.Weight)/1.5;
 double aySpeed=abs(((abs(Location.YVelocity)*Attributes.Weight)-(abs(b->Location.YVelocity)*
                                  b->Attributes.Weight))/Attributes.Weight)/1.5;
 double bySpeed=abs(((abs(b->Location.YVelocity)*b->Attributes.Weight)-(abs(Location.YVelocity)*
                                   Attributes.Weight))/b->Attributes.Weight)/1.5;
*/

 double axSpeed=abs((Location.XVelocity*Attributes.Weight)-(b->Location.XVelocity*
                                  b->Attributes.Weight))/Attributes.Weight/1.5;
 double bxSpeed=abs((b->Location.XVelocity*b->Attributes.Weight)-(Location.XVelocity*
                                   Attributes.Weight))/b->Attributes.Weight/1.5;
 double aySpeed=abs((Location.YVelocity*Attributes.Weight)-(b->Location.YVelocity*
                                  b->Attributes.Weight))/Attributes.Weight/1.5;
 double bySpeed=abs((b->Location.YVelocity*b->Attributes.Weight)-(Location.YVelocity*
                                   Attributes.Weight))/b->Attributes.Weight/1.5;


 if (DestX<Location.X&&axSpeed>0)
		axSpeed=-axSpeed;
 if (DestY<Location.Y&&aySpeed>0)
		aySpeed=-aySpeed;



 Location.XVelocity=axSpeed;
 Location.YVelocity=aySpeed;

 if ((abs(tempx-Location.XVelocity)>15||abs(tempy-Location.YVelocity)>15)&&InControl>=0)
	{
//   InControl=-50;		//determine if the first player is knocked over
		 Body.Joints.Hip.XVelocity=-axSpeed;
   Body.Joints.Hip.YVelocity=-aySpeed;
	}
 else if ((abs(tempx-Location.XVelocity)>5||abs(tempy-Location.YVelocity)>10)&&InControl>=0)
	{
//   InControl=-10;
		 Body.Joints.Hip.XVelocity=-axSpeed;
   Body.Joints.Hip.YVelocity=-aySpeed;
 }
 tempx=b->Location.XVelocity;
 tempy=b->Location.YVelocity;

 //handle the outcome for the second player
 if ((!(b->Location.XVelocity*Location.XVelocity>0))&&abs(b->Location.XVelocity*b->Attributes.Weight)<abs(Location.XVelocity*Attributes.Weight))
   b->DestX=DestX;
 if ((!(b->Location.YVelocity*Location.YVelocity>0))&&abs(b->Location.YVelocity*b->Attributes.Weight)<abs(Location.YVelocity*Attributes.Weight))
   b->DestY=DestY;

 if (b->DestX<b->Location.X&&bxSpeed>0)
		bxSpeed=-bxSpeed;
 if (b->DestY<b->Location.Y&&bySpeed>0)
		bySpeed=-bySpeed;

 b->Location.XVelocity=bxSpeed;
 b->Location.YVelocity=bySpeed;

 if ((abs(tempx-b->Location.XVelocity)>15||abs(tempy-b->Location.YVelocity)>15)&&b->InControl>=0)
	{
//    b->InControl=-50; //check if he's knocked over
 		 b->Body.Joints.Hip.XVelocity=-bxSpeed;
    b->Body.Joints.Hip.YVelocity=-bySpeed;
 }
 if ((abs(tempx-Location.XVelocity)>5||abs(tempy-Location.YVelocity)>5)&&b->InControl>=0)
	{
//   b->InControl=-10; //or hit just enough to stagger him
		 b->Body.Joints.Hip.XVelocity=-bxSpeed;
   b->Body.Joints.Hip.YVelocity=-bySpeed;
	}
 if ((b->Location.X-Location.X)<playerdiameter/2&&(b->Location.X-Location.X)>0)
   b->Location.X=Location.X+playerdiameter/2;
 if ((b->Location.X-Location.X)>-playerdiameter/2&&(b->Location.X-Location.X)<0)
   b->Location.X=Location.X-playerdiameter/2;
 if ((b->Location.Y-Location.Y)<playerdiameter/2&&(b->Location.Y-Location.Y)>0)
   b->Location.Y=Location.Y+playerdiameter/2;
 if ((b->Location.Y-Location.Y)>-playerdiameter/2&&(b->Location.Y-Location.Y)<0)
   b->Location.Y=Location.Y-playerdiameter/2;

}

void GPlayer::Fatigue()
{
 if (abs(Location.XVelocity)>.5||abs(Location.YVelocity)>.5)
   Energy*=(Attributes.Stamina/(Attributes.Stamina+.01));
 else
   Energy*=(Attributes.Stamina+.005)/(Attributes.Stamina);
 if (Energy>100)
  Energy=100;
}

double GPlayer::AdjustForFatigue(double Attribute)
{
 //return 100;
 //return Attribute;
 return (Energy*Attribute)/100;
}

void GPlayer::Move()
//physically move the player
{
 OldLocation=Location;
 double TotalSpeed=sqrt((Location.XVelocity*Location.XVelocity)+(Location.YVelocity*Location.YVelocity))+3;
 if (TotalSpeed>AdjustForFatigue(Attributes.SkatingSpeed/3))
  TotalSpeed=AdjustForFatigue(Attributes.SkatingSpeed/3);
 SetComponents(TotalSpeed);
 // if ((DestY>width||DestY<0)&&OnIce!=1)
   //   cout<<"Uh oh...trying to get off the ice and not tired."<<endl; 

 Location.X+=((Location.XVelocity/1.1)*AdjustForFatigue(Attributes.Quickness))/(FrameRate*100);
 Location.Y+=((Location.YVelocity/1.1)*AdjustForFatigue(Attributes.Quickness))/(FrameRate*100);
 if (Location.X>length)              //bounce off of walls
 {
  Location.X=length;
  Location.XVelocity=-Location.XVelocity;
 }
 if (Location.Y>width&&OnIce)
 {
  Location.Y=width;
  Location.YVelocity=-Location.YVelocity;
 }
 if (Location.Y<0&&OnIce)
 {
  Location.Y=0;
  Location.YVelocity=-Location.YVelocity;
 }
 if (Location.X<0)
 {
  Location.X=0;
  Location.XVelocity=-Location.XVelocity;
 }
 

}


void GPlayer::Walk()
{
	Body.Move();
	Body.Animate(Location,&BaseModel->BodyParts,Shooting);
}

/*
void GPlayer::Walk()
{
	if (abs(Location.XVelocity)+abs(Location.YVelocity)<5)
	{
		if (abs(Body.LeftFoot.X<1))
		{
			Body.LeftKnee.XVelocity=0;
			Body.LeftFoot.XVelocity=0;
			return;
		}
		if (abs(Body.RightFoot.X<1))
		{
			Body.LeftKnee.XVelocity=0;
			Body.RightFoot.XVelocity=0;
			return;
		}
 }
		Point *leadfoot=&Body.RightFoot;
  Point *leadknee=&Body.RightKnee;
	 Point *trailfoot=&Body.LeftFoot;
	 Point *trailknee=&Body.LeftKnee; 

 	if (((Direction<pi/2||Direction>3*pi/2)&&
		   (Body.LeftFoot.XVelocity>0))||
    ((Direction>pi/2&&Direction<3*pi/2)&&
		   (Body.LeftFoot.XVelocity<0)))
 	{
 		leadfoot=&Body.LeftFoot;
 		leadknee=&Body.LeftKnee;
 		trailfoot=&Body.RightFoot;
 		trailknee=&Body.RightKnee;
 	}
 
// leadfoot->X=sqrt(sqr(leadfoot->X)+sqr(leadfoot->Y));
// trailfoot->X=-sqrt((sqr(trailfoot->X)+sqr(trailfoot->Y)));
// leadknee->X=sqrt(sqr(leadknee->X)+sqr(leadknee->Y));
// trailknee->X=-sqrt((sqr(trailknee->X)+sqr(trailknee->Y)));


	leadfoot->XVelocity=3;
	leadknee->XVelocity=2.5;
	trailfoot->XVelocity=-3;
	trailknee->XVelocity=-2.5;

 Point HipRel;
	HipRel.SetPosition(0,0,6);

/*	if (((Body.RightKnee.XVelocity*Location.XVelocity)>0)&&((Location.XVelocity*HipRel.XZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.RightFoot.XVelocity=0;
	else if (((Body.RightKnee.XVelocity*Location.XVelocity)<0)&&((Location.XVelocity*HipRel.XZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.RightKnee.XVelocity=0;
	if (((Body.LeftKnee.XVelocity*Location.XVelocity)>0)&&((Location.XVelocity*HipRel.XZCrossProduct(Body.LeftKnee,Body.LeftFoot))>0))
		Body.LeftFoot.XVelocity=0;
	else if (((Body.LeftKnee.XVelocity*Location.XVelocity)<0)&&((Location.XVelocity*HipRel.XZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.LeftKnee.XVelocity=0;

	if (((Body.RightKnee.YVelocity*Location.YVelocity)>0)&&((Location.YVelocity*HipRel.YZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.RightFoot.YVelocity=0;
	else if (((Body.RightKnee.YVelocity*Location.YVelocity)<0)&&((Location.YVelocity*HipRel.YZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.RightKnee.YVelocity=0;
	if (((Body.LeftKnee.YVelocity*Location.YVelocity)>0)&&((Location.YVelocity*HipRel.YZCrossProduct(Body.LeftKnee,Body.LeftFoot))>0))
		Body.LeftFoot.YVelocity=0;
	else if (((Body.LeftKnee.YVelocity*Location.YVelocity)<0)&&((Location.YVelocity*HipRel.YZCrossProduct(Body.RightKnee,Body.RightFoot))>0))
		Body.LeftKnee.YVelocity=0;
*/
/*
	Body.LeftElbow.X=Body.RightKnee.X/2;
	Body.RightElbow.X=Body.LeftKnee.X/2;
	Body.LeftHand.X=Body.RightKnee.X;
	Body.RightHand.X=Body.LeftKnee.X;

	leadfoot->Move();
	trailfoot->Move();
	leadknee->Move();
	trailknee->Move();

	leadfoot->CheckRange(playerdiameter*1.5);
	trailfoot->CheckRange(playerdiameter*1.5);
	leadknee->CheckRange(playerdiameter*1.2);
	trailknee->CheckRange(playerdiameter*1.2);


/*	Point *leadfoot=&RightFoot;
 Point *leadknee=&RightKnee;
	Point *trailfoot=&LeftFoot;
	Point *trailknee=&LeftKnee;

	if ((Location.XVelocity>0&&LeftKnee.XVelocity>=0)||
		   (Location.XVelocity<0&&LeftKnee.XVelocity<0))
	{
		leadfoot=&LeftFoot;
		leadknee=&LeftKnee;
		trailfoot=&RightFoot;
		trailknee=&RightKnee;
	}

 double totalspeed=2.5;
 leadfoot->SetComponents(Location.XVelocity, Location.YVelocity, totalspeed);
// trailfoot->SetComponents(-XVelocity, -YVelocity, totalspeed);
 leadknee->SetComponents(Location.XVelocity, Location.YVelocity, totalspeed*.75);
// trailknee->SetComponents(-XVelocity, -YVelocity, totalspeed*.75);
	trailfoot->SetComponents(*leadfoot,-1);
 trailknee->SetComponents(*leadknee,-1);

 Point HipRel;
	HipRel.SetPosition(0,0,6);

	if (((RightKnee.XVelocity*Location.XVelocity)>0)&&((Location.XVelocity*HipRel.XZCrossProduct(RightKnee,RightFoot))>0))
		RightFoot.XVelocity=0;
	else if (((RightKnee.XVelocity*Location.XVelocity)<0)&&((Location.XVelocity*HipRel.XZCrossProduct(RightKnee,RightFoot))>0))
		RightKnee.XVelocity=0;
	if (((LeftKnee.XVelocity*Location.XVelocity)>0)&&((Location.XVelocity*HipRel.XZCrossProduct(LeftKnee,LeftFoot))>0))
		LeftFoot.XVelocity=0;
	else if (((LeftKnee.XVelocity*Location.XVelocity)<0)&&((Location.XVelocity*HipRel.XZCrossProduct(RightKnee,RightFoot))>0))
		LeftKnee.XVelocity=0;

	if (((RightKnee.YVelocity*Location.YVelocity)>0)&&((Location.YVelocity*HipRel.YZCrossProduct(RightKnee,RightFoot))>0))
		RightFoot.YVelocity=0;
	else if (((RightKnee.YVelocity*Location.YVelocity)<0)&&((Location.YVelocity*HipRel.YZCrossProduct(RightKnee,RightFoot))>0))
		RightKnee.YVelocity=0;
	if (((LeftKnee.YVelocity*Location.YVelocity)>0)&&((Location.YVelocity*HipRel.YZCrossProduct(LeftKnee,LeftFoot))>0))
		LeftFoot.YVelocity=0;
	else if (((LeftKnee.YVelocity*Location.YVelocity)<0)&&((Location.YVelocity*HipRel.YZCrossProduct(RightKnee,RightFoot))>0))
		LeftKnee.YVelocity=0;

 Point NextHipRel;
 NextHipRel.SetPosition(Location.XVelocity/2, Location.YVelocity/2,6);

 RightKnee.YVelocity+=1*(2*(HipRel.XYCrossProduct(NextHipRel,RightKnee)>1)-1)*(2*(Location.XVelocity>0)-1);
 RightFoot.YVelocity+=1*(2*(HipRel.XYCrossProduct(NextHipRel,RightFoot)>1)-1)*(2*(Location.XVelocity>0)-1);
 LeftKnee.YVelocity+=1*(2*(HipRel.XYCrossProduct(NextHipRel,LeftKnee)>1)-1)*(2*(Location.XVelocity>0)-1);
 LeftFoot.YVelocity+=1*(2*(HipRel.XYCrossProduct(NextHipRel,LeftFoot)>1)-1)*(2*(Location.XVelocity>0)-1);




 leadfoot->Move();
	trailfoot->Move();
	leadknee->Move();
	trailknee->Move();

 //if (CrossProduct(*leadfoot, *leadknee)

 
	leadfoot->CheckRange(playerdiameter*1.5);
	trailfoot->CheckRange(playerdiameter*1.5);
	leadknee->CheckRange(playerdiameter*.75);
	trailknee->CheckRange(playerdiameter*.75);
*/
 
/*
}
*/


int GPlayer::CountPlayersOnIce(int homeorvisitor)
{
 int answer=0;
 for (int x=0+(homeorvisitor*PlayersPerTeam);x<PlayersPerTeam+(homeorvisitor*PlayersPerTeam);x++)
 	 if (gamestatus[x].Y>0&&gamestatus[x].Y<width)
		 answer++;
 return answer;
}

int GPlayer::ImClosest(Puck p)
{
	int homeorvisitor=HomeOrVisitor;
 for (int i=0;i<PlayersPerTeam*2;i++)
		if (gamestatus[i].InControl&&gamestatus[i].ID!=Attributes.ID&&(gamestatus[i].OnIce==1||gamestatus[i].OnIce==2)&&Distance(gamestatus[i].X, gamestatus[i].Y, p.GetX(), p.GetY())<
			   Distance(Location.X, Location.Y, p.GetX(), p.GetY()))
						return 0;
	return 1;
}

int GPlayer::ImClosestOnMyTeam(Puck p)
{
	int homeorvisitor=HomeOrVisitor;
 for (int i=PlayersPerTeam*homeorvisitor;i<PlayersPerTeam*(homeorvisitor+1);i++)
		if (gamestatus[i].InControl&&gamestatus[i].ID!=Attributes.ID&&(gamestatus[i].OnIce==1||gamestatus[i].OnIce==2)&&Distance(gamestatus[i].X, gamestatus[i].Y, p.GetX(), p.GetY())<
			   Distance(Location.X, Location.Y, p.GetX(), p.GetY()))
						return 0;
	return 1;
}

void GPlayer::SetView(PlayerView status[(PlayersPerTeam*2)+4])
{
	for (int x=0;x<PlayersPerTeam*2+4;x++)
	{
                gamestatus[x].X=status[x].X;
		gamestatus[x].Y=status[x].Y;
		gamestatus[x].Crashing=status[x].Crashing;
		gamestatus[x].InControl=status[x].InControl;
		gamestatus[x].OnIce=status[x].OnIce;
		gamestatus[x].WantsPuck=status[x].WantsPuck;
		gamestatus[x].XVelocity=status[x].XVelocity;
		gamestatus[x].YVelocity=status[x].YVelocity;
		gamestatus[x].ID=status[x].ID;
		gamestatus[x].Position=status[x].Position;
	}
}

int GPlayer::NumDefensemenBehindNet()
{
	int homeorvisitor=HomeOrVisitor;
	int count=0;
	for (int x=PlayersPerTeam*homeorvisitor;x<PlayersPerTeam*(homeorvisitor+1);x++)
		if (gamestatus[x].Position>3&&gamestatus[x].OnIce&&
			  ((homeorvisitor==0&&gamestatus[x].X<homegoalx)||
					 (homeorvisitor==1&&gamestatus[x].X>visitorgoalx)))
						count++;
	return count;
}

void GPlayer::HandleSpray(std::list<SprayMaker> &spraymakers)
{
  if (abs(sqrt(sqr(Location.XVelocity)+sqr(Location.YVelocity))-
          sqrt(sqr(OldLocation.XVelocity)+sqr(OldLocation.YVelocity)))>7&&
      sqrt(sqr(OldLocation.XVelocity)+sqr(OldLocation.YVelocity))>20)
  {
   SprayMaker l(Location);
   spraymakers.insert(spraymakers.begin(),l);
  }
}

int GPlayer::GetID()
{
 return Attributes.ID;
}

int GPlayer::GetPosition()
{
 return Attributes.Position;
}

bool GPlayer::IsDressed()
{
 return true;
}
