// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//gplayer.h

//functions common to all players
#include "PlayerAttributes.h"
#include "Puck.h"
#ifdef USEMFC
#include "stdafx.h"
#include <GL/gl.h>
#else
#include <GL/glut.h>
#endif
#include "Constants.h"
#include "Point.h"
#include "Tiff.h"
#include "Model.h"
#include "SprayMaker.h"
#include <list>

#ifndef GPLAYER
#define GPLAYER

class GPlayer
{
  friend class Game;
  public:
    GPlayer ();			//initialize
    GPlayer(PLAYER_TYPE attr);
	GPlayer(const GPlayer &p);

   ~GPlayer ();
    virtual int CanReachPuck (Puck p);	//determines if the puck is near the player
    int HomeOrVisitor;
#ifndef TWODVERSION
  void GenerateTexture (char *filename);
  void Paint (Puck & p, int CurrentPlayer, int Textures);	//draws the player
#endif
#ifdef TWODVERSION
  void Paint (CDC &dc, Puck &p, int CurrentPlayer);
#endif
  int GetPosition();
  int GetID();
  bool IsDressed();
  virtual void SetComponents (double totalspeed);	//sets the component vectors

  virtual int Surrounded ();	//determines if the player

  virtual int SurroundedInFront ();	//determines if the player

  virtual int SurroundedByBadGuys ();
  //is in danger of being hit
  void SetPosition (PositionData Home, int dot = 0);	//sets up for a faceoff

  int ClearPath (double destx, double desty);	//determines if the path to the given
  //point is clear of obstacles

  void Shoot (Puck & p, double GoalX, double GoalY);
  void Pass (Puck & p);		//passes the puck

  void Check (GPlayer * Victim);	//goes after the victim

  void Move ();			//physically moves the player

  void HandleCollision (GPlayer * b);	//determines the outcome of a collision

  int ImClosest (Puck p);
  int ImClosestOnMyTeam (Puck p);
  virtual int AtDestination ();	//determines if the player is close enough
  //to his destination to be considered at it

  void UpdateDelays (Puck p);
  int TeamPossesses (int homeorvisitor, Puck p);	//determines if a player
  //on the same team possesses
  //the puck

  int ForwardOnTeamPossesses (int homeorvisitor, Puck p);	//determines if a
  //forward on the same team has
  //the puck

  void Fatigue ();
  double AdjustForFatigue (double Attribute);
  double SituationQuality (int i);
  void HandleSpray(std::list<SprayMaker> &spraymakers);

  int OnIce;
 protected:
  Model * BaseModel;
  GLuint TextureName;
  Point Location;
  Point OldLocation;
  PlayerView gamestatus[PlayersPerTeam * 2 + 4];
  int id;			//uniquely identifies the player
  double Direction;
  int InControl;		//whether or not the player is in control of himself

  double DestX;			//the player's destination

  double DestY;
  int Shooting;			//whether the player wants to shoot

  double PassX;			//the location to pass the puck to

  double PassY;
  int PassDelay;		//used to simulate gaining control of the puck before
  //sending it somewhere else

  int PlayerToCheck;		//the id of the player to go after

  int Crashing;
  int PenaltyTime;
  Skeleton Body;
  double Energy;

  void SetModel (Model * model);
  int NumBadGuysBlockingMyShot (double goalx);
  int InMyZone (Puck p);
  int GoodAngle ();
  void Walk ();
  int OnMyHalf (Puck p);
  double PassValue (int i);
  void SetView (PlayerView status[(PlayersPerTeam * 2) + 4]);
  int CountPlayersOnIce (int homeorvisitor);
  double SetPassX ();
  double SetPassY ();
  double SetDumpSpeed (Puck p);
  double SetShotX (double GoalX, double GoalY);
  double SetShotY (double GoalX, double GoalY);
  double SetShotZ (double GoalX, double GoalY);
  double FindPassSpeed (Puck p);
  double SetShotSpeed (Puck p, double GoalX, double GoalY);
  double AdjustXForDot (double y, int dot);
  double AdjustYForDot (double y, int dot);
  int AttackerInFrontOfGoal ();
  int SomebodyIsCrashing ();
  int NumDefensemenBehindNet ();
// private:
  PlayerAttributes Attributes;
};
#endif
