// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//gskater.cpp

//skater specific functions
#include "GSkater.h"
#include <math.h>
#include "Constants.h"
#include "Utils.h"
#include <fstream>
#include <stdlib.h>
using namespace std;


GSkater:: GSkater ():GPlayer ()
//initializes a skater
{
  Attributes.Generate ();
  OnIce = 0;
  Energy = 100;
}

GSkater::GSkater(PLAYER_TYPE attr):GPlayer(attr)
{
  Attributes.Load(attr);
  SAttributes.Load(attr);
  //    cout<<"Skating speed is "<<Attributes.SkatingSpeed<<endl;
    OnIce = 0;
    Energy = 100;
}

GSkater::GSkater(const GSkater &s)//:GPlayer(s)
{
 Attributes = s.Attributes;
 SAttributes = s.SAttributes;
// Attributes.ID = s.Attributes.ID;
// Attributes.Position = s.Attributes.Position;
 OnIce = 0;
 Energy = 100;
}

double GSkater::
ShotQuality ()
{
  double GoalX, GoalY;
  if (HomeOrVisitor==1)
    GoalX = 50;
  else
    GoalX = length - 50;
  GoalY = width / 2;
  double maxdistance = Distance (0, 0, length / 2, width);
  if (maxdistance < 1)
    maxdistance = 1;
  double distance = 1 * Distance (Location.X, Location.Y, GoalX, GoalY);
  if (distance < 1)
    distance = 1;
  double yoffset = 1 * Distance (Location.X, Location.Y, Location.X, width / 2);
  if (yoffset < 1)
    yoffset = 1;
  double angle = .70 * ((double) abs (GoalX - Location.X) / (abs (GoalY - Location.Y) + abs (GoalX - Location.X) + 1) + 1);
  return (100 - ((150 * (distance + yoffset)) / (angle * maxdistance + width / 2))) - (NumBadGuysBlockingMyShot (GoalX) * 10);
//         ((Distance(X,Y,GoalX,GoalY)-(Distance(X,Y,X,width/2)+DistanceFactor)))*100;
}


double GSkater::
AttackX (int homeorvisitor, Puck p, double BlueLine,
	 PositionData Home, CoachSettings coach)
//determines the correct offensive x position for a player
{
  if (p.PlayerInControl != -1 && gamestatus[p.PlayerInControl].ID == Attributes.ID &&
      ((homeorvisitor == 0 && Location.X < BlueLine) ||
       (homeorvisitor == 1 && Location.X > BlueLine)))
    for (int x = PlayersPerTeam * homeorvisitor; x < PlayersPerTeam * (homeorvisitor + 1); x++)
      if ((homeorvisitor == 0 && gamestatus[x].X > BlueLine && gamestatus[x].OnIce > 0) ||
	  (homeorvisitor == 1 && gamestatus[x].X < BlueLine && gamestatus[x].OnIce > 0))
	return BlueLine+(((2*homeorvisitor)-1)*20);
  if (p.PlayerInControl != -1 && gamestatus[p.PlayerInControl].ID == Attributes.ID)
    return Home.OffenseX;
  if (p.PlayerInControl != -1 && gamestatus[p.PlayerInControl].ID != Attributes.ID  &&
      !p.InAttackZone (homeorvisitor, BlueLine))
    return BlueLine+(((2*homeorvisitor)-1)*20);
  if (((p.InAttackZone (homeorvisitor, BlueLine) &&
	((coach.NumForeCheckers <= 2 && p.GetX () > width / 2 && Attributes.Position == 2) ||
	 (coach.NumForeCheckers <= 2 && p.GetX () < width / 2 && Attributes.Position == 1) ||
	 (coach.NumForeCheckers == 2 && Attributes.Position == 0) ||
	 (coach.NumForeCheckers == 3 && Attributes.Position < 3)))
       || (TeamPossesses (homeorvisitor, p) && p.InAttackZone (homeorvisitor, BlueLine))) ||
      gamestatus[p.PlayerInControl].ID == Attributes.ID)
    //if in the opponent's attack zone
    {
      int deepest = DeepestThreat ();
      if (gamestatus[p.PlayerInControl].ID != Attributes.ID && Attributes.Position > 2 && homeorvisitor == 0 && gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity - 50 < BlueLine /*&&deepest>width/2 */ )
	return gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity - 50;
      if (gamestatus[p.PlayerInControl].ID != Attributes.ID && Attributes.Position > 2 && homeorvisitor == 1 && gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity + 50 > BlueLine /*&&deepest<width/2 */ )
	return gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity + 50;
      return Home.OffenseX;
    }
  else
    {
      int deepest = DeepestThreat ();
      if (gamestatus[p.PlayerInControl].ID != Attributes.ID && Attributes.Position > 2 && homeorvisitor == 0 && gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity - 50 < BlueLine /*&&deepest>width/2 */ )
	return gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity - 50;
      if (gamestatus[p.PlayerInControl].ID != Attributes.ID && Attributes.Position > 2 && homeorvisitor == 1 && gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity + 50 > BlueLine /*&&deepest<width/2 */ )
	return gamestatus[deepest].X + 4 * gamestatus[deepest].XVelocity + 50;
      if (homeorvisitor == 0)
	return BlueLine + 20;
      return BlueLine - 20;
    }

}

double GSkater::
AttackY (PositionData Home, Puck p)
//determines the correct offensive y position for a player
{
  if ((Attributes.Position == 4 && p.GetY () > width / 2) ||
      (Attributes.Position == 3 && p.GetY () < width / 2))
    return p.GetY ();
  return Home.OffenseY;
}

int GSkater::
PositionToCover ()
{
  switch (Attributes.Position)
    {
    case 0:
      return 0;
    case 1:
      return 1;
    case 2:
      return 2;
    case 3:
      return 0;
    case 4:
      return 0;
    }
  return 0;
}

double GSkater::
FindManX (PositionData Home)
{
//      return 0; 
  int otherteam = 1;
  if (HomeOrVisitor==1)
    otherteam = 0;
  double result = Home.DefenseX;
  for (int x = PlayersPerTeam * otherteam; x < PlayersPerTeam * (otherteam + 1); x++)
    if (gamestatus[x].Position == PositionToCover () && gamestatus[x].OnIce == 1 &&
      (Distance (Location.X, Location.Y, gamestatus[x].X, gamestatus[x].Y) -
       Distance (Location.X, Location.Y, gamestatus[x].X + gamestatus[x].XVelocity, gamestatus[x].Y) < .5))
      result = gamestatus[x].X + gamestatus[x].XVelocity;
  if (HomeOrVisitor==1)
    result += playerdiameter;
  else
    result -= playerdiameter;
  return result;
}

double GSkater::
FindManY (PositionData Home)
{
  int otherteam = 1;
  if (HomeOrVisitor==1)
    otherteam = 0;
  double result = Home.DefenseY;
  int y=-1;
  for (int x = PlayersPerTeam * otherteam; x < PlayersPerTeam * (otherteam + 1); x++)
    if (gamestatus[x].Position == PositionToCover () && gamestatus[x].OnIce == 1 &&
      (Distance (Location.X, Location.Y, gamestatus[x].X, gamestatus[x].Y) <
       Distance (Location.X, Location.Y, gamestatus[x].X, gamestatus[x].Y + gamestatus[x].YVelocity)))
      {
       result = gamestatus[x].Y + gamestatus[x].YVelocity;
       y=x;
      }
  if (result > width / 2)
    result -= playerdiameter;
  else
    result += playerdiameter;
  //  if (result>width)
  //    cout<<"Hmm...should I follow this guy to his bench? I'm on team "<<HomeOrVisitor<<
  //     ".  His position is "<<gamestatus[y].Position<<", mine is "<<Attributes.Position<<
  //    " and he's at "<<gamestatus[y].X<<", "<<gamestatus[y].Y<<", moving along Y at "<<
  //    gamestatus[y].YVelocity<<". His index is "<<y<<endl;
  return result;
}


int GSkater::
DeepestThreat ()
{
  int homeorvisitor = 0;
  int otherteam = 1;
  double goalx = homegoalx;
  if (HomeOrVisitor==1)
    {
      homeorvisitor = 1;
      otherteam = 0;
      goalx = visitorgoalx;
    }
///     fstream debug("debug.txt",ios::app);
  //      debug<<"Checking deepest.  ="<<otherteam<<endl;
  //      debug.close();

  int deepest = -1;
  for (int x = (otherteam * PlayersPerTeam); x < (otherteam * PlayersPerTeam) + PlayersPerTeam; x++)
    if (deepest == -1 && (gamestatus[x].OnIce == 1||gamestatus[x].OnIce==2))
      deepest = x;
    else if (deepest != -1)
      if (gamestatus[x].OnIce == 1 &&
	  Distance (gamestatus[x].X, gamestatus[x].Y, goalx, width / 2) <
	  Distance (gamestatus[deepest].X, gamestatus[deepest].Y, goalx, width / 2))	//&&
	//                                              ((homeorvisitor==0&&gamestatus[x].X>goalx)||
	//                                               (homeorvisitor==1&&gamestatus[x].X<goalx))))

	{
	  deepest = x;
	}
  return deepest;
}

double GSkater::
DefenseX (int homeorvisitor, Puck p,
	  PositionData Home, CoachSettings coach)
//defensive x position
{
  int otherteam = 1;
  if (homeorvisitor == 1)
    otherteam = 0;
  //return Home.DefenseX;
  PlayerToCheck = -1;
  int deepest = DeepestThreat ();
  double goalx;
  if (homeorvisitor == 0)
    goalx = homegoalx;
  else
    goalx = visitorgoalx;
  if ((p.GetX () > length / 4 && p.GetX () < length - length / 4) &&
      Attributes.Position > 2 &&
      p.InAttackZone (homeorvisitor, BlueLine[otherteam]))	//&&
    //(!TeamPossesses(!homeorvisitor,p)))
    //      ((homeorvisitor==1&&p.GetXVelocity()<0)||
    //      (homeorvisitor==0&&p.GetXVelocity()>0)))

    {
      if (homeorvisitor == 0 && gamestatus[deepest].X + 2 * gamestatus[deepest].XVelocity - 50 < BlueLine[otherteam] /*&&deepest>width/2 */ )
	return gamestatus[deepest].X + 2 * gamestatus[deepest].XVelocity - 50;
      if (homeorvisitor == 1 && gamestatus[deepest].X + 2 * gamestatus[deepest].XVelocity + 50 > BlueLine[otherteam] /*&&deepest<width/2 */ )
	return gamestatus[deepest].X + 2 * gamestatus[deepest].XVelocity + 50;
      return BlueLine[otherteam];
    }
  else if (coach.Coverage == 0 || Attributes.Position > 2 &&
	   (Distance (gamestatus[deepest].X, gamestatus[deepest].Y, goalx, width / 2) <
	 Distance (Home.DefenseX, gamestatus[deepest].Y, goalx, width / 2)))
    {
      int x = deepest;
      if ((gamestatus[x].X < length / 5 || gamestatus[x].X > length - length / 5) &&
      (gamestatus[x].Y > width / 4 && gamestatus[x].Y < width - width / 4) &&
	  ((Attributes.Position == 3 && (gamestatus[x].Y < width / 2 + 10 /*||!PartnerBack(p) */ )) ||
	   (Attributes.Position == 4 && (gamestatus[x].Y > width / 2 - 10 /*||!PartnerBack(p) */ ))) &&
      (abs(gamestatus[x].Y-width/2)<100)&&  gamestatus[x].OnIce == 1 && NumDefensemenBehindNet () <= 1)
	{
	  PlayerToCheck = x;
	  return gamestatus[x].X;
	}
      else
	return Home.DefenseX;
    }
  else if (coach.Coverage == 0 || Attributes.Position > 2)
    return Home.DefenseX;
  else
    return FindManX (Home);
}

double GSkater::
DefenseY (Puck p,
	  PositionData Home, CoachSettings coach)
//defensive y
{
  int homeorvisitor = HomeOrVisitor;
  int otherteam = 1;
  if (homeorvisitor == 1)
    otherteam = 0;

  double goalx;
  if (homeorvisitor == 0)
    goalx = homegoalx;
  else
    goalx = visitorgoalx;
  if ((p.GetX () < length / 4 || p.GetX () > length - length / 4) &&
      p.InAttackZone (homeorvisitor, BlueLine[otherteam]))	//&&
    //(!TeamPossesses(!homeorvisitor,p)))
    //      ((homeorvisitor==1&&p.GetXVelocity()<0)||
    //      (homeorvisitor==0&&p.GetXVelocity()>0)))

    return Home.NeutralY;
  if ((coach.Coverage == 0 || Attributes.Position > 2) &&
      OnMyHalf (p))
    return (width / 2) + ((p.GetY () - width / 2) / 5);		//stay in line with the puck

  else if ((Attributes.Position < 3 && coach.Coverage == 0) ||
	   (Attributes.Position > 2))
    return Home.DefenseY;
  else
//                                      return Home.DefenseY;
    return FindManY (Home);	//+(15*((2*FindManY(Home)<width/2)-1));

}

int GSkater::
PartnerBack (Puck p)
{
  //Badly broken..works better when it's always true:

  return 1;
  int partnerpos = 0;
  if (Attributes.Position % 2 == 0)
    partnerpos = 1;
// if (Attributes.Position==3||At)
  //  partnerpos=0;

  int homeorvisitor = 0;
  double goalx = homegoalx;	//homegoalx;

  if (HomeOrVisitor==1)
    {
      homeorvisitor = 1;
      goalx = visitorgoalx;	//visitorgoalx; //!!!Suspicious...!!!!

    }

  for (int x = PlayersPerTeam * homeorvisitor; x < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); x++)
    if (gamestatus[x].Position == partnerpos && gamestatus[x].OnIce == 1 &&
	gamestatus[x].X > homegoalx + 10 && gamestatus[x].X < visitorgoalx - 10 &&
	Distance (goalx, width / 2, p.GetX (), p.GetY ()) + 20 >
	Distance (goalx, width / 2, gamestatus[x].X, gamestatus[x].Y))
      return 1;
//   else return 0;
  return 0;
}


void GSkater::
MoveTowardsPuck (Puck p)
{
  DestX = p.GetX () + p.GetXVelocity ();	//then move towards the puck

  DestY = p.GetY () + p.GetXVelocity ();
  // if (PlayerToCheck>=-1)
  if (p.PlayerInControl<PlayersPerTeam*2)
   PlayerToCheck = p.PlayerInControl;	//take it from whoever has it

}

void GSkater::
HandleLineChanges (int priority)
{
  int homeorvisitor = HomeOrVisitor;
  if (OnIce == 2 && priority == 1)
    {
      DestX = (length / 2 + 50) + (-100 * homeorvisitor);
      DestY = (width);
    }
  if (OnIce == 2 && Location.Y > (width - (width / 3)))
    {
      DestX = (length / 2 + 50) + (-100 * homeorvisitor);
      DestY = (width);
    }
}



void GSkater::
SetShot (Puck p, CoachSettings Coach)
{
  int homeorvisitor = HomeOrVisitor;
  double goalx;
  if (homeorvisitor == 0)
    goalx = visitorgoalx;
  else
    goalx = homegoalx;
  int surroundedbybadguys = SurroundedByBadGuys ();
  double ScaledSQ = ((maxshotquality - minshotquality) * (100 - Coach.ShotAggression)) / 100;
  ScaledSQ += minshotquality;
  if ((!surroundedbybadguys || (Distance (Location.X, Location.Y, goalx, width / 2) < 70 && rand () % 5000 < Attributes.StickHandling)) &&
      ((GoodAngle () && (ShotQuality () >= ScaledSQ ||
     (AttackerInFrontOfGoal () && NumBadGuysBlockingMyShot (goalx) <= 2)))))	//and not too far in the zone

    if (surroundedbybadguys)
      Shooting = 3;		//*(p.ClearPath(homegoalx,width/2,gamestatus,homeorvisitor)||Attributes.Position>2); //shoot if

    else			//the path is clear

      Shooting = 10;		//*(p.ClearPath(homegoalx,width/2,gamestatus,homeorvisitor)||Attributes.Position>2); //shoot if

}

void GSkater::
HeadTowardsGoal ()
{
  int homeorvisitor = 0;
  int otherteam = 0;
  if (HomeOrVisitor==1)
    {
      homeorvisitor = 1;
      otherteam = 0;
    }
  double goalx;
  if (homeorvisitor == 0)
    goalx = visitorgoalx;
  else
    goalx = homegoalx;
  //if (ClearPath(goalx-(20*(-1*otherteam)),width/2))
  //{
  DestX = goalx - (20 * (-1 * otherteam));
  DestY = width / 2;
  //}
}

void GSkater::
SetOffensiveAction (Puck p,
		    PositionData Home, CoachSettings Coach)
{
  int homeorvisitor = HomeOrVisitor;
  int otherteam = !homeorvisitor;
  if ((!TeamPossesses (homeorvisitor, p))	//but don't control it
       && ((Attributes.Position % 5 < 3) || abs (p.GetX () - Location.X) < 100 || ImClosest (p))	//and you're not a defenseman,

  //or you're really close to where
  //you should be
      &&
      ((Attributes.Position < 3 && Distance (Location.X, Location.Y, p.GetX (), p.GetY ()) < 2 * Coach.StayHomeAttack) || ImClosestOnMyTeam (p)) &&
      (OnMyHalf (p) || ImClosest (p)) &&
      ((Distance (Location.X, Location.Y, p.GetX (), p.GetY ()) < 50) ||
       (ImClosestOnMyTeam (p)) ||
       (Coach.NumForeCheckers <= 2 && p.GetX () > width / 2 && Attributes.Position == 1) ||
       (Coach.NumForeCheckers <= 2 && p.GetX () < width / 2 && Attributes.Position == 2) ||
       (Coach.NumForeCheckers == 2 && Attributes.Position == 0) ||
       (Coach.NumForeCheckers == 3 && Attributes.Position < 3)))	//of the ice

    {
      Crashing = 0;
      MoveTowardsPuck (p);
      HandleLineChanges (1);
    }
  else if (TeamPossesses (otherteam, p) &&	//if the other team has the puck
	    (Attributes.Position > 2 ||		//and you're a defenseman
	      (!ImClosest (p) && !OnMyHalf (p))) &&
	   ((homeorvisitor == 1 && p.GetXVelocity () > 0) ||
	    (homeorvisitor == 0 && p.GetXVelocity () < 0)))
    {
      DestX = DefenseX (homeorvisitor, p, Home, Coach);
      //start moving towards the other end
      DestY = DefenseY (p, Home, Coach);
      Shooting = 0;
      HandleLineChanges (0);
    }
  else
    {
      if (!SomebodyIsCrashing () && AttackX (homeorvisitor, p, BlueLine[otherteam], Home, Coach) != BlueLine[otherteam] &&
	  ((homeorvisitor == 1 && (Location.X < BlueLine[0] - 20)) ||
	   (homeorvisitor == 0 && Location.X > BlueLine[1] + 20)))	//line up in

	if (homeorvisitor == 0)
	  {
	    Crashing = 1;
	    DestX = visitorgoalx - 50;
	    DestY = width / 2;
	  }
	else
	  {
	    Crashing = 1;
	    DestX = homegoalx + 50;
	    DestY = width / 2;
	  }
      else
	{
	  DestX = AttackX (homeorvisitor, p, BlueLine[otherteam], Home, Coach);		//line up in

	  DestY = AttackY (Home, p);	//standard offensive positions

	  if (p.PlayerInControl != -1 && Shooting <= 0 && gamestatus[p.PlayerInControl].ID == Attributes.ID)		//if not already shooting

	    SetShot (p, Coach);
	  HandleLineChanges (1);
	}
    }
  if (gamestatus[p.PlayerInControl].ID ==Attributes.ID && Breakaway ())
    HeadTowardsGoal ();


}

void GSkater::
SetDefensiveAction (Puck p,
		    PositionData Home, CoachSettings Coach)
{
  PlayerToCheck = -1;
  int homeorvisitor = HomeOrVisitor;
  int otherteam = 0;
  if (HomeOrVisitor==0)
   otherteam=1;
  int partnerback = PartnerBack (p);
  int imclosest /*onmyteam */  = ImClosest /*OnMyTeam */ (p);
  Crashing = 0;			//reset...

  if (!TeamPossesses (homeorvisitor, p) &&	//but don't control it
       (Attributes.Position == 0 ||	//and you're a center or the puck is in your half
	 (imclosest /*onmyteam */  && (OnMyHalf (p) || !partnerback) && (Attributes.Position > 2 && (p.GetX () < length / 4 || p.GetX () > length - length / 4))) ||
	((Attributes.Position == 3 || Attributes.Position == 4) && !partnerback && NumDefensemenBehindNet () <= 1) ||
	(Attributes.Position > 2 && OnMyHalf (p) && (p.GetX () < length / 5 || p.GetX () > length - length / 5))) &&
      Distance (Location.X, Location.Y, Home.DefenseX, Home.DefenseY) <= 100 + Coach.StayHomeAttack &&
      (Coach.Coverage == 0 || Attributes.Position > 2 || Distance (Location.X, Location.Y, FindManX (Home), FindManY (Home) <= Coach.StayHomeAttack)))
    {
      MoveTowardsPuck (p);
      //PlayerToCheck=id;
      //DestX=DefenseX(homeorvisitor, p, BlueLine[otherteam], Home, Coach);
      //DestY=DefenseY(p, Home, Coach);   //if not safe, set up in a defensive Attributes.Position
    }
  else if (Attributes.Position > 2 && gamestatus[p.PlayerInControl].ID == Attributes.ID)	//if a defenseman and you have
    //the puck

    {
      DestX = AttackX (homeorvisitor, p, BlueLine[otherteam], Home, Coach);
      DestY = AttackY (Home, p);	//carry it out

    }
  else if (ForwardOnTeamPossesses (homeorvisitor, p) &&		//if it's safe to
    //(Attributes.Position!=0||p.PlayerInControl==id)&&
	    (Attributes.Position < 3 || !OnMyHalf (p)) &&
	   (p.GetX () > (length / 2 - length / 3) && p.GetX () < length - (length / 2 - length / 3))
    /*(Coach.Coverage==0||p.PlayerInControl==id) */ )
    //vacate

    {
      DestX = AttackX (homeorvisitor, p, BlueLine[otherteam], Home, Coach);	//do so

      DestY = AttackY (Home, p);
      //   Shooting=1;
      HandleLineChanges (0);
    }
  else
    {
      DestX = DefenseX (homeorvisitor, p, Home, Coach);
      DestY = DefenseY (p, Home, Coach);	//if not safe, set up in a defensive Attributes.Position

      if (PlayerToCheck != -1)
	{
	  DestX = gamestatus[PlayerToCheck].X;
	  DestY = gamestatus[PlayerToCheck].Y;
	}
      //PlayerToCheck=25;
      Shooting = 0;
    }
}

void GSkater::
SetNeutralZoneAction (Puck p,
		      PositionData Home, CoachSettings Coach)
{
  int homeorvisitor = HomeOrVisitor;
  int otherteam = !homeorvisitor;
  if (TeamPossesses (homeorvisitor, p))		//In neutral zone with puck

    {
      if (Attributes.Position<3)
      {
       DestX = AttackX (homeorvisitor, p, BlueLine[otherteam], Home, Coach);
      //if someone on your team has the puck in the neutral zone,
       DestY = AttackY (Home, p);	//head toward the attack zone
      }
      else
      {
       DestX = Home.NeutralX;
       DestY = Home.NeutralY;
      }
      //   Shooting=1;

      HandleLineChanges (0);
    }
  else if (TeamPossesses (otherteam, p))
    {
      DestX = DefenseX (homeorvisitor, p, Home, Coach);
      //if the other team has it,
      DestY = DefenseY (p, Home, Coach);	//move towards the other zone

      Shooting = 0;
      HandleLineChanges (0);
    }
  else				//In Neutral Zone and don't have the puck

    if (ImClosest (p) ||
	(Attributes.Position < 3	//try to get it if a forward
	  && (Attributes.Position == 0 ||	//or it's on your half
	       OnMyHalf (p))))

    {
      MoveTowardsPuck (p);
      HandleLineChanges (0);
    }
  else
    {
      DestX = DefenseX (homeorvisitor, p, Home, Coach);		//if a

      DestY = DefenseY (p, Home, Coach);	//defenseman or it's in the opposite half
      //assume the worst and set up in the defensive zone

      Shooting = 0;
    }
}

void GSkater::
AvoidObstacles (Puck p)
{
  int homeorvisitor = HomeOrVisitor;
  int otherteam=0;
  if (HomeOrVisitor==0)
   otherteam=1;
  if (DestY > Location.Y && DestY - Location.Y > 50)	//don't plan too far ahead

    DestY = Location.Y + 50;
  else if (DestY < Location.Y && Location.Y - DestY > 50)
    DestY = Location.Y - 50;

  if (DestX > Location.X && DestX - Location.X > 50)
    DestX = Location.X + 50;
  else if (DestX < Location.X && Location.X - DestX > 50)
    DestX = Location.X - 50;

  int xdirection = 1;		//set up for evasion heuristic

  int ydirection = 1;
  if (DestX > Location.X)
    xdirection = 0;
  if (DestY > Location.Y)
    ydirection = 0;

  if (((SurroundedInFront () ||	//under pressure and need to evade
	 !ClearPath (DestX, DestY)) &&
       (!Crashing) &&
       (PlayerToCheck < 0)))	//and not trying to run into someone
    //       (AtDestination()&&
    //     !p.ClearPath(X,Y,gamestatus,homeorvisitor))&&
    //     PlayerToCheck>=0)

    {
      if (ClearPath (Location.X + (50 * (3 - (2 * (1 + xdirection)))),
		     Location.Y + (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving down and toward the destination first
	  DestX = Location.X + (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y + (50 * (3 - (2 * (1 + ydirection))));
	}
      else if (ClearPath (Location.X + (50 * (3 - (2 * (1 + xdirection)))), Location.Y))
	{
	  //try moving directly toward the destination next <shrug>
	  DestX = Location.X + (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y;
	}
      else if (ClearPath (Location.X + (50 * (3 - (2 * (1 + xdirection)))),
			  Location.Y - (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving up and toward the destination
	  DestX = Location.X + (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y - (50 * (3 - (2 * (1 + ydirection))));
	}
      else if (ClearPath (Location.X, Location.Y - (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving straight up
	  DestY = Location.Y - (50 * (3 - (2 * (1 + ydirection))));
	  DestX = Location.X;
	}
      else if (ClearPath (Location.X, Location.Y + (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving straight down
	  DestY = Location.Y + (50 * (3 - (2 * (1 + ydirection))));
	  DestX = Location.X;
	}
      else if ((!(abs (width / 2 - Location.Y) < 100 && gamestatus[p.PlayerInControl].ID == Attributes.ID &&
		  p.InAttackZone (otherteam, BlueLine[homeorvisitor]))) &&
	       ClearPath (Location.X - (50 * (3 - (2 * (1 + xdirection)))),
			  Location.Y + (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving down and away
	  DestX = Location.X - (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y + (50 * (3 - (2 * (1 + ydirection))));
	}
      else if ((!(abs (width / 2 - Location.Y) < 100 && gamestatus[p.PlayerInControl].ID == Attributes.ID &&
		  p.InAttackZone (otherteam, BlueLine[homeorvisitor]))) &&
	       ClearPath (Location.X - (50 * (3 - (2 * (1 + xdirection)))), Location.Y))
	{
	  //try moving directly away
	  DestX = Location.X - (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y;
	}
      else if ((!(abs (width / 2 - Location.Y) < 100 && gamestatus[p.PlayerInControl].ID == Attributes.ID &&
		  p.InAttackZone (otherteam, BlueLine[homeorvisitor]))) &&
	       ClearPath (Location.X - (50 * (3 - (2 * (1 + xdirection)))),
			  Location.Y - (50 * (3 - (2 * (1 + ydirection))))))
	{
	  //try moving up and away
	  DestX = Location.X - (50 * (3 - (2 * (1 + xdirection))));
	  DestY = Location.Y - (50 * (3 - (2 * (1 + ydirection))));
	}
    }

//goal

  if ((Location.X < homegoalx - 5 - goalwidth / 2) && (abs (Location.Y - width / 2) < goallength) && DestX > homegoalx - 5)
    {
      DestX = Location.X;
      DestY = (int) width *(Attributes.Position % 2);
    }

  if ((Location.X > visitorgoalx + 5 + goalwidth / 2) && (abs (Location.Y - width / 2) < goallength) && DestX < visitorgoalx + 5)
    {
      DestX = Location.X;
      DestY = (int) width *(Attributes.Position % 2);
    }

  if ((Location.X > homegoalx + 5 + goalwidth / 2) && (abs (Location.Y - width / 2) < goallength) && DestX < homegoalx + 5)
    {
      DestX = Location.X;
      DestY = (int) width *(Attributes.Position % 2);
    }

  if ((Location.X < visitorgoalx - 5 - goalwidth / 2) && (abs (Location.Y - width / 2) < goallength) && DestX > visitorgoalx - 5)
    {
      DestX = Location.X;
      DestY = (int) width *(Attributes.Position % 2);
    }


}


void GSkater::
SetPasses (Puck p)
{
  int homeorvisitor = 0;
  int otherteam = 1;
  if (HomeOrVisitor==1)
    {
      homeorvisitor = 1;
      otherteam = 0;
    }
  if (PassX > 0)
    PassX = 0;
  PassY = 0;

  int PlayerToPassTo = -1;

  for (int i = 0 + (PlayersPerTeam * homeorvisitor); i < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); i++)
    if (
	//PassValue (i) > PassValue (id) &&
	!SurroundedInFront () &&
	p.ClearPath (gamestatus[i].X, gamestatus[i].Y,
		     gamestatus, homeorvisitor) == 1 &&		//but have an open teammate
	 p.ClearPath (gamestatus[i].X + ((Distance (Location.X, Location.Y, gamestatus[PlayerToPassTo].X, gamestatus[PlayerToPassTo].Y) / 100) * gamestatus[PlayerToPassTo].XVelocity),
		      gamestatus[i].Y + ((Distance (Location.X, Location.Y, gamestatus[PlayerToPassTo].X, gamestatus[PlayerToPassTo].Y) / 100) * gamestatus[PlayerToPassTo].XVelocity),
		      gamestatus, homeorvisitor) == 1 &&	//but have an open teammate
	 gamestatus[i].InControl > -5 &&
	PassX >= 0 &&
	 (((!p.InAttackZone (homeorvisitor, BlueLine[otherteam]))&&(gamestatus[i].X*((2*homeorvisitor)-1)<Location.X*((2*homeorvisitor)-1))/*&&((gamestatus[i].Y < width / 5 && Location.Y < width / 2) &&
																	     (gamestatus[i].Y > width - width / 5 && Location.Y > width / 2))*/) ||
	 (homeorvisitor == 1 && ((p.InAttackZone (homeorvisitor, BlueLine[otherteam]) && gamestatus[i].X < BlueLine[otherteam])))||
	 (homeorvisitor == 0 && ((p.InAttackZone (homeorvisitor, BlueLine[otherteam]) && gamestatus[i].X > BlueLine[otherteam]))))&&
	gamestatus[i].ID != Attributes.ID &&
	gamestatus[i].OnIce)
      {
	//	cout<<"Passing...inattackzone="<<p.InAttackZone (homeorvisitor, BlueLine[otherteam])<<endl;
	if (PlayerToPassTo == -1 ||
	    PassValue (PlayerToPassTo) >
	    PassValue (i))
	  PlayerToPassTo = i;
      }
  if (PlayerToPassTo != -1)
    {
      //pass to the open teammate
      PassX = gamestatus[PlayerToPassTo].X + ((Distance (Location.X, Location.Y, gamestatus[PlayerToPassTo].X, gamestatus[PlayerToPassTo].Y) / 100) * gamestatus[PlayerToPassTo].XVelocity);
      PassY = gamestatus[PlayerToPassTo].Y + ((Distance (Location.X, Location.Y, gamestatus[PlayerToPassTo].X, gamestatus[PlayerToPassTo].Y) / 100) * gamestatus[PlayerToPassTo].YVelocity);
      //Shooting=0; //cancel any thoughts of shooting
    }
/*      if (PassX>0&&p.PlayerInControl==id)
   {
   fstream debug("debug.txt",ios::app);
   debug<<"Passing from ("<<Location.X<<", "<<Location.Y<<") to ("<<PassX<<", "<<PassY<<").  Clearpath="<<p.ClearPath(PassX,PassY,gamestatus,homeorvisitor)<<endl;
   debug<<"Other thingie="<<(!p.InAttackZone(otherteam,BlueLine[homeorvisitor])||
   (gamestatus[i].Y<width/5&&Location.Y<width/2)||
   (gamestatus[i].Y>width-width/5&&Location.Y>width/2))&&
   (homeorvisitor==1&&((p.InAttackZone(homeorvisitor,BlueLine[otherteam])&&gamestatus[i].X<BlueLine[otherteam])||
   (gamestatus[i].X-50<Location.X))||
   //don't pass too far backwards
   (homeorvisitor==0&&((p.InAttackZone(homeorvisitor,BlueLine[otherteam])&&gamestatus[i].X>BlueLine[otherteam])||
   (gamestatus[i].X+50>Location.X))));
   debug<<"\n";

   debug.close();
   }
 */
}

int GSkater::
Breakaway ()
{
  int homeorvisitor = 0;
  int otherteam = 1;
  int x;
  if (HomeOrVisitor==1)
    {
      homeorvisitor = 1;
      otherteam = 0;
    }
  double goalx = homegoalx;
  if (homeorvisitor == 0)
    goalx = visitorgoalx;
  int numgoodguys = 1;
  int numbadguys = 0;
  for (x = homeorvisitor * PlayersPerTeam; x < (homeorvisitor + 1) * PlayersPerTeam; x++)
    if (((homeorvisitor == 1 && gamestatus[x].X < Location.X) ||
	 (homeorvisitor == 0 && gamestatus[x].X > Location.X)) &&
    //abs(gamestatus[x].Y-width/2)<abs(Distance(X,Y,goalx,width/2))&&
	gamestatus[x].OnIce == 1)
      numgoodguys++;
  for (x = otherteam * PlayersPerTeam; x < (otherteam + 1) * PlayersPerTeam; x++)
    if (((homeorvisitor == 1 && gamestatus[x].X < Location.X) ||
	 (homeorvisitor == 0 && gamestatus[x].X > Location.X)) &&
	abs (gamestatus[x].Y - width / 2) < abs (Distance (Location.X, Location.Y, goalx, width / 2)) &&
    //abs(gamestatus[x].Y-width/2)<abs(Location.Y-width/2)&&
	gamestatus[x].OnIce == 1)
      numbadguys++;
  if (numgoodguys > numbadguys)
    return 1;
  return 0;
}

void GSkater::
SetDump (Puck p, CoachSettings Coach)
{
  double PassDump = .5 * Coach.PassDump + 50;

  int homeorvisitor = HomeOrVisitor;
  int otherteam = !homeorvisitor;
  if (!Breakaway () &&
      !Shooting &&
      (Attributes.Position > 2 ||
       ((AdjustForFatigue (Attributes.SkatingSpeed) + AdjustForFatigue (Attributes.Quickness)) / 2) < PassDump) &&
  (CountPlayersOnIce (homeorvisitor) < CountPlayersOnIce (!homeorvisitor) ||
   ((!homeorvisitor && Location.X > length / 2) || (homeorvisitor && Location.X < length / 2))) &&
  //in the attacking half
  //    (!p.InAttackZone(homeorvisitor,BlueLine[otherteam]))&&
  //    (PassX>=0)&&
      (				/*!ClearPath(DestX, DestY, gamestatus, homeorvisitor)|| */
	SurroundedInFront () || OnIce == 2) &&	//and under pressure
       (Location.X > length / 4) &&	//and not too deep into an attack zone
       (Location.X < length - (length / 4)) &&
      PassX == 0 && PassY == 0)	//and have no one to pass to

    if (homeorvisitor == 0)
      {
	PassX = length;		//dump the puck into the attack zone

	if (Attributes.Position % 2 == 1)
	  PassY = 1;
	else
	  PassY = width;
	//PassY=Y;
      }
    else
      {
	PassX = 1;
	if (Attributes.Position % 2 == 1)
	  PassY = 1;
	else
	  PassY = width;
	//PassY=Y;
      }
}

void GSkater::
SetChecking (Puck p, CoachSettings Coach)
{
  int homeorvisitor = 0;
  if (HomeOrVisitor==1)
    homeorvisitor = 1;
  if (Distance (Location.X, Location.Y, p.GetX (), p.GetY ()) < playerdiameter * 2 * (.5 + (1 - ((double) Coach.ManPuck / 100))) &&	// if can reach the puck
       p.PlayerInControl < PlayersPerTeam * 2 &&
      (Attributes.Position < 3 || ((InMyZone (p) && OnMyHalf (p)) || !PartnerBack (p))) &&
      (Distance (Location.X, Location.Y, gamestatus[p.PlayerInControl].X, gamestatus[p.PlayerInControl].Y) < Coach.StayHomeAttack / 2) &&
      ((homeorvisitor == 0 && p.PlayerInControl >= PlayersPerTeam &&p.PlayerInControl<PlayersPerTeam*2) ||	//and the player in control
        (homeorvisitor == 1 && p.PlayerInControl < PlayersPerTeam)) &&	//of it is from the opposite
  // team
       (PlayerToCheck >= -1))
    PlayerToCheck = p.PlayerInControl;	//check him

}

void GSkater::
SetAction (PlayerView status[(PlayersPerTeam * 2) + 4], Puck p,
	   KeyData Keys)
{
  SetView (status);
  int homeorvisitor = 0;
  if (HomeOrVisitor==1)
    homeorvisitor = 1;
  if (Keys.up)
    DestY = Location.Y - 50;
  else if (Keys.down)
    DestY = Location.Y + 50;
  else
    DestY = Location.Y;
  if (Keys.left)
    DestX = Location.X + 50;
  else if (Keys.right)
    DestX = Location.X - 50;
  else
    DestX = Location.X;
  if (Keys.shoot)
    Shooting = 10;

  if (p.PlayerInControl==-1 || !gamestatus[p.PlayerInControl].ID == Attributes.ID)
    {
    Shooting = 0;
    //    cout<<"Cancelled shot...don't have the puck!"<<endl;
    }
  int playertopassto = -1;
  if (Keys.pass && PassX >= 0)
    {
      PassDelay = 0;
      for (int x = PlayersPerTeam * homeorvisitor; x < PlayersPerTeam * (homeorvisitor + 1); x++)
	if (gamestatus[x].ID != Attributes.ID &&
	    (gamestatus[x].X < Location.X && Keys.right ||
	     gamestatus[x].X > Location.X && Keys.left ||
	     (!Keys.left && !Keys.right && abs ((gamestatus[x].X - Location.X) / (gamestatus[x].Y - Location.Y)) < 1)) &&
	    (gamestatus[x].Y < Location.Y && Keys.up ||
	     gamestatus[x].Y > Location.Y && Keys.down ||
	     (!Keys.up && !Keys.down && abs ((gamestatus[x].X - Location.X) / (gamestatus[x].Y - Location.Y)) > 1)) &&
	    (playertopassto == -1 ||
	Distance (Location.X, Location.Y, gamestatus[x].X, gamestatus[x].Y) <
	     Distance (Location.X, Location.Y, gamestatus[playertopassto].X, gamestatus[playertopassto].Y)))
	  playertopassto = x;
      if (playertopassto == -1)
	{
	  if (Keys.left)
	    PassX = Location.X + 200;
	  else if (Keys.right)
	    PassX = Location.X - 200;
	  else
	    PassX = Location.X;
	  if (Keys.up)
	    PassY = Location.Y - 200;
	  else if (Keys.down)
	    PassY = Location.Y + 200;
	  else
	    PassY = Location.Y;
	}
      else
	{
	  PassX = gamestatus[playertopassto].X + gamestatus[playertopassto].XVelocity;
	  PassY = gamestatus[playertopassto].Y + gamestatus[playertopassto].YVelocity;
	}
    }
  else if (Keys.dump)
    {
      PassDelay = 0;
      if (homeorvisitor == 0)
	PassX = length;
      else
	PassX = 1;
      if (Location.Y < width / 2)
	PassY = 1;
      else
	PassY = width;
    }
  else
    {
      if (PassX >= 0)
	PassX = 0;
      PassY = 0;
    }
}



void GSkater::
SetAction (PlayerView status[(PlayersPerTeam * 2) + 4], Puck p,
	   PositionData Home, CoachSettings Coach)
//figures out what to do in a frame
{
  SetView (status);
  int position = Attributes.Position;	//(attributes.position)    //make quick reference variables

  int homeorvisitor = HomeOrVisitor;;
  int otherteam = !homeorvisitor;
  if (abs (otherteam) != 0)
    otherteam = 1;
  else
    homeorvisitor = 1;
  if (p.InAttackZone (homeorvisitor, BlueLine[otherteam]))	//if on offense

    SetOffensiveAction (p, Home, Coach);
  else if (p.InAttackZone (otherteam, BlueLine[homeorvisitor]))		//if defending

    SetDefensiveAction (p, Home, Coach);
  else
    SetNeutralZoneAction (p, Home, Coach);


  AvoidObstacles (p);
  if (gamestatus[p.PlayerInControl].ID == Attributes.ID)
    {
      SetPasses (p);
      SetDump (p, Coach);
    }
  else
    SetChecking (p, Coach);

}

int GSkater::SpeedFactor()
{
 return Attributes.SpeedFactor() + SAttributes.SpeedFactor();
}

int GSkater::PowerFactor()
{
 return Attributes.PowerFactor() + SAttributes.SpeedFactor();
}
