// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//gskater.h

//skater specific functions

#include "SkaterAttributes.h"
#include "Puck.h"
#ifdef USEMFC
#include "stdafx.h"
#endif
#include "GPlayer.h"
#include "Constants.h"
#include <vector>
using namespace std;


#ifndef GSKATER
#define GSKATER

class GSkater:public GPlayer
{
  friend class Game;
    public:
    GSkater ();			//initializes, sets all attributes
    GSkater (PLAYER_TYPE attr);
    GSkater(const GSkater &s);
  int SpeedFactor();
  int PowerFactor();
  double AttackX (int homeorvisitor, Puck p, double BlueLine, PositionData Home, CoachSettings coach);
  //determines the correct offensive x position for a player
  double AttackY (PositionData Home, Puck p);
  //determines the correct offensive y position for a player
  double DefenseX (int homeorvisitor, Puck p,
		   PositionData Home, CoachSettings coach);
  //defensive x position
  double DefenseY (Puck p,
		   PositionData Home, CoachSettings coach);
  //defensive y
  void SetAction (PlayerView status[(PlayersPerTeam * 2) + 4], Puck p,
		  PositionData Home, CoachSettings Coach);
  //sets a player's actions for a frame.  this is where most
  //of the AI is done

  void SetAction (PlayerView status[(PlayersPerTeam * 2) + 4], Puck p, KeyData Keys);

    protected:
  int Breakaway ();
  int DeepestThreat ();
  int PartnerBack (Puck p);
  void HeadTowardsGoal ();
  void MoveTowardsPuck (Puck p);
  void HandleLineChanges (int priority);
  void SetShot (Puck p, CoachSettings Coach);
  void SetDump (Puck p, CoachSettings Coach);
  double ShotQuality ();
  void SetOffensiveAction (Puck p,
			   PositionData Home, CoachSettings Coach);
  void SetDefensiveAction (Puck p,
			   PositionData Home, CoachSettings Coach);
  void SetNeutralZoneAction (Puck p,
			     PositionData Home, CoachSettings Coach);
  void AvoidObstacles (Puck p);
  void SetPasses (Puck p);
  void SetChecking (Puck p, CoachSettings Coach);
  int PositionToCover ();
  double FindManX (PositionData Home);
  double FindManY (PositionData Home);
  SkaterAttributes SAttributes;
};

typedef vector<GSkater> SKATERLIST;
#endif
