#include "Database.h"
#include "GTeam.h"

GTeam::GTeam():Skaters(), Goalies()
{
 for (int x=0;x<5;x++)
  ActivePlayers[x]=0;
}

GTeam::GTeam(int teamID)	//create a team with a specific ID
{
        for (int x=0;x<5;x++)
         ActivePlayers[x]=0;
	TeamID = teamID;
	LoadTeam();
}


bool GTeam::LoadTeam(void)
{
    PLAYERLIST slist;
    PLAYERLIST glist;
    cout<<"Loading team "<<TeamID<<endl;

    //first load the skaters from the database
    GetAllSkaters(TeamID,slist);
    
    //next load the GSkater objects
    //PLAYERLIST::iterator i;
    for (int i=0;i<slist.size();i++)
    {
	PLAYER_TYPE x;
	x = (PLAYER_TYPE)slist[i];
	//	cout<<"x.SkatingSpeed="<<x.SkatingSpeed<<endl;
	GSkater skater(x);
	//	cout<<"Got skater, id="<<skater.GetID()<<", position="<<skater.GetPosition()<<", SpeedFactor="<<skater.SpeedFactor()<<endl;
	Skaters.push_back(skater);
    }
    
    //Now do the same for the Goalies
    //PLAYERLIST::iterator k;
    GetAllGoalies(TeamID,glist);
    for (int k=0;k<glist.size();k++)
    {
	PLAYER_TYPE x;
	x = (PLAYER_TYPE)slist[k];
	GGoalie goalie(x);
	Goalies.push_back(goalie);
    }
    //  cout<<"Generating lines..."<<endl;
  Lines.Generate(&Skaters);
  return true;
}

SKATERLIST *GTeam::GetSkaters()
{
 return &Skaters;
}

GOALIELIST *GTeam::GetGoalies()
{
 return &Goalies;
} 


void GTeam::SetActiveLine(int situation, int position)
{
//  SKATERLIST::iterator i;
//  for (i=Skaters.begin();i!=Skaters.end();i++)
//  {
//    for (int x=0;x<5;x++)
//     if ((*i).GetID()==Lines[ActiveLine][x])
//       (*i).OnIce=0;
//  } 
 ActivePlayers[position]++;
 ActivePlayers[position]%=NUMLINESPERSITUATION;
//  for (i=Skaters.begin();i!=Skaters.end();i++)
//  {
//    for (int x=0;x<5;x++)
//     if ((*i).GetID()==Lines[ActiveLine][x])
//       (*i).OnIce=1;
//  }
}

int GTeam::GetReplacement(int situation, int position)
{
 SetActiveLine(situation, position);
 int **lines=Lines.GetLines(situation);
 // cout<<"Asked for lines["<<ActivePlayers[position]<<"]["<<position<<"]"<<endl;
 return lines[ActivePlayers[position]][position];
}

void GTeam::PutLineOnIce(int situation, int linenumber)
{
 int **lines=Lines.GetLines(situation);
 //SKATERLIST::iterator i;
 for (int i=0;i<Skaters.size();i++)
 {
   for (int x=0;x<5;x++)
     //    if ((*i).GetID()==lines[linenumber][x])
      Skaters[i].OnIce=0;
 } 
 for (int j=0;j<Skaters.size();j++)
 {
   for (int x=0;x<5;x++)
    if (Skaters[j].GetID()==lines[linenumber][x])
	{
     Skaters[j].OnIce=1;
	 int p = Skaters[j].GetPosition();
	}
 }
}
