// Hockey Simulator
// Copyright (C) 1998  Mike Johns

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

// Email Mike Johns at johnsmc@hiramf.hiram.edu for further information.


//game.cpp

//functions used by the game itself

#include "Game.h"
#include <math.h>
#include <fstream>
#include <time.h>
#include "Constants.h"
#include "Utils.h"
#include <stdio.h>
//#include <mmsystem.h>
#include <stdlib.h>
#include <string.h>
#include "teamutil.h"

using namespace std;

//const double FrameRate=5;

Game::Game (int hometeamid, int visitorteamid, CoachSettings & HomeCoachSettings,
CoachSettings & VisitorCoachSettings):HomeCoachSettings (HomeCoachSettings), VisitorCoachSettings (VisitorCoachSettings), PlayerModel (), HomeLines(), VisitorLines(), HomeTeam(hometeamid), VisitorTeam(visitorteamid), SoundManager()
//sets up the rink, and initializes player home positions
{
  cout<<"Setting up the game..."<<endl;
  Home[0][0].OffenseX = length - (.15 * length);	//Home team home values

  Home[0][0].OffenseY = (width / 2);
  Home[0][1].OffenseX = (length - (.15 * length));
  Home[0][1].OffenseY = (width / 5);	//6

  Home[0][2].OffenseX = (length - (.15 * length));
  Home[0][2].OffenseY = width - (width / 5);	//6

  Home[0][3].OffenseX = BlueLine[1] + 35;
  Home[0][3].OffenseY = (width / 4);
  Home[0][4].OffenseX = BlueLine[1] + 35;
  Home[0][4].OffenseY = width - (width / 4);
  Home[0][5].OffenseX = homegoalx + goalwidth / 2;
  Home[0][5].OffenseY = width / 2;


  Home[0][0].NeutralX = (length / 2) - 10;
  Home[0][0].NeutralY = width / 2 + 10;
  Home[0][1].NeutralX = (length / 2) - 10;
  Home[0][1].NeutralY = (width / 8);
  Home[0][2].NeutralX = (length / 2) - 10;
  Home[0][2].NeutralY = width - (width / 8);
  Home[0][3].NeutralX = BlueLine[0];
  Home[0][3].NeutralY = width / 4;
  Home[0][4].NeutralX = BlueLine[0];
  Home[0][4].NeutralY = width - (width / 4);
  Home[0][5].NeutralX = homegoalx + goalwidth / 2;
  Home[0][5].NeutralY = width / 2;


  Home[0][0].DefenseX = .25 * length;
  Home[0][0].DefenseY = width / 2;
  Home[0][1].DefenseX = .25 * length;
  Home[0][1].DefenseY = (width / 5);
  Home[0][2].DefenseX = .25 * length;
  Home[0][2].DefenseY = width - (width / 5);
  Home[0][3].DefenseX = .15 * length;
  Home[0][3].DefenseY = width / 2.3;
  Home[0][4].DefenseX = .15 * length;
  Home[0][4].DefenseY = width - (width / 2.3);
  Home[0][5].DefenseX = homegoalx + goalwidth / 2;
  Home[0][5].DefenseY = width / 2;


  Home[1][0].OffenseX = .15 * length;	//Visiting team home values

  Home[1][0].OffenseY = width / 2;
  Home[1][1].OffenseX = .15 * length;
  Home[1][1].OffenseY = (width / 5);
  Home[1][2].OffenseX = .15 * length;
  Home[1][2].OffenseY = width - (width / 5);
  Home[1][3].OffenseX = BlueLine[0] - 35;
  Home[1][3].OffenseY = width / 4;
  Home[1][4].OffenseX = BlueLine[0] - 35;
  Home[1][4].OffenseY = width - (width / 4);
  Home[1][5].OffenseX = visitorgoalx - goalwidth / 2;
  Home[1][5].OffenseY = width / 2;

  Home[1][0].NeutralX = (length / 2) + 10;
  Home[1][0].NeutralY = width / 2 - 10;
  Home[1][1].NeutralX = (length / 2) + 10;
  Home[1][1].NeutralY = (width / 8);
  Home[1][2].NeutralX = (length / 2) + 10;
  Home[1][2].NeutralY = width - (width / 8);
  Home[1][3].NeutralX = BlueLine[1];
  Home[1][3].NeutralY = width / 4;
  Home[1][4].NeutralX = BlueLine[1];
  Home[1][4].NeutralY = width - (width / 4);
  Home[1][5].NeutralX = visitorgoalx - goalwidth / 2;
  Home[1][5].NeutralY = width / 2;

  Home[1][0].DefenseX = length - (.25 * length);
  Home[1][0].DefenseY = (width / 2);
  Home[1][1].DefenseX = (length - (.25 * length));
  Home[1][1].DefenseY = (width / 5);
  Home[1][2].DefenseX = (length - (.25 * length));
  Home[1][2].DefenseY = width - (width / 5);
  Home[1][3].DefenseX = length - (.15 * length);
  Home[1][3].DefenseY = (width / 2.3);
  Home[1][4].DefenseX = length - (.15 * length);
  Home[1][4].DefenseY = width - (width / 2.3);
  Home[1][5].DefenseX = visitorgoalx - goalwidth / 2;
  Home[1][5].DefenseY = width / 2;

  LastPlayerToShoot = -1;
  SKATERLIST *ht=HomeTeam.GetSkaters();
  SKATERLIST *vt=VisitorTeam.GetSkaters();
  SKATERLIST::iterator i;
  int x=0;
  for (i=ht->begin();i!=ht->end()&&x<PlayersPerTeam;i++)
  //  for (int x = 0; x < PlayersPerTeam * 2; x++)
    //put the players in their initial neutral zone positions and set their id's
    {
//       if ((x % PlayersPerTeam) >= 0 && (x % PlayersPerTeam) < 5)
// 	Skaters[x]->OnIce = 1;
//       else
// 	Skaters[x]->OnIce = 0;
//       Skaters[x]->id = x;
//       Skaters[x]->Attributes.Position = x % 5;
//       Skaters[x]->Attributes.UniformNumber = x;
      //      cout<<"Home using player, id="<<(*i).GetID()<<endl;
      if ((*i).IsDressed())
	{
	  Skaters[x]=&*i;
	  Skaters[x]->HomeOrVisitor=0;
	  Skaters[x]->SetPosition (Home[0][Skaters[x]->Attributes.Position], 0);
	  x++;
	}
    }
  //  cout<<"Done dressing home team, x="<<x<<endl;
  for (i=vt->begin();i!=vt->end()&&x<PlayersPerTeam*2;i++)
  //  for (int x = 0; x < PlayersPerTeam * 2; x++)
    //put the players in their initial neutral zone positions and set their id's
    {
//       if ((x % PlayersPerTeam) >= 0 && (x % PlayersPerTeam) < 5)
// 	Skaters[x]->OnIce = 1;
//       else
// 	Skaters[x]->OnIce = 0;
//       Skaters[x]->id = x;
//       Skaters[x]->Attributes.Position = x % 5;
//       Skaters[x]->Attributes.UniformNumber = x;
      //      cout<<"Visitors using player, id="<<(*i).GetID()<<endl;
      if ((*i).IsDressed())
 	{
         Skaters[x]=&*i;
         Skaters[x]->HomeOrVisitor=1;
         x++;
	}
    }
  //cout<<"Done dressing visiting team, x="<<x<<endl;

  HomeTeam.PutLineOnIce(0,0);
  VisitorTeam.PutLineOnIce(0,0);

  for (x=0; x<PlayersPerTeam*2;x++)
  {
    //    cout<<"Finding place for "<<Skaters[x]->GetID()<<endl;
   Skaters[x]->SetPosition (Home[Skaters[x]->HomeOrVisitor][Skaters[x]->Attributes.Position], 0);
  }
// Skaters[20].OnIce=0;
  // Skaters[22].OnIce=0;
  GOALIELIST *hg=HomeTeam.GetGoalies();
  GOALIELIST *vg=VisitorTeam.GetGoalies();
  //GOALIELIST::iterator g;
  //g=hg->begin();
  HomeGoalie=&((*hg)[0]);
  HomeGoalie->OnIce = 1;
  HomeGoalie->HomeOrVisitor=0;
  HomeGoalie->id = PlayersPerTeam * 2;
  HomeGoalie->SetPosition (Home[0][5]);
  //  HomeGoalie->Attributes.Generate ();
//  g=vg->begin();
  VisitorGoalie=&((*vg)[0]);
  VisitorGoalie->id = (PlayersPerTeam * 2) + 2;
  VisitorGoalie->OnIce = 1;
  VisitorGoalie->HomeOrVisitor=1;
  VisitorGoalie->SetPosition (Home[1][5]);
  //  cout<<"Dealt with goalies."<<endl;
  //VisitorGoalie->Attributes.Generate ();
  HomeScore = 0;		//initialize the game score

  HomeShots = 0;
  VisitorScore = 0;
  VisitorShots = 0;
  HomeMaxPlayers = 5;
  VisitorMaxPlayers = 5;
  for (int h = 0; h < 6; h++)
    LastPlayerToTouch[h] = 0;
  MrPuck.Reset (0);
  LastTimePuckMoved = 0;
  CurrentPlayer = -1;		//-1

  strcpy (StatusBarText, "");
  HomeOffsides = 0;
  VisitorOffsides = 0;
  SoundManager.LoadSound("crowdloop.wav", SND_CROWDLOOP, true);
  SoundManager.LoadSound("crowdexcite.wav", SND_CROWDEXCITEMAJOR, false);
  SoundManager.LoadSound("crowdexciteminor.wav", SND_CROWDEXCITEMINOR, false);
  SoundManager.LoadSound("cheer.wav", SND_CROWDEXCITEEXTRAMINOR, false);
  SoundManager.LoadSound("boo.wav", SND_CROWDUPSET, false);
  SoundManager.LoadSound("whistle.wav", SND_WHISTLE, false);
  SoundManager.LoadSound("boards.wav", SND_PUCKBOARDS, false);
  SoundManager.LoadSound("crunch.wav", SND_CRUNCH, false);
  SoundManager.LoadSound("dump_around_boards.wav", SND_DUMP, false);
  SoundManager.LoadSound("end_of_power_play.wav", SND_POWERPLAYEND, false);
  SoundManager.LoadSound("miss.wav", SND_MISS, false);
  SoundManager.LoadSound("pass_the_puck.wav", SND_DEMANDPASS, false);
  SoundManager.LoadSound("post.wav", SND_PUCKPOST, false);
  SoundManager.LoadSound("shot.wav", SND_SHOT, false);

}

char *Game::
GetStatusBarText ()
{
  return StatusBarText;
}

int Game::
GetScore (int hv)
{
  if (hv == 0)
    return HomeScore;
  else
    return VisitorScore;
}

int Game::
GetShots (int hv)
{
  if (hv == 0)
    return HomeShots;
  else
    return VisitorShots;
}

double Game::
GetPuckX ()
{
  return MrPuck.GetX ();
}

double Game::
GetPuckY ()
{
  return MrPuck.GetY ();
}

double Game::
GetPuckZ ()
{
  return MrPuck.GetZ ();
}

double Game::
GetPuckXVelocity ()
{
  return MrPuck.GetXVelocity ();
}

double Game::
GetPuckYVelocity ()
{
  return MrPuck.GetYVelocity ();
}

double Game::
GetPuckZVelocity ()
{
  return MrPuck.GetZVelocity ();
}

Point Game::
GetHomeGoalieCoordinates ()
{
  return HomeGoalie->Location;
}

int Game::
GetStrength (int homeorvisitor)
{
  int total = 0;
  for (int x = homeorvisitor * PlayersPerTeam; x < (homeorvisitor + 1) * PlayersPerTeam; x++)
    total += Skaters[x]->Attributes.Passing +
      Skaters[x]->Attributes.SkatingSpeed +
      Skaters[x]->Attributes.Quickness +
      Skaters[x]->Attributes.PuckControl +
      Skaters[x]->Attributes.Stamina +
      Skaters[x]->Attributes.StickHandling +
      Skaters[x]->SAttributes.Strength;
  return total;
}


int Game::
GetGoalieStrength (int homeorvisitor)
{
  if (homeorvisitor == 0)
    return HomeGoalie->Attributes.Passing +
      HomeGoalie->Attributes.SkatingSpeed +
      HomeGoalie->Attributes.Quickness +
      HomeGoalie->Attributes.PuckControl +
      HomeGoalie->Attributes.Stamina +
      HomeGoalie->Attributes.StickHandling +
      HomeGoalie->GAttributes.Blocker +
      HomeGoalie->GAttributes.Concentration +
      HomeGoalie->GAttributes.Glove +
      HomeGoalie->GAttributes.Pads +
      HomeGoalie->GAttributes.Stick;
  else
    return VisitorGoalie->Attributes.Passing +
      VisitorGoalie->Attributes.SkatingSpeed +
      VisitorGoalie->Attributes.Quickness +
      VisitorGoalie->Attributes.PuckControl +
      VisitorGoalie->Attributes.Stamina +
      VisitorGoalie->Attributes.StickHandling +
      VisitorGoalie->GAttributes.Blocker +
      VisitorGoalie->GAttributes.Concentration +
      VisitorGoalie->GAttributes.Glove +
      VisitorGoalie->GAttributes.Pads +
      VisitorGoalie->GAttributes.Stick;
}

void Game::
GenerateTextures ()
{
#ifndef TWODVERSION
 	int x;
  for (x = 0; x < PlayersPerTeam; x++)
    Skaters[x]->GenerateTexture ("home.tiff");
  for (x = PlayersPerTeam; x < PlayersPerTeam * 2; x++)
    Skaters[x]->GenerateTexture ("visitor.tiff");
  HomeGoalie->GenerateTexture ("homeg.tiff");
  VisitorGoalie->GenerateTexture ("visitorg.tiff");
#endif
}

void Game::
UseFunnel (int homeorvisitor)
{
  double goalx = homegoalx;
  double insidemultiplier = 1;
  if (homeorvisitor == 0)
    {
      goalx = visitorgoalx;
      insidemultiplier = -1;
    }

  Home[homeorvisitor][0].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][0].OffenseY = width / 2;

  Home[homeorvisitor][1].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][1].OffenseY = width / 2 - 30;

  Home[homeorvisitor][2].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][2].OffenseY = width / 2 + 30;

  Home[homeorvisitor][3].OffenseX = BlueLine[!homeorvisitor] + (20 * -insidemultiplier);
  Home[homeorvisitor][3].OffenseY = width / 5;

  Home[homeorvisitor][4].OffenseX = BlueLine[!homeorvisitor] + (20 * -insidemultiplier);
  Home[homeorvisitor][4].OffenseY = width - width / 5;

}

void Game::
UseDiamond (int homeorvisitor)
{
  double goalx = homegoalx;
  double insidemultiplier = 1;
  if (homeorvisitor == 0)
    {
      goalx = visitorgoalx;
      insidemultiplier = -1;
    }

  Home[homeorvisitor][0].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][0].OffenseY = width / 2 + 30;

  Home[homeorvisitor][1].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][1].OffenseY = width / 2 - 30;

  Home[homeorvisitor][2].OffenseX = goalx + (length / 5 * insidemultiplier);
  Home[homeorvisitor][2].OffenseY = width - width / 5;

  Home[homeorvisitor][3].OffenseX = goalx + (length / 5 * insidemultiplier);
  Home[homeorvisitor][3].OffenseY = width / 5;

  Home[homeorvisitor][4].OffenseX = BlueLine[!homeorvisitor] + (20 * -insidemultiplier);
  Home[homeorvisitor][4].OffenseY = width / 2;
}

void Game::
Use212 (int homeorvisitor)
{
  double goalx = homegoalx;
  double insidemultiplier = 1;
  if (homeorvisitor == 0)
    {
      goalx = visitorgoalx;
      insidemultiplier = -1;
    }

  Home[homeorvisitor][0].OffenseX = goalx + (30 * insidemultiplier);
  Home[homeorvisitor][0].OffenseY = width / 2;

  Home[homeorvisitor][1].OffenseX = goalx + (10 * insidemultiplier);
  Home[homeorvisitor][1].OffenseY = width / 5;

  Home[homeorvisitor][2].OffenseX = goalx + (10 * insidemultiplier);
  Home[homeorvisitor][2].OffenseY = width - width / 5;

  Home[homeorvisitor][3].OffenseX = BlueLine[!homeorvisitor] + (20 * -insidemultiplier);
  Home[homeorvisitor][3].OffenseY = width / 5;

  Home[homeorvisitor][4].OffenseX = BlueLine[!homeorvisitor] + (20 * -insidemultiplier);
  Home[homeorvisitor][4].OffenseY = width - width / 5;
}


void Game::
SetOffensiveFormation (int homeorvisitor, int ourspeed, int theirspeed,
		       int ourpower, int theirpower)
{
  if (ourpower > theirpower && ourspeed <= theirspeed)
    UseFunnel (homeorvisitor);
  else if (ourspeed > theirspeed && ourpower <= theirpower)
    UseDiamond (homeorvisitor);
  else
    Use212 (homeorvisitor);
}

void Game::
SetCoachSettings (int homeorvisitor, int &Breakout, int &PassDump,
		  int &ShotAggression, int &ForecheckingAggression,
		  int &NumForeCheckers, int &Coverage, int &ManPuck,
		  int &StayHomeAttack)
{
  int start = PlayersPerTeam * homeorvisitor;
  int ourscore, theirscore;
  double ourspeed = 0, theirspeed = 0, ourpower = 0, theirpower = 0;
  if (homeorvisitor == 0)
    {
      ourscore = HomeScore;
      theirscore = VisitorScore;
    }
  else
    {
      ourscore = VisitorScore;
      theirscore = HomeScore;
    }
  int ouradvantage = ourscore - theirscore;
  if (ouradvantage < 0)
    ouradvantage = 0;
  int theiradvantage = theirscore - ourscore;
  if (theiradvantage < 0)
    theiradvantage = 0;
  for (int x = 0; x < 2 * PlayersPerTeam; x++)
    if (x >= start && x < start + PlayersPerTeam && Skaters[x]->OnIce)
      {
	ourspeed += Skaters[x]->AdjustForFatigue ((double) (2 * Skaters[x]->Attributes.SkatingSpeed) + (2 * Skaters[x]->Attributes.Quickness) + Skaters[x]->Attributes.Passing +
				       Skaters[x]->Attributes.StickHandling);
	ourpower += Skaters[x]->AdjustForFatigue ((double) (2 * Skaters[x]->SAttributes.Strength) + Skaters[x]->Attributes.Weight + Skaters[x]->Attributes.SkatingSpeed + Skaters[x]->SAttributes.Checking);
      }
    else if (Skaters[x]->OnIce)
      {
	theirspeed += Skaters[x]->AdjustForFatigue ((double) (2 * Skaters[x]->Attributes.SkatingSpeed) + (2 * Skaters[x]->Attributes.Quickness) + Skaters[x]->Attributes.Passing +
				       Skaters[x]->Attributes.StickHandling);
	theirpower += Skaters[x]->AdjustForFatigue ((double) (2 * Skaters[x]->SAttributes.Strength) + Skaters[x]->Attributes.Weight + Skaters[x]->Attributes.SkatingSpeed + Skaters[x]->SAttributes.Checking);
      }

  Breakout = (int) (50 + (100 * (sqr (ourspeed) / sqr (theirspeed) - 1)) + (theirscore - ourscore * 10));
  PassDump = (int) (50 + (100 * ((sqr (theirspeed + theirpower)) / (sqr (ourspeed + ourpower)) - 1)));
  ShotAggression = (int) (50 + (100 * (sqr (theirspeed) / sqr (ourspeed) - 1)) + (theirscore - ourscore * 5));
  ForecheckingAggression = (int) (50 + (100 * (sqr (ourspeed / theirspeed) - 1)));
  if (ouradvantage >= 3 || theirspeed - ourspeed > ourspeed / 4 || CountPlayersOnIce (homeorvisitor) < CountPlayersOnIce (!homeorvisitor))
    NumForeCheckers = 1;
  else if (theiradvantage >= 2 || ourspeed - theirspeed > -50)
    NumForeCheckers = 3;
  else
    NumForeCheckers = 2;
  if (ourspeed - theirspeed > -20)
    Coverage = 0;
  else
    Coverage = 1;

  StayHomeAttack = (int) (50 + (100 * (sqr (ourspeed) / sqr (theirspeed) - 1)));

  Normalize (Breakout);
  Normalize (PassDump);
  Normalize (ShotAggression);
  Normalize (ForecheckingAggression);
  Normalize (ManPuck);
  Normalize (StayHomeAttack);
  SetOffensiveFormation (homeorvisitor, (int)ourspeed, (int)theirspeed,
                        (int)ourpower, (int)theirpower);
}

void Game::
Coach (int homeorvisitor)
{
  if (homeorvisitor == 0)
    SetCoachSettings (0, HomeCoachSettings.Breakout, HomeCoachSettings.PassDump,
		      HomeCoachSettings.ShotAggression, HomeCoachSettings.ForecheckingAggression,
		      HomeCoachSettings.NumForeCheckers, HomeCoachSettings.Coverage, HomeCoachSettings.ManPuck,
		      HomeCoachSettings.StayHomeAttack);
  else
    SetCoachSettings (1, VisitorCoachSettings.Breakout, VisitorCoachSettings.PassDump,
		      VisitorCoachSettings.ShotAggression, VisitorCoachSettings.ForecheckingAggression,
		      VisitorCoachSettings.NumForeCheckers, VisitorCoachSettings.Coverage, VisitorCoachSettings.ManPuck,
		      VisitorCoachSettings.StayHomeAttack);

}

void Game::
MakeView (GPlayer * Skater, PlayerView Status[(PlayersPerTeam * 2) + 4])
//create a view of the ice for a player
//at the moment, this just copies all of the data for the skaters into
//the view, but when intelligence ratings are implemented, the view will
//be skewed according to how well the player can see the ice
{
  for (int i = 0; i < PlayersPerTeam * 2; i++)
    {
      Status[i].X = Skaters[i]->Location.X;
      Status[i].Y = Skaters[i]->Location.Y;
      Status[i].XVelocity = Skaters[i]->Location.XVelocity;
      Status[i].YVelocity = Skaters[i]->Location.YVelocity;
      Status[i].WantsPuck = abs (Skaters[i]->PassX || Skaters[i]->PassY) % 2;
      Status[i].OnIce = Skaters[i]->OnIce;
      Status[i].Crashing = Skaters[i]->Crashing;
      Status[i].ID=Skaters[i]->GetID();
      Status[i].Position=Skaters[i]->GetPosition();
    }
  Status[PlayersPerTeam * 2].X = HomeGoalie->Location.X;
  Status[PlayersPerTeam * 2].Y = HomeGoalie->Location.Y;
  Status[PlayersPerTeam * 2].XVelocity = HomeGoalie->Location.XVelocity;
  Status[PlayersPerTeam * 2].YVelocity = HomeGoalie->Location.YVelocity;
  Status[PlayersPerTeam * 2].WantsPuck = 0;
  Status[PlayersPerTeam * 2].OnIce = 1;
  Status[PlayersPerTeam * 2].Crashing = 0;
  Status[PlayersPerTeam * 2].ID = HomeGoalie->GetID();
  Status[(PlayersPerTeam * 2)].Position = 5;

  Status[(PlayersPerTeam * 2) + 2].X = VisitorGoalie->Location.X;
  Status[(PlayersPerTeam * 2) + 2].Y = VisitorGoalie->Location.Y;
  Status[(PlayersPerTeam * 2) + 2].XVelocity = VisitorGoalie->Location.XVelocity;
  Status[(PlayersPerTeam * 2) + 2].YVelocity = VisitorGoalie->Location.YVelocity;
  Status[(PlayersPerTeam * 2) + 2].WantsPuck = 0;
  Status[(PlayersPerTeam * 2) + 2].OnIce = 0;
  Status[(PlayersPerTeam * 2) + 2].Crashing = 0;
  Status[(PlayersPerTeam * 2) + 2].ID = VisitorGoalie->GetID();
  Status[(PlayersPerTeam * 2) + 2].Position = 5;

}

void Game::
HandleDeflections (GPlayer * s, Puck & p)
{
  double goalx, goaly;
  if (s->HomeOrVisitor==1)
    goalx = homegoalx;
  else
    goalx = visitorgoalx;
  goaly = width / 2;
  double deflectedvelocity = (sqrt (sqr (p.GetXVelocity ()) + sqr (p.GetYVelocity ()) +
	 sqr (p.GetZVelocity ()))) * (double) (((rand () % 8) + 16) / 24.0);
  if (s->Attributes.Position<5 && p.PlayerInControl == -1 && s->CanReachPuck (p) == 2 && s->PassX >= 0 && s->Shooting >= 0 && p.PlayerInControl != s->id && sqrt (sqr (p.GetXVelocity ()) + sqr (p.GetYVelocity ())) > 20)
    {
      s->PassX = -10;
      if (rand () % 3 == 0)
	{
	  if ((goalx == homegoalx && p.GetXVelocity () > 20) ||
	      (goalx == visitorgoalx && p.GetXVelocity () < -20))
	    deflectedvelocity /= 5;
	  p.SetComponents (deflectedvelocity,
			   goalx + rand () % 50 - rand () % 50, goaly + rand () % 50 - rand () % 50, rand () % 3 - rand () % 3);
	}
      else
	{
	  double newx = p.GetX () + rand () % 30 - rand () % 30;
	  double newy = p.GetY () + rand () % 30 - rand () % 30;
	  if ((newx < p.GetX () && p.GetXVelocity () > 20) ||
	      (newx > p.GetX () && p.GetXVelocity () < -20))
	    deflectedvelocity /= 5;
	  else
	    deflectedvelocity /= 1.2;
	  p.SetComponents (deflectedvelocity,
			   newx, newy, rand () % 3 - rand () % 3);
	}
      p.ResetTrackingTime ();
    }
}


void Game::
DoAction (PlayerView Status[PlayersPerTeam * 2 + 4], GPlayer * s, Puck & p)
//carries out the skater's current action for a frame
{
  int index=0;
//  int q = s->GetID();
  while (Status[index].ID!=s->GetID())
   index++;
  s->UpdateDelays (p);
  HandleDeflections (s, p);
  //s->Check();
  if (s->PlayerToCheck > -1 && s->PlayerToCheck<PlayersPerTeam *2 && s->CanReachPuck (p))	//if you've decided to knock someone
    //over, and you're close to him

    s->Check (Skaters[s->PlayerToCheck]);	//then knock him over

  else if (s->Shooting > 0)
    {
      if (index >= PlayersPerTeam)
	if (p.PlayerInControl == index)		//&&MrPuck.ClearPath(50,(width/2),Status))
	  {
	    if (s->Shooting == 1)
 	     SoundManager.PlaySound(SND_SHOT);
	   s->Shoot (p, homegoalx, (width / 2));		//if you've decided to shoot and you have the
      //puck, then shoot
	  }

	else;
      else if (p.PlayerInControl == index)	//&&MrPuck.ClearPath(length-50,width/2,Status))
	{
         if (s->Shooting == 1)
	  SoundManager.PlaySound(SND_SHOT);
	 s->Shoot (p, visitorgoalx, width / 2);	//same as above, but shoot at the other
      //goal if you're on the other team
	}

    }
  else if ((s->PassX > 0 || s->PassY > 0) && s->PassX >= 0)
    if (p.PlayerInControl == index)
      s->Pass (p);		//pass if you want

  s->Move ();			//physically move the player

}


void Game::
CheckCollisions ()
//determines whether two masses are trying to occupy the same space
{
  for (int a = 0; a < PlayersPerTeam * 2; a++)
    for (int z = 0; z < PlayersPerTeam * 2; z++)
      {
	if (Distance (Skaters[a]->Location.X, Skaters[a]->Location.Y, Skaters[z]->Location.X, Skaters[z]->Location.Y) <
	    playerdiameter / 2 &&
	    (a != z) && (Skaters[a]->OnIce && Skaters[z]->OnIce))
	  {
	    //            SoundManager.PlaySound(SND_CRUNCH);  // Crunch
	    Skaters[a]->HandleCollision (Skaters[z]);
	    //  SprayMaker l(Skaters[a]->Location);
	    //  SprayMakers.insert(SprayMakers.begin(),l);
	    if (MrPuck.PlayerInControl < PlayersPerTeam * 2 && MrPuck.PlayerInControl != -1 && Skaters[MrPuck.PlayerInControl]->InControl < 0)
	      {
		MrPuck.PlayerInControl = -1;
		MrPuck.SetVelocity (rand () % 20 - rand () % 20, rand () % 20 - rand () % 20, 0);
	      }
	    if (rand () % 100 > Skaters[a]->Attributes.Aggressiveness &&
		rand () % 50 == 0)
	      {
	        SoundManager.PlaySound(SND_WHISTLE);
		Skaters[a]->PenaltyTime = 2 * TicksPerMinute;
		if (a < PlayersPerTeam && HomeMaxPlayers > 3)
		  HomeMaxPlayers--;
		else if (a > PlayersPerTeam && VisitorMaxPlayers > 3)
		  VisitorMaxPlayers--;
	      }
	  }

	if (Distance (Skaters[a]->Location.X, Skaters[a]->Location.Y, HomeGoalie->Location.X, HomeGoalie->Location.Y) <
	    playerdiameter / 2 && (Skaters[a]->OnIce && Skaters[z]->OnIce))
	  Skaters[a]->HandleCollision (HomeGoalie);

	if (Distance (Skaters[a]->Location.X, Skaters[a]->Location.Y, VisitorGoalie->Location.X, VisitorGoalie->Location.Y) <
	    playerdiameter / 2 && (Skaters[a]->OnIce && Skaters[z]->OnIce))
	  Skaters[a]->HandleCollision (VisitorGoalie);

      }
}

void Game::
CheckGoaliePossession (GGoalie * g, Puck & p, int &shotcounter)
{
  int canreach = g->CanReachPuck (p);
  int homeorvisitor = 0;
  if (g->HomeOrVisitor == 1)
    homeorvisitor=1;
  //  cout<<"Checking goalie possession for goalie "<<homeorvisitor<<endl; 
  if (canreach &&
      ((homeorvisitor == 0 && p.GetXVelocity () < 5) ||
       (homeorvisitor == 1 && p.GetXVelocity () > -5)))
    {
      if (LastPlayerToShoot != LastPlayerToTouch[0] &&
	  sqrt (sqr (p.GetXVelocity ()) + sqr (p.GetYVelocity ())) > 20 &&
	  LastPlayerToTouch[0]<PlayersPerTeam*2 &&
	  ((!homeorvisitor && LastPlayerToTouch[0] >= PlayersPerTeam && LastPlayerToTouch[0] < PlayersPerTeam * 2) ||
	   (homeorvisitor && LastPlayerToTouch[0] < PlayersPerTeam)))
	{
	  SoundManager.PlaySound(SND_CROWDEXCITEMINOR);
	  shotcounter++;
	  LastPlayerToShoot = LastPlayerToTouch[0];
	  if (canreach==1 ||
	      sqrt(sqr(p.GetXVelocity())+sqr(p.GetYVelocity()))<10)
   	  p.PlayerInControl = (PlayersPerTeam*2)+(2*g->HomeOrVisitor);	//goalies can always just dive on

	}
      else
	p.SetVelocity (-p.GetXVelocity () / (rand () % 10+ 20), -p.GetYVelocity() /(rand () % 10 + 20), -p.GetZVelocity () / (rand () % 5 + 3));
    }
}


void Game::
ResolvePossessionConflicts (Puck & MrPuck, int PuckHog)
//gives the correct player the puck, depending on surrounding teammates
//and proximity
{
  //  int homegcanreach = HomeGoalie->CanReachPuck (MrPuck);
  //  int visgcanreach = VisitorGoalie->CanReachPuck (MrPuck);
  int o,j;
  if (MrPuck.PlayerInControl >= PlayersPerTeam*2) 
    return;
  if (MrPuck.PlayerInControl != -1 && Skaters[MrPuck.PlayerInControl]->OnIce == 0)
    MrPuck.PlayerInControl = -1;
  int canreach[PlayersPerTeam * 2];
  CheckGoaliePossession (HomeGoalie, MrPuck, VisitorShots);
  CheckGoaliePossession (VisitorGoalie, MrPuck, HomeShots);

  if (MrPuck.PlayerInControl < PlayersPerTeam * 2)
    if (sqrt ((MrPuck.GetXVelocity () * MrPuck.GetXVelocity ()) +
	      (MrPuck.GetYVelocity () * MrPuck.GetYVelocity ())) > 50)	//if it's moving
      //quickly, it's
      //hard to control

      {
	MrPuck.PlayerInControl = -1;
      }
    else
      {
	if (MrPuck.PlayerInControl != -1)	//Poke checking

	  for (o = (MrPuck.PlayerInControl < PlayersPerTeam) * PlayersPerTeam;
	       o < (MrPuck.PlayerInControl < PlayersPerTeam) * PlayersPerTeam + PlayersPerTeam;
	       o++)
	    if ((MrPuck.PlayerInControl != -1) &&  MrPuck.PlayerInControl <PlayersPerTeam*2 &&
		Skaters[o]->CanReachPuck (MrPuck) == 1 &&
//          o!=MrPuck.PlayerInControl&&
		Skaters[o]->SAttributes.Checking * 3 + rand () % 20 >
		Skaters[MrPuck.PlayerInControl]->Attributes.PuckControl +
		Skaters[MrPuck.PlayerInControl]->Attributes.StickHandling +
		Skaters[MrPuck.PlayerInControl]->Attributes.Quickness)
	      {
		MrPuck.SetVelocity (rand () % 30 - rand () % 30, rand () % 30 - rand () % 30, rand () % 5);
		Skaters[MrPuck.PlayerInControl]->PassX = -10;
		Skaters[o]->PassX = -10;
		MrPuck.PlayerInControl = -1;
	      }


	int HomeInReach = 0;
	int VisInReach = 0;
	for (j = 0; j < PlayersPerTeam * 2; j++)
	  canreach[j] = Skaters[j]->CanReachPuck (MrPuck);
	for (o = 0; o < PlayersPerTeam; o++)	//tally up how many skaters from the home team
	  //can reach the puck

	  if (canreach[o] && Skaters[o]->PassX >= 0 &&
	      Skaters[o]->Shooting >= 0)
	    HomeInReach += (int) (rand () % PConChanceFactor + Skaters[o]->AdjustForFatigue (Skaters[o]->SAttributes.Strength + Skaters[o]->SAttributes.Checking + Skaters[o]->Attributes.PuckControl) - (2 * Skaters[o]->Shooting));
	for (int l = PlayersPerTeam; l < 2 * PlayersPerTeam; l++)	//corresponding tally for visitors

	  if (canreach[l] && Skaters[l]->PassX >= 0 &&
	      Skaters[l]->Shooting >= 0)
	    VisInReach += (int) (rand () % PConChanceFactor + Skaters[l]->AdjustForFatigue (Skaters[l]->SAttributes.Strength + Skaters[l]->SAttributes.Checking + Skaters[l]->Attributes.PuckControl) - (2 * Skaters[l]->Shooting));
	if (HomeInReach > VisInReach)	//give the puck to whichever team has more
	  //stickhandling ability, power, etc in the area

	  for (int b = 0; b < PlayersPerTeam; b++)
	    if (canreach[b] == 1 && Skaters[b]->PassX >= 0 && Skaters[b]->Shooting >= 0)
	      {
		if (b < PlayersPerTeam && CurrentPlayer != -1 && PuckHog == 1)
		  CurrentPlayer = b;
		MrPuck.PlayerInControl = b;
	      }
	if (VisInReach > HomeInReach)
	  for (o = PlayersPerTeam; o < PlayersPerTeam * 2; o++)
	    if (Skaters[o]->OnIce && canreach[o] == 1 && Skaters[o]->PassX >= 0 && Skaters[o]->Shooting >= 0)
	      {
		if (o < PlayersPerTeam && CurrentPlayer != -1 && PuckHog == 1)
		  CurrentPlayer = o;
		MrPuck.PlayerInControl = o;
	      }


      }
}

int Game::
CountPlayersOnIce (int homeorvisitor)
{
  int answer = 0;
  for (int x = 0 + (PlayersPerTeam * homeorvisitor); x < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); x++)
    if (Skaters[x]->OnIce==1||Skaters[x]->OnIce==2)
      answer++;
  return answer;
}

void Game::
SetNumberOfPlayers (int homeorvisitor, int maxplayers)
{
  int teamcontrols = 0;
  if (homeorvisitor == 0 && MrPuck.PlayerInControl != -1 && MrPuck.PlayerInControl < PlayersPerTeam)
    teamcontrols = 1;
  else if (homeorvisitor == 1 && MrPuck.PlayerInControl >= PlayersPerTeam)
    teamcontrols = 1;
  for (int x = 0 + (PlayersPerTeam * homeorvisitor); x < PlayersPerTeam + (PlayersPerTeam * homeorvisitor); x++)
    {
      if (Skaters[x]->OnIce && teamcontrols &&
	  ((maxplayers == 4 && Skaters[x]->GetPosition() == 0) ||
	   (maxplayers == 3 && (Skaters[x]->GetPosition() == 1 || Skaters[x]->GetPosition() == 2))))
	{
	  Skaters[x]->OnIce = 0;
	  Skaters[x]->Location.X = length / 2;
	  Skaters[x]->Location.Y = -5;
	  FaceOff ();
	}
      if (Skaters[x]->OnIce == 0 &&
	  Skaters[x]->Location.Y == -5 &&
	  ((maxplayers == 5 && Skaters[x]->GetPosition() == 0) ||
	   (maxplayers == 4 && (Skaters[x]->GetPosition() == 1)) ||
	   (maxplayers == 3 && (Skaters[x]->GetPosition() == 0))))
	{
	  Skaters[x]->OnIce = 1;
	  Skaters[x]->Location.Y = 5;
	}
    }
}

int Game::
GetMaxPlayers (int homeorvisitor)
{
  if (homeorvisitor == 0)
    return HomeMaxPlayers;
  else
    return VisitorMaxPlayers;
}

void Game::
CheckNumberOfPlayers (int homeorvisitor)
{
  int maxplayers = GetMaxPlayers (homeorvisitor);

  if (CountPlayersOnIce (homeorvisitor) != maxplayers)
    SetNumberOfPlayers (homeorvisitor, maxplayers);
}

void Game::
UpdatePenaltyStatus (int s)
{
  if (Skaters[s]->PenaltyTime > 0)
    {
      Skaters[s]->PenaltyTime--;
      if (Skaters[s]->PenaltyTime == 0)
	{
	  if (s < PlayersPerTeam && HomeMaxPlayers < 5)
	  {
	   HomeMaxPlayers++;
	   SoundManager.PlaySound(SND_POWERPLAYEND);
	  }
	  else if (VisitorMaxPlayers < 5)
	  {
	   VisitorMaxPlayers++;
	   SoundManager.PlaySound(SND_POWERPLAYEND);
	  }
	}
    }
}

void Game::
FaceOff ()
{
  int a;
  LastPlayerToShoot = -1;
  HomeOffsides = 0;
  VisitorOffsides = 0;
  LastTouchX = (int) (length / 2);
  for (a = 0; a < PlayersPerTeam * 2; a++)
    if (Skaters[a]->OnIce == 2)
      {
	Skaters[a]->OnIce = 0;
	Skaters[a]->Location.X = (length / 2) + 50 - (100 * a >= PlayersPerTeam);
	Skaters[a]->Location.Y = width + 10;
	int newplayer=GetReplacement(a);
	int newindex=0;
	while (Skaters[newindex]->GetID()!=newplayer)
	  newindex++;
      	Skaters[newindex]->OnIce = 1;
      }
  for (a = 0; a < PlayersPerTeam * 2; a++)
    Skaters[a]->SetPosition (Home[Skaters[a]->HomeOrVisitor][Skaters[a]->Attributes.Position], MrPuck.FindFaceOffPosition ());
  HomeGoalie->SetPosition (Home[0][5]);	//if so, reset it

  VisitorGoalie->SetPosition (Home[1][5]);
  MrPuck.Reset (MrPuck.FindFaceOffPosition ());
}

void Game::
CenterIceFaceOff ()
{
  for (int p=0;p<5;p++)
  {
   HomeTeam.SetActiveLine(0,p);
   VisitorTeam.SetActiveLine(0,p);
  }
  int a;
  for (a = 0; a < PlayersPerTeam * 2; a++)
     if (Skaters[a]->OnIce == 2)
       {
      	Skaters[a]->OnIce = 0;
 	Skaters[a]->Location.X = (length / 2) + 50 - (100 * a >= PlayersPerTeam);
 	Skaters[a]->Location.Y = width + 10;
	int newplayer=GetReplacement(a);
	int newindex=0;
	while (Skaters[newindex]->GetID()!=newplayer)
	  newindex++;
      	Skaters[newindex]->OnIce = 1;
       }
  for (a = 0; a < PlayersPerTeam * 2; a++)
     Skaters[a]->SetPosition (Home[Skaters[a]->HomeOrVisitor][Skaters[a]->Attributes.Position], 0);
  HomeGoalie->SetPosition (Home[0][5]);	//if so, reset it

  VisitorGoalie->SetPosition (Home[1][5]);
  MrPuck.Reset (0);
}
/*
   void Game::DrawScore(CDC &dc)
   {
   char buf[10];
   itoa(HomeScore,buf,10);              //draw score data, etc
   dc.TextOut(10,(int)width+10,"Blue:",5);
   dc.TextOut(90,(int)width+10,buf,strlen(buf));
   itoa(HomeShots,buf,10);              //draw score data, etc
   dc.TextOut(10,(int)width+30,"Shots:",6);
   dc.TextOut(90,(int)width+30,buf,strlen(buf));

   itoa(VisitorScore, buf,10);
   dc.TextOut((int)length-125,(int)width+10,"Red:",4);
   dc.TextOut((int)length-50,(int)width+10,buf,strlen(buf));
   itoa(VisitorShots,buf,10);           //draw score data, etc
   dc.TextOut((int)length-125,(int)width+30,"Shots:",6);
   dc.TextOut((int)length-50,(int)width+30,buf,strlen(buf));

   itoa(VisitorMaxPlayers, buf,10);
   dc.TextOut((int)length-125,(int)width+50,"RedMax:",7);
   dc.TextOut((int)length-50,(int)width+50,buf,strlen(buf));

   itoa(HomeMaxPlayers,buf,10); 
   dc.TextOut(10,(int)width+50,"BlueMax:",8);
   dc.TextOut(90,(int)width+50,buf,strlen(buf));

   itoa(CountPlayersOnIce(1), buf,10);
   dc.TextOut((int)length-125,(int)width+70,"NumRed:",7);
   dc.TextOut((int)length-50,(int)width+70,buf,strlen(buf));

   itoa(CountPlayersOnIce(0),buf,10);           
   dc.TextOut(10,(int)width+70,"NumBlue:",8);
   dc.TextOut(90,(int)width+70,buf,strlen(buf));

   // itoa(LastPlayerToTouch[0],buf,10);                
   // dc.TextOut(length/2-50, width+50,"Last:",5);
   // dc.TextOut(length/2,width+50,buf,strlen(buf));



   }
 */

void Game::
CheckOffsides ()
{
  int playerinattackzone = 0;
  if (MrPuck.GetX () > BlueLine[1] &&
      MrPuck.GetX () - MrPuck.GetXVelocity () < BlueLine[1])
    {
      for (int l = 0; l < PlayersPerTeam; l++)
	if (Skaters[l]->Location.X > BlueLine[1] + 10 &&
	    l != MrPuck.PlayerInControl &&
	    Skaters[l]->OnIce > 0)
	  {
	    playerinattackzone = 1;
	    if (HomeOffsides == 0)
	      HomeOffsides = 1;
	  }
    }
  if (!playerinattackzone && HomeOffsides)
    HomeOffsides = 0;

//              int VisitorOffsides=0;
  playerinattackzone = 0;
  if (MrPuck.GetX () < BlueLine[0] &&
      MrPuck.GetX () - MrPuck.GetXVelocity () > BlueLine[0])
    for (int l = PlayersPerTeam; l < PlayersPerTeam * 2; l++)
      {
	if (Skaters[l]->Location.X < BlueLine[0] - 10 &&
	    l != MrPuck.PlayerInControl &&
	    Skaters[l]->OnIce > 0)
	  {
	    playerinattackzone = 1;
	    if (VisitorOffsides == 0)
	      VisitorOffsides = 1;
	  }
      }
  if (!playerinattackzone && VisitorOffsides)
    VisitorOffsides = 0;

  if (MrPuck.PlayerInControl >= PlayersPerTeam &&
      MrPuck.PlayerInControl < PlayersPerTeam * 2 &&
      VisitorOffsides)
    {
      SoundManager.PlaySound(SND_WHISTLE);
      MrPuck.SetPosition (BlueLine[0], MrPuck.GetY (), 0);
      FaceOff ();
    }
  if (MrPuck.PlayerInControl != -1 &&
      MrPuck.PlayerInControl < PlayersPerTeam &&
      HomeOffsides)
    {
      SoundManager.PlaySound(SND_WHISTLE);
      MrPuck.SetPosition (BlueLine[1], MrPuck.GetY (), 0);
      FaceOff ();
    }

}

void Game::UpdateSprayMakers(int display)
{
 std::list<SprayMaker>::iterator i;
 for (i=SprayMakers.begin();i!=SprayMakers.end();i++) 
 {
   //  cerr<<"Dealing with a spraymaker..."<<endl;
  SprayMaker *s;
  s=(SprayMaker*)&(*i);
  s->Act();
  if (display)
    {
      s->Draw();
    }
  if (s->IsDead())
    {
      //      cerr<<"A spraymaker died...removing it."<<endl;
     std::list<SprayMaker>::const_iterator x=i;
     i++;
//      SprayMakers.erase(x);
     SprayMakers.erase(x);
    }
 }
 // cerr<<"Done with updatespraymakers..."<<endl;
	

/*	
 for (int i=0;i<SprayMakers.size();i++) 
 {
   //  cerr<<"Dealing with a spraymaker..."<<endl;
  SprayMaker *s;
  s=&SprayMakers[i];
  s->Act();
  if (display)
    {
      s->Draw();
    }
  if (s->IsDead())
    {
      //      cerr<<"A spraymaker died...removing it."<<endl;
      i++;
      SprayMakers->remove(*s);
    }
 }
 // cerr<<"Done with updatespraymakers..."<<endl;
	*/
}

int Game::GetReplacement(int index)
{
 if (Skaters[index]->HomeOrVisitor==0)
  return HomeTeam.GetReplacement(0,Skaters[index]->GetPosition());
 else
  return VisitorTeam.GetReplacement(0,Skaters[index]->GetPosition());
 return 0;
} 

#ifndef TWODVERSION
void Game::
Play (long Timer, CoachSettings & HomeCoachSettings, CoachSettings & VisitorCoachSettings, ControlData HControl, ControlData VControl, KeyData Keys, uint32 * IceTexture /*[1024][512][3] */ , int Textures, int Display, int SoundEffectsOn)
#endif
#ifdef TWODVERSION
void Game::
Play (long Timer, CoachSettings & HomeCoachSettings, CoachSettings & VisitorCoachSettings, ControlData HControl, ControlData VControl, KeyData Keys, uint32 * IceTexture /*[1024][512][3] */ , int Textures, int Display, int SoundEffectsOn, CDC &dc)
#endif
//plays the game for one frame
{
 SoundManager.SetPowerSwitch(SoundEffectsOn);
 if (Timer == 1 && Display)
 {
  PlayerModel.Load ("skater.ac");
//              PlayerModel.SetScale(1);
  GoalieModel.Load ("goalie.ac");

//              GoalieModel.SetScale(1);
  for (int a = 0; a < PlayersPerTeam * 2; a++)
   Skaters[a]->SetModel (&PlayerModel);
  HomeGoalie->SetModel (&GoalieModel);
  VisitorGoalie->SetModel (&GoalieModel);
  SoundManager.PlaySound(SND_CROWDLOOP);   // Crowd loop
 }
  char homeshotstr[6] =
  {'S', 'h', 'o', 't', 's', 0};
 char visitorshotstr[6] =
  {'S', 'h', 'o', 't', 's', 0};
  if (HomeShots == 1)
    strcpy (homeshotstr, "Shot");
  if (VisitorShots == 1)
    strcpy (visitorshotstr, "Shot");
  sprintf (StatusBarText, "Home %d (%d %s), Visitor %d (%d %s)", HomeScore, HomeShots, homeshotstr, VisitorScore, VisitorShots, visitorshotstr);
  if (Timer % ((long) TicksPerMinute * 20) == 0)
    {
      cout<<"Starting a new period..."<<endl;
//              sndPlaySound("damnit.wav",SND_FILENAME|SND_ASYNC);
      CenterIceFaceOff ();
    }
  //DrawScore(dc);
  if (Timer >= ((long) TicksPerMinute * 60) && HomeScore != VisitorScore)
    return;

  CoachSettings currentcoach;
  if (HControl.Coaching == -1)
    Coach (0);
  if (VControl.Coaching == -1)
    Coach (1);
  CheckNumberOfPlayers (0);
  CheckNumberOfPlayers (1);
  if (HControl.Position == -1 && HControl.Player == -1 && HControl.PuckHog == -1)
    CurrentPlayer = -1;

  SoundManager.Tick();

  ////////////!!!!!!!!!!!!!!!!!  This stuff should work!
     if (HControl.Position != -1 && (CurrentPlayer == -1 || Skaters[CurrentPlayer]->Attributes.Position != HControl.Position || !Skaters[CurrentPlayer]->OnIce))
     {
       for (int j = 0; j < PlayersPerTeam; j++)
 	if (Skaters[j]->OnIce && Skaters[j]->Attributes.Position == HControl.Position)
 	  CurrentPlayer = j;
     }

/* CPen BlackPen(PS_SOLID,1,RGB(0,0,0));
   CPen *pPen=dc.SelectObject(&BlackPen);
   CBrush WhiteBrush(RGB(0,0,0));
   CBrush *pBrush=dc.SelectObject(&WhiteBrush);
 */
  int hv = 0;
  if (CurrentPlayer >= PlayersPerTeam)
    hv = 1;
  if (Keys.nextplayer == 1 && HControl.PuckHog == 1)
    {
      int oldcurrent = CurrentPlayer;
      CurrentPlayer = -1;
      for (int x = PlayersPerTeam * hv; x < PlayersPerTeam * (hv + 1); x++)
	if (x != oldcurrent && (Skaters[x]->OnIce == 1 || Skaters[x]->OnIce == 2) && (CurrentPlayer == -1 ||
										    (Distance (MrPuck.GetX (), MrPuck.GetY (), Skaters[x]->Location.X, Skaters[x]->Location.Y) <
										     Distance (MrPuck.GetX (), MrPuck.GetY (), Skaters[CurrentPlayer]->Location.X, Skaters[CurrentPlayer]->Location.Y))))
	  CurrentPlayer = x;
    }
  if (MrPuck.PlayerInControl != LastPlayerToTouch[0] && MrPuck.PlayerInControl != -1)
    {
      for (int x = 5; x > 0; x--)
	LastPlayerToTouch[x] = LastPlayerToTouch[x - 1];
      LastPlayerToTouch[0] = MrPuck.PlayerInControl;
    }
  if (MrPuck.PlayerInControl != -1)
    {
      if (MrPuck.PlayerInControl >= PlayersPerTeam && MrPuck.PlayerInControl <PlayersPerTeam*2 &&
	  Skaters[MrPuck.PlayerInControl]->Location.X > visitorgoalx &&
	  LastTouchX < length / 2 &&
	  LastPlayerToTouch[1] < PlayersPerTeam &&
	  CountPlayersOnIce (0) >= CountPlayersOnIce (1))
	{
	  MrPuck.SetPosition (homegoalx + 30, MrPuck.GetY (), 0);
	  FaceOff ();
	}
      if (MrPuck.PlayerInControl != -1 && MrPuck.PlayerInControl < PlayersPerTeam && 
	  Skaters[MrPuck.PlayerInControl]->Location.X < homegoalx &&
	  LastTouchX > length / 2 &&
	  LastPlayerToTouch[1] >= PlayersPerTeam &&
	  CountPlayersOnIce (1) >= CountPlayersOnIce (0))
	{
	  MrPuck.SetPosition (visitorgoalx - 30, MrPuck.GetY (), 0);
	  FaceOff ();
	}
//              int HomeOffsides=0;
      CheckOffsides ();
    }
  if (MrPuck.PlayerInControl != -1)
    LastTouchX = (int)MrPuck.GetX ();

  if (abs (MrPuck.GetXVelocity ()) < 1 && abs (MrPuck.GetYVelocity ()) < 1
  /*&&MrPuck.PlayerInControl>9 */ )
    {
      if (Timer - LastTimePuckMoved > 100)	//determines if the puck is frozen

	{
	  FaceOff ();
	  LastTimePuckMoved = Timer;
	}
    }
  else
    LastTimePuckMoved = Timer;


  int color = 10 /**MrPuck.GetZ()*/ ;
  if (color > 10)
    color = 200;
  if (color < 0)
    color = 0;
  PlayerView Status[(PlayersPerTeam * 2) + 4];
  switch (MrPuck.Act ())
  {
   case PUCK_HIT_SIDEBOARD: SoundManager.PlaySound(SND_PUCKBOARDS); break;
   case PUCK_HIT_CORNER: SoundManager.PlaySound(SND_DUMP); break;
   case PUCK_HIT_POST: SoundManager.PlaySound(SND_PUCKPOST); break;
   case PUCK_HIT_BACKBOARD: SoundManager.PlaySound(SND_MISS); break;
  }
  if (Display)
#ifdef TWODVERSION
			MrPuck.Paint (dc);
#endif
#ifndef TWODVERSION
		 MrPuck.Paint();
#endif
  if (MrPuck.InGoal (visitorgoalx, width / 2))	//check if a goal has been
    //scored by the visitors

    {
      SoundManager.PlaySound(SND_CROWDEXCITEMAJOR);
      HomeScore++;
      HomeShots++;
      CenterIceFaceOff ();
    }
  if (MrPuck.InGoal (homegoalx, width / 2))	//check if the home team scored

    {
      SoundManager.PlaySound(SND_CROWDUPSET);
      VisitorScore++;
      VisitorShots++;
      CenterIceFaceOff ();
    }

  CheckCollisions ();		//handle all collisions for the frame
  UpdateSprayMakers(Display);

  ResolvePossessionConflicts (MrPuck, HControl.PuckHog);	//give the correct player the puck

  for (int s = 0; s < PlayersPerTeam * 2; s++)
    {
	  if (Skaters[s]->GetID() == -1)
		  cout<<"!"<<endl;
      if (s < PlayersPerTeam)
	currentcoach = HomeCoachSettings;
      else
	currentcoach = VisitorCoachSettings;
      Skaters[s]->Fatigue ();
      UpdatePenaltyStatus (s);
      if (Skaters[s]->OnIce)
       Skaters[s]->HandleSpray(SprayMakers);



      if (Skaters[s]->Energy < 90 && Skaters[s]->OnIce == 1)
	Skaters[s]->OnIce = 2;
      if (Skaters[s]->OnIce)
	{
//                              if (s==3)
	  //                              {
	  //                        IceTexture[/*1024-*/(int)(Skaters[s]->Location.X*(1024.0/length))][(int)(Skaters[s]->Location.Y*(512.0/width))][0]=255;
	  //                        IceTexture[/*1024-*/(int)(Skaters[s]->Location.X*(1024.0/length))][(int)(Skaters[s]->Location.Y*(512.0/width))][1]=255;
	  //                        IceTexture[/*1024-*/(int)(Skaters[s]->Location.X*(1024.0/length))][(int)(Skaters[s]->Location.Y*(512.0/width))][2]=255;
	  //    }
	  MakeView (Skaters[s], Status);	//have the skater look at the ice

	  if (s == MrPuck.PlayerInControl && s < PlayersPerTeam * 2)
	    {
	      char buf[5];
//     itoa((int)Skaters[MrPuck.PlayerInControl]->SituationQuality(Status,s),buf,10);            //draw score data, etc
	      //     itoa((int)Skaters[MrPuck.PlayerInControl]->ShotQuality(),buf,10);
	      //                                      dc.TextOut(length/2-60,width+30,"SQ:",3);
	      //     dc.TextOut(length/2-10,width+30,buf,strlen(buf));
	    }
	  if (Skaters[s]->InControl < 0 || !Skaters[s]->OnIce)	//if he can't control himself or not on the ice

	    {
	      if (MrPuck.PlayerInControl == s)
		MrPuck.PlayerInControl = -1;	//he can't control the puck

	    }
	  else
	    {
         if (CurrentPlayer == -1 || (CurrentPlayer != s || (Skaters[s]->OnIce == 2 && Skaters[s]->Location.X > BlueLine[0] && Skaters[s]->Location.X < BlueLine[1] && Skaters[s]->Location.Y > width - width / 6)))
		  Skaters[s]->SetAction (Status, MrPuck, Home[(s >= PlayersPerTeam)][Skaters[s]->Attributes.Position], currentcoach);
	 	 else
		  Skaters[s]->SetAction (Status, MrPuck, Keys);
	      //figure out what to do for this frame

//!!
	      if (MrPuck.PlayerInControl == s)	//if the skater has the puck, it moves with
		//him

		{
		  MrPuck.SetPosition (Skaters[s]->Location.X + Skaters[s]->Location.XVelocity / 1.5,
				      Skaters[s]->Location.Y + Skaters[s]->Location.YVelocity / 1.5);
		  MrPuck.SetVelocity (Skaters[s]->Location.XVelocity, Skaters[s]->Location.YVelocity, 0);
		}
	    }
	  DoAction (Status, Skaters[s], MrPuck);	//carry out the action

	  if (Display)
	    {
	      Skaters[s]->Walk ();
#ifndef TWODVERSION
	      Skaters[s]->Paint (MrPuck, CurrentPlayer, Textures);	//draw him
#endif
#ifdef TWODVERSION
							Skaters[s]->Paint (dc, MrPuck, CurrentPlayer);
#endif

	    }

	}
      if (Skaters[s]->OnIce == 2 && Skaters[s]->AtDestination () && Skaters[s]->DestY == width)
	{
	  Skaters[s]->OnIce = 0;
//  Skaters[s]->Energy=100;
	  Skaters[s]->Location.X = (length / 2) + 50 - (100 * s >= PlayersPerTeam);
	  Skaters[s]->Location.Y = width + 10;
//  if (s<PlayersPerTeam)
	  //       Skaters[(s+5)%PlayersPerTeam]->OnIce=1;
	  //  else
	  //    Skaters[PlayersPerTeam+((s+5)%PlayersPerTeam)]->OnIce=1;
	  if (Skaters[s]->HomeOrVisitor==0)
	    HomeTeam.SetActiveLine(0,Skaters[s]->GetPosition());
	  else
	    VisitorTeam.SetActiveLine(0,Skaters[s]->GetPosition());
	  int newplayer=GetReplacement(s);
	  //	  cout<<"Replacing "<<Skaters[s]->GetID()<<" with "<<newplayer<<endl;
	  int newindex=0;
	  while (Skaters[newindex]->GetID()!=newplayer)
	    newindex++;
	  Skaters[newindex]->OnIce = 1;

	  Skaters[newindex]->Energy=100;
	  //  Skaters[(s+5)]->OnIce=1;
	  //  Skaters[(s-(s%4))+((s+1)%4)]->Y=width-20;
	}
      if (Skaters[s]->OnIce == 0)
	{
	  Skaters[s]->Location.XVelocity = 0;
	  Skaters[s]->Location.YVelocity = 0;
	}

    }


  if (MrPuck.PlayerInControl == PlayersPerTeam*2)	//possession for goalies

    {
      MrPuck.SetPosition (HomeGoalie->Location.X + HomeGoalie->Location.XVelocity,
		     HomeGoalie->Location.Y + HomeGoalie->Location.YVelocity);
      MrPuck.SetVelocity (HomeGoalie->Location.XVelocity, HomeGoalie->Location.YVelocity, 0);
    }

  if (MrPuck.PlayerInControl == PlayersPerTeam*2+2)
    {
      MrPuck.SetPosition (VisitorGoalie->Location.X + VisitorGoalie->Location.XVelocity,
	       VisitorGoalie->Location.Y + VisitorGoalie->Location.YVelocity);
      MrPuck.SetVelocity (VisitorGoalie->Location.XVelocity, VisitorGoalie->Location.YVelocity, 0);
    }
  //actions for goalies
  MakeView (HomeGoalie, Status);	//have the skater look at the ice
  HomeGoalie->SetAction (Status, MrPuck, Home[0][5]);
  MakeView (VisitorGoalie, Status);	//have the skater look at the ice
  VisitorGoalie->SetAction (Status, MrPuck, Home[1][5]);
  if (Display)
    {
      HomeGoalie->Walk ();
#ifndef TWODVERSION
      HomeGoalie->Paint (MrPuck, CurrentPlayer, Textures);
#endif
#ifdef TWODVERSION
      HomeGoalie->Paint (dc, MrPuck, CurrentPlayer);
#endif
      VisitorGoalie->Walk ();
#ifndef TWODVERSION
      VisitorGoalie->Paint (MrPuck, CurrentPlayer, Textures);
#endif
#ifdef TWODVERSION
      VisitorGoalie->Paint (dc, MrPuck, CurrentPlayer);
#endif    
		}
  DoAction (Status, HomeGoalie, MrPuck);
  DoAction (Status, VisitorGoalie, MrPuck);
//  dc.SelectObject(pPen);
  //  dc.SelectObject(pBrush);
}
